# This module has been generated automatically from space group information
# obtained from the Computational Crystallography Toolbox
#

from Scientific.Geometry import Vector, Tensor
from Scientific.Geometry.Transformation import Rotation, Translation
from Scientific import N

class SpaceGroup(object):

    def __init__(self, number, labels, transformations):
        self.number = number
        self.labels = labels
        self.transformations = []
        for rot, trans in transformations:
            self.transformations.append(Translation(trans)*Rotation(Tensor(rot)))

_space_group_table = {}

def getSpaceGroupTransformations(space_group_label_or_number):
    try:
        return _space_group_table[space_group_label_or_number].transformations
    except KeyError:
        pass
    space_group_label = ''.join(space_group_label_or_number.split())
    return _space_group_table[space_group_label].transformations

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(1, ['C1^1', '1', 'P 1', 'P1'], transformations)
_space_group_table[1] = sg
_space_group_table['C1^1'] = sg
_space_group_table['1'] = sg
_space_group_table['P 1'] = sg
_space_group_table['P1'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(3, ['C2^1', 'P 2y', 'P121', 'P2:b', '3:b', 'C2^1', 'P 2', 'P112', 'P2:c', '3:c', 'C2^1', 'P 2x', 'P211', 'P2:a', '3:a'], transformations)
_space_group_table[3] = sg
_space_group_table['C2^1'] = sg
_space_group_table['P 2y'] = sg
_space_group_table['P121'] = sg
_space_group_table['P2:b'] = sg
_space_group_table['3:b'] = sg
_space_group_table['C2^1'] = sg
_space_group_table['P 2'] = sg
_space_group_table['P112'] = sg
_space_group_table['P2:c'] = sg
_space_group_table['3:c'] = sg
_space_group_table['C2^1'] = sg
_space_group_table['P 2x'] = sg
_space_group_table['P211'] = sg
_space_group_table['P2:a'] = sg
_space_group_table['3:a'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(4, ['C2^2', 'P 2yb', 'P1211', 'P21:b', '4:b', 'C2^2', 'P 2c', 'P1121', 'P21:c', '4:c', 'C2^2', 'P 2xa', 'P2111', 'P21:a', '4:a'], transformations)
_space_group_table[4] = sg
_space_group_table['C2^2'] = sg
_space_group_table['P 2yb'] = sg
_space_group_table['P1211'] = sg
_space_group_table['P21:b'] = sg
_space_group_table['4:b'] = sg
_space_group_table['C2^2'] = sg
_space_group_table['P 2c'] = sg
_space_group_table['P1121'] = sg
_space_group_table['P21:c'] = sg
_space_group_table['4:c'] = sg
_space_group_table['C2^2'] = sg
_space_group_table['P 2xa'] = sg
_space_group_table['P2111'] = sg
_space_group_table['P21:a'] = sg
_space_group_table['4:a'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(5, ['C2^3', 'C 2y', 'C121', 'C2:b1', '5:b1', 'C2^3', 'A 2y', 'A121', 'C2:b2', '5:b2', 'C2^3', 'I 2y', 'I121', 'C2:b3', '5:b3', 'C2^3', 'A 2', 'A112', 'C2:c1', '5:c1', 'C2^3', 'B 2', 'B2', 'B112', 'C2:c2', '5:c2', 'C2^3', 'I 2', 'I112', 'C2:c3', '5:c3', 'C2^3', 'B 2x', 'B211', 'C2:a1', '5:a1', 'C2^3', 'C 2x', 'C211', 'C2:a2', '5:a2', 'C2^3', 'I 2x', 'I211', 'C2:a3', '5:a3'], transformations)
_space_group_table[5] = sg
_space_group_table['C2^3'] = sg
_space_group_table['C 2y'] = sg
_space_group_table['C121'] = sg
_space_group_table['C2:b1'] = sg
_space_group_table['5:b1'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['A 2y'] = sg
_space_group_table['A121'] = sg
_space_group_table['C2:b2'] = sg
_space_group_table['5:b2'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['I 2y'] = sg
_space_group_table['I121'] = sg
_space_group_table['C2:b3'] = sg
_space_group_table['5:b3'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['A 2'] = sg
_space_group_table['A112'] = sg
_space_group_table['C2:c1'] = sg
_space_group_table['5:c1'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['B 2'] = sg
_space_group_table['B2'] = sg
_space_group_table['B112'] = sg
_space_group_table['C2:c2'] = sg
_space_group_table['5:c2'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['I 2'] = sg
_space_group_table['I112'] = sg
_space_group_table['C2:c3'] = sg
_space_group_table['5:c3'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['B 2x'] = sg
_space_group_table['B211'] = sg
_space_group_table['C2:a1'] = sg
_space_group_table['5:a1'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['C 2x'] = sg
_space_group_table['C211'] = sg
_space_group_table['C2:a2'] = sg
_space_group_table['5:a2'] = sg
_space_group_table['C2^3'] = sg
_space_group_table['I 2x'] = sg
_space_group_table['I211'] = sg
_space_group_table['C2:a3'] = sg
_space_group_table['5:a3'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(16, ['D2^1', '16', 'P 2 2', 'P222'], transformations)
_space_group_table[16] = sg
_space_group_table['D2^1'] = sg
_space_group_table['16'] = sg
_space_group_table['P 2 2'] = sg
_space_group_table['P222'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(17, ['D2^2', '17', 'P 2c 2', 'P2221', 'D2^2', 'P 2a 2a', 'P2122', '17:cab', 'D2^2', 'P 2 2b', 'P2212', '17:bca'], transformations)
_space_group_table[17] = sg
_space_group_table['D2^2'] = sg
_space_group_table['17'] = sg
_space_group_table['P 2c 2'] = sg
_space_group_table['P2221'] = sg
_space_group_table['D2^2'] = sg
_space_group_table['P 2a 2a'] = sg
_space_group_table['P2122'] = sg
_space_group_table['17:cab'] = sg
_space_group_table['D2^2'] = sg
_space_group_table['P 2 2b'] = sg
_space_group_table['P2212'] = sg
_space_group_table['17:bca'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(18, ['D2^3', '18', 'P 2 2ab', 'P21212', 'D2^3', 'P 2bc 2', 'P22121', '18:cab', 'D2^3', 'P 2ac 2ac', 'P21221', '18:bca'], transformations)
_space_group_table[18] = sg
_space_group_table['D2^3'] = sg
_space_group_table['18'] = sg
_space_group_table['P 2 2ab'] = sg
_space_group_table['P21212'] = sg
_space_group_table['D2^3'] = sg
_space_group_table['P 2bc 2'] = sg
_space_group_table['P22121'] = sg
_space_group_table['18:cab'] = sg
_space_group_table['D2^3'] = sg
_space_group_table['P 2ac 2ac'] = sg
_space_group_table['P21221'] = sg
_space_group_table['18:bca'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(19, ['D2^4', '19', 'P 2ac 2ab', 'P212121'], transformations)
_space_group_table[19] = sg
_space_group_table['D2^4'] = sg
_space_group_table['19'] = sg
_space_group_table['P 2ac 2ab'] = sg
_space_group_table['P212121'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(20, ['D2^5', '20', 'C 2c 2', 'C2221', 'D2^5', 'A 2a 2a', 'A2122', '20:cab', 'D2^5', 'B 2 2b', 'B2212', '20:bca'], transformations)
_space_group_table[20] = sg
_space_group_table['D2^5'] = sg
_space_group_table['20'] = sg
_space_group_table['C 2c 2'] = sg
_space_group_table['C2221'] = sg
_space_group_table['D2^5'] = sg
_space_group_table['A 2a 2a'] = sg
_space_group_table['A2122'] = sg
_space_group_table['20:cab'] = sg
_space_group_table['D2^5'] = sg
_space_group_table['B 2 2b'] = sg
_space_group_table['B2212'] = sg
_space_group_table['20:bca'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(21, ['D2^6', '21', 'C 2 2', 'C222', 'D2^6', 'A 2 2', 'A222', '21:cab', 'D2^6', 'B 2 2', 'B222', '21:bca'], transformations)
_space_group_table[21] = sg
_space_group_table['D2^6'] = sg
_space_group_table['21'] = sg
_space_group_table['C 2 2'] = sg
_space_group_table['C222'] = sg
_space_group_table['D2^6'] = sg
_space_group_table['A 2 2'] = sg
_space_group_table['A222'] = sg
_space_group_table['21:cab'] = sg
_space_group_table['D2^6'] = sg
_space_group_table['B 2 2'] = sg
_space_group_table['B222'] = sg
_space_group_table['21:bca'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(22, ['D2^7', '22', 'F 2 2', 'F222'], transformations)
_space_group_table[22] = sg
_space_group_table['D2^7'] = sg
_space_group_table['22'] = sg
_space_group_table['F 2 2'] = sg
_space_group_table['F222'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(23, ['D2^8', '23', 'I 2 2', 'I222'], transformations)
_space_group_table[23] = sg
_space_group_table['D2^8'] = sg
_space_group_table['23'] = sg
_space_group_table['I 2 2'] = sg
_space_group_table['I222'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(24, ['D2^9', '24', 'I 2b 2c', 'I212121'], transformations)
_space_group_table[24] = sg
_space_group_table['D2^9'] = sg
_space_group_table['24'] = sg
_space_group_table['I 2b 2c'] = sg
_space_group_table['I212121'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(75, ['C4^1', '75', 'P 4', 'P4'], transformations)
_space_group_table[75] = sg
_space_group_table['C4^1'] = sg
_space_group_table['75'] = sg
_space_group_table['P 4'] = sg
_space_group_table['P4'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(76, ['C4^2', '76', 'P 4w', 'P41'], transformations)
_space_group_table[76] = sg
_space_group_table['C4^2'] = sg
_space_group_table['76'] = sg
_space_group_table['P 4w'] = sg
_space_group_table['P41'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(77, ['C4^3', '77', 'P 4c', 'P42'], transformations)
_space_group_table[77] = sg
_space_group_table['C4^3'] = sg
_space_group_table['77'] = sg
_space_group_table['P 4c'] = sg
_space_group_table['P42'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(78, ['C4^4', '78', 'P 4cw', 'P43'], transformations)
_space_group_table[78] = sg
_space_group_table['C4^4'] = sg
_space_group_table['78'] = sg
_space_group_table['P 4cw'] = sg
_space_group_table['P43'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(79, ['C4^5', '79', 'I 4', 'I4'], transformations)
_space_group_table[79] = sg
_space_group_table['C4^5'] = sg
_space_group_table['79'] = sg
_space_group_table['I 4'] = sg
_space_group_table['I4'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,5./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(80, ['C4^6', '80', 'I 4bw', 'I41'], transformations)
_space_group_table[80] = sg
_space_group_table['C4^6'] = sg
_space_group_table['80'] = sg
_space_group_table['I 4bw'] = sg
_space_group_table['I41'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(89, ['D4^1', '89', 'P 4 2', 'P422'], transformations)
_space_group_table[89] = sg
_space_group_table['D4^1'] = sg
_space_group_table['89'] = sg
_space_group_table['P 4 2'] = sg
_space_group_table['P422'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(90, ['D4^2', '90', 'P 4ab 2ab', 'P4212'], transformations)
_space_group_table[90] = sg
_space_group_table['D4^2'] = sg
_space_group_table['90'] = sg
_space_group_table['P 4ab 2ab'] = sg
_space_group_table['P4212'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./4.)
transformations.append((rot, trans))
sg = SpaceGroup(91, ['D4^3', '91', 'P 4w 2c', 'P4122'], transformations)
_space_group_table[91] = sg
_space_group_table['D4^3'] = sg
_space_group_table['91'] = sg
_space_group_table['P 4w 2c'] = sg
_space_group_table['P4122'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(92, ['D4^4', '92', 'P 4abw 2nw', 'P41212'], transformations)
_space_group_table[92] = sg
_space_group_table['D4^4'] = sg
_space_group_table['92'] = sg
_space_group_table['P 4abw 2nw'] = sg
_space_group_table['P41212'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(93, ['D4^5', '93', 'P 4c 2', 'P4222'], transformations)
_space_group_table[93] = sg
_space_group_table['D4^5'] = sg
_space_group_table['93'] = sg
_space_group_table['P 4c 2'] = sg
_space_group_table['P4222'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(94, ['D4^6', '94', 'P 4n 2n', 'P42212'], transformations)
_space_group_table[94] = sg
_space_group_table['D4^6'] = sg
_space_group_table['94'] = sg
_space_group_table['P 4n 2n'] = sg
_space_group_table['P42212'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,3./4.)
transformations.append((rot, trans))
sg = SpaceGroup(95, ['D4^7', '95', 'P 4cw 2c', 'P4322'], transformations)
_space_group_table[95] = sg
_space_group_table['D4^7'] = sg
_space_group_table['95'] = sg
_space_group_table['P 4cw 2c'] = sg
_space_group_table['P4322'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(96, ['D4^8', '96', 'P 4nw 2abw', 'P43212'], transformations)
_space_group_table[96] = sg
_space_group_table['D4^8'] = sg
_space_group_table['96'] = sg
_space_group_table['P 4nw 2abw'] = sg
_space_group_table['P43212'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(97, ['D4^9', '97', 'I 4 2', 'I422'], transformations)
_space_group_table[97] = sg
_space_group_table['D4^9'] = sg
_space_group_table['97'] = sg
_space_group_table['I 4 2'] = sg
_space_group_table['I422'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,5./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,5./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,5./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(98, ['D4^10', '98', 'I 4bw 2bw', 'I4122'], transformations)
_space_group_table[98] = sg
_space_group_table['D4^10'] = sg
_space_group_table['98'] = sg
_space_group_table['I 4bw 2bw'] = sg
_space_group_table['I4122'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(143, ['C3^1', '143', 'P 3', 'P3'], transformations)
_space_group_table[143] = sg
_space_group_table['C3^1'] = sg
_space_group_table['143'] = sg
_space_group_table['P 3'] = sg
_space_group_table['P3'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
sg = SpaceGroup(144, ['C3^2', '144', 'P 31', 'P31'], transformations)
_space_group_table[144] = sg
_space_group_table['C3^2'] = sg
_space_group_table['144'] = sg
_space_group_table['P 31'] = sg
_space_group_table['P31'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
sg = SpaceGroup(145, ['C3^3', '145', 'P 32', 'P32'], transformations)
_space_group_table[145] = sg
_space_group_table['C3^3'] = sg
_space_group_table['145'] = sg
_space_group_table['P 32'] = sg
_space_group_table['P32'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
sg = SpaceGroup(146, ['C3^4', 'R 3', 'H 3', 'R3:H', '146:H', 'C3^4', 'P 3*', 'R3:R', '146:R'], transformations)
_space_group_table[146] = sg
_space_group_table['C3^4'] = sg
_space_group_table['R 3'] = sg
_space_group_table['H 3'] = sg
_space_group_table['R3:H'] = sg
_space_group_table['146:H'] = sg
_space_group_table['C3^4'] = sg
_space_group_table['P 3*'] = sg
_space_group_table['R3:R'] = sg
_space_group_table['146:R'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(149, ['D3^1', '149', 'P 3 2', 'P312'], transformations)
_space_group_table[149] = sg
_space_group_table['D3^1'] = sg
_space_group_table['149'] = sg
_space_group_table['P 3 2'] = sg
_space_group_table['P312'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(150, ['D3^2', '150', 'P 3 2"', 'P321'], transformations)
_space_group_table[150] = sg
_space_group_table['D3^2'] = sg
_space_group_table['150'] = sg
_space_group_table['P 3 2"'] = sg
_space_group_table['P321'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(151, ['D3^3', '151', 'P 31 2c (0 0 1)', 'P3112'], transformations)
_space_group_table[151] = sg
_space_group_table['D3^3'] = sg
_space_group_table['151'] = sg
_space_group_table['P 31 2c (0 0 1)'] = sg
_space_group_table['P3112'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(152, ['D3^4', '152', 'P 31 2"', 'P3121'], transformations)
_space_group_table[152] = sg
_space_group_table['D3^4'] = sg
_space_group_table['152'] = sg
_space_group_table['P 31 2"'] = sg
_space_group_table['P3121'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(153, ['D3^5', '153', 'P 32 2c (0 0 -1)', 'P3212'], transformations)
_space_group_table[153] = sg
_space_group_table['D3^5'] = sg
_space_group_table['153'] = sg
_space_group_table['P 32 2c (0 0 -1)'] = sg
_space_group_table['P3212'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(154, ['D3^6', '154', 'P 32 2"', 'P3221'], transformations)
_space_group_table[154] = sg
_space_group_table['D3^6'] = sg
_space_group_table['154'] = sg
_space_group_table['P 32 2"'] = sg
_space_group_table['P3221'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./3.,2./3.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(2./3.,1./3.,1./3.)
transformations.append((rot, trans))
sg = SpaceGroup(155, ['D3^7', 'R 3 2', 'H 3 2', 'R32:H', '155:H', 'D3^7', 'P 3* 2', 'R32:R', '155:R'], transformations)
_space_group_table[155] = sg
_space_group_table['D3^7'] = sg
_space_group_table['R 3 2'] = sg
_space_group_table['H 3 2'] = sg
_space_group_table['R32:H'] = sg
_space_group_table['155:H'] = sg
_space_group_table['D3^7'] = sg
_space_group_table['P 3* 2'] = sg
_space_group_table['R32:R'] = sg
_space_group_table['155:R'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(168, ['C6^1', '168', 'P 6', 'P6'], transformations)
_space_group_table[168] = sg
_space_group_table['C6^1'] = sg
_space_group_table['168'] = sg
_space_group_table['P 6'] = sg
_space_group_table['P6'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./6.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,5./6.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(169, ['C6^2', '169', 'P 61', 'P61'], transformations)
_space_group_table[169] = sg
_space_group_table['C6^2'] = sg
_space_group_table['169'] = sg
_space_group_table['P 61'] = sg
_space_group_table['P61'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,5./6.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./6.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(170, ['C6^3', '170', 'P 65', 'P65'], transformations)
_space_group_table[170] = sg
_space_group_table['C6^3'] = sg
_space_group_table['170'] = sg
_space_group_table['P 65'] = sg
_space_group_table['P65'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(171, ['C6^4', '171', 'P 62', 'P62'], transformations)
_space_group_table[171] = sg
_space_group_table['C6^4'] = sg
_space_group_table['171'] = sg
_space_group_table['P 62'] = sg
_space_group_table['P62'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(172, ['C6^5', '172', 'P 64', 'P64'], transformations)
_space_group_table[172] = sg
_space_group_table['C6^5'] = sg
_space_group_table['172'] = sg
_space_group_table['P 64'] = sg
_space_group_table['P64'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(173, ['C6^6', '173', 'P 6c', 'P63'], transformations)
_space_group_table[173] = sg
_space_group_table['C6^6'] = sg
_space_group_table['173'] = sg
_space_group_table['P 6c'] = sg
_space_group_table['P63'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(177, ['D6^1', '177', 'P 6 2', 'P622'], transformations)
_space_group_table[177] = sg
_space_group_table['D6^1'] = sg
_space_group_table['177'] = sg
_space_group_table['P 6 2'] = sg
_space_group_table['P622'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./6.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,5./6.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,5./6.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./6.)
transformations.append((rot, trans))
sg = SpaceGroup(178, ['D6^2', '178', 'P 61 2 (0 0 -1)', 'P6122'], transformations)
_space_group_table[178] = sg
_space_group_table['D6^2'] = sg
_space_group_table['178'] = sg
_space_group_table['P 61 2 (0 0 -1)'] = sg
_space_group_table['P6122'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,5./6.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./6.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./6.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,5./6.)
transformations.append((rot, trans))
sg = SpaceGroup(179, ['D6^3', '179', 'P 65 2 (0 0 1)', 'P6522'], transformations)
_space_group_table[179] = sg
_space_group_table['D6^3'] = sg
_space_group_table['179'] = sg
_space_group_table['P 65 2 (0 0 1)'] = sg
_space_group_table['P6522'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
sg = SpaceGroup(180, ['D6^4', '180', 'P 62 2c (0 0 1)', 'P6222'], transformations)
_space_group_table[180] = sg
_space_group_table['D6^4'] = sg
_space_group_table['180'] = sg
_space_group_table['P 62 2c (0 0 1)'] = sg
_space_group_table['P6222'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./3.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,2./3.)
transformations.append((rot, trans))
sg = SpaceGroup(181, ['D6^5', '181', 'P 64 2c (0 0 01)', 'P6422'], transformations)
_space_group_table[181] = sg
_space_group_table['D6^5'] = sg
_space_group_table['181'] = sg
_space_group_table['P 64 2c (0 0 01)'] = sg
_space_group_table['P6422'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,-1,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,-1,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,1,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,1,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(182, ['D6^6', '182', 'P 6c 2c', 'P6322'], transformations)
_space_group_table[182] = sg
_space_group_table['D6^6'] = sg
_space_group_table['182'] = sg
_space_group_table['P 6c 2c'] = sg
_space_group_table['P6322'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(195, ['T^1', '195', 'P 2 2 3', 'P23'], transformations)
_space_group_table[195] = sg
_space_group_table['T^1'] = sg
_space_group_table['195'] = sg
_space_group_table['P 2 2 3'] = sg
_space_group_table['P23'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(196, ['T^2', '196', 'F 2 2 3', 'F23'], transformations)
_space_group_table[196] = sg
_space_group_table['T^2'] = sg
_space_group_table['196'] = sg
_space_group_table['F 2 2 3'] = sg
_space_group_table['F23'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(197, ['T^3', '197', 'I 2 2 3', 'I23'], transformations)
_space_group_table[197] = sg
_space_group_table['T^3'] = sg
_space_group_table['197'] = sg
_space_group_table['I 2 2 3'] = sg
_space_group_table['I23'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(198, ['T^4', '198', 'P 2ac 2ab 3', 'P213'], transformations)
_space_group_table[198] = sg
_space_group_table['T^4'] = sg
_space_group_table['198'] = sg
_space_group_table['P 2ac 2ab 3'] = sg
_space_group_table['P213'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(199, ['T^5', '199', 'I 2b 2c 3', 'I213'], transformations)
_space_group_table[199] = sg
_space_group_table['T^5'] = sg
_space_group_table['199'] = sg
_space_group_table['I 2b 2c 3'] = sg
_space_group_table['I213'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(207, ['O^1', '207', 'P 4 2 3', 'P432'], transformations)
_space_group_table[207] = sg
_space_group_table['O^1'] = sg
_space_group_table['207'] = sg
_space_group_table['P 4 2 3'] = sg
_space_group_table['P432'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(208, ['O^2', '208', 'P 4n 2 3', 'P4232'], transformations)
_space_group_table[208] = sg
_space_group_table['O^2'] = sg
_space_group_table['208'] = sg
_space_group_table['P 4n 2 3'] = sg
_space_group_table['P4232'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
sg = SpaceGroup(209, ['O^3', '209', 'F 4 2 3', 'F432'], transformations)
_space_group_table[209] = sg
_space_group_table['O^3'] = sg
_space_group_table['209'] = sg
_space_group_table['F 4 2 3'] = sg
_space_group_table['F432'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
sg = SpaceGroup(210, ['O^4', '210', 'F 4d 2 3', 'F4132'], transformations)
_space_group_table[210] = sg
_space_group_table['O^4'] = sg
_space_group_table['210'] = sg
_space_group_table['F 4d 2 3'] = sg
_space_group_table['F4132'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
sg = SpaceGroup(211, ['O^5', '211', 'I 4 2 3', 'I432'], transformations)
_space_group_table[211] = sg
_space_group_table['O^5'] = sg
_space_group_table['211'] = sg
_space_group_table['I 4 2 3'] = sg
_space_group_table['I432'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
sg = SpaceGroup(212, ['O^6', '212', 'P 4acd 2ab 3', 'P4332'], transformations)
_space_group_table[212] = sg
_space_group_table['O^6'] = sg
_space_group_table['212'] = sg
_space_group_table['P 4acd 2ab 3'] = sg
_space_group_table['P4332'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,3./4.)
transformations.append((rot, trans))
sg = SpaceGroup(213, ['O^7', '213', 'P 4bd 2ab 3', 'P4132'], transformations)
_space_group_table[213] = sg
_space_group_table['O^7'] = sg
_space_group_table['213'] = sg
_space_group_table['P 4bd 2ab 3'] = sg
_space_group_table['P4132'] = sg

transformations = []
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(0.,0.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,0.,0.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(0.,1./2.,0.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,3./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./4.,1./4.,1./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,-1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,5./4.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,0,1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,5./4.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,5./4.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,5./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,5./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,1,0,-1,0,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,-1,1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,1,-1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,0,0,1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,-1,0,0,0,1,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,1,0,0,0,-1,0])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,0,0,-1,-1,0,0])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([1,0,0,0,-1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1./2.,1./2.,1.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,1,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(1.,1./2.,1./2.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,-1,0,0,0,1])
rot.shape = (3, 3)
trans = Vector(1./2.,1.,1./2.)
transformations.append((rot, trans))
rot = N.array([0,1,0,1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,5./4.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,-1,0,-1,0,0,0,0,-1])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([0,0,1,0,-1,0,1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,5./4.)
transformations.append((rot, trans))
rot = N.array([0,0,-1,0,-1,0,-1,0,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,1,0,1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,5./4.,3./4.)
transformations.append((rot, trans))
rot = N.array([-1,0,0,0,0,-1,0,-1,0])
rot.shape = (3, 3)
trans = Vector(3./4.,3./4.,3./4.)
transformations.append((rot, trans))
sg = SpaceGroup(214, ['O^8', '214', 'I 4bd 2c 3', 'I4132'], transformations)
_space_group_table[214] = sg
_space_group_table['O^8'] = sg
_space_group_table['214'] = sg
_space_group_table['I 4bd 2c 3'] = sg
_space_group_table['I4132'] = sg


del transformations
del rot
del trans

