# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RedisLinkedServerCreateParameters(Model):
    """Parameter required for creating a linked server to redis cache.

    :param linked_redis_cache_id: Fully qualified resourceId of the linked
     redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Location of the linked redis cache.
    :type linked_redis_cache_location: str
    :param server_role: Role of the linked server. Possible values include:
     'Primary', 'Secondary'
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    """

    _validation = {
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
    }

    _attribute_map = {
        'linked_redis_cache_id': {'key': 'properties.linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'properties.linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'ReplicationRole'},
    }

    def __init__(self, linked_redis_cache_id, linked_redis_cache_location, server_role):
        super(RedisLinkedServerCreateParameters, self).__init__()
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role
