# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobUpdateParameter(Model):
    """Parameters for a CloudJobOperations.Update request.

    :param priority: The priority of the job. Priority values can range from
     -1000 to 1000, with -1000 being the lowest priority and 1000 being the
     highest priority. If omitted, it is set to the default value 0.
    :type priority: int
    :param constraints: The execution constraints for the job. If omitted,
     the constraints are cleared.
    :type constraints: :class:`JobConstraints
     <azure.batch.models.JobConstraints>`
    :param pool_info: The pool on which the Batch service runs the job's
     tasks. You may change the pool for a job only when the job is disabled.
     The Update Job call will fail if you include the poolInfo element and
     the job is not disabled. If you specify an autoPoolSpecification
     specification in the poolInfo, only the keepAlive property can be
     updated, and then only if the auto pool has a poolLifetimeOption of job.
    :type pool_info: :class:`PoolInformation
     <azure.batch.models.PoolInformation>`
    :param metadata: A list of name-value pairs associated with the job as
     metadata. If omitted, it takes the default value of an empty list; in
     effect, any existing metadata is deleted.
    :type metadata: list of :class:`MetadataItem
     <azure.batch.models.MetadataItem>`
    :param on_all_tasks_complete: Specifies an action the Batch service
     should take when all tasks in the job are in the completed state.
     Possible values include: 'noAction', 'terminateJob'
    :type on_all_tasks_complete: str or :class:`OnAllTasksComplete
     <azure.batch.models.OnAllTasksComplete>`
    """ 

    _validation = {
        'pool_info': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'constraints': {'key': 'constraints', 'type': 'JobConstraints'},
        'pool_info': {'key': 'poolInfo', 'type': 'PoolInformation'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'on_all_tasks_complete': {'key': 'onAllTasksComplete', 'type': 'OnAllTasksComplete'},
    }

    def __init__(self, pool_info, priority=None, constraints=None, metadata=None, on_all_tasks_complete=None):
        self.priority = priority
        self.constraints = constraints
        self.pool_info = pool_info
        self.metadata = metadata
        self.on_all_tasks_complete = on_all_tasks_complete
