/**
 ** Standalone printf.
 **/

#include <stdarg.h>

/*
 * This is our external interface nowadays.
 * Its place is in a header but we do not want to proliferate headers.
 */
struct prf_fp {
	void *xfp;
	void (*write)(void *, char *, int);
};
void prf(struct prf_fp *, char*, va_list);

/*
 */
static void printn(struct prf_fp *, unsigned long, unsigned int);
static void putchar(char, struct prf_fp *);

static char hextab[] = "0123456789ABCDEF";

/*
 * Scaled down version of C Library printf.
 * Only %c %s %u %d (==%u) %o %x %D %O are recognized.
 */

#if 0
void
xprintf(int filog, char *fmt, ...)
{
	va_list x1;

	va_start(x1,fmt);
	prf(filog,fmt,x1);
	va_end(x1);
}
#endif

void
prf(struct prf_fp *filog, char *fmt, va_list adx)
{
        register c;
        char *s;

	for(;;) {
        	while((c = *fmt++) != '%') {
                	if(c == '\0') {
                        	putchar(0,filog);
                        	return;
                	}
                	putchar(c,filog);
        	}
        	c = *fmt++;
        	if(c == 'd' || c == 'o' || c == 'x' || c == 'X') {
                	printn(filog, (long)va_arg(adx,unsigned),
				c=='o'? 8: (c=='d'? 10:16));
        	} else if(c == 'c') {
                	putchar(va_arg(adx,unsigned), filog);
        	} else if(c == 's') {
                	s = va_arg(adx,char*);
               		while(c = *s++)
                        	putchar(c,filog);
       		} else if (c == 'l' || c == 'O') {
        	        printn(filog, (long)va_arg(adx,long), c=='l'?10:8);
	        }
        }
}

/*
 * Print an unsigned integer in base b, avoiding recursion.
 */
static void
printn(struct prf_fp *filog, unsigned long n, unsigned int b)
{
        char prbuf[24];
        register char *cp;

        if (b == 10 && n < 0) {
                putchar('-',filog);
                n = (~n) + 1;		/* n = -n */
        }
        cp = prbuf;
        do
		*cp++ = hextab[(unsigned int)(n%b)];
        while(n /= b);
        do
	        putchar(*--cp, filog);
	while(cp > prbuf);
}

/*
 * Hex to text, available from outside.
 */
void xtoa(unsigned int x, char *buf, int len)
{
	while (len != 0) {
		--len;
		buf[len] = hextab[x & 0xF];
		x >>= 4;
	}
}

/*
 * This part is rewritten by Igor Timkin <ivt@msu.su>. Than I
 * rewritten it again but kept the MISS style, originated from
 * Wladimir Butenko. --P3
 */
#define OBSIZE      200

static void
uputo1(char c, struct prf_fp *filog)
{
  /* P3: This buffer can be static while xprintf flushes it on exit. */
  static char       buff[OBSIZE+1];
  static int        ox;

  if ((buff[ox]=c) == 0) {
    (*filog->write)(filog->xfp,buff,ox);  ox=0;
  } else {
    if (++ox>=OBSIZE) {
      buff[ox]=0;
      (*filog->write)(filog->xfp,buff,ox);  ox=0;
    } /*if*/
  }
} /*uputo1*/

static void
putchar(char c, struct prf_fp *filog)
{
	if (c == '\n') uputo1('\r', filog);
	uputo1(c, filog);
}
