/* TextGrid_Sound.h
 *
 * Copyright (C) 1992-2011,2013,2014,2015,2017 Paul Boersma
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This code is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this work. If not, see <http://www.gnu.org/licenses/>.
 */

#include "TextGrid.h"
#include "Sound.h"
#include "Pitch.h"

void TextGrid_Sound_draw (TextGrid me, Sound sound, Graphics g, double tmin, double tmax,
	bool showBoundaries, bool useTextStyles, bool garnish);

Collection_define (SoundList, OrderedOf, Sound) {
};

autoSoundList TextGrid_Sound_extractAllIntervals (TextGrid me, Sound sound, long itier, bool preserveTimes);
autoSoundList TextGrid_Sound_extractNonemptyIntervals (TextGrid me, Sound sound, long itier, bool preserveTimes);
autoSoundList TextGrid_Sound_extractIntervalsWhere (TextGrid me, Sound sound,
	long itier, kMelder_string which, const char32 *text, bool preserveTimes);

void TextGrid_Pitch_draw (TextGrid grid, Pitch pitch, Graphics g,
	long itier, double tmin, double tmax, double fmin, double fmax,
	double fontSize, bool useTextStyles, int horizontalAlignment, bool garnish, bool speckle, kPitch_unit unit);
void TextGrid_Pitch_drawSeparately (TextGrid grid, Pitch pitch, Graphics g, double tmin, double tmax,
	double fmin, double fmax, bool showBoundaries, bool useTextStyles, bool garnish, bool speckle, kPitch_unit unit);

void TextGrid_anySound_alignInterval (TextGrid me, Function anySound, long tierNumber, long intervalNumber,
	const char32 *languageName, bool includeWords, bool includePhonemes);

/* End of file TextGrid_Sound.h */
