#
# This file is part of FreedomBox.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#
# Generated by Django 2.2.6 on 2020-01-29 03:17
#
"""
Django migration for adding the notification model.
"""

from django.db import migrations, models

from plinth.models import JSONField


class Migration(migrations.Migration):

    dependencies = [
        ('plinth', '0004_userprofile'),
    ]

    operations = [
        migrations.CreateModel(
            name='StoredNotification',
            fields=[
                ('id',
                 models.CharField(max_length=128, primary_key=True,
                                  serialize=False)),
                ('app_id',
                 models.CharField(default=None, max_length=128, null=True)),
                ('severity', models.CharField(max_length=32)),
                ('title', models.CharField(max_length=256)),
                ('message', models.TextField(default=None, null=True)),
                ('actions', JSONField(default=list)),
                ('body_template',
                 models.CharField(max_length=128, null=True, default=None)),
                ('data', JSONField(default=dict)),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('last_update_time', models.DateTimeField(auto_now=True)),
                ('user',
                 models.CharField(max_length=128, default=None, null=True)),
                ('group',
                 models.CharField(max_length=128, default=None, null=True)),
                ('dismissed', models.BooleanField(default=False)),
            ],
        ),
    ]
