<?php
/**
 * Describes the synchronization handler.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_Storage
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @link     http://pear.horde.org/index.php?package=Kolab_Storage
 */

/**
 * Describes the synchronization handler.
 *
 * Copyright 2012-2014 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Kolab
 * @package  Kolab_Storage
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @link     http://pear.horde.org/index.php?package=Kolab_Storage
 */
abstract class Horde_Kolab_Storage_List_Synchronization
{
    /**
     * Register a new synchronization listener.
     *
     * @param Horde_Kolab_Storage_List_Synchronization_Listener $listener The new listener.
     */
    abstract public function registerListener(Horde_Kolab_Storage_List_Synchronization_Listener $listener);

    /**
     * Inform all listeners about the synchronization call.
     */
    abstract public function synchronize();
}
