/***************************************************************************
                          masterdisplay.h  -  description
                             -------------------
    begin                : Sun Sep 19 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MASTERDISPLAY_H
#define MASTERDISPLAY_H

#include <qwidget.h>
#include "rxfreqdisplay.h"
#include "txfreqdisplay.h"
#include "childdisplay.h"

/**
  *@author Edson Pereira
  */

class MasterDisplay : public QWidget {

	Q_OBJECT

public:
	MasterDisplay( QWidget *parent=0, const char *name=0 );
	~MasterDisplay();

public slots:

private:
	void paintEvent( QPaintEvent * );

	RxFreqDisplay* rxDisplay;
    TxFreqDisplay* txDisplay;
    ChildDisplay*  dcdDisplay;
    ChildDisplay*  afcDisplay;
    ChildDisplay*  netDisplay;
    ChildDisplay*  confidenceDisplay;
    ChildDisplay*  inputLevelDisplay;
    ChildDisplay*  modeDisplay;
    ChildDisplay*  beaconDisplay;
    ChildDisplay*  voxDisplay;

public slots: // Public slots

  void setRxFreq( float );
  void setTxFreq( float );
  void setDCD( bool );
  void setAFC( bool );
  void setNET( bool );
  void setConfidence( int );
  void setInputLevel( double );
  void setMode( bool );
  void setBeacon( bool );
  void setVox( bool );
};

#endif













