DROP DATABASE IF EXISTS `issue26211`;
CREATE DATABASE `issue26211`;
USE `issue26211`;

CREATE TABLE `process_model` (
  `PROC_MODEL_ID` decimal(10,0) NOT NULL,
  `PKG_MEM_ID` decimal(10,0) NOT NULL,
  `PROC_ID` decimal(10,0) DEFAULT NULL,
  `ACTIVE_VERSION` decimal(10,0) DEFAULT NULL,
  `CURRENT_VERSION` decimal(10,0) DEFAULT NULL,
  `ENABLED` decimal(1,0) NOT NULL,
  `NAME` varchar(64) NOT NULL,
  `COMMENTS` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`PROC_MODEL_ID`),
  KEY `I_PROCESS_MODEL_PKG_MEM_ID` (`PKG_MEM_ID`),
  KEY `I_PROCESS_MODEL_PROC_ID` (`PROC_ID`),
  KEY `procmodel_name_indx` (`NAME`)
) ENGINE=InnoDB;

CREATE TABLE `process_model_inst` (
  `PROC_MODEL_INST_ID` decimal(10,0) NOT NULL,
  `VERSION` decimal(10,0) NOT NULL,
  `PROC_MODEL_ID` decimal(10,0) NOT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `CHANGE_NOTE` varchar(4000) DEFAULT NULL,
  `XML` longtext NOT NULL,
  `AUTHOR` varchar(50) DEFAULT NULL,
  `CHECKSUM` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`PROC_MODEL_INST_ID`),
  UNIQUE KEY `UK_PROCMODEL_INST` (`VERSION`,`PROC_MODEL_ID`),
  KEY `I_PROCESS_MODEL_INST_PROC_MODE` (`PROC_MODEL_ID`),
  CONSTRAINT `FK_PROCMODINST_REF_PROCMOD` FOREIGN KEY (`PROC_MODEL_ID`) REFERENCES `process_model` (`PROC_MODEL_ID`) ON DELETE CASCADE
) ENGINE=InnoDB;
