//                                               -*- C++ -*-
/**
 * @file  t_MethodBoundNumericalMathEvaluationImplementation_std.cxx
 * @brief The test file of class MethodBoundNumericalMathEvaluationImplementation for standard methods
 *
 *  Copyright (C) 2005-2014 Airbus-EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author lebrun
 *  @date   2008-07-03 08:31:34 +0200 (jeu, 03 jui 2008)
 */
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try
  {
    Normal distribution(0, 1.0);
    NumericalMathFunction function = bindMethod <Normal, NumericalPoint, NumericalPoint> ( distribution, &Normal::computeDDF, 1, 1 );
    NumericalPoint p(1, 1.0);
    fullprint << "Normal DDF=" << distribution.computeDDF(p) << std::endl;
    fullprint << "bind DDF  =" << function(p)[0] << std::endl;
  }
  catch (TestFailed & ex)
  {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
