/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8004802
 * @key nmt jcmd regression
 * @summary Regression test for invoking a jcmd with baseline=false, result was that the target VM crashed
 * @library /testlibrary
 * @ignore
 * @run main/othervm -XX:NativeMemoryTracking=detail BaselineWithParameter
 */

import com.oracle.java.testlibrary.*;

public class BaselineWithParameter {

  public static void main(String args[]) throws Exception {
    // Grab my own PID
    String pid = Integer.toString(ProcessTools.getProcessId());
    OutputAnalyzer output;

    ProcessBuilder pb = new ProcessBuilder();

    // Run 'jcmd <pid> VM.native_memory baseline=false'
    pb.command(new String[] { JDKToolFinder.getJDKTool("jcmd"), pid, "VM.native_memory", "baseline=false"});
    pb.start().waitFor();

    // Run 'jcmd <pid> VM.native_memory summary=false'
    pb.command(new String[] { JDKToolFinder.getJDKTool("jcmd"), pid, "VM.native_memory", "summary=false"});
    output = new OutputAnalyzer(pb.start());
    output.shouldContain("No command to execute");

  }
}
