/*
 * Copyright (c) 1997, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources.pt;

import sun.util.resources.TimeZoneNamesBundle;

public final class TimeZoneNames_pt_BR extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Fuso hor\u00e1rio do Acre", "ACT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Acre", "ACST",
                                     "Fuso hor\u00e1rio do Acre", "ACT"};
        String ADELAIDE[] = new String[] {"Hor\u00E1rio-Padr\u00E3o Central (Austr\u00E1lia do Sul)", "CST",
                                          "Fuso Hor\u00E1rio de Ver\u00E3o Central (Austr\u00E1lia do Sul)", "CST",
                                          "Hor\u00E1rio Central (Austr\u00E1lia do Sul)", "CT"};
        String AGT[] = new String[] {"Fuso hor\u00e1rio da Argentina", "ART",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Argentina", "ARST",
                                     "Hor\u00E1rio da Argentina", "ART"};
        String AKST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do Alaska", "AKST",
                                      "Hor\u00e1rio de luz natural do Alaska", "AKDT",
                                      "Hor\u00E1rio do Alasca", "AKT"};
        String AMT[] = new String[] {"Fuso hor\u00e1rio do Amazonas", "AMT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Amazonas", "AMST",
                                     "Hor\u00E1rio do Amazonas", "AMT"};
        String ARAST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o da Ar\u00e1bia", "AST",
                                       "Hor\u00e1rio de luz natural da Ar\u00e1bia", "ADT",
                                       "Hor\u00E1rio da Ar\u00E1bia", "AT"};
        String ARMT[] = new String[] {"Fuso hor\u00e1rio da Arm\u00eania", "AMT",
                                      "Fuso hor\u00e1rio de ver\u00e3o da Arm\u00eania", "AMST",
                                      "Hor\u00E1rio da Arm\u00EAnia", "AMT"};
        String AST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do Atl\u00e2ntico", "AST",
                                     "Hor\u00e1rio de luz natural do Atl\u00e2ntico", "ADT",
                                     "Hor\u00E1rio do Atl\u00E2ntico", "AT"};
        String BDT[] = new String[] {"Fuso hor\u00e1rio de Bangladesh", "BDT",
                                     "Fuso hor\u00e1rio de ver\u00e3o de Bangladesh", "BDST",
                                     "Hor\u00E1rio de Bangladesh", "BDT"};
        String BRISBANE[] = new String[] {"Hor\u00E1rio-Padr\u00E3o do Leste (Queensland)", "EST",
                                          "Fuso Hor\u00E1rio de Ver\u00E3o Oriental (Queensland)", "EST",
                                          "Hor\u00E1rio do Leste (Queensland)", "ET"};
        String BROKEN_HILL[] = new String[] {"Hor\u00E1rio-Padr\u00E3o Central (Austr\u00E1lia do Sul/Nova Gales do Sul)", "CST",
                                             "Fuso Hor\u00E1rio de Ver\u00E3o Central (Austr\u00E1lia do Sul/Nova Gales do Sul)", "CST",
                                             "Hor\u00E1rio Central (Austr\u00E1lia do Sul/Nova Gales do Sul)", "CT"};
        String BRT[] = new String[] {"Fuso hor\u00e1rio de Bras\u00edlia", "BRT",
                                     "Fuso hor\u00e1rio de ver\u00e3o de Bras\u00edlia", "BRST",
                                     "Hor\u00E1rio de Bras\u00EDlia", "BRT"};
        String BTT[] = new String[] {"Fuso hor\u00e1rio de But\u00e3o", "BTT",
                                     "Fuso hor\u00e1rio de ver\u00e3o de But\u00e3o", "BTST",
                                     "Hor\u00E1rio do But\u00E3o", "BTT"};
        String CAT[] = new String[] {"Fuso hor\u00e1rio da \u00c1frica Central", "CAT",
                                     "Fuso hor\u00e1rio de ver\u00e3o da \u00c1frica Central", "CAST",
                                     "Hor\u00E1rio da \u00C1frica Central", "CAT"};
        String CET[] = new String[] {"Fuso hor\u00e1rio da Europa Central", "CET",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Europa Central", "CEST",
                                     "Hor\u00E1rio da Europa Central", "CET"};
        String CHAST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Chatham", "CHAST",
                                       "Hor\u00e1rio de luz natural de Chatham", "CHADT",
                                       "Hor\u00E1rio de Chatham", "CHAT"};
        String CIT[] = new String[] {"Fuso hor\u00e1rio da Indon\u00e9sia Central", "WITA",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Indon\u00e9sia Central", "CIST",
                                     "Hor\u00E1rio da Indon\u00E9sia Central", "WITA"};
        String CLT[] = new String[] {"Fuso hor\u00e1rio do Chile", "CLT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Chile", "CLST",
                                     "Hor\u00E1rio do Chile", "CLT"};
        String CST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o central", "CST",
                                     "Hor\u00e1rio de luz natural central", "CDT",
                                     "Hor\u00E1rio Central", "CT"};
        String CTT[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o da China", "CST",
                                     "Hor\u00e1rio de luz natural da China", "CDT",
                                     "Hor\u00E1rio da China", "CT"};
        String CUBA[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Cuba", "CST",
                                      "Hor\u00e1rio de luz natural de Cuba", "CDT",
                                      "Hor\u00E1rio de Cuba", "CT"};
        String DARWIN[] = new String[] {"Hor\u00E1rio-Padr\u00E3o Central (Territ\u00F3rio do Norte)", "CST",
                                        "Fuso Hor\u00E1rio de Ver\u00E3o Central (Territ\u00F3rio do Norte)", "CST",
                                        "Hor\u00E1rio Central (Territ\u00F3rio do Norte)", "CT"};
        String DUBLIN[] = new String[] {"Fuso hor\u00e1rio do meridiano de Greenwich", "GMT",
                                        "Fuso hor\u00e1rio de ver\u00e3o da Irlanda", "IST",
                                        "Hor\u00E1rio da Rep\u00FAblica da Irlanda", "IT"};
        String EAT[] = new String[] {"Fuso hor\u00e1rio da \u00c1frica Oriental", "EAT",
                                     "Fuso hor\u00e1rio padr\u00e3o da \u00c1frica Oriental", "EAST",
                                     "Hor\u00E1rio do Leste da \u00C1frica", "EAT"};
        String EASTER[] = new String[] {"Fuso hor\u00e1rio da Ilha de P\u00e1scoa", "EAST",
                                        "Fuso hor\u00e1rio de ver\u00e3o da Ilha de P\u00e1scoa", "EASST",
                                        "Hor\u00E1rio da Ilha de P\u00E1scoa", "EAST"};
        String EET[] = new String[] {"Fuso hor\u00e1rio da Europa Oriental", "EET",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Europa Oriental", "EEST",
                                     "Hor\u00e1rio da Europa Oriental", "EET"};
        String EGT[] = new String[] {"Fuso hor\u00e1rio da Groenl\u00e2ndia Oriental", "EGT",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Groenl\u00e2ndia Oriental", "EGST",
                                     "Hor\u00E1rio da Groenl\u00E2ndia Oriental", "EGT"};
        String EST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o oriental", "EST",
                                     "Hor\u00e1rio de luz natural oriental", "EDT",
                                     "Hor\u00E1rio do Leste", "ET"};
        String EST_NSW[] = new String[] {"Hor\u00E1rio-Padr\u00E3o Oriental (Nova Gales do Sul)", "EST",
                                         "Fuso Hor\u00E1rio de Ver\u00E3o Oriental (Nova Gales do Sul)", "EST",
                                         "Hor\u00E1rio Oriental (Nova Gales do Sul)", "ET"};
        String FET[] = new String[] {"Hor\u00E1rio do Extremo Leste Europeu (FET)", "FET",
                                     "Fuso Hor\u00E1rio de Ver\u00E3o do Extremo Leste Europeu", "FEST",
                                     "Hor\u00E1rio do Extremo Leste Europeu (FET)", "FET"};
        String GHMT[] = new String[] {"Fuso hor\u00e1rio do meridiano de Gana", "GMT",
                                      "Fuso hor\u00e1rio de ver\u00e3o de Gana", "GHST",
                                      "Fuso Hor\u00E1rio do Meridiano de Gana", "GMT"};
        String GAMBIER[] =  new String[] {"Fuso hor\u00e1rio de Gambier", "GAMT",
                                          "Fuso hor\u00e1rio de ver\u00e3o de Gambier", "GAMST",
                                          "Hor\u00E1rio de Gambier", "GAMT"};
        String GMT[] = new String[] {"Fuso hor\u00e1rio do meridiano de Greenwich", "GMT",
                                     "Fuso hor\u00e1rio do meridiano de Greenwich", "GMT",
                                     "Hor\u00E1rio M\u00E9dio de Greenwich", "GMT"};
        String GMTBST[] = new String[] {"Fuso hor\u00e1rio do meridiano de Greenwich", "GMT",
                                        "Fuso hor\u00e1rio de ver\u00e3o da Gr\u00e3-Bretanha", "BST",
                                        "Hor\u00E1rio do Reino Unido", "BT"};
        String GST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do golfo", "GST",
                                     "Hor\u00e1rio de luz natural do golfo", "GDT",
                                     "Hor\u00E1rio do Golfo", "GT"};
        String HAST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do Hava\u00ed-Aleutian", "HAST",
                                      "Hor\u00e1rio de luz natural do Hava\u00ed-Aleutian", "HADT",
                                      "Hor\u00E1rio do Hava\u00ED-Aleutas", "HAT"};
        String HKT[] =  new String[] {"Fuso hor\u00e1rio de Hong Kong", "HKT",
                                      "Fuso hor\u00e1rio de ver\u00e3o de Hong Kong", "HKST",
                                      "Hor\u00E1rio de Hong Kong", "HKT"};
        String HST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do Hava\u00ed", "HST",
                                     "Hor\u00e1rio de luz natural do Hava\u00ed", "HDT",
                                     "Hor\u00E1rio do Hava\u00ED", "HT"};
        String ICT[] = new String[] {"Fuso hor\u00e1rio da Indochina", "ICT",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Indochina", "ICST",
                                     "Hor\u00E1rio da Indochina", "ICT"};
        String IRT[] = new String[] {"Fuso hor\u00e1rio do Ir\u00e3", "IRST",
                                     "Hor\u00e1rio de luz natural do Ir\u00e3", "IRDT",
                                     "Hor\u00E1rio do Ir\u00E3", "IRT"};
        String ISRAEL[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Israel", "IST",
                                        "Hor\u00e1rio de luz natural de Israel", "IDT",
                                        "Hor\u00E1rio de Israel", "IT"};
        String IST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o da \u00cdndia", "IST",
                                     "Hor\u00e1rio de luz natural da \u00cdndia", "IDT",
                                     "Hor\u00E1rio da \u00CDndia", "IT"};
        String JST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do Jap\u00e3o", "JST",
                                     "Hor\u00e1rio de luz natural do Jap\u00e3o", "JDT",
                                     "Hor\u00E1rio do Jap\u00E3o", "JT"};
        String KST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o da Coreia", "KST",
                                     "Hor\u00e1rio de luz natural da Coreia", "KDT",
                                     "Hor\u00E1rio da Coreia", "KT"};
        String LORD_HOWE[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Lord Howe", "LHST",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Lord Howe", "LHST",
                                           "Hor\u00E1rio de Lord Howe", "LHT"};
        String MHT[] = new String[] {"Fuso hor\u00e1rio das Ilhas Marshall", "MHT",
                                     "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Marshall", "MHST",
                                     "Hor\u00E1rio das Ilhas Marshall", "MHT"};
        String MSK[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Moscou", "MSK",
                                     "Hor\u00e1rio de luz natural de Moscou", "MSD",
                                     "Hor\u00E1rio de Moscou", "MT"};
        String MST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o das montanhas", "MST",
                                     "Hor\u00e1rio de luz natural das montanhas", "MDT",
                                     "Hor\u00E1rio das Montanhas Rochosas", "MT"};
        String MYT[] = new String[] {"Fuso hor\u00e1rio da Mal\u00e1sia", "MYT",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Mal\u00e1sia", "MYST",
                                     "Hor\u00E1rio da Mal\u00E1sia", "MYT"};
        String NORONHA[] = new String[] {"Fuso hor\u00e1rio de Fernando de Noronha", "FNT",
                                         "Fuso hor\u00e1rio de ver\u00e3o de Fernando de Noronha", "FNST",
                                         "Hor\u00E1rio de Fernando de Noronha", "FNT"};
        String NOVT[] = new String[] {"Fuso hor\u00e1rio de Novosibirsk", "NOVT",
                                      "Fuso hor\u00e1rio de ver\u00e3o de Novosibirsk", "NOVST",
                                      "Hor\u00E1rio de Novosibirsk", "NOVT"};
        String NPT[] = new String[] {"Fuso hor\u00e1rio do Nepal", "NPT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Nepal", "NPST",
                                     "Hor\u00E1rio do Nepal", "NPT"};
        String NST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Terra Nova", "NST",
                                     "Hor\u00e1rio de luz natural de Terra Nova", "NDT",
                                     "Hor\u00E1rio de Terra Nova", "NT"};
        String NZST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o da Nova Zel\u00e2ndia", "NZST",
                                      "Hor\u00e1rio de luz natural da Nova Zel\u00e2ndia", "NZDT",
                                      "Hor\u00E1rio da Nova Zel\u00E2ndia", "NZT"};
        String PITCAIRN[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Pitcairn", "PST",
                                          "Hor\u00e1rio de luz natural de Pitcairn", "PDT",
                                          "Hor\u00E1rio de Pitcairn", "PT"};
        String PKT[] = new String[] {"Fuso hor\u00e1rio do Paquist\u00e3o", "PKT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Paquist\u00e3o", "PKST",
                                     "Hor\u00E1rio do Paquist\u00E3o", "PKT"};
        String PONT[] = new String[] {"Fuso Hor\u00E1rio de Pohnpei", "PONT",
                                      "Fuso Hor\u00E1rio de Ver\u00E3o de Pohnpei", "PONST",
                                      "Hor\u00E1rio de Ponape", "PONT"};
        String PST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o do Pac\u00edfico", "PST",
                                     "Hor\u00e1rio de luz natural do Pac\u00edfico", "PDT",
                                     "Hor\u00E1rio do Pac\u00EDfico", "PT"};
        String SAST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o da \u00c1frica do Sul", "SAST",
                                      "Fuso hor\u00e1rio de ver\u00e3o da \u00c1frica do Sul", "SAST",
                                      "Hor\u00E1rio da \u00C1frica do Sul", "SAT"};
        String SBT[] = new String[] {"Fuso hor\u00e1rio das Ilhas Salom\u00e3o", "SBT",
                                     "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Salom\u00e3o", "SBST",
                                     "Hor\u00E1rio das Ilhas Salom\u00E3o", "SBT"};
        String SGT[] = new String[] {"Fuso hor\u00e1rio de Cingapura", "SGT",
                                     "Fuso hor\u00e1rio de ver\u00e1 de Cingapura", "SGST",
                                     "Hor\u00E1rio de Cingapura", "SGT"};
        String SLST[] = new String[] {"Fuso hor\u00e1rio do meridiano de Greenwich", "GMT",
                                      "Fuso hor\u00e1rio de ver\u00e3o de Serra Leoa", "SLST",
                                      "Hor\u00E1rio de Serra Leoa", "SLT"};
        String TASMANIA[] = new String[] {"Hor\u00E1rio-Padr\u00E3o do Leste (Tasm\u00E2nia)", "EST",
                                          "Fuso Hor\u00E1rio de Ver\u00E3o Oriental (Tasm\u00E2nia)", "EST",
                                          "Hor\u00E1rio do Leste (Tasm\u00E2nia)", "ET"};
        String TMT[] = new String[] {"Fuso hor\u00e1rio do Turcomenist\u00e3o", "TMT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Turcomenist\u00e3o", "TMST",
                                     "Hor\u00E1rio do Turcomenist\u00E3o", "TMT"};
        String TRUT[] = new String[] {"Fuso Hor\u00E1rio de Chuuk", "CHUT",
                                      "Fuso Hor\u00E1rio de Ver\u00E3o de Chuuk", "CHUST",
                                      "Fuso Hor\u00E1rio de Chuuk", "CHUT"};
        String ULAT[]= new String[] {"Fuso hor\u00e1rio de Ulan Bator", "ULAT",
                                     "Fuso hor\u00e1rio de ver\u00e3o de Ulan Bator", "ULAST",
                                     "Hor\u00E1rio de Ulaanbaatar", "ULAT"};
        String WAT[] = new String[] {"Fuso hor\u00e1rio da \u00c1frica Ocidental", "WAT",
                                     "Fuso hor\u00e1rio de ver\u00e3o da \u00c1frica Ocidental", "WAST",
                                     "Hor\u00E1rio da \u00C1frica Ocidental", "WAT"};
        String WET[] = new String[] {"Fuso hor\u00e1rio da Europa Ocidental", "WET",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Europa Ocidental", "WEST",
                                     "Hor\u00E1rio da Europa Ocidental", "WET"};
        String WIT[] = new String[] {"Fuso hor\u00e1rio da Indon\u00e9sia Ocidental", "WIB",
                                     "Fuso hor\u00e1rio de ver\u00e3o da Indon\u00e9sia Ocidental", "WIST",
                                     "Hor\u00E1rio da Indon\u00E9sia Ocidental", "WIB"};
        String WST_AUS[] = new String[] {"Hor\u00E1rio-Padr\u00E3o Ocidental (Austr\u00E1lia)", "WST",
                                         "Fuso Hor\u00E1rio de Ver\u00E3o Ocidental (Austr\u00E1lia)", "WST",
                                         "Hor\u00E1rio Ocidental (Austr\u00E1lia)", "WT"};
        String SAMOA[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Samoa", "SST",
                                       "Hor\u00e1rio de luz natural de Samoa", "SDT",
                                       "Hor\u00E1rio da Samoa", "ST"};
        String WST_SAMOA[] = new String[] {"Fuso hor\u00e1rio de Samoa Ocidental", "WST",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Samoa Ocidental", "WSDT",
                                           "Fuso Hor\u00E1rio de Samoa Ocidental", "WST"};
        String ChST[] = new String[] {"Fuso hor\u00e1rio padr\u00e3o de Chamorro", "ChST",
                                      "Hor\u00e1rio de luz natural de Chamorro", "ChDT",
                                      "Hor\u00E1rio de Chamorro", "ChT"};
        String VICTORIA[] = new String[] {"Hor\u00E1rio-Padr\u00E3o do Leste (Victoria)", "EST",
                                          "Fuso Hor\u00E1rio de Ver\u00E3o Oriental (Victoria)", "EST",
                                          "Hor\u00E1rio do Leste (Victoria)", "ET"};
        String UTC[] = new String[] {"Tempo universal coordenado", "UTC",
                                     "Tempo universal coordenado", "UTC",
                                     "Hor\u00E1rio Universal Coordenado", "UTC"};
        String UZT[] = new String[] {"Fuso hor\u00e1rio do Uzbequist\u00e3o", "UZT",
                                     "Fuso hor\u00e1rio de ver\u00e3o do Uzbequist\u00e3o", "UZST",
                                     "Hor\u00E1rio do Uzbequist\u00E3o", "UZT"};
        String WART[] = new String[] {"Fuso hor\u00e1rio da Argentina Ocidental", "WART",
                                      "Fuso hor\u00e1rio de ver\u00e3o da Argentina Ocidental", "WARST"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", SLST},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", EAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", EAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", WAT},
            {"America/Adak", HAST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"Fuso hor\u00e1rio do Paraguai", "PYT",
                                               "Fuso hor\u00e1rio de ver\u00e3o do Paraguai", "PYST",
                                               "Hor\u00E1rio do Paraguai", "PYT"}},
            {"America/Atikokan", EST},
            {"America/Atka", HAST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"Fuso hor\u00e1rio da Col\u00f4mbia", "COT",
                                             "Fuso hor\u00e1rio de ver\u00e3o da Col\u00f4mbia", "COST",
                                             "Hor\u00E1rio da Col\u00F4mbia", "COT"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", CST},
            {"America/Caracas", new String[] {"Fuso hor\u00e1rio da Venezuela", "VET",
                                              "Fuso hor\u00e1rio de ver\u00e3o da Venezuela", "VEST",
                                              "Hor\u00E1rio da Venezuela", "VET"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"Fuso hor\u00e1rio da Guiana Francesa", "GFT",
                                              "Fuso hor\u00e1rio de ver\u00e3o da Guiana Francesa", "GFST",
                                              "Hor\u00E1rio da Guiana Francesa", "GFT"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"Fuso hor\u00e1rio da Groenl\u00e2ndia Ocidental", "WGT",
                                              "Fuso hor\u00e1rio de ver\u00e3o da Groenl\u00e2ndia Ocidental", "WGST",
                                              "Hor\u00E1rio da Groenl\u00E2ndia Ocidental", "WGT"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"Fuso hor\u00e1rio do Equador", "ECT",
                                                "Fuso hor\u00e1rio de ver\u00e3o do Equador", "ECST",
                                                "Hor\u00E1rio do Equador", "ECT"}},
            {"America/Guyana", new String[] {"Fuso hor\u00e1rio da Guiana", "GYT",
                                             "Fuso hor\u00e1rio de ver\u00e3o da Guiana", "GYST",
                                             "Hor\u00E1rios da Guiana", "GYT"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"Fuso hor\u00e1rio da Bol\u00edvia", "BOT",
                                             "Fuso hor\u00e1rio de ver\u00e3o da Bol\u00edvia", "BOST",
                                             "Hor\u00E1rio da Bol\u00EDvia", "BOT"}},
            {"America/Lima", new String[] {"Fuso hor\u00e1rio do Peru", "PET",
                                           "Fuso hor\u00e1rio de ver\u00e3o do Peru", "PEST",
                                           "Hor\u00E1rio do Peru", "PET"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", new String[] {"Hor\u00E1rio Padr\u00E3o de Metlakatla", "MeST",
                                                 "Hor\u00E1rio de Luz Natural de Metlakatla", "MeDT",
                                                 "Hor\u00E1rio de Metlakatla", "MeT"}},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"Fuso hor\u00e1rio padr\u00e3o de S\u00e3o Pedro e Miquelon", "PMST",
                                               "Hor\u00e1rio de luz natural de S\u00e3o Pedro e Miquelon", "PMDT",
                                               "Hor\u00E1rio de Saint Pierre e Miquelon", "PMT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"Fuso hor\u00e1rio do Uruguai", "UYT",
                                                 "Fuso hor\u00e1rio de ver\u00e3o do Uruguai", "UYST",
                                                 "Hor\u00E1rio do Uruguai", "UYT"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"Fuso hor\u00e1rio do Suriname", "SRT",
                                                 "Fuso hor\u00e1rio de ver\u00e3o do Suriname", "SRST",
                                                 "Hor\u00E1rio do Suriname", "SRT"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"Fuso hor\u00e1rio de Davis", "DAVT",
                                               "Fuso hor\u00e1rio de ver\u00e3o de Davis", "DAVST",
                                               "Hor\u00E1rio de Davis", "DAVT"}},
            {"Antarctica/DumontDUrville", new String[] {"Fuso hor\u00e1rio de Dumont-d'Urville", "DDUT",
                                                        "Fuso hor\u00e1rio de ver\u00e3o de Dumont-d'Urville", "DDUST",
                                                        "Fuso Hor\u00E1rio de Dumont-d'Urville", "DDUT"}},
            {"Antarctica/Macquarie", new String[] {"Fuso Hor\u00E1rio da Ilha de Macquarie", "MIST",
                                                   "Fuso Hor\u00E1rio de Ver\u00E3o da Ilha de Macquarie", "MIST",
                                                   "Fuso Hor\u00E1rio da Ilha de Macquarie", "MIST"}},
            {"Antarctica/Mawson", new String[] {"Fuso hor\u00e1rio de Mawson", "MAWT",
                                                "Fuso hor\u00e1rio de ver\u00e3o de Mawson", "MAWST",
                                                "Hor\u00E1rio de Mawson", "MAWT"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"Fuso hor\u00e1rio de Rothera", "ROTT",
                                                 "Fuso hor\u00e1rio de ver\u00e3o de Rothera", "ROTST",
                                                 "Hor\u00E1rio de Rothera", "ROTT"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Fuso hor\u00e1rio de Syowa", "SYOT",
                                               "Fuso hor\u00e1rio de ver\u00e3o de Syowa", "SYOST",
                                               "Hor\u00E1rio de Syowa", "SYOT"}},
            {"Antarctica/Troll", new String[] {"Tempo universal coordenado", "UTC",
                                               "Fuso hor\u00e1rio de ver\u00e3o da Europa Central", "CEST",
                                               "Troll Time", "ATT"}},
            {"Antarctica/Vostok", new String[] {"Fuso hor\u00e1rio de Vostok", "VOST",
                                                "Fuso hor\u00e1rio de ver\u00e3o de Vostok", "VOSST",
                                                "Hor\u00E1rio de Vostok", "VOST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Fuso hor\u00e1rio de Alma-Ata", "ALMT",
                                          "Fuso hor\u00e1rio de ver\u00e3o de Alma-Ata", "ALMST",
                                          "Hor\u00E1rio de Alma-Ata", "ALMT"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"Fuso hor\u00e1rio de Anadyr", "ANAT",
                                          "Fuso hor\u00e1rio de ver\u00e3o de Anadyr", "ANAST",
                                          "Hor\u00E1rio de Anadyr", "ANAT"}},
            {"Asia/Aqtau", new String[] {"Fuso hor\u00e1rio de Aqtau", "AQTT",
                                         "Fuso hor\u00e1rio de ver\u00e3o de Aqtau", "AQTST",
                                         "Hor\u00E1rio de Aqtau", "AQTT"}},
            {"Asia/Aqtobe", new String[] {"Fuso hor\u00e1rio de Aqtobe", "AQTT",
                                          "Fuso hor\u00e1rio de ver\u00e3o de Aqtobe", "AQTST",
                                          "Hor\u00E1rio de Aqtobe", "AQTT"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"Fuso hor\u00e1rio do Azerbaij\u00e3o", "AZT",
                                        "Fuso hor\u00e1rio de ver\u00e3o do Azerbaij\u00e3o", "AZST",
                                        "Hor\u00E1rio do Azerbaij\u00E3o", "AZT"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"Fuso hor\u00e1rio do Quirguist\u00e3o", "KGT",
                                           "Fuso hor\u00e1rio de ver\u00e3o do Quirguist\u00e3o", "KGST",
                                           "Hor\u00E1rio do Quirguist\u00E3o", "KGT"}},
            {"Asia/Brunei", new String[] {"Fuso hor\u00e1rio de Brunei", "BNT",
                                          "Fuso hor\u00e1rio de ver\u00e3o de Brunei", "BNST",
                                          "Hor\u00E1rio de Brunei", "BNT"}},
            {"Asia/Calcutta", IST},
            {"Asia/Choibalsan", new String[] {"Fuso hor\u00e1rio de Choibalsan", "CHOT",
                                              "Fuso hor\u00e1rio de ver\u00e3o de Choibalsan", "CHOST",
                                              "Hor\u00E1rio de Choibalsan", "CHOT"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"Fuso hor\u00e1rio do Timor-Leste", "TLT",
                                        "Fuso hor\u00e1rio de ver\u00e3o do Timor-Leste", "TLST",
                                        "Hor\u00E1rio do Timor-Leste", "TLT"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"Fuso hor\u00e1rio do Tadjiquist\u00e3o", "TJT",
                                            "Fuso hor\u00e1rio de ver\u00e3o do Tadjiquist\u00e3o", "TJST",
                                            "Hor\u00E1rio do Tadjiquist\u00E3o", "TJT"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Fuso hor\u00e1rio de Hovd", "HOVT",
                                        "Fuso hor\u00e1rio de ver\u00e3o de Hovd", "HOVST",
                                        "Hor\u00E1rio de Hovd", "HOVT"}},
            {"Asia/Irkutsk", new String[] {"Fuso hor\u00e1rio de Irkutsk", "IRKT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Irkutsk", "IRKST",
                                           "Hor\u00E1rio de Irkutsk", "IRKT"}},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"Fuso hor\u00e1rio da Indon\u00e9sia Oriental", "WIT",
                                            "Fuso hor\u00e1rio de ver\u00e3o da Indon\u00e9sia Oriental", "EIST",
                                            "Hor\u00E1rio da Indon\u00E9sia Oriental", "WIT"}},
            {"Asia/Kabul", new String[] {"Fuso hor\u00e1rio do Afeganist\u00e3o", "AFT",
                                         "Fuso hor\u00e1rio de ver\u00e3o do Afeganist\u00e3o", "AFST",
                                         "Hor\u00E1rio do Afeganist\u00E3o", "AFT"}},
            {"Asia/Kamchatka", new String[] {"Fuso hor\u00e1rio de Petropavlovsk-Kamchatski", "PETT",
                                             "Fuso hor\u00e1rio de ver\u00e3o de Petropavlovsk-Kamchatski", "PETST",
                                             "Hor\u00E1rio de Petropavlovsk-Kamchatski", "PETT"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", CTT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", new String[] {"Hor\u00E1rio de Khandyga", "YAKT",
                                            "Hor\u00E1rio de Ver\u00E3o de Khandyga", "YAKST",
                                            "Hor\u00E1rio de Khandyga", "YAKT"}},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", new String[] {"Fuso hor\u00e1rio de Krasnoyarsk", "KRAT",
                                               "Fuso hor\u00e1rio de ver\u00e3o de Krasnoyarsk", "KRAST",
                                               "Hor\u00E1rio de Krasnoyarsk", "KRAT"}},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Fuso hor\u00e1rio de Magadan", "MAGT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Magadan", "MAGST",
                                           "Hor\u00E1rio de Magadan", "MAGT"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Fuso hor\u00e1rio das Filipinas", "PHT",
                                          "Fuso hor\u00e1rio de ver\u00e3o das Filipinas", "PHST",
                                          "Hor\u00E1rio das Filipinas", "PHT"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", NOVT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Fuso hor\u00e1rio de Uralsk", "ORAT",
                                        "Fuso hor\u00e1rio de ver\u00e3o de Uralsk", "ORAST",
                                        "Hor\u00E1rio de Uralsk", "ORAT"}},
            {"Asia/Omsk", new String[] {"Fuso hor\u00e1rio de Omsk", "OMST",
                                        "Fuso hor\u00e1rio de ver\u00e3o de Omsk", "OMSST",
                                        "Hor\u00E1rio de Omsk", "OMST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Fuso hor\u00e1rio de Kizil-Orda", "QYZT",
                                             "Fuso hor\u00e1rio de ver\u00e3o de Kizil-Orda", "QYZST",
                                             "Hor\u00E1rio de Qyzylorda", "QYZT"}},
            {"Asia/Rangoon", new String[] {"Fuso hor\u00e1rio de Mianmar", "MMT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Mianmar", "MMST",
                                           "Hor\u00E1rio de Mianmar", "MMT"}},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"Fuso hor\u00e1rio de Sakhalina", "SAKT",
                                            "Fuso hor\u00e1rio de ver\u00e3o de Sakhalina", "SAKST",
                                            "Hor\u00E1rio de Sakhalin", "SAKT"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"Fuso hor\u00e1rio da Ge\u00f3rgia", "GET",
                                           "Fuso hor\u00e1rio de ver\u00e3o da Ge\u00f3rgia", "GEST",
                                           "Hor\u00E1rio da Ge\u00F3rgia", "GET"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", CTT},
            {"Asia/Ust-Nera", new String[] {"Hor\u00E1rio de Ust-Nera", "VLAT",
                                            "Hor\u00E1rio de Ver\u00E3o de Ust-Nera", "VLAST",
                                            "Hor\u00E1rio de Ust-Nera", "VLAT"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"Fuso hor\u00e1rio de Vladivostok", "VLAT",
                                               "Fuso hor\u00e1rio de ver\u00e3o de Vladivostok", "VLAST",
                                               "Hor\u00E1rio de Vladivostok", "VLAT"}},
            {"Asia/Yakutsk", new String[] {"Fuso hor\u00e1rio de Yakutsk", "YAKT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Yakutsk", "YAKST",
                                           "Hor\u00E1rio de Yakutsk", "YAKT"}},
            {"Asia/Yekaterinburg", new String[] {"Fuso hor\u00e1rio de Yekaterinburgo", "YEKT",
                                                 "Fuso hor\u00e1rio de ver\u00e3o de Yekaterinburgo", "YEKST",
                                                 "Hor\u00E1rio de Yekaterinburg", "YEKT"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"Fuso hor\u00e1rio das A\u00e7ores", "AZOT",
                                              "Fuso hor\u00e1rio de ver\u00e3o das A\u00e7ores", "AZOST",
                                              "Hor\u00E1rio de A\u00E7ores", "AZOT"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"Fuso hor\u00e1rio de Cabo Verde", "CVT",
                                                  "Fuso hor\u00e1rio de ver\u00e3o de Cabo Verde", "CVST",
                                                  "Hor\u00E1rio de Cabo Verde", "CVT"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"Fuso hor\u00e1rio padr\u00e3o da Ge\u00f3rgia do Sul", "GST",
                                                     "Hor\u00e1rio de luz natural da Ge\u00f3rgia do Sul", "GDT",
                                                     "Hor\u00E1rio da Ge\u00F3rgia do Sul", "GT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"Fuso hor\u00e1rio das Ilhas Falkland", "FKT",
                                               "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Falkland", "FKST",
                                               "Hor\u00E1rio das Ilhas Malvinas", "FKT"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"Fuso Hor\u00E1rio Ocidental Central (Austr\u00E1lia)", "CWST",
                                              "Fuso Hor\u00E1rio de Ver\u00E3o Ocidental Central (Austr\u00E1lia)", "CWST",
                                              "Hor\u00E1rio Ocidental Central (Austr\u00E1lia)", "CWT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/East-Saskatchewan", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", FET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", FET},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"Fuso hor\u00e1rio de Samara", "SAMT",
                                            "Fuso hor\u00e1rio de ver\u00e3o de Samara", "SAMST",
                                            "Hor\u00E1rio de Samara", "SAMT"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", new String[] {"Fuso hor\u00e1rio de Volgogrado", "VOLT",
                                               "Fuso hor\u00e1rio de ver\u00e3o de Volgogrado", "VOLST",
                                               "Hor\u00E1rio de Volgogrado", "VOLT"}},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"Fuso hor\u00e1rio dos territ\u00f3rios do Oceano \u00cdndico", "IOT",
                                            "Fuso hor\u00e1rio de ver\u00e3o dos territ\u00f3rios do Oceano \u00cdndico", "IOST",
                                            "Hor\u00E1rio do Territ\u00F3rio do Oceano \u00CDndico", "IOT"}},
            {"Indian/Christmas", new String[] {"Fuso hor\u00e1rio das Ilhas Christmas", "CXT",
                                               "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Christmas", "CXST",
                                               "Hor\u00E1rio da Ilha Christmas", "CIT"}},
            {"Indian/Cocos", new String[] {"Fuso hor\u00e1rio das Ilhas Cocos", "CCT",
                                           "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Cocos", "CCST",
                                           "Hor\u00E1rio das Ilhas Cocos", "CCT"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"Fuso hor\u00e1rio das Terras Austrais e Ant\u00e1rticas Francesas", "TFT",
                                               "Fuso hor\u00e1rio de ver\u00e3o das Terras Austrais e Ant\u00e1rticas Francesas", "TFST",
                                               "Hor\u00E1rio do Territ\u00F3rio Franc\u00EAs no Sul da Ant\u00E1rtica", "TFT"}},
            {"Indian/Mahe", new String[] {"Fuso hor\u00e1rio das Seychelles", "SCT",
                                          "Fuso hor\u00e1rio de ver\u00e3o das Seychelles", "SCST",
                                          "Hor\u00E1rio de Seychelles", "SCT"}},
            {"Indian/Maldives", new String[] {"Fuso hor\u00e1rio das Maldivas", "MVT",
                                              "Fuso hor\u00e1rio de ver\u00e3o das Maldivas", "MVST",
                                              "Hor\u00E1rio das Maldivas", "MVT"}},
            {"Indian/Mauritius", new String[] {"Fuso hor\u00e1rio das Ilhas Maur\u00edcio", "MUT",
                                               "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Maur\u00edcio", "MUST",
                                               "Hor\u00E1rio de Maur\u00EDcio", "MUT"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"Fuso hor\u00e1rio de Reuni\u00e3o", "RET",
                                             "Fuso hor\u00e1rio de ver\u00e3o de Reuni\u00e3o", "REST",
                                             "Hor\u00E1rio das Ilhas Reuni\u00E3o", "RET"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"Fuso hor\u00e1rio da Europa M\u00e9dia", "MET",
                                  "Fuso hor\u00e1rio de ver\u00e3o da Europa M\u00e9dia", "MEST",
                                  "MET", "MET"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", TRUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"Fuso hor\u00e1rio de Vanuatu", "VUT",
                                            "Fuso hor\u00e1rio de ver\u00e3o de Vanuatu", "VUST",
                                            "Hor\u00E1rio de Vanuatu", "VUT"}},
            {"Pacific/Enderbury", new String[] {"Fuso hor\u00e1rio das Ilhas F\u00e9nix", "PHOT",
                                                "Fuso hor\u00e1rio de ver\u00e3o das Ilhas F\u00e9nix", "PHOST",
                                                "Hor\u00E1rio da Ilha Phoenix", "PHOT"}},
            {"Pacific/Fakaofo", new String[] {"Fuso hor\u00e1rio de Tokelau", "TKT",
                                              "Fuso hor\u00e1rio de ver\u00e3o de Tokelau", "TKST",
                                              "Hor\u00E1rio de Toquelau", "TKT"}},
            {"Pacific/Fiji", new String[] {"Fuso hor\u00e1rio de Fiji", "FJT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Fiji", "FJST",
                                           "Hor\u00E1rio de Fiji", "FJT"}},
            {"Pacific/Funafuti", new String[] {"Fuso hor\u00e1rio de Tuvalu", "TVT",
                                               "Fuso hor\u00e1rio de ver\u00e3o de Tuvalu", "TVST",
                                               "Hor\u00E1rio de Tuvalu", "TVT"}},
            {"Pacific/Galapagos", new String[] {"Fuso hor\u00e1rio das Ilhas Gal\u00e1pagos", "GALT",
                                                "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Gal\u00e1pagos", "GALST",
                                                "Hor\u00E1rio de Gal\u00E1pagos", "GALT"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Fuso hor\u00e1rio das Esp\u00f3rades Equatoriais", "LINT",
                                                 "Fuso hor\u00e1rio de ver\u00e3o das Esp\u00f3rades Equatoriais", "LINST",
                                                 "Hor\u00E1rio das Ilhas Line", "LINT"}},
            {"Pacific/Kosrae", new String[] {"Fuso hor\u00e1rio de Kosrae", "KOST",
                                             "Fuso hor\u00e1rio de ver\u00e3o de Kosrae", "KOSST",
                                             "Hor\u00E1rio de Kosrae", "KOST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"Fuso hor\u00e1rio das Ilhas Marquesas", "MART",
                                                "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Marquesas", "MARST",
                                                "Hor\u00E1rio das Ilhas Marquesas", "MART"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"Fuso hor\u00e1rio de Nauru", "NRT",
                                            "Fuso hor\u00e1rio de ver\u00e3o de Nauru", "NRST",
                                            "Hor\u00E1rio de Nauru", "NRT"}},
            {"Pacific/Niue", new String[] {"Fuso hor\u00e1rio de Niue", "NUT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Niue", "NUST",
                                           "Hor\u00E1rio de Niue", "NUT"}},
            {"Pacific/Norfolk", new String[] {"Fuso hor\u00e1rio da Ilha de Norfolk", "NFT",
                                              "Fuso hor\u00e1rio de ver\u00e3o da Ilha de Norfolk", "NFST",
                                              "Hor\u00E1rio de Norfolk", "NFT"}},
            {"Pacific/Noumea", new String[] {"Fuso hor\u00e1rio da Nova Caled\u00f4nia", "NCT",
                                             "Fuso hor\u00e1rio de ver\u00e3o da Nova Caled\u00f4nia", "NCST",
                                             "Hor\u00E1rio da Nova Caled\u00F4nia", "NCT"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"Fuso hor\u00e1rio de Palau", "PWT",
                                            "Fuso hor\u00e1rio de ver\u00e3o de Palau", "PWST",
                                            "Hor\u00E1rio de Palau", "PWT"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"Fuso hor\u00e1rio de Papua-Nova Guin\u00e9", "PGT",
                                                   "Fuso hor\u00e1rio de ver\u00e3o de Papua-Nova Guin\u00e9", "PGST",
                                                   "Hor\u00E1rio de Papua-Nova Guin\u00E9", "PGT"}},
            {"Pacific/Rarotonga", new String[] {"Fuso hor\u00e1rio das Ilhas Cook", "CKT",
                                                "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Cook", "CKHST",
                                                "Hor\u00E1rio das Ilhas Cook", "CKT"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"Fuso hor\u00e1rio do Taiti", "TAHT",
                                             "Fuso hor\u00e1rio de ver\u00e3o do Taiti", "TAHST",
                                             "Hor\u00E1rio do Tahiti", "TAHT"}},
            {"Pacific/Tarawa", new String[] {"Fuso hor\u00e1rio das Ilhas Gilbert", "GILT",
                                             "Fuso hor\u00e1rio de ver\u00e3o das Ilhas Gilbert", "GILST",
                                             "Hor\u00E1rio das Ilhas Gilbert", "GILT"}},
            {"Pacific/Tongatapu", new String[] {"Fuso hor\u00e1rio de Tonga", "TOT",
                                                "Fuso hor\u00e1rio de ver\u00e3o de Tonga", "TOST",
                                                "Hor\u00E1rio de Tonga", "TOT"}},
            {"Pacific/Truk", TRUT},
            {"Pacific/Wake", new String[] {"Fuso hor\u00e1rio de Wake", "WAKT",
                                           "Fuso hor\u00e1rio de ver\u00e3o de Wake", "WAKST",
                                           "Hor\u00E1rio de Wake", "WAKT"}},
            {"Pacific/Wallis", new String[] {"Fuso hor\u00e1rio de Wallis e Futuna", "WFT",
                                             "Fuso hor\u00e1rio de ver\u00e3o de Wallis e Futuna", "WFST",
                                             "Hor\u00E1rio das Ilhas Wallis e Futuna", "WFT"}},
            {"Pacific/Yap", TRUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HAST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"UTC", UTC},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
