#!/bin/sh
set -e
export TAR_OPTIONS='--owner root --group root --mode a+rX --format ustar'
export GZIP_OPTIONS='-9n'
set -x
destdir=$1
[ -z "$destdir" ] && destdir=$(pwd)
tmpdir=$(mktemp -d -t openinbrowser.get-orig-source.XXXXXX)
uscan --no-conf --verbose --force-download --destdir "$tmpdir"
(
    cd "$tmpdir"
    version=$(echo *.xpi | sed -r -e 's/.*-([0-9.]+)-.*/\1/')
    mkdir "openinbrowser-$version.orig"
    cd *.orig/
    unzip ../*.xpi
    cd ..
    tar -czf "$destdir/openinbrowser_$version.orig.tar.gz" *.orig/
)
rm -rf "$tmpdir"

# vim:ts=4 sts=4 sw=4 et
