/*
 *
 * European Centre for Medium-Range Weather Forecasts: Reading
 * Anomalies
 *
 * Center: 98
 * Subcenter: 0
 * Parameter table version: 171
 */

TBLE2 ecmwf_171_params[] = {
{1, "Stream function anomaly", "m**2 s**-1", "STRFA"},
{2, "Velocity potential anomaly", "m**2 s**-1", "VPOTA"},
{3, "Potential temperature anomaly", "K", "PTA"},
{4, "Equivalent potential temperature anomaly", "K", "EPTA"},
{5, "Saturated equivalent potential temperature anomaly", "K", "SEPTA"},
{6, "100 metre U wind component anomaly", "m s**-1", "100UA"},
{7, "100 metre V wind component anomaly", "m s**-1", "100VA"},
{11, "U component of divergent wind anomaly", "m s**-1", "UDWA"},
{12, "V component of divergent wind anomaly", "m s**-1", "VDWA"},
{13, "U component of rotational wind anomaly", "m s**-1", "URWA"},
{14, "V component of rotational wind anomaly", "m s**-1", "VRWA"},
{21, "Unbalanced component of temperature anomaly", "K", "UCTPA"},
{22, "Unbalanced component of logarithm of surface pressure anomaly", "-", "UCLNA"},
{23, "Unbalanced component of divergence anomaly", "s**-1", "UCDVA"},
{26, "Lake cover anomaly", "(0 - 1)", "CLA"},
{27, "Low vegetation cover anomaly", "(0 - 1)", "CVLA"},
{28, "High vegetation cover anomaly", "(0 - 1)", "CVHA"},
{29, "Type of low vegetation anomaly", "-", "TVLA"},
{30, "Type of high vegetation anomaly", "-", "TVHA"},
{31, "Sea-ice cover anomaly", "(0 - 1)", "SICA"},
{32, "Snow albedo anomaly", "(0 - 1)", "ASNA"},
{33, "Snow density anomaly", "kg m**-3", "RSNA"},
{34, "Sea surface temperature anomaly", "K", "SSTA"},
{35, "Ice surface temperature anomaly layer 1", "K", "ISTAL1"},
{36, "Ice surface temperature anomaly layer 2", "K", "ISTAL2"},
{37, "Ice surface temperature anomaly layer 3", "K", "ISTAL3"},
{38, "Ice surface temperature anomaly layer 4", "K", "ISTAL4"},
{39, "Volumetric soil water anomaly layer 1", "m**3 m**-3", "SWVAL1"},
{40, "Volumetric soil water anomaly layer 2", "m**3 m**-3", "SWVAL2"},
{41, "Volumetric soil water anomaly layer 3", "m**3 m**-3", "SWVAL3"},
{42, "Volumetric soil water anomaly layer 4", "m**3 m**-3", "SWVAL4"},
{43, "Soil type anomaly", "-", "SLTA"},
{44, "Snow evaporation anomaly", "kg m**-2", "ESA"},
{45, "Snowmelt anomaly", "kg m**-2", "SMLTA"},
{46, "Solar duration anomaly", "s", "SDURA"},
{47, "Direct solar radiation anomaly", "J m**-2", "DSRPA"},
{48, "Magnitude of surface stress anomaly", "N m**-2 s", "MAGSSA"},
{49, "10 metre wind gust anomaly", "m s**-1", "10FGA"},
{50, "Large-scale precipitation fraction anomaly", "s", "LSPFA"},
{51, "Maximum 2 metre temperature in the last 24 hours anomaly", "K", "MX2T24A"},
{52, "Minimum 2 metre temperature in the last 24 hours anomaly", "K", "MN2T24A"},
{53, "Montgomery potential anomaly", "m**2 s**-2", "MONTA"},
{54, "Pressure anomaly", "Pa", "PA"},
{55, "Mean 2 metre temperature in the last 24 hours anomaly", "K", "MN2T24A"},
{56, "Mean 2 metre dewpoint temperature in the last 24 hours anomaly", "K", "MN2D24A"},
{57, "Downward UV radiation at the surface anomaly", "J m**-2", "UVBA"},
{58, "Photosynthetically active radiation at the surface anomaly", "J m**-2", "PARA"},
{59, "Convective available potential energy anomaly", "J kg**-1", "CAPEA"},
{60, "Potential vorticity anomaly", "K m**2 kg**-1 s**-1", "PVA"},
{61, "Total precipitation from observations anomaly", "Millimetres*100 + number of stations", "TPOA"},
{62, "Observation count anomaly", "-", "OBCTA"},
{63, "Start time for skin temperature difference anomaly", "s", "STSKTDA"},
{64, "Finish time for skin temperature difference anomaly", "s", "FTSKTDA"},
{65, "Skin temperature difference anomaly", "K", "SKTDA"},
{78, "Total column liquid water anomaly", "kg m**-2", "TCLWA"},
{79, "Total column ice water anomaly", "kg m**-2", "TCIWA"},
{121, "Maximum temperature at 2 metres in the last 6 hours anomaly", "K", "MX2T6A"},
{122, "Minimum temperature at 2 metres in the last 6 hours anomaly", "K", "MN2T6A"},
{125, "Vertically integrated total energy anomaly", "J m**-2", "VITEA"},
{126, "Generic parameter for sensitive area prediction", "Various", ""},
{127, "Atmospheric tide anomaly", "-", "ATA"},
{128, "Budget values anomaly", "-", "BVA"},
{129, "Geopotential anomaly", "m**2 s**-2", "ZA"},
{130, "Temperature anomaly", "K", "TA"},
{131, "U component of wind anomaly", "m s**-1", "UA"},
{132, "V component of wind anomaly", "m s**-1", "VA"},
{133, "Specific humidity anomaly", "kg kg**-1", "QA"},
{134, "Surface pressure anomaly", "Pa", "SPA"},
{135, "Vertical velocity", "Pa s**-1", "WA"},
{136, "Total column water anomaly", "kg m**-2", "TCWA"},
{137, "Total column water vapour anomaly", "kg m**-2", "TCWVA"},
{138, "Relative vorticity anomaly", "s**-1", "VOA"},
{139, "Soil temperature anomaly level 1", "K", "STAL1"},
{140, "Soil wetness anomaly level 1", "kg m**-2", "SWAL1"},
{141, "Snow depth anomaly", "m of water equivalent", "SDA"},
{142, "Stratiform precipitation", "m", "LSPA"},
{143, "Convective precipitation anomaly", "m", "CPA"},
{144, "Snowfall", "m of water equivalent", "SFA"},
{145, "Boundary layer dissipation anomaly", "J m**-2", "BLDA"},
{146, "Surface sensible heat flux anomaly", "J m**-2", "SSHFA"},
{147, "Surface latent heat flux anomaly", "J m**-2", "SLHFA"},
{148, "Charnock anomaly", "-", "CHNKA"},
{149, "Surface net radiation anomaly", "J m**-2", "SNRA"},
{150, "Top net radiation anomaly", "-", "TNRA"},
{151, "Mean sea level pressure anomaly", "Pa", "MSLA"},
{152, "Logarithm of surface pressure anomaly", "-", "LSPA"},
{153, "Short-wave heating rate anomaly", "K", "SWHRA"},
{154, "Long-wave heating rate anomaly", "K", "LWHRA"},
{155, "Relative divergence anomaly", "s**-1", "DA"},
{156, "Height anomaly", "m", "GHA"},
{157, "Relative humidity anomaly", "%", "RA"},
{158, "Tendency of surface pressure anomaly", "Pa s**-1", "TSPA"},
{159, "Boundary layer height anomaly", "m", "BLHA"},
{160, "Standard deviation of orography anomaly", "-", "SDORA"},
{161, "Anisotropy of sub-gridscale orography anomaly", "-", "ISORA"},
{162, "Angle of sub-gridscale orography anomaly", "radians", "ANORA"},
{163, "Slope of sub-gridscale orography anomaly", "-", "SLORA"},
{164, "Total cloud cover anomaly", "(0 - 1)", "TCCA"},
{165, "10 metre U wind component anomaly", "m s**-1", "10UA"},
{166, "10 metre V wind component anomaly", "m s**-1", "10VA"},
{167, "2 metre temperature anomaly", "K", "2TA"},
{168, "2 metre dewpoint temperature anomaly", "K", "2DA"},
{169, "Surface solar radiation downwards anomaly", "J m**-2", "SSRDA"},
{170, "Soil temperature anomaly level 2", "K", "SLAL2"},
{171, "Soil wetness anomaly level 2", "kg m**-2", "SWAL2"},
{172, "Land-sea mask", "(0 - 1)", "LSM"},
{173, "Surface roughness anomaly", "m", "SRA"},
{174, "Albedo anomaly", "(0 - 1)", "ALA"},
{175, "Surface thermal radiation downwards anomaly", "J m**-2", "STRDA"},
{176, "Surface net solar radiation anomaly", "J m**-2", "SSRA"},
{177, "Surface net thermal radiation anomaly", "J m**-2", "STRA"},
{178, "Top net solar radiation anomaly", "J m**-2", "TSRA"},
{179, "Top net thermal radiation anomaly", "J m**-2", "TTRA"},
{180, "East-West surface stress anomaly", "N m**-2 s", "EQSSA"},
{181, "North-South surface stress anomaly", "N m**-2 s", "NSSSA"},
{182, "Evaporation anomaly", "kg m**-2", "EA"},
{183, "Soil temperature anomaly level 3", "K", "STAL3"},
{184, "Soil wetness anomaly level 3", "kg m**-2", "SWAL3"},
{185, "Convective cloud cover anomaly", "(0 - 1)", "CCCA"},
{186, "Low cloud cover anomaly", "(0 - 1)", "LCCA"},
{187, "Medium cloud cover anomaly", "(0 - 1)", "MCCA"},
{188, "High cloud cover anomaly", "(0 - 1)", "HCCA"},
{189, "Sunshine duration anomaly", "s", "SUNDA"},
{190, "East-West component of sub-gridscale orographic variance anomaly", "m**2", "EWOVA"},
{191, "North-South component of sub-gridscale orographic variance anomaly", "m**2", "NSOVA"},
{192, "North-West", "m**2", "NWOVA"},
{193, "North-East", "m**2", "NEOVA"},
{194, "Brightness temperature anomaly", "K", "BTMPA"},
{195, "Longitudinal component of gravity wave stress anomaly", "N m**-2 s", "LGWSA"},
{196, "Meridional component of gravity wave stress anomaly", "N m**-2 s", "MGWSA"},
{197, "Gravity wave dissipation anomaly", "J m**-2", "GWDA"},
{198, "Skin reservoir content anomaly", "kg m**-2", "SRCA"},
{199, "Vegetation fraction anomaly", "(0 - 1)", "VFA"},
{200, "Variance of sub-gridscale orography anomaly", "m**2", "VSOA"},
{201, "Maximum temperature at 2 metres anomaly", "K", "MX2TA"},
{202, "Minimum temperature at 2 metres anomaly", "K", "MN2TA"},
{203, "Ozone mass mixing ratio anomaly", "kg kg**-1", "O3A"},
{204, "Precipitation analysis weights anomaly", "-", "PAWA"},
{205, "Runoff anomaly", "m", "ROA"},
{206, "Total column ozone anomaly", "kg m**-2", "TCO3A"},
{207, "10 metre wind speed anomaly", "m s**-1", "10UA"},
{208, "Top net solar radiation clear sky anomaly", "J m**-2", "TSRCA"},
{209, "Top net thermal radiation clear sky anomaly", "J m**-2", "TTRCA"},
{210, "Surface net solar radiation clear sky anomaly", "J m**-2", "SSRCA"},
{211, "Surface net thermal radiation", "J m**-2", "STRCA"},
{212, "Solar insolation anomaly", "J m**-2", "SIA"},
{214, "Diabatic heating by radiation anomaly", "K", "DHRA"},
{215, "Diabatic heating by vertical diffusion anomaly", "K", "DHVDA"},
{216, "Diabatic heating by cumulus convection anomaly", "K", "DHCCA"},
{217, "Diabatic heating by large-scale condensation anomaly", "K", "DHLCA"},
{218, "Vertical diffusion of zonal wind anomaly", "m s**-1", "VDZWA"},
{219, "Vertical diffusion of meridional wind anomaly", "m s**-1", "VDMWA"},
{220, "East-West gravity wave drag tendency anomaly", "m s**-1", "EWGDA"},
{221, "North-South gravity wave drag tendency anomaly", "m s**-1", "NSGDA"},
{222, "Convective tendency of zonal wind anomaly", "m s**-1", "CTZWA"},
{223, "Convective tendency of meridional wind anomaly", "m s**-1", "CTMWA"},
{224, "Vertical diffusion of humidity anomaly", "kg kg**-1", "VDHA"},
{225, "Humidity tendency by cumulus convection anomaly", "kg kg**-1", "HTCCA"},
{226, "Humidity tendency by large-scale condensation anomaly", "kg kg**-1", "HTLCA"},
{227, "Change from removal of negative humidity anomaly", "kg kg**-1", "CRNHA"},
{228, "Total precipitation anomaly", "m", "TPA"},
{229, "Instantaneous X surface stress anomaly", "N m**-2", "IEWSA"},
{230, "Instantaneous Y surface stress anomaly", "N m**-2", "INSSA"},
{231, "Instantaneous surface heat flux anomaly", "J m**-2", "ISHFA"},
{232, "Instantaneous moisture flux anomaly", "kg m**-2 s", "IEA"},
{233, "Apparent surface humidity anomaly", "kg kg**-1", "ASQA"},
{234, "Logarithm of surface roughness length for heat anomaly", "-", "LSRHA"},
{235, "Skin temperature anomaly", "K", "SKTA"},
{236, "Soil temperature level 4 anomaly", "K", "STAL4"},
{237, "Soil wetness level 4 anomaly", "m", "SWAL4"},
{238, "Temperature of snow layer anomaly", "K", "TSNA"},
{239, "Convective snowfall anomaly", "m of water equivalent", "CSFA"},
{240, "Large scale snowfall anomaly", "m of water equivalent", "LSFA"},
{241, "Accumulated cloud fraction tendency anomaly", "(-1 to 1)", "ACFA"},
{242, "Accumulated liquid water tendency anomaly", "(-1 to 1)", "ALWA"},
{243, "Forecast albedo anomaly", "(0 - 1)", "FALA"},
{244, "Forecast surface roughness anomaly", "m", "FSRA"},
{245, "Forecast logarithm of surface roughness for heat anomaly", "-", "FLSRA"},
{246, "Cloud liquid water content anomaly", "kg kg**-1", "CLWCA"},
{247, "Cloud ice water content anomaly", "kg kg**-1", "CIWCA"},
{248, "Cloud cover anomaly", "(0 - 1)", "CCA"},
{249, "Accumulated ice water tendency anomaly", "(-1 to 1)", "AIWA"},
{250, "Ice age anomaly", "(0 - 1)", "IAA"},
{251, "Adiabatic tendency of temperature anomaly", "K", "ATTEA"},
{252, "Adiabatic tendency of humidity anomaly", "kg kg**-1", "ATHEA"},
{253, "Adiabatic tendency of zonal wind anomaly", "m s**-1", "ATZEA"},
{254, "Adiabatic tendency of meridional wind anomaly", "m s**-1", "ATMWA"},
};
