#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <mysql.h>
#include <qmainwindow.h>
#include <qtoolbar.h>
#include <qcombobox.h>
#include <qpopupmenu.h>
#include <qtabwidget.h>
#include <qsplitter.h>
#include <qtoolbutton.h>
#include <qapplication.h>
#include <qworkspace.h>
#include <qlineedit.h>
#include <qmap.h>
#include <qlistview.h>
#include <qlineedit.h>

#include "mainwindowoption.h"
#include "xworkspace.h"
#include "xcombobox.h"
#include "loglistview.h"

struct server_data
{
	QString user;
	QString password;
	QString database;
	QString port;
	QString socket;
	QString timeout;
};

class MainWindow: public QMainWindow
{
Q_OBJECT

public:
	MainWindow();
	~MainWindow();

public slots:
	void slot_open();
	void slot_open2();

private slots:
	void slot_new();
	void slot_quit();
	void slot_exit();
	void slot_close();
	void slot_close_all();
	void slot_close_all_except_schema();
	void slot_windows();
	void slot_motif();
	void slot_motif_plus();
	void slot_cde();
	void slot_platinum();
	void slot_sgi();
	void slot_jfc();
	void slot_nextstep();
	void slot_default_style();
	void slot_user(int);
	void slot_user_create();
	void slot_user_modify();
	void slot_user_delete();
	void slot_table();
	void slot_table(const QString &);
	void slot_query2();
	void slot_query2(int);
	void slot_process();
	void slot_xport();
	void slot_xport(int);
	void slot_status();
	void slot_variable();
	void slot_password();
	void slot_password_modify();
	void slot_ping();
	void slot_flush();
	void slot_flush_hosts();
	void slot_flush_logs();
	void slot_flush_privilages();
	void slot_flush_status();
	void slot_flush_tables();
	void slot_flush_threads();
	void slot_script();
	void slot_edit();
	void slot_terminal();
	void slot_clear_query();
	void slot_save_query();
	void about();
	void aboutQt();
	void slot_error();
	void slot_query();
	void slot_create_database(int);
	void slot_delete_database(int);
	void slot_create_table(int);
	void slot_delete_table(int);
	void slot_delete_field(int);
	void slot_delete_primary(int);
	void slot_delete_index(int);
	void slot_delete_unique(int);
	void slot_create_primary(int);
	void slot_create_unique(int);
	void slot_create_index(int);
	void slot_create_field(int);
	void slot_create_field();
	void slot_change_field(int);
	void slot_modify_field(int);
	void slot_highlight(int);
	void slot_schema_clicked(QListViewItem *, const QPoint &, int);
	void slot_schema_clicked(QListViewItem *);
	void slot_table_records(int);
	void slot_table_keys(int);
	void slot_table_fields(int);
	void slot_table_status(int);
	void slot_query(const QString &, const QString &);
	void slot_query(const QString &, const QString &, const QString &);
	void slot_schema(int);		
	void slot_schema();
	void slot_flush_hosts(int);
	void slot_flush_logs(int);
	void slot_flush_status(int);
	void slot_flush_tables(int);
	void slot_flush_tables2(int);
	void slot_flush_privileges(int);
	void slot_truncate_table(int);
	void slot_rename_table(int);
	void slot_shutdown();
	void slot_privilege();
	void slot_option();
	void slot_xpm();
	void slot_workspace_clicked();
	void slot_find();
	void slot_optimize();
	void slot_check_normal();
	void slot_check_quick();
	void slot_ckeck_fast();
	void slot_check_changed();
	void slot_check_extended();
	void slot_analyze();
	void slot_repair_normal();
	void slot_repair_quick();
	void slot_read_lock_table(int);	
	void slot_read_local_lock_table(int);	
	void slot_write_lock(int);	
	void slot_low_priority_write_lock(int);	
	void slot_unlock_table(int);
	void slot_table_in_database(int);
	void slot_schema2();
	bool slot_database();
	void slot_server(const QString &, const QString &);
	void slot_move_table(int);
	void slot_copy_table(int);
	void slot_font(int);
	void slot_key(int);
	void slot_create_key(int);
	void slot_key(const QString &, const QString &);
	void slot_delete_key();
	void slot_log();
		
public slots:
	void slot_list_fields(int);
	void slot_unlist_fields(int);
	void slot_query2(const QString &, const QString &);

protected:
	virtual void closeEvent(QCloseEvent *);
	virtual void keyPressEvent(QKeyEvent *);
	virtual void resizeEvent(QResizeEvent *);

private:
	void make_layout();
	void make_central_widget();
	void make_toolbar();
	void make_menubar();
	void make_statusbar();
	void set_base_color(QWidget *,QColor);
	void set_xpm_color(QWidget *,QColor);
	void signal_connect();
	void load_session();
	void save_session();
	void disable_menu();
	void save_query();
	void clear_query();
	void initialize();
	void load_query();
	void enable_menu();
	bool is_sql_exist(const QString &);
	QList<QString> get_database();

private:
	QComboBox *query;
	XWorkspace *workspace;
	
public:
	MYSQL mysql;
	bool open;
	char host[255];
	char user[255];
	struct __option__ option;
	QMap<QString, struct server_data> server_map;
	QListViewItem *hay; 	
	XComboBox *database;
	LogListView *log;
	QComboBox *host1;
	QComboBox *user1;
	QComboBox *port1;
	QLineEdit *password1;
	QComboBox *database1;
	
public:
	void open_directly(const QString &host, const QString &user, const QString &password, const QString &database, const int &port, const QString &socket, const QString &timeout);
	
signals:
	void signal_schema();
	void signal_xpm(const QString&);
	void signal_database();
};

#endif 
