<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Moodle's formal_white theme, an example of how to make a Bootstrap theme
 *
 * DO NOT MODIFY THIS THEME!
 * COPY IT FIRST, THEN RENAME THE COPY AND MODIFY IT INSTEAD.
 *
 * For full information about creating Moodle themes, see:
 * http://docs.moodle.org/dev/Themes_2.0
 *
 * @package   theme_formal_white
 * @copyright 2013 Mediatouch 2000, mediatouch.it
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['blockcolumnwidth'] = 'Blocks column width';
$string['blockcolumnwidthdesc'] = 'This sets the blocks column width for the theme. <strong>If width is lower than 200px (blockcolumnwidth-2*blockpadding), the calendar block is not able to fit.</strong>';
$string['blockcontentbgc'] = 'Blocks content background colour';
$string['blockcontentbgcdesc'] = 'This sets the blocks content background colour for the theme.';
$string['blockpadding'] = 'Margin around blocks';
$string['blockpaddingdesc'] = 'This sets the margin between each block and the containing column.';
$string['blueberry'] = 'blueberry';
$string['choosereadme'] = '
<div class="clearfix">
    <div class="theme_screenshot">
        <h2>Formal White</h2>
        <img src="formal_white/pix/screenshot.gif" />

        <h3>Theme Discussion Forum:</h3>
        <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

        <h3>Theme Credits</h3>
        <p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>

        <h3>Theme Documentation:</h3>
        <p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

        <h3>Report a bug:</h3>
        <p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
    </div>
    <div class="theme_description">
        <h2>About</h2>
        <p>Formal White is a fluid-width, three-column theme ported over to 2.0 from Moodle 1.X.</p>
        <h2>Tweaks</h2>
        <p>This theme is built upon both Base and Canvas, two parent themes included in the Moodle core. If you want to modify this theme, we recommend that you first duplicate it, then rename it before making your changes. This will prevent your customized theme from being overwritten by future Moodle upgrades, and you\'ll still have the original files if you make a mess. More information on modifying themes can be found in the <a href="http://docs.moodle.org/en/Theme">MoodleDocs</a>.</p>
    <h2>Credits</h2>
    <p>This theme was coded and is maintained by MediaTouch 2000. </p>
        <h2>License</h2>
        <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.
    </div>
</div>';
$string['configtitle'] = 'Formal white theme';
$string['creditstomoodleorg'] = 'Display credits to moodle.org';
$string['creditstomoodleorgdesc'] = 'Display the usual small moodle logo at the bottom of the page';
$string['ctmo_ineverypage'] = 'in every page'; // ctmo == credits to moodle org
$string['ctmo_no'] = 'never'; // ctmo == credits to moodle org
$string['ctmo_onfrontpageonly'] = 'in the front page only'; // ctmo == credits to moodle org
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Any CSS you enter here will be added to every page allowing your to easily customise this theme. For example, it is possible to change colour of links adding one or more of the following:
<pre>a:link, a:visited, a:hover, a:active, a:focus {color:blue;}</pre>
Please adjust colors and CSS rules to fit your needs.';
$string['customlogourl'] = 'Custom logo';
$string['customlogourldesc'] = 'Change the logo for this theme by entering the full or relative URL to an image you wish to use (i.e. http://www.yoursite.tld/mylogo.png or ../path/to/your/logo.png). As a reference the default logo is 200px wide, 50px high and a transparent png will work best.';
$string['displayheading'] = 'Display page heading';
$string['displaylogo'] = 'Display logo';
$string['fontsizereference'] = 'Font size reference';
$string['fontsizereferencedesc'] = 'This allows you to set the default font size for this theme. It is not recommended to set this higher than 13px as it is known to cause display problems with certain blocks.';
$string['footnote'] = 'Footnote';
$string['footnotedesc'] = 'The content from this textarea will be displayed in the footer of every page.';
$string['framemargin'] = 'Frame margin';
$string['framemargindesc'] = 'Room between the frame and the edge of the browser window. (This setting will be ignored if "{$a}" is requested).';
$string['frontpagelogourl'] = 'Custom front page logo';
$string['frontpagelogourldesc'] = 'Change the logo that is displayed on the front page of your site by entering the full or relative URL to the image you wish to use (i.e. http://www.yoursite.tld/myfrontpagelogo.png or ../path/to/your/logo.png). This setting overrides the custom logo setting. As a reference the default logo is 300px wide, 80px high and a transparent png will work best.';
$string['headerbgc'] = 'Header background colour';
$string['headerbgcdesc'] = 'This sets the blocks header background colour for the theme.';
$string['headercontent'] = 'Header content';
$string['headercontentdesc'] = 'Choose whether display moodle logo or page heading text in the header.';
$string['lblockcolumnbgc'] = 'Left column background colour';
$string['lblockcolumnbgcdesc'] = 'This sets the left column background colour for the theme.';
$string['lemon'] = 'lemon';
$string['lime'] = 'lime';
$string['mink'] = 'mink';
$string['noframe'] = 'Formal white 1.9 look';
$string['noframedesc'] = 'Select this option to require your moodle page to look like moodle 1.*, alias, without the surrounding frame.';
$string['orange'] = 'orange';
$string['peach'] = 'peach';
$string['pluginname'] = 'Formal white';
$string['rblockcolumnbgc'] = 'Right column background colour';
$string['rblockcolumnbgcdesc'] = 'This sets the right column background colour for the theme. If you leave this empty the left column background colour will be used.';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['silver'] = 'silver';
$string['trendcolor'] = 'Trend color';
$string['trendcolordesc'] = 'Choose the general trend for the color of the theme.';
