/*-------------------------------------------------------------------------
 * Copyright (c) 2000-2002 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * mathwar_main
 *
 * Synopsis:
 *   Main module for the MathWar game.
 *
 * $Id: mathwar_main.c,v 1.2 2002/02/17 19:59:30 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
#ifdef HAVE_CONFIG_H
#   include <config.h>
#endif

#include <gnome.h>
#include <syslog.h>

#include "cards.h"
#include "mainwin.h"

#define STD_DISCLAIMER "\
%s version %s, Copyright (C) 2000 Kenneth W. Sodemann\n\n\
%s is free software; you can redistribute it and/or modify it\n\
under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n\n\
%s is distributed in the hope that it will be useful, but\n\
WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n\n"

static void
session_die (GnomeClient *client, gpointer client_data)
{
   gtk_main_quit();
}


static gint
session_save (GnomeClient        *client,
              gint                phase,
              GnomeSaveStyle      save_style,
              gint                is_shutdown,
              GnomeInteractStyle  interact_style,
              gint                is_fast,
              gpointer            client_data)
{
   gchar **argv;
   guint   argc;

   argv = g_malloc0 (sizeof (gchar*) * 2);

   argv[0] = client_data;
   argc = 1;

   gnome_client_set_clone_command (client, argc, argv);
   gnome_client_set_restart_command (client, argc, argv);

   return TRUE;
}


int
main (int argc, char *argv[])
{
   GnomeClient  *client;
   GtkWidget    *mainwin;
   static gint   show_copyright = FALSE;
   poptContext   pctx;

   struct poptOption options[] = {
      {
         "copyright",
         'c',
         POPT_ARG_NONE,
         &show_copyright,
         0,
         N_("Show the copyright information, and exit"),
         NULL
      },
      {
         NULL,
         '\0',
         0,
         NULL,
         0,
         NULL,
         NULL
      }
   };

#ifdef ENABLE_NLS
   bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
   textdomain (PACKAGE);
#endif

   gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv,
                               options, 0, &pctx);

   if (show_copyright)
      {
      g_print (_(STD_DISCLAIMER), PACKAGE, VERSION, PACKAGE, PACKAGE);
      exit (0);
      }

   if (!load_deck())
      {
      g_error ("Something about the load_deck() failed!!\n");
      }
   mainwin = create_mainwin ();
   gtk_widget_show (mainwin);

   client = gnome_master_client();
   gtk_signal_connect (GTK_OBJECT (client), "save_yourself",
                       GTK_SIGNAL_FUNC (session_save), argv[0]);
   gtk_signal_connect (GTK_OBJECT (client), "die",
                       GTK_SIGNAL_FUNC (session_die), NULL);

   gtk_main();
   destroy_deck();

   return 0;
}
