/*
 *  /MathJax/config/AM_HTMLorMML-full.js
 *  
 *  Copyright (c) 2010-2014 The MathJax Consortium
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

MathJax.Hub.Config({delayJaxRegistration: true});

MathJax.Ajax.Preloading(
  "[MathJax]/jax/input/AsciiMath/config.js",
  "[MathJax]/jax/output/HTML-CSS/config.js",
  "[MathJax]/jax/output/NativeMML/config.js",
  "[MathJax]/config/MMLorHTML.js",
  "[MathJax]/extensions/asciimath2jax.js",
  "[MathJax]/extensions/MathEvents.js",
  "[MathJax]/extensions/MathZoom.js",
  "[MathJax]/extensions/MathMenu.js",
  "[MathJax]/jax/element/mml/jax.js",
  "[MathJax]/extensions/toMathML.js",
  "[MathJax]/jax/input/AsciiMath/jax.js",
  "[MathJax]/jax/output/NativeMML/jax.js",
  "[MathJax]/jax/output/HTML-CSS/jax.js",
  "[MathJax]/jax/output/HTML-CSS/autoload/mtable.js"
);

MathJax.Hub.Config({"v1.0-compatible":false});

MathJax.InputJax.AsciiMath=MathJax.InputJax({id:"AsciiMath",version:"2.4.0",directory:MathJax.InputJax.directory+"/AsciiMath",extensionDir:MathJax.InputJax.extensionDir+"/AsciiMath",config:{fixphi:true,useMathMLspacing:true,displaystyle:true,decimalsign:"."}});MathJax.InputJax.AsciiMath.Register("math/asciimath");MathJax.InputJax.AsciiMath.loadComplete("config.js");
MathJax.OutputJax["HTML-CSS"]=MathJax.OutputJax({id:"HTML-CSS",version:"2.4.0",directory:MathJax.OutputJax.directory+"/HTML-CSS",extensionDir:MathJax.OutputJax.extensionDir+"/HTML-CSS",autoloadDir:MathJax.OutputJax.directory+"/HTML-CSS/autoload",fontDir:MathJax.OutputJax.directory+"/HTML-CSS/fonts",webfontDir:MathJax.OutputJax.fontDir+"/HTML-CSS",config:{matchFontHeight:true,scale:100,minScaleAdjust:50,availableFonts:["STIX","TeX"],preferredFont:"TeX",webFont:"TeX",imageFont:"TeX",undefinedFamily:"STIXGeneral,'Arial Unicode MS',serif",mtextFontInherit:false,EqnChunk:(MathJax.Hub.Browser.isMobile?10:50),EqnChunkFactor:1.5,EqnChunkDelay:100,linebreaks:{automatic:false,width:"container"},styles:{".MathJax_Display":{"text-align":"center",margin:"1em 0em"},".MathJax .merror":{"background-color":"#FFFF88",color:"#CC0000",border:"1px solid #CC0000",padding:"1px 3px","font-style":"normal","font-size":"90%"},".MathJax .MJX-monospace":{"font-family":"monospace"},".MathJax .MJX-sans-serif":{"font-family":"sans-serif"},"#MathJax_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')",padding:"3px 4px","z-index":401}}}});if(MathJax.Hub.Browser.isMSIE&&document.documentMode>=9){delete MathJax.OutputJax["HTML-CSS"].config.styles["#MathJax_Tooltip"].filter}if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}MathJax.Hub.Register.StartupHook("End Config",[function(b,c){var a=b.Insert({minBrowserVersion:{Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4},inlineMathDelimiters:["$","$"],displayMathDelimiters:["$$","$$"],multilineDisplay:true,minBrowserTranslate:function(f){var e=b.getJaxFor(f),k=["[Math]"],j;var h=document.createElement("span",{className:"MathJax_Preview"});if(e.inputJax==="TeX"){if(e.root.Get("displaystyle")){j=a.displayMathDelimiters;k=[j[0]+e.originalText+j[1]];if(a.multilineDisplay){k=k[0].split(/\n/)}}else{j=a.inlineMathDelimiters;k=[j[0]+e.originalText.replace(/^\s+/,"").replace(/\s+$/,"")+j[1]]}}for(var g=0,d=k.length;g<d;g++){h.appendChild(document.createTextNode(k[g]));if(g<d-1){h.appendChild(document.createElement("br"))}}f.parentNode.insertBefore(h,f)}},(b.config["HTML-CSS"]||{}));if(b.Browser.version!=="0.0"&&!b.Browser.versionAtLeast(a.minBrowserVersion[b.Browser]||0)){c.Translate=a.minBrowserTranslate;b.Config({showProcessingMessages:false});MathJax.Message.Set(["MathJaxNotSupported","Your browser does not support MathJax"],null,4000);b.Startup.signal.Post("MathJax not supported")}},MathJax.Hub,MathJax.OutputJax["HTML-CSS"]]);MathJax.OutputJax["HTML-CSS"].loadComplete("config.js");
MathJax.OutputJax.NativeMML=MathJax.OutputJax({id:"NativeMML",version:"2.4.0",directory:MathJax.OutputJax.directory+"/NativeMML",extensionDir:MathJax.OutputJax.extensionDir+"/NativeMML",config:{matchFontHeight:true,scale:100,minScaleAdjust:50,styles:{"div.MathJax_MathML":{"text-align":"center",margin:".75em 0px"}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.NativeMML.Register("jax/mml")}MathJax.OutputJax.NativeMML.loadComplete("config.js");
(function(c,g){var f="2.4.0";var a=MathJax.Hub.CombineConfig("MMLorHTML",{prefer:{MSIE:"MML",Firefox:"HTML",Opera:"HTML",Chrome:"HTML",Safari:"HTML",other:"HTML"}});var e={Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4};var b=(g.version==="0.0"||g.versionAtLeast(e[g]||0));var d=(g.isFirefox&&g.versionAtLeast("1.5"))||(g.isMSIE&&g.hasMathPlayer)||(g.isSafari&&g.versionAtLeast("5.0"))||(g.isOpera&&g.versionAtLeast("9.52"));c.Register.StartupHook("End Config",function(){var h=(a.prefer&&typeof(a.prefer)==="object"?a.prefer[MathJax.Hub.Browser]||a.prefer.other||"HTML":a.prefer);if(b||d){if(d&&(h==="MML"||!b)){if(MathJax.OutputJax.NativeMML){MathJax.OutputJax.NativeMML.Register("jax/mml")}else{c.config.jax.unshift("output/NativeMML")}c.Startup.signal.Post("NativeMML output selected")}else{if(MathJax.OutputJax["HTML-CSS"]){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}else{c.config.jax.unshift("output/HTML-CSS")}c.Startup.signal.Post("HTML-CSS output selected")}}else{c.PreProcess.disabled=true;c.prepareScripts.disabled=true;MathJax.Message.Set(["MathJaxNotSupported","Your browser does not support MathJax"],null,4000);c.Startup.signal.Post("MathJax not supported")}})})(MathJax.Hub,MathJax.Hub.Browser);MathJax.Ajax.loadComplete("[MathJax]/config/MMLorHTML.js");
MathJax.Extension.asciimath2jax={version:"2.4.0",config:{delimiters:[["`","`"]],skipTags:["script","noscript","style","textarea","pre","code","annotation","annotation-xml"],ignoreClass:"asciimath2jax_ignore",processClass:"asciimath2jax_process",preview:"AsciiMath"},PreProcess:function(a){if(!this.configured){this.config=MathJax.Hub.CombineConfig("asciimath2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.configured=true}if(typeof(a)==="string"){a=document.getElementById(a)}if(!a){a=document.body}if(this.createPatterns()){this.scanElement(a,a.nextSibling)}},createPatterns:function(){var d=[],c,a,b=this.config;this.match={};if(b.delimiters.length===0){return false}for(c=0,a=b.delimiters.length;c<a;c++){d.push(this.patternQuote(b.delimiters[c][0]));this.match[b.delimiters[c][0]]={mode:"",end:b.delimiters[c][1],pattern:this.endPattern(b.delimiters[c][1])}}this.start=new RegExp(d.sort(this.sortLength).join("|"),"g");this.skipTags=new RegExp("^("+b.skipTags.join("|")+")$","i");var e=[];if(MathJax.Hub.config.preRemoveClass){e.push(MathJax.Hub.config.preRemoveClass)}if(b.ignoreClass){e.push(b.ignoreClass)}this.ignoreClass=(e.length?new RegExp("(^| )("+e.join("|")+")( |$)"):/^$/);this.processClass=new RegExp("(^| )("+b.processClass+")( |$)");return true},patternQuote:function(a){return a.replace(/([\^$(){}+*?\-|\[\]\:\\])/g,"\\$1")},endPattern:function(a){return new RegExp(this.patternQuote(a)+"|\\\\.","g")},sortLength:function(d,c){if(d.length!==c.length){return c.length-d.length}return(d==c?0:(d<c?-1:1))},scanElement:function(c,b,g){var a,e,d,f;while(c&&c!=b){if(c.nodeName.toLowerCase()==="#text"){if(!g){c=this.scanText(c)}}else{a=(typeof(c.className)==="undefined"?"":c.className);e=(typeof(c.tagName)==="undefined"?"":c.tagName);if(typeof(a)!=="string"){a=String(a)}f=this.processClass.exec(a);if(c.firstChild&&!a.match(/(^| )MathJax/)&&(f||!this.skipTags.exec(e))){d=(g||this.ignoreClass.exec(a))&&!f;this.scanElement(c.firstChild,b,d)}}if(c){c=c.nextSibling}}},scanText:function(b){if(b.nodeValue.replace(/\s+/,"")==""){return b}var a,c;this.search={start:true};this.pattern=this.start;while(b){this.pattern.lastIndex=0;while(b&&b.nodeName.toLowerCase()==="#text"&&(a=this.pattern.exec(b.nodeValue))){if(this.search.start){b=this.startMatch(a,b)}else{b=this.endMatch(a,b)}}if(this.search.matched){b=this.encloseMath(b)}if(b){do{c=b;b=b.nextSibling}while(b&&(b.nodeName.toLowerCase()==="br"||b.nodeName.toLowerCase()==="#comment"));if(!b||b.nodeName!=="#text"){return c}}}return b},startMatch:function(a,b){var c=this.match[a[0]];if(c!=null){this.search={end:c.end,mode:c.mode,open:b,olen:a[0].length,opos:this.pattern.lastIndex-a[0].length};this.switchPattern(c.pattern)}return b},endMatch:function(a,b){if(a[0]==this.search.end){this.search.close=b;this.search.cpos=this.pattern.lastIndex;this.search.clen=(this.search.isBeginEnd?0:a[0].length);this.search.matched=true;b=this.encloseMath(b);this.switchPattern(this.start)}return b},switchPattern:function(a){a.lastIndex=this.pattern.lastIndex;this.pattern=a;this.search.start=(a===this.start)},encloseMath:function(b){var a=this.search,f=a.close,e,c;if(a.cpos===f.length){f=f.nextSibling}else{f=f.splitText(a.cpos)}if(!f){e=f=MathJax.HTML.addText(a.close.parentNode,"")}a.close=f;c=(a.opos?a.open.splitText(a.opos):a.open);while(c.nextSibling&&c.nextSibling!==f){if(c.nextSibling.nodeValue!==null){if(c.nextSibling.nodeName==="#comment"){c.nodeValue+=c.nextSibling.nodeValue.replace(/^\[CDATA\[((.|\n|\r)*)\]\]$/,"$1")}else{c.nodeValue+=c.nextSibling.nodeValue}}else{if(this.msieNewlineBug){c.nodeValue+=(c.nextSibling.nodeName.toLowerCase()==="br"?"\n":" ")}else{c.nodeValue+=" "}}c.parentNode.removeChild(c.nextSibling)}var d=c.nodeValue.substr(a.olen,c.nodeValue.length-a.olen-a.clen);c.parentNode.removeChild(c);if(this.config.preview!=="none"){this.createPreview(a.mode,d)}c=this.createMathTag(a.mode,d);this.search={};this.pattern.lastIndex=0;if(e){e.parentNode.removeChild(e)}return c},insertNode:function(b){var a=this.search;a.close.parentNode.insertBefore(b,a.close)},createPreview:function(c,a){var b=this.config.preview;if(b==="none"){return}if(b==="AsciiMath"){b=[this.filterPreview(a)]}if(b){b=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},b);this.insertNode(b)}},createMathTag:function(c,a){var b=document.createElement("script");b.type="math/asciimath"+c;MathJax.HTML.setScript(b,a);this.insertNode(b);return b},filterPreview:function(a){return a},msieNewlineBug:(MathJax.Hub.Browser.isMSIE&&(document.documentMode||0)<9)};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.asciimath2jax]);MathJax.Ajax.loadComplete("[MathJax]/extensions/asciimath2jax.js");
(function(d,h,l,g,m,b,j){var q="2.4.0";var i=MathJax.Extension;var c=i.MathEvents={version:q};var k=d.config.menuSettings;var p={hover:500,frame:{x:3.5,y:5,bwidth:1,bcolor:"#A6D",hwidth:"15px",hcolor:"#83A"},button:{x:-4,y:-3,wx:-2,src:l.urlRev(b.imageDir+"/MenuArrow-15.png")},fadeinInc:0.2,fadeoutInc:0.05,fadeDelay:50,fadeoutStart:400,fadeoutDelay:15*1000,styles:{".MathJax_Hover_Frame":{"border-radius":".25em","-webkit-border-radius":".25em","-moz-border-radius":".25em","-khtml-border-radius":".25em","box-shadow":"0px 0px 15px #83A","-webkit-box-shadow":"0px 0px 15px #83A","-moz-box-shadow":"0px 0px 15px #83A","-khtml-box-shadow":"0px 0px 15px #83A",border:"1px solid #A6D ! important",display:"inline-block",position:"absolute"},".MathJax_Hover_Arrow":{position:"absolute",width:"15px",height:"11px",cursor:"pointer"}}};var n=c.Event={LEFTBUTTON:0,RIGHTBUTTON:2,MENUKEY:"altKey",Mousedown:function(r){return n.Handler(r,"Mousedown",this)},Mouseup:function(r){return n.Handler(r,"Mouseup",this)},Mousemove:function(r){return n.Handler(r,"Mousemove",this)},Mouseover:function(r){return n.Handler(r,"Mouseover",this)},Mouseout:function(r){return n.Handler(r,"Mouseout",this)},Click:function(r){return n.Handler(r,"Click",this)},DblClick:function(r){return n.Handler(r,"DblClick",this)},Menu:function(r){return n.Handler(r,"ContextMenu",this)},Handler:function(u,s,t){if(l.loadingMathMenu){return n.False(u)}var r=b[t.jaxID];if(!u){u=window.event}u.isContextMenu=(s==="ContextMenu");if(r[s]){return r[s](u,t)}if(i.MathZoom){return i.MathZoom.HandleEvent(u,s,t)}},False:function(r){if(!r){r=window.event}if(r){if(r.preventDefault){r.preventDefault()}else{r.returnValue=false}if(r.stopPropagation){r.stopPropagation()}r.cancelBubble=true}return false},ContextMenu:function(u,F,x){var C=b[F.jaxID],w=C.getJaxFromMath(F);var G=(C.config.showMathMenu!=null?C:d).config.showMathMenu;if(!G||(k.context!=="MathJax"&&!x)){return}if(c.msieEventBug){u=window.event||u}n.ClearSelection();f.ClearHoverTimer();if(w.hover){if(w.hover.remove){clearTimeout(w.hover.remove);delete w.hover.remove}w.hover.nofade=true}var v=MathJax.Menu;var H,E;if(v){if(v.loadingDomain){return n.False(u)}H=m.loadDomain("MathMenu");if(!H){v.jax=w;var s=v.menu.Find("Show Math As").menu;s.items[0].name=w.sourceMenuTitle;s.items[0].format=(w.sourceMenuFormat||"MathML");s.items[1].name=j[w.inputJax].sourceMenuTitle;s.items[5].disabled=!j[w.inputJax].annotationEncoding;var B=s.items[2];B.disabled=true;var r=B.menu.items;annotationList=MathJax.Hub.Config.semanticsAnnotations;for(var A=0,z=r.length;A<z;A++){var t=r[A].name[1];if(w.root&&w.root.getAnnotation(t)!==null){B.disabled=false;r[A].hidden=false}else{r[A].hidden=true}}var y=v.menu.Find("Math Settings","MathPlayer");y.hidden=!(w.outputJax==="NativeMML"&&d.Browser.hasMathPlayer);return v.menu.Post(u)}v.loadingDomain=true;E=function(){delete v.loadingDomain}}else{if(l.loadingMathMenu){return n.False(u)}l.loadingMathMenu=true;H=l.Require("[MathJax]/extensions/MathMenu.js");E=function(){delete l.loadingMathMenu;if(!MathJax.Menu){MathJax.Menu={}}}}var D={pageX:u.pageX,pageY:u.pageY,clientX:u.clientX,clientY:u.clientY};g.Queue(H,E,["ContextMenu",n,D,F,x]);return n.False(u)},AltContextMenu:function(t,s){var u=b[s.jaxID];var r=(u.config.showMathMenu!=null?u:d).config.showMathMenu;if(r){r=(u.config.showMathMenuMSIE!=null?u:d).config.showMathMenuMSIE;if(k.context==="MathJax"&&!k.mpContext&&r){if(!c.noContextMenuBug||t.button!==n.RIGHTBUTTON){return}}else{if(!t[n.MENUKEY]||t.button!==n.LEFTBUTTON){return}}return u.ContextMenu(t,s,true)}},ClearSelection:function(){if(c.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(document.selection){setTimeout("document.selection.empty()",0)}},getBBox:function(t){t.appendChild(c.topImg);var s=c.topImg.offsetTop,u=t.offsetHeight-s,r=t.offsetWidth;t.removeChild(c.topImg);return{w:r,h:s,d:u}}};var f=c.Hover={Mouseover:function(t,s){if(k.discoverable||k.zoom==="Hover"){var v=t.fromElement||t.relatedTarget,u=t.toElement||t.target;if(v&&u&&(v.isMathJax!=u.isMathJax||d.getJaxFor(v)!==d.getJaxFor(u))){var r=this.getJaxFromMath(s);if(r.hover){f.ReHover(r)}else{f.HoverTimer(r,s)}return n.False(t)}}},Mouseout:function(t,s){if(k.discoverable||k.zoom==="Hover"){var v=t.fromElement||t.relatedTarget,u=t.toElement||t.target;if(v&&u&&(v.isMathJax!=u.isMathJax||d.getJaxFor(v)!==d.getJaxFor(u))){var r=this.getJaxFromMath(s);if(r.hover){f.UnHover(r)}else{f.ClearHoverTimer()}return n.False(t)}}},Mousemove:function(t,s){if(k.discoverable||k.zoom==="Hover"){var r=this.getJaxFromMath(s);if(r.hover){return}if(f.lastX==t.clientX&&f.lastY==t.clientY){return}f.lastX=t.clientX;f.lastY=t.clientY;f.HoverTimer(r,s);return n.False(t)}},HoverTimer:function(r,s){this.ClearHoverTimer();this.hoverTimer=setTimeout(g(["Hover",this,r,s]),p.hover)},ClearHoverTimer:function(){if(this.hoverTimer){clearTimeout(this.hoverTimer);delete this.hoverTimer}},Hover:function(r,v){if(i.MathZoom&&i.MathZoom.Hover({},v)){return}var u=b[r.outputJax],w=u.getHoverSpan(r,v),z=u.getHoverBBox(r,w,v),x=(u.config.showMathMenu!=null?u:d).config.showMathMenu;var B=p.frame.x,A=p.frame.y,y=p.frame.bwidth;if(c.msieBorderWidthBug){y=0}r.hover={opacity:0,id:r.inputID+"-Hover"};var s=h.Element("span",{id:r.hover.id,isMathJax:true,style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{className:"MathJax_Hover_Frame",isMathJax:true,style:{display:"inline-block",position:"absolute",top:this.Px(-z.h-A-y-(z.y||0)),left:this.Px(-B-y+(z.x||0)),width:this.Px(z.w+2*B),height:this.Px(z.h+z.d+2*A),opacity:0,filter:"alpha(opacity=0)"}}]]);var t=h.Element("span",{isMathJax:true,id:r.hover.id+"Menu",style:{display:"inline-block","z-index":1,width:0,height:0,position:"relative"}},[["img",{className:"MathJax_Hover_Arrow",isMathJax:true,math:v,src:p.button.src,onclick:this.HoverMenu,jax:u.id,style:{left:this.Px(z.w+B+y+(z.x||0)+p.button.x),top:this.Px(-z.h-A-y-(z.y||0)-p.button.y),opacity:0,filter:"alpha(opacity=0)"}}]]);if(z.width){s.style.width=t.style.width=z.width;s.style.marginRight=t.style.marginRight="-"+z.width;s.firstChild.style.width=z.width;t.firstChild.style.left="";t.firstChild.style.right=this.Px(p.button.wx)}w.parentNode.insertBefore(s,w);if(x){w.parentNode.insertBefore(t,w)}if(w.style){w.style.position="relative"}this.ReHover(r)},ReHover:function(r){if(r.hover.remove){clearTimeout(r.hover.remove)}r.hover.remove=setTimeout(g(["UnHover",this,r]),p.fadeoutDelay);this.HoverFadeTimer(r,p.fadeinInc)},UnHover:function(r){if(!r.hover.nofade){this.HoverFadeTimer(r,-p.fadeoutInc,p.fadeoutStart)}},HoverFade:function(r){delete r.hover.timer;r.hover.opacity=Math.max(0,Math.min(1,r.hover.opacity+r.hover.inc));r.hover.opacity=Math.floor(1000*r.hover.opacity)/1000;var t=document.getElementById(r.hover.id),s=document.getElementById(r.hover.id+"Menu");t.firstChild.style.opacity=r.hover.opacity;t.firstChild.style.filter="alpha(opacity="+Math.floor(100*r.hover.opacity)+")";if(s){s.firstChild.style.opacity=r.hover.opacity;s.firstChild.style.filter=t.style.filter}if(r.hover.opacity===1){return}if(r.hover.opacity>0){this.HoverFadeTimer(r,r.hover.inc);return}t.parentNode.removeChild(t);if(s){s.parentNode.removeChild(s)}if(r.hover.remove){clearTimeout(r.hover.remove)}delete r.hover},HoverFadeTimer:function(r,t,s){r.hover.inc=t;if(!r.hover.timer){r.hover.timer=setTimeout(g(["HoverFade",this,r]),(s||p.fadeDelay))}},HoverMenu:function(r){if(!r){r=window.event}return b[this.jax].ContextMenu(r,this.math,true)},ClearHover:function(r){if(r.hover.remove){clearTimeout(r.hover.remove)}if(r.hover.timer){clearTimeout(r.hover.timer)}f.ClearHoverTimer();delete r.hover},Px:function(r){if(Math.abs(r)<0.006){return"0px"}return r.toFixed(2).replace(/\.?0+$/,"")+"px"},getImages:function(){if(k.discoverable){var r=new Image();r.src=p.button.src}}};var a=c.Touch={last:0,delay:500,start:function(s){var r=new Date().getTime();var t=(r-a.last<a.delay&&a.up);a.last=r;a.up=false;if(t){a.timeout=setTimeout(a.menu,a.delay,s,this);s.preventDefault()}},end:function(s){var r=new Date().getTime();a.up=(r-a.last<a.delay);if(a.timeout){clearTimeout(a.timeout);delete a.timeout;a.last=0;a.up=false;s.preventDefault();return n.Handler((s.touches[0]||s.touch),"DblClick",this)}},menu:function(s,r){delete a.timeout;a.last=0;a.up=false;return n.Handler((s.touches[0]||s.touch),"ContextMenu",r)}};if(d.Browser.isMobile){var o=p.styles[".MathJax_Hover_Arrow"];o.width="25px";o.height="18px";p.button.x=-6}d.Browser.Select({MSIE:function(r){var t=(document.documentMode||0);var s=r.versionAtLeast("8.0");c.msieBorderWidthBug=(document.compatMode==="BackCompat");c.msieEventBug=r.isIE9;c.msieAlignBug=(!s||t<8);if(t<9){n.LEFTBUTTON=1}},Safari:function(r){c.safariContextMenuBug=true},Opera:function(r){c.operaPositionBug=true},Konqueror:function(r){c.noContextMenuBug=true}});c.topImg=(c.msieAlignBug?h.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):h.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(c.operaPositionBug){c.topImg.style.border="1px solid"}c.config=p=d.CombineConfig("MathEvents",p);var e=function(){var r=p.styles[".MathJax_Hover_Frame"];r.border=p.frame.bwidth+"px solid "+p.frame.bcolor+" ! important";r["box-shadow"]=r["-webkit-box-shadow"]=r["-moz-box-shadow"]=r["-khtml-box-shadow"]="0px 0px "+p.frame.hwidth+" "+p.frame.hcolor};g.Queue(d.Register.StartupHook("End Config",{}),[e],["getImages",f],["Styles",l,p.styles],["Post",d.Startup.signal,"MathEvents Ready"],["loadComplete",l,"[MathJax]/extensions/MathEvents.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.Callback,MathJax.Localization,MathJax.OutputJax,MathJax.InputJax);
(function(a,d,f,c,j){var k="2.4.0";var i=a.CombineConfig("MathZoom",{styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"},"#MathJax_ZoomFrame":{position:"relative",display:"inline-block",height:0,width:0},"#MathJax_ZoomEventTrap":{position:"absolute",left:0,top:0,"z-index":302,display:"inline-block",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var e,b,g;MathJax.Hub.Register.StartupHook("MathEvents Ready",function(){g=MathJax.Extension.MathEvents.Event;e=MathJax.Extension.MathEvents.Event.False;b=MathJax.Extension.MathEvents.Hover});var h=MathJax.Extension.MathZoom={version:k,settings:a.config.menuSettings,scrollSize:18,HandleEvent:function(n,l,m){if(h.settings.CTRL&&!n.ctrlKey){return true}if(h.settings.ALT&&!n.altKey){return true}if(h.settings.CMD&&!n.metaKey){return true}if(h.settings.Shift&&!n.shiftKey){return true}if(!h[l]){return true}return h[l](n,m)},Click:function(m,l){if(this.settings.zoom==="Click"){return this.Zoom(m,l)}},DblClick:function(m,l){if(this.settings.zoom==="Double-Click"||this.settings.zoom==="DoubleClick"){return this.Zoom(m,l)}},Hover:function(m,l){if(this.settings.zoom==="Hover"){this.Zoom(m,l);return true}return false},Zoom:function(o,u){this.Remove();b.ClearHoverTimer();g.ClearSelection();var s=MathJax.OutputJax[u.jaxID];var p=s.getJaxFromMath(u);if(p.hover){b.UnHover(p)}var q=this.findContainer(u);var l=Math.floor(0.85*q.clientWidth),t=Math.max(document.body.clientHeight,document.documentElement.clientHeight);if(this.getOverflow(q)!=="visible"){t=Math.min(q.clientHeight,t)}t=Math.floor(0.85*t);var n=d.Element("span",{id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale}},[["span",{style:{display:"inline-block","white-space":"nowrap"}}]]]]);var z=n.lastChild,w=z.firstChild,r=n.firstChild;u.parentNode.insertBefore(n,u);u.parentNode.insertBefore(u,n);if(w.addEventListener){w.addEventListener("mousedown",this.Remove,true)}var m=z.offsetWidth||z.clientWidth;l-=m;t-=m;z.style.maxWidth=l+"px";z.style.maxHeight=t+"px";if(this.msieTrapEventBug){var y=d.Element("span",{id:"MathJax_ZoomEventTrap",onmousedown:this.Remove});n.insertBefore(y,z)}if(this.msieZIndexBug){var v=d.addElement(document.body,"img",{src:"about:blank",id:"MathJax_ZoomTracker",width:0,height:0,style:{width:0,height:0,position:"relative"}});n.style.position="relative";n.style.zIndex=i.styles["#MathJax_ZoomOverlay"]["z-index"];n=v}var x=s.Zoom(p,w,u,l,t);if(this.msiePositionBug){if(this.msieSizeBug){z.style.height=x.zH+"px";z.style.width=x.zW+"px"}if(z.offsetHeight>t){z.style.height=t+"px";z.style.width=(x.zW+this.scrollSize)+"px"}if(z.offsetWidth>l){z.style.width=l+"px";z.style.height=(x.zH+this.scrollSize)+"px"}}if(this.operaPositionBug){z.style.width=Math.min(l,x.zW)+"px"}if(z.offsetWidth>m&&z.offsetWidth-m<l&&z.offsetHeight-m<t){z.style.overflow="visible"}this.Position(z,x);if(this.msieTrapEventBug){y.style.height=z.clientHeight+"px";y.style.width=z.clientWidth+"px";y.style.left=(parseFloat(z.style.left)+z.clientLeft)+"px";y.style.top=(parseFloat(z.style.top)+z.clientTop)+"px"}z.style.visibility="";if(this.settings.zoom==="Hover"){r.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}a.signal.Post(["math zoomed",p]);return e(o)},Position:function(p,r){p.style.display="none";var q=this.Resize(),m=q.x,s=q.y,l=r.mW;p.style.display="";var o=-l-Math.floor((p.offsetWidth-l)/2),n=r.Y;p.style.left=Math.max(o,10-m)+"px";p.style.top=Math.max(n,10-s)+"px";if(!h.msiePositionBug){h.SetWH()}},Resize:function(m){if(h.onresize){h.onresize(m)}var q=document.getElementById("MathJax_ZoomFrame"),l=document.getElementById("MathJax_ZoomOverlay");var o=h.getXY(q),n=h.findContainer(q);if(h.getOverflow(n)!=="visible"){l.scroll_parent=n;var p=h.getXY(n);o.x-=p.x;o.y-=p.y;p=h.getBorder(n);o.x-=p.x;o.y-=p.y}l.style.left=(-o.x)+"px";l.style.top=(-o.y)+"px";if(h.msiePositionBug){setTimeout(h.SetWH,0)}else{h.SetWH()}return o},SetWH:function(){var l=document.getElementById("MathJax_ZoomOverlay");l.style.display="none";var m=l.scroll_parent||document.documentElement||document.body;l.style.width=m.scrollWidth+"px";l.style.height=Math.max(m.clientHeight,m.scrollHeight)+"px";l.style.display=""},findContainer:function(l){l=l.parentNode;while(l.parentNode&&l!==document.body&&h.getOverflow(l)==="visible"){l=l.parentNode}return l},getOverflow:(window.getComputedStyle?function(l){return getComputedStyle(l).overflow}:function(l){return(l.currentStyle||{overflow:"visible"}).overflow}),getBorder:function(o){var m={thin:1,medium:2,thick:3};var n=(window.getComputedStyle?getComputedStyle(o):(o.currentStyle||{borderLeftWidth:0,borderTopWidth:0}));var l=n.borderLeftWidth,p=n.borderTopWidth;if(m[l]){l=m[l]}else{l=parseInt(l)}if(m[p]){p=m[p]}else{p=parseInt(p)}return{x:l,y:p}},getXY:function(o){var l=0,n=0,m;m=o;while(m.offsetParent){l+=m.offsetLeft;m=m.offsetParent}if(h.operaPositionBug){o.style.border="1px solid"}m=o;while(m.offsetParent){n+=m.offsetTop;m=m.offsetParent}if(h.operaPositionBug){o.style.border=""}return{x:l,y:n}},Remove:function(n){var p=document.getElementById("MathJax_ZoomFrame");if(p){var o=MathJax.OutputJax[p.previousSibling.jaxID];var l=o.getJaxFromMath(p.previousSibling);a.signal.Post(["math unzoomed",l]);p.parentNode.removeChild(p);p=document.getElementById("MathJax_ZoomTracker");if(p){p.parentNode.removeChild(p)}if(h.operaRefreshBug){var m=d.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});document.body.removeChild(m)}if(window.removeEventListener){removeEventListener("resize",h.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",h.Resize)}else{window.onresize=h.onresize;delete h.onresize}}}return e(n)}};a.Browser.Select({MSIE:function(l){var n=(document.documentMode||0);var m=(n>=9);h.msiePositionBug=!m;h.msieSizeBug=l.versionAtLeast("7.0")&&(!document.documentMode||n===7||n===8);h.msieZIndexBug=(n<=7);h.msieInlineBlockAlignBug=(n<=7);h.msieTrapEventBug=!window.addEventListener;if(document.compatMode==="BackCompat"){h.scrollSize=52}if(m){delete i.styles["#MathJax_Zoom"].filter}},Opera:function(l){h.operaPositionBug=true;h.operaRefreshBug=true}});h.topImg=(h.msieInlineBlockAlignBug?d.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):d.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(h.operaPositionBug||h.msieTopBug){h.topImg.style.border="1px solid"}MathJax.Callback.Queue(["StartupHook",MathJax.Hub.Register,"Begin Styles",{}],["Styles",f,i.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",f,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);
(function(c,g,k,f,b){var q="2.4.0";var j=MathJax.Callback.Signal("menu");MathJax.Extension.MathMenu={version:q,signal:j};var o=function(r){return MathJax.Localization._.apply(MathJax.Localization,[["MathMenu",r]].concat([].slice.call(arguments,1)))};var n=c.Browser.isPC,l=c.Browser.isMSIE,e=((document.documentMode||0)>8);var i=(n?null:"5px");var p=c.CombineConfig("MathMenu",{delay:150,closeImg:k.urlRev(b.imageDir+"/CloseX-31.png"),showRenderer:true,showMathPlayer:true,showFontMenu:false,showContext:false,showDiscoverable:false,showLocale:true,showLocaleURL:false,semanticsAnnotations:{TeX:["TeX","LaTeX","application/x-tex"],StarMath:["StarMath 5.0"],Maple:["Maple"],ContentMathML:["MathML-Content","application/mathml-content+xml"],OpenMath:["OpenMath"]},windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:400,height:300,left:Math.round((screen.width-400)/2),top:Math.round((screen.height-300)/3)},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:(n?"2px":"5px 0px"),border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":i,"-webkit-border-radius":i,"-moz-border-radius":i,"-khtml-border-radius":i,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:(n?"2px 2em":"1px 2em"),background:"transparent"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuArrow.RTL":{left:".5em",right:"auto"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":(l?"'Arial unicode MS'":null)},".MathJax_MenuCheck.RTL":{right:".7em",left:"auto"},".MathJax_MenuRadioCheck":{position:"absolute",left:(n?"1em":".7em")},".MathJax_MenuRadioCheck.RTL":{right:(n?"1em":".7em"),left:"auto"},".MathJax_MenuLabel":{padding:(n?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em"),"font-style":"italic"},".MathJax_MenuRule":{"border-top":(n?"1px solid #CCCCCC":"1px solid #DDDDDD"),margin:(n?"4px 1px 0px":"4px 3px")},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":(n?"Highlight":"#606872"),color:(n?"HighlightText":"white")},".MathJax_Menu_Close":{position:"absolute",width:"31px",height:"31px",top:"-15px",left:"-15px"}}});var h,d;c.Register.StartupHook("MathEvents Ready",function(){h=MathJax.Extension.MathEvents.Event.False;d=MathJax.Extension.MathEvents.Hover});var a=MathJax.Menu=MathJax.Object.Subclass({version:q,items:[],posted:false,title:null,margin:5,Init:function(r){this.items=[].slice.call(arguments,0)},With:function(r){if(r){c.Insert(this,r)}return this},Post:function(s,C,A){if(!s){s=window.event}var r=document.getElementById("MathJax_MenuFrame");if(!r){r=a.Background(this);delete m.lastItem;delete m.lastMenu;delete a.skipUp;j.Post(["post",a.jax]);a.isRTL=(MathJax.Localization.fontDirection()==="rtl")}var t=g.Element("div",{onmouseup:a.Mouseup,ondblclick:h,ondragstart:h,onselectstart:h,oncontextmenu:h,menuItem:this,className:"MathJax_Menu"});if(!A){MathJax.Localization.setCSS(t)}for(var v=0,u=this.items.length;v<u;v++){this.items[v].Create(t)}if(a.isMobile){g.addElement(t,"span",{className:"MathJax_Menu_Close",menu:C,ontouchstart:a.Close,ontouchend:h,onmousedown:a.Close,onmouseup:h},[["img",{src:p.closeImg,style:{width:"100%",height:"100%"}}]])}r.appendChild(t);this.posted=true;t.style.width=(t.offsetWidth+2)+"px";var B=s.pageX,z=s.pageY;if(!B&&!z){B=s.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;z=s.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!C){if(B+t.offsetWidth>document.body.offsetWidth-this.margin){B=document.body.offsetWidth-t.offsetWidth-this.margin}if(a.isMobile){B=Math.max(5,B-Math.floor(t.offsetWidth/2));z-=20}a.skipUp=s.isContextMenu}else{var w="left",D=C.offsetWidth;B=(a.isMobile?30:D-2);z=0;while(C&&C!==r){B+=C.offsetLeft;z+=C.offsetTop;C=C.parentNode}if(!a.isMobile){if((a.isRTL&&B-D-t.offsetWidth>this.margin)||(!a.isRTL&&B+t.offsetWidth>document.body.offsetWidth-this.margin)){w="right";B=Math.max(this.margin,B-D-t.offsetWidth+6)}}if(!n){t.style["borderRadiusTop"+w]=0;t.style["WebkitBorderRadiusTop"+w]=0;t.style["MozBorderRadiusTop"+w]=0;t.style["KhtmlBorderRadiusTop"+w]=0}}t.style.left=B+"px";t.style.top=z+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return h(s)},Remove:function(r,s){j.Post(["unpost",a.jax]);var t=document.getElementById("MathJax_MenuFrame");if(t){t.parentNode.removeChild(t);if(this.msieFixedPositionBug){detachEvent("onresize",a.Resize)}}if(a.jax.hover){delete a.jax.hover.nofade;d.UnHover(a.jax)}return h(r)},Find:function(r){return this.FindN(1,r,[].slice.call(arguments,1))},FindId:function(r){return this.FindN(0,r,[].slice.call(arguments,1))},FindN:function(v,s,u){for(var t=0,r=this.items.length;t<r;t++){if(this.items[t].name[v]===s){if(u.length){if(!this.items[t].menu){return null}return this.items[t].menu.FindN(v,u[0],u.slice(1))}return this.items[t]}}return null},IndexOf:function(r){return this.IndexOfN(1,r)},IndexOfId:function(r){return this.IndexOfN(0,r)},IndexOfN:function(u,s){for(var t=0,r=this.items.length;t<r;t++){if(this.items[t].name[u]===s){return t}}return null}},{config:p,div:null,Close:function(r){return a.Event(r,this.menu||this.parentNode,(this.menu?"Touchend":"Remove"))},Remove:function(r){return a.Event(r,this,"Remove")},Mouseover:function(r){return a.Event(r,this,"Mouseover")},Mouseout:function(r){return a.Event(r,this,"Mouseout")},Mousedown:function(r){return a.Event(r,this,"Mousedown")},Mouseup:function(r){return a.Event(r,this,"Mouseup")},Touchstart:function(r){return a.Event(r,this,"Touchstart")},Touchend:function(r){return a.Event(r,this,"Touchend")},Event:function(t,v,r,u){if(a.skipMouseover&&r==="Mouseover"&&!u){return h(t)}if(a.skipUp){if(r.match(/Mouseup|Touchend/)){delete a.skipUp;return h(t)}if(r==="Touchstart"||(r==="Mousedown"&&!a.skipMousedown)){delete a.skipUp}}if(!t){t=window.event}var s=v.menuItem;if(s&&s[r]){return s[r](t,v)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(s){var t=g.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:s,onmousedown:this.Remove}]]);var r=t.firstChild;if(a.msieBackgroundBug){r.style.backgroundColor="white";r.style.filter="alpha(opacity=0)"}if(a.msieFixedPositionBug){t.width=t.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{r.style.position="fixed"}return t},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var r=document.getElementById("MathJax_MenuFrame");if(r){r=r.firstChild;r.style.width=r.style.height="1px";r.style.width=document.body.scrollWidth+"px";r.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){g.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=g.Cookie.Get("menu")},getImages:function(){if(a.isMobile){var r=new Image();r.src=p.closeImg}}});var m=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(s){if(!this.hidden){var r={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:a.Mousedown,ondragstart:h,onselectstart:h,onselectend:h,ontouchstart:a.Touchstart,ontouchend:a.Touchend,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){r.className+=" MathJax_MenuDisabled"}g.addElement(s,"div",r,this.Label(r,s))}},Name:function(){return o(this.name[0],this.name[1])},Mouseover:function(v,x){if(!this.disabled){this.Activate(x)}if(!this.menu||!this.menu.posted){var w=document.getElementById("MathJax_MenuFrame").childNodes,s=x.parentNode.childNodes;for(var t=0,r=s.length;t<r;t++){var u=s[t].menuItem;if(u&&u.menu&&u.menu.posted){u.Deactivate(s[t])}}r=w.length-1;while(r>=0&&x.parentNode.menuItem!==w[r].menuItem){w[r].menuItem.posted=false;w[r].parentNode.removeChild(w[r]);r--}if(this.Timer&&!a.isMobile){this.Timer(v,x)}}},Mouseout:function(r,s){if(!this.menu||!this.menu.posted){this.Deactivate(s)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(r,s){return this.Remove(r,s)},Touchstart:function(r,s){return this.TouchEvent(r,s,"Mousedown")},Touchend:function(r,s){return this.TouchEvent(r,s,"Mouseup")},TouchEvent:function(s,t,r){if(this!==m.lastItem){if(m.lastMenu){a.Event(s,m.lastMenu,"Mouseout")}a.Event(s,t,"Mouseover",true);m.lastItem=this;m.lastMenu=t}if(this.nativeTouch){return null}a.Event(s,t,r);return false},Remove:function(r,s){s=s.parentNode.menuItem;return s.Remove(r,s)},Activate:function(r){this.Deactivate(r);r.className+=" MathJax_MenuActive"},Deactivate:function(r){r.className=r.className.replace(/ MathJax_MenuActive/,"")},With:function(r){if(r){c.Insert(this,r)}return this},isRTL:function(){return a.isRTL},rtlClass:function(){return(this.isRTL()?" RTL":"")}});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(r,t,s){if(!(r instanceof Array)){r=[r,r]}this.name=r;this.action=t;this.With(s)},Label:function(r,s){return[this.Name()]},Mouseup:function(r,s){if(!this.disabled){this.Remove(r,s);j.Post(["command",this]);this.action.call(this,r)}return h(r)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:(n&&!c.Browser.isSafari?"\u25B6":"\u25B8"),markerRTL:(n&&!c.Browser.isSafari?"\u25B0":"\u25C2"),Init:function(r,t){if(!(r instanceof Array)){r=[r,r]}this.name=r;var s=1;if(!(t instanceof a.ITEM)){this.With(t),s++}this.menu=a.apply(a,[].slice.call(arguments,s))},Label:function(r,s){this.menu.posted=false;return[this.Name()+" ",["span",{className:"MathJax_MenuArrow"+this.rtlClass()},[this.isRTL()?this.markerRTL:this.marker]]]},Timer:function(r,s){if(this.timer){clearTimeout(this.timer)}r={clientX:r.clientX,clientY:r.clientY};this.timer=setTimeout(f(["Mouseup",this,r,s]),p.delay)},Touchend:function(s,u){var t=this.menu.posted;var r=this.SUPER(arguments).Touchend.apply(this,arguments);if(t){this.Deactivate(u);delete m.lastItem;delete m.lastMenu}return r},Mouseup:function(s,u){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(s,u,this.ltr)}else{var t=document.getElementById("MathJax_MenuFrame").childNodes,r=t.length-1;while(r>=0){var v=t[r];v.menuItem.posted=false;v.parentNode.removeChild(v);if(v.menuItem===this.menu){break}r--}}}return h(s)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:(n?"\u25CF":"\u2713"),Init:function(s,r,t){if(!(s instanceof Array)){s=[s,s]}this.name=s;this.variable=r;this.With(t);if(this.value==null){this.value=this.name[0]}},Label:function(s,t){var r={className:"MathJax_MenuRadioCheck"+this.rtlClass()};if(p.settings[this.variable]!==this.value){r={style:{display:"none"}}}return[["span",r,[this.marker]]," "+this.Name()]},Mouseup:function(u,v){if(!this.disabled){var w=v.parentNode.childNodes;for(var s=0,r=w.length;s<r;s++){var t=w[s].menuItem;if(t&&t.variable===this.variable){w[s].firstChild.style.display="none"}}v.firstChild.display="";p.settings[this.variable]=this.value;a.cookie[this.variable]=p.settings[this.variable];a.saveCookie();j.Post(["radio button",this])}this.Remove(u,v);if(this.action&&!this.disabled){this.action.call(a,this)}return h(u)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"\u2713",Init:function(s,r,t){if(!(s instanceof Array)){s=[s,s]}this.name=s;this.variable=r;this.With(t)},Label:function(s,t){var r={className:"MathJax_MenuCheck"+this.rtlClass()};if(!p.settings[this.variable]){r={style:{display:"none"}}}return[["span",r,[this.marker]]," "+this.Name()]},Mouseup:function(r,s){if(!this.disabled){s.firstChild.display=(p.settings[this.variable]?"none":"");p.settings[this.variable]=!p.settings[this.variable];a.cookie[this.variable]=p.settings[this.variable];a.saveCookie();j.Post(["checkbox",this])}this.Remove(r,s);if(this.action&&!this.disabled){this.action.call(a,this)}return h(r)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(r,s){if(!(r instanceof Array)){r=[r,r]}this.name=r;this.With(s)},Label:function(r,s){delete r.onmouseover,delete r.onmouseout;delete r.onmousedown;r.className+=" MathJax_MenuLabel";return[this.Name()]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(r,s){delete r.onmouseover,delete r.onmouseout;delete r.onmousedown;r.className+=" MathJax_MenuRule";return null}});a.About=function(){var t=b["HTML-CSS"]||{};var s=(t.imgFonts?"image":(t.fontInUse?(t.webFonts?"web":"local")+" "+t.fontInUse:(b.SVG?"web SVG":"generic")))+" fonts";var x=(!t.webFonts||t.imgFonts?null:t.allowWebFonts.replace(/otf/,"woff or otf")+" fonts");var r=["MathJax.js v"+MathJax.fileversion,["br"]];r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(r,MathJax.InputJax,["InputJax","%1 Input Jax v%2"]);a.About.GetJax(r,MathJax.OutputJax,["OutputJax","%1 Output Jax v%2"]);a.About.GetJax(r,MathJax.ElementJax,["ElementJax","%1 Element Jax v%2"]);r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(r,MathJax.Extension,["Extension","%1 Extension v%2"],true);r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[c.Browser+" v"+c.Browser.version+(x?" \u2014 "+o(x.replace(/ /g,""),x):"")]]);a.About.div=a.Background(a.About);var v=g.addElement(a.About.div,"div",{id:"MathJax_About"},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],o(s.replace(/ /g,""),"using "+s),["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","max-height":"20em",overflow:"auto","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},r],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]],["img",{src:p.closeImg,style:{width:"21px",height:"21px",position:"absolute",top:".2em",right:".2em"},onclick:a.About.Remove}]]);MathJax.Localization.setCSS(v);var w=(document.documentElement||{});var u=window.innerHeight||w.clientHeight||w.scrollHeight||0;if(a.prototype.msieAboutBug){v.style.width="20em";v.style.position="absolute";v.style.left=Math.floor((document.documentElement.scrollWidth-v.offsetWidth)/2)+"px";v.style.top=(Math.floor((u-v.offsetHeight)/3)+document.body.scrollTop)+"px"}else{v.style.marginLeft=Math.floor(-v.offsetWidth/2)+"px";v.style.top=Math.floor((u-v.offsetHeight)/3)+"px"}};a.About.Remove=function(r){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(s,x,v,u){var w=[];for(var y in x){if(x.hasOwnProperty(y)&&x[y]){if((u&&x[y].version)||(x[y].isa&&x[y].isa(x))){w.push(o(v[0],v[1],(x[y].id||y),x[y].version))}}}w.sort();for(var t=0,r=w.length;t<r;t++){s.push(w[t],["br"])}return s};a.Help=function(){k.Require("[MathJax]/extensions/HelpDialog.js",function(){MathJax.Extension.Help.Dialog()})};a.ShowSource=function(v){if(!v){v=window.event}var u={screenX:v.screenX,screenY:v.screenY};if(!a.jax){return}if(this.format==="MathML"){var s=MathJax.ElementJax.mml;if(s&&typeof(s.mbase.prototype.toMathML)!=="undefined"){try{a.ShowSource.Text(a.jax.root.toMathML("",a.jax),v)}catch(t){if(!t.restart){throw t}f.After([this,a.ShowSource,u],t.restart)}}else{if(!k.loadingToMathML){k.loadingToMathML=true;a.ShowSource.Window(v);f.Queue(k.Require("[MathJax]/extensions/toMathML.js"),function(){delete k.loadingToMathML;if(!s.mbase.prototype.toMathML){s.mbase.prototype.toMathML=function(){}}},[this,a.ShowSource,u]);return}}}else{if(this.format==="Error"){a.ShowSource.Text(a.jax.errorText,v)}else{if(p.semanticsAnnotations[this.format]){var r=a.jax.root.getAnnotation(this.format);if(r.data[0]){a.ShowSource.Text(r.data[0].toString())}}else{if(a.jax.originalText==null){alert(o("NoOriginalForm","No original form available"));return}a.ShowSource.Text(a.jax.originalText,v)}}}};a.ShowSource.Window=function(s){if(!a.ShowSource.w){var t=[],r=p.windowSettings;for(var u in r){if(r.hasOwnProperty(u)){t.push(u+"="+r[u])}}a.ShowSource.w=window.open("","_blank",t.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(v,t){var r=a.ShowSource.Window(t);delete a.ShowSource.w;v=v.replace(/^\s*/,"").replace(/\s*$/,"");v=v.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");var u=o("EqSource","MathJax Equation Source");if(a.isMobile){r.document.open();r.document.write("<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0' /><title>"+u+"</title></head><body style='font-size:85%'>");r.document.write("<pre>"+v+"</pre>");r.document.write("<hr><input type='button' value='"+o("Close","Close")+"' onclick='window.close()' />");r.document.write("</body></html>");r.document.close()}else{r.document.open();r.document.write("<html><head><title>"+u+"</title></head><body style='font-size:85%'>");r.document.write("<table><tr><td><pre>"+v+"</pre></td></tr></table>");r.document.write("</body></html>");r.document.close();var s=r.document.body.firstChild;setTimeout(function(){var A=(r.outerHeight-r.innerHeight)||30,z=(r.outerWidth-r.innerWidth)||30,w,D;z=Math.max(100,Math.min(Math.floor(0.5*screen.width),s.offsetWidth+z+25));A=Math.max(40,Math.min(Math.floor(0.5*screen.height),s.offsetHeight+A+25));if(a.prototype.msieHeightBug){A+=35}r.resizeTo(z,A);var C;try{C=t.screenX}catch(B){}if(t&&C!=null){w=Math.max(0,Math.min(t.screenX-Math.floor(z/2),screen.width-z-20));D=Math.max(0,Math.min(t.screenY-Math.floor(A/2),screen.height-A-20));r.moveTo(w,D)}},50)}};a.Scale=function(){var s=b["HTML-CSS"],r=b.NativeMML,v=b.SVG;var u=(s||r||v||{config:{scale:100}}).config.scale;var t=prompt(o("ScaleMath","Scale all mathematics (compared to surrounding text) by"),u+"%");if(t){if(t.match(/^\s*\d+(\.\d*)?\s*%?\s*$/)){t=parseFloat(t);if(t){if(t!==u){if(s){s.config.scale=t}if(r){r.config.scale=t}if(v){v.config.scale=t}a.cookie.scale=t;a.saveCookie();c.Reprocess()}}else{alert(o("NonZeroScale","The scale should not be zero"))}}else{alert(o("PercentScale","The scale should be a percentage (e.g., 120%%)"))}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){k.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var s=c.outputJax["jax/mml"];if(s[0]!==p.settings.renderer){var v=c.Browser,u,r=a.Renderer.Messages,t;switch(p.settings.renderer){case"NativeMML":if(!p.settings.warnedMML){if(v.isChrome&&v.version.substr(0,3)!=="24."){u=r.MML.WebKit}else{if(v.isSafari&&!v.versionAtLeast("5.0")){u=r.MML.WebKit}else{if(v.isMSIE){if(!v.hasMathPlayer){u=r.MML.MSIE}}else{u=r.MML[v]}}}t="warnedMML"}break;case"SVG":if(!p.settings.warnedSVG){if(v.isMSIE&&!e){u=r.SVG.MSIE}}break}if(u){u=o(u[0],u[1]);u+="\n\n";u+=o("SwitchAnyway","Switch the renderer anyway?\n\n(Press OK to switch, CANCEL to continue with the current renderer)");a.cookie.renderer=s[0].id;a.saveCookie();if(!confirm(u)){a.cookie.renderer=p.settings.renderer=g.Cookie.Get("menu").renderer;a.saveCookie();return}if(t){a.cookie.warned=p.settings.warned=true}a.cookie.renderer=p.settings.renderer;a.saveCookie()}c.Queue(["setRenderer",c,p.settings.renderer,"jax/mml"],["Rerender",c])}};a.Renderer.Messages={MML:{WebKit:["WebkitNativeMMLWarning","Your browser doesn't seem to support MathML natively, so switching to MathML output may cause the mathematics on the page to become unreadable."],MSIE:["MSIENativeMMLWarning","Internet Explorer requires the MathPlayer plugin in order to process MathML output."],Opera:["OperaNativeMMLWarning","Opera's support for MathML is limited, so switching to MathML output may cause some expressions to render poorly."],Safari:["SafariNativeMMLWarning","Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."],Firefox:["FirefoxNativeMMLWarning","Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."]},SVG:{MSIE:["MSIESVGWarning","SVG is not implemented in Internet Explorer prior to IE9 or when it is emulating IE8 or below. Switching to SVG output will cause the mathematics to not display properly."]}};a.Font=function(){var r=b["HTML-CSS"];if(!r){return}document.location.reload()};a.Locale=function(){MathJax.Localization.setLocale(p.settings.locale);MathJax.Hub.Queue(["Reprocess",MathJax.Hub])};a.LoadLocale=function(){var r=prompt(o("LoadURL","Load translation data from this URL:"));if(r){if(!r.match(/\.js$/)){alert(o("BadURL","The URL should be for a javascript file that defines MathJax translation data.  Javascript file names should end with '.js'"))}k.Require(r,function(s){if(s!=k.STATUS.OK){alert(o("BadData","Failed to load translation data from %1",r))}})}};a.MPEvents=function(t){var s=p.settings.discoverable,r=a.MPEvents.Messages;if(!e){if(p.settings.mpMouse&&!confirm(o.apply(o,r.IE8warning))){delete a.cookie.mpContext;delete p.settings.mpContext;delete a.cookie.mpMouse;delete p.settings.mpMouse;a.saveCookie();return}p.settings.mpContext=p.settings.mpMouse;a.cookie.mpContext=a.cookie.mpMouse=p.settings.mpMouse;a.saveCookie();MathJax.Hub.Queue(["Rerender",MathJax.Hub])}else{if(!s&&t.name[1]==="Menu Events"&&p.settings.mpContext){alert(o.apply(o,r.IE9warning))}}};a.MPEvents.Messages={IE8warning:["IE8warning","This will disable the MathJax menu and zoom features, but you can Alt-Click on an expression to obtain the MathJax menu instead.\n\nReally change the MathPlayer settings?"],IE9warning:["IE9warning","The MathJax contextual menu will be disabled, but you can Alt-Click on an expression to obtain the MathJax menu instead."]};c.Browser.Select({MSIE:function(r){var s=(document.compatMode==="BackCompat");var t=r.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:((document.documentMode||0)<9),msieFixedPositionBug:(s||!t),msieAboutBug:s,msieHeightBug:((document.documentMode||0)<9)});if(e){delete p.styles["#MathJax_About"].filter;delete p.styles[".MathJax_Menu"].filter}},Firefox:function(r){a.skipMouseover=r.isMobile&&r.versionAtLeast("6.0");a.skipMousedown=r.isMobile}});a.isMobile=c.Browser.isMobile;a.noContextMenu=c.Browser.noContextMenu;a.CreateLocaleMenu=function(){if(!a.menu){return}var w=a.menu.Find("Language").menu,t=w.items;var s=[],y=MathJax.Localization.strings;for(var x in y){if(y.hasOwnProperty(x)){s.push(x)}}s=s.sort();w.items=[];for(var u=0,r=s.length;u<r;u++){var v=y[s[u]].menuTitle;if(v){v+=" ("+s[u]+")"}else{v=s[u]}w.items.push(m.RADIO([s[u],v],"locale",{action:a.Locale}))}w.items.push(t[t.length-2],t[t.length-1])};a.CreateAnnotationMenu=function(){if(!a.menu){return}var t=a.menu.Find("Show Math As","Annotation").menu;var s=p.semanticsAnnotations;for(var r in s){if(s.hasOwnProperty(r)){t.items.push(m.COMMAND([r,r],a.ShowSource,{hidden:true,nativeTouch:true,format:r}))}}};c.Register.StartupHook("End Config",function(){p.settings=c.config.menuSettings;if(typeof(p.settings.showRenderer)!=="undefined"){p.showRenderer=p.settings.showRenderer}if(typeof(p.settings.showFontMenu)!=="undefined"){p.showFontMenu=p.settings.showFontMenu}if(typeof(p.settings.showContext)!=="undefined"){p.showContext=p.settings.showContext}a.getCookie();a.menu=a(m.SUBMENU(["Show","Show Math As"],m.COMMAND(["MathMLcode","MathML Code"],a.ShowSource,{nativeTouch:true,format:"MathML"}),m.COMMAND(["Original","Original Form"],a.ShowSource,{nativeTouch:true}),m.SUBMENU(["Annotation","Annotation"],{disabled:true}),m.RULE(),m.CHECKBOX(["texHints","Show TeX hints in MathML"],"texHints"),m.CHECKBOX(["semantics","Add original form as annotation"],"semantics")),m.RULE(),m.SUBMENU(["Settings","Math Settings"],m.SUBMENU(["ZoomTrigger","Zoom Trigger"],m.RADIO(["Hover","Hover"],"zoom",{action:a.Zoom}),m.RADIO(["Click","Click"],"zoom",{action:a.Zoom}),m.RADIO(["DoubleClick","Double-Click"],"zoom",{action:a.Zoom}),m.RADIO(["NoZoom","No Zoom"],"zoom",{value:"None"}),m.RULE(),m.LABEL(["TriggerRequires","Trigger Requires:"]),m.CHECKBOX((c.Browser.isMac?["Option","Option"]:["Alt","Alt"]),"ALT"),m.CHECKBOX(["Command","Command"],"CMD",{hidden:!c.Browser.isMac}),m.CHECKBOX(["Control","Control"],"CTRL",{hidden:c.Browser.isMac}),m.CHECKBOX(["Shift","Shift"],"Shift")),m.SUBMENU(["ZoomFactor","Zoom Factor"],m.RADIO("125%","zscale"),m.RADIO("133%","zscale"),m.RADIO("150%","zscale"),m.RADIO("175%","zscale"),m.RADIO("200%","zscale"),m.RADIO("250%","zscale"),m.RADIO("300%","zscale"),m.RADIO("400%","zscale")),m.RULE(),m.SUBMENU(["Renderer","Math Renderer"],{hidden:!p.showRenderer},m.RADIO("HTML-CSS","renderer",{action:a.Renderer}),m.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"}),m.RADIO("SVG","renderer",{action:a.Renderer})),m.SUBMENU("MathPlayer",{hidden:!c.Browser.isMSIE||!p.showMathPlayer,disabled:!c.Browser.hasMathPlayer},m.LABEL(["MPHandles","Let MathPlayer Handle:"]),m.CHECKBOX(["MenuEvents","Menu Events"],"mpContext",{action:a.MPEvents,hidden:!e}),m.CHECKBOX(["MouseEvents","Mouse Events"],"mpMouse",{action:a.MPEvents,hidden:!e}),m.CHECKBOX(["MenuAndMouse","Mouse and Menu Events"],"mpMouse",{action:a.MPEvents,hidden:e})),m.SUBMENU(["FontPrefs","Font Preference"],{hidden:!p.showFontMenu},m.LABEL(["ForHTMLCSS","For HTML-CSS:"]),m.RADIO(["Auto","Auto"],"font",{action:a.Font}),m.RULE(),m.RADIO(["TeXLocal","TeX (local)"],"font",{action:a.Font}),m.RADIO(["TeXWeb","TeX (web)"],"font",{action:a.Font}),m.RADIO(["TeXImage","TeX (image)"],"font",{action:a.Font}),m.RULE(),m.RADIO(["STIXLocal","STIX (local)"],"font",{action:a.Font}),m.RADIO(["STIXWeb","STIX (web)"],"font",{action:a.Font}),m.RULE(),m.RADIO(["AsanaMathWeb","Asana Math (web)"],"font",{action:a.Font}),m.RADIO(["GyrePagellaWeb","Gyre Pagella (web)"],"font",{action:a.Font}),m.RADIO(["GyreTermesWeb","Gyre Termes (web)"],"font",{action:a.Font}),m.RADIO(["LatinModernWeb","Latin Modern (web)"],"font",{action:a.Font}),m.RADIO(["NeoEulerWeb","Neo Euler (web)"],"font",{action:a.Font})),m.SUBMENU(["ContextMenu","Contextual Menu"],{hidden:!p.showContext},m.RADIO("MathJax","context"),m.RADIO(["Browser","Browser"],"context")),m.COMMAND(["Scale","Scale All Math ..."],a.Scale),m.RULE().With({hidden:!p.showDiscoverable,name:["","discover_rule"]}),m.CHECKBOX(["Discoverable","Highlight on Hover"],"discoverable",{hidden:!p.showDiscoverable})),m.SUBMENU(["Locale","Language"],{hidden:!p.showLocale,ltr:true},m.RADIO("en","locale",{action:a.Locale}),m.RULE().With({hidden:!p.showLocaleURL,name:["","localURL_rule"]}),m.COMMAND(["LoadLocale","Load from URL ..."],a.LoadLocale,{hidden:!p.showLocaleURL})),m.RULE(),m.COMMAND(["About","About MathJax"],a.About),m.COMMAND(["Help","MathJax Help"],a.Help));if(a.isMobile){(function(){var s=p.settings;var r=a.menu.Find("Math Settings","Zoom Trigger").menu;r.items[0].disabled=r.items[1].disabled=true;if(s.zoom==="Hover"||s.zoom=="Click"){s.zoom="None"}r.items=r.items.slice(0,4);if(navigator.appVersion.match(/[ (]Android[) ]/)){a.ITEM.SUBMENU.Augment({marker:"\u00BB"})}})()}a.CreateLocaleMenu();a.CreateAnnotationMenu()});a.showRenderer=function(r){a.cookie.showRenderer=p.showRenderer=r;a.saveCookie();a.menu.Find("Math Settings","Math Renderer").hidden=!r};a.showMathPlayer=function(r){a.cookie.showMathPlayer=p.showMathPlayer=r;a.saveCookie();a.menu.Find("Math Settings","MathPlayer").hidden=!r};a.showFontMenu=function(r){a.cookie.showFontMenu=p.showFontMenu=r;a.saveCookie();a.menu.Find("Math Settings","Font Preference").hidden=!r};a.showContext=function(r){a.cookie.showContext=p.showContext=r;a.saveCookie();a.menu.Find("Math Settings","Contextual Menu").hidden=!r};a.showDiscoverable=function(r){a.cookie.showDiscoverable=p.showDiscoverable=r;a.saveCookie();a.menu.Find("Math Settings","Highlight on Hover").hidden=!r;a.menu.Find("Math Settings","discover_rule").hidden=!r};a.showLocale=function(r){a.cookie.showLocale=p.showLocale=r;a.saveCookie();a.menu.Find("Language").hidden=!r};MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){if(!MathJax.OutputJax["HTML-CSS"].config.imageFont){a.menu.Find("Math Settings","Font Preference","TeX (image)").disabled=true}});f.Queue(c.Register.StartupHook("End Config",{}),["getImages",a],["Styles",k,p.styles],["Post",c.Startup.signal,"MathMenu Ready"],["loadComplete",k,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.CallBack,MathJax.OutputJax);
MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"2.4.0",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.attr&&this.root.attr.mode){if(!this.root.display&&this.root.attr.mode==="display"){this.root.display="block";this.root.attrNames.push("display")}delete this.root.attr.mode;for(var b=0,a=this.root.attrNames.length;b<a;b++){if(this.root.attrNames[b]==="mode"){this.root.attrNames.splice(b,1);break}}}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",UPDIAGONALARROW:"updiagonalarrow",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",PHASORANGLE:"phasorangle",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},TEXCLASSNAMES:["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"],copyAttributes:{fontfamily:true,fontsize:true,fontweight:true,fontstyle:true,color:true,background:true,id:true,"class":true,href:true,style:true},skipAttributes:{texClass:true,useHeight:true,texprimestyle:true},copyAttributeNames:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"],Error:function(d,e){var c=this.merror(d),b=MathJax.Localization.fontDirection(),a=MathJax.Localization.fontFamily();if(e){c=c.With(e)}if(b||a){c=this.mstyle(c);if(b){c.dir=b}if(a){c.style.fontFamily="font-family: "+a}}return c}});(function(a){a.mbase=MathJax.Object.Subclass({type:"base",isToken:false,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT},noInherit:{},noInheritAttribute:{texClass:true},linebreakContainer:false,Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:true,notParent:true}))}this.Append.apply(this,arguments)},With:function(e){for(var f in e){if(e.hasOwnProperty(f)){this[f]=e[f]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var f=0,e=arguments.length;f<e;f++){this.SetData(this.data.length,arguments[f])}}},SetData:function(e,f){if(f!=null){if(!(f instanceof a.mbase)){f=(this.isToken||this.isChars?a.chars(f):a.mtext(f))}f.parent=this;f.setInherit(this.inheritFromMe?this:this.inherit)}this.data[e]=f},Parent:function(){var e=this.parent;while(e&&e.notParent){e=e.parent}return e},Get:function(f,k){if(this[f]!=null){return this[f]}if(this.attr&&this.attr[f]!=null){return this.attr[f]}var g=this.Parent();if(g&&g["adjustChild_"+f]!=null){return(g["adjustChild_"+f])(this.childPosition(),k)}var j=this.inherit;var e=j;while(j){var i=j[f];if(i==null&&j.attr){i=j.attr[f]}if(i!=null&&j.noInheritAttribute&&!j.noInheritAttribute[f]){var h=j.noInherit[this.type];if(!(h&&h[f])){return i}}e=j;j=j.inherit}if(!k){if(this.defaults[f]===a.AUTO){return this.autoDefault(f)}if(this.defaults[f]!==a.INHERIT&&this.defaults[f]!=null){return this.defaults[f]}if(e){return e.defaults[f]}}return null},hasValue:function(e){return(this.Get(e,true)!=null)},getValues:function(){var f={};for(var g=0,e=arguments.length;g<e;g++){f[arguments[g]]=this.Get(arguments[g])}return f},adjustChild_scriptlevel:function(f,e){return this.Get("scriptlevel",e)},adjustChild_displaystyle:function(f,e){return this.Get("displaystyle",e)},adjustChild_texprimestyle:function(f,e){return this.Get("texprimestyle",e)},childPosition:function(){var h=this,g=h.parent;while(g.notParent){h=g;g=h.parent}for(var f=0,e=g.data.length;f<e;f++){if(g.data[f]===h){return f}}return null},setInherit:function(g){if(g!==this.inherit&&this.inherit==null){this.inherit=g;for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&this.data[f].setInherit){this.data[f].setInherit(g)}}}},setTeXclass:function(e){this.getPrevClass(e);return(typeof(this.texClass)!=="undefined"?this:e)},getPrevClass:function(e){if(e){this.prevClass=e.Get("texClass");this.prevLevel=e.Get("scriptlevel")}},updateTeXclass:function(e){if(e){this.prevClass=e.prevClass;delete e.prevClass;this.prevLevel=e.prevLevel;delete e.prevLevel;this.texClass=e.Get("texClass")}},texSpacing:function(){var f=(this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE);var e=(this.Get("texClass")||a.TEXCLASS.ORD);if(f===a.TEXCLASS.NONE||e===a.TEXCLASS.NONE){return""}if(f===a.TEXCLASS.VCENTER){f=a.TEXCLASS.ORD}if(e===a.TEXCLASS.VCENTER){e=a.TEXCLASS.ORD}var g=this.TEXSPACE[f][e];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&g>=0){return""}return this.TEXSPACELENGTH[Math.abs(g)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(e){return""},isSpacelike:function(){return false},isEmbellished:function(){return false},Core:function(){return this},CoreMO:function(){return this},hasNewline:function(){if(this.isEmbellished()){return this.CoreMO().hasNewline()}if(this.isToken||this.linebreakContainer){return false}for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&this.data[f].hasNewline()){return true}}return false},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"},getAnnotation:function(){return null}},{childrenSpacelike:function(){for(var f=0,e=this.data.length;f<e;f++){if(!this.data[f].isSpacelike()){return false}}return true},childEmbellished:function(){return(this.data[0]&&this.data[0].isEmbellished())},childCore:function(){return this.data[0]},childCoreMO:function(){return(this.data[0]?this.data[0].CoreMO():null)},setChildTeXclass:function(e){if(this.data[0]){e=this.data[0].setTeXclass(e);this.updateTeXclass(this.data[0])}return e},setBaseTeXclasses:function(g){this.getPrevClass(g);this.texClass=null;if(this.data[0]){if(this.isEmbellished()||this.data[0].isa(a.mi)){g=this.data[0].setTeXclass(g);this.updateTeXclass(this.Core())}else{this.data[0].setTeXclass();g=this}}else{g=this}for(var f=1,e=this.data.length;f<e;f++){if(this.data[f]){this.data[f].setTeXclass()}}return g},setSeparateTeXclasses:function(g){this.getPrevClass(g);for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]){this.data[f].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT},autoDefault:function(f){if(f==="mathvariant"){var e=(this.data[0]||"").toString();return(e.length===1||(e.length===2&&e.charCodeAt(0)>=55296&&e.charCodeAt(0)<56320)?a.VARIANT.ITALIC:a.VARIANT.NORMAL)}return""},setTeXclass:function(f){this.getPrevClass(f);var e=this.data.join("");if(e.length>1&&e.match(/^[a-z][a-z0-9]*$/i)&&this.texClass===a.TEXCLASS.ORD){this.texClass=a.TEXCLASS.OP;this.autoOP=true}return this}});a.mn=a.mbase.Subclass({type:"mn",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:true,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:false,separator:false,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:false,symmetric:false,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:false,movablelimits:false,accent:false,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(g,n){var l=this.def;if(!l){if(g==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var k=this.data.join("");var f=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var h=0,e=f.length;h<e;h++){var j=this.OPTABLE[f[h]][k];if(j){l=this.makeDef(j);break}}if(!l){l=this.CheckRange(k)}if(!l&&n){l={}}else{if(!l){l=MathJax.Hub.Insert({},this.defaultDef)}l.form=f[0];this.def=l}}this.useMMLspacing&=~(this.SPACE_ATTR[g]||0);if(l[g]!=null){return l[g]}else{if(!n){return this.defaultDef[g]}}return""},CheckRange:function(j){var k=j.charCodeAt(0);if(k>=55296&&k<56320){k=(((k-55296)<<10)+(j.charCodeAt(1)-56320))+65536}for(var g=0,e=this.RANGES.length;g<e&&this.RANGES[g][0]<=k;g++){if(k<=this.RANGES[g][1]){if(this.RANGES[g][3]){var f=a.optableDir+"/"+this.RANGES[g][3]+".js";this.RANGES[g][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(f))}var h=a.TEXCLASSNAMES[this.RANGES[g][2]];h=this.OPTABLE.infix[j]=a.mo.OPTYPES[h==="BIN"?"BIN3":h];return this.makeDef(h)}}return null},makeDef:function(f){if(f[2]==null){f[2]=this.defaultDef.texClass}if(!f[3]){f[3]={}}var e=MathJax.Hub.Insert({},f[3]);e.lspace=this.SPACE[f[0]];e.rspace=this.SPACE[f[1]];e.texClass=f[2];if(e.texClass===a.TEXCLASS.REL&&(this.movablelimits||this.data.join("").match(/^[a-z]+$/i))){e.texClass=a.TEXCLASS.OP}return e},getForm:function(){var e=this,g=this.parent,f=this.Parent();while(f&&f.isEmbellished()){e=g;g=f.parent;f=f.Parent()}if(g&&g.type==="mrow"&&g.NonSpaceLength()!==1){if(g.FirstNonSpace()===e){return a.FORM.PREFIX}if(g.LastNonSpace()===e){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return true},hasNewline:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE)},setTeXclass:function(f){var e=this.getValues("form","lspace","rspace","fence");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}if(e.fence&&!this.texClass){if(e.form===a.FORM.PREFIX){this.texClass=a.TEXCLASS.OPEN}if(e.form===a.FORM.POSTFIX){this.texClass=a.TEXCLASS.CLOSE}}this.texClass=this.Get("texClass");if(this.data.join("")==="\u2061"){if(f){f.texClass=a.TEXCLASS.OP;f.fnOP=true}this.texClass=this.prevClass=a.TEXCLASS.NONE;return f}return this.adjustTeXclass(f)},adjustTeXclass:function(e){if(this.texClass===a.TEXCLASS.NONE){return e}if(e){if(e.autoOP&&(this.texClass===a.TEXCLASS.BIN||this.texClass===a.TEXCLASS.REL)){e.texClass=a.TEXCLASS.ORD}this.prevClass=e.texClass||a.TEXCLASS.ORD;this.prevLevel=e.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){e.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:true,isSpacelike:function(){return true},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:true,isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},hasDimAttr:function(){return(this.hasValue("width")||this.hasValue("height")||this.hasValue("depth"))},hasNewline:function(){return(!this.hasDimAttr()&&this.Get("linebreak")===a.LINEBREAK.NEWLINE)}});a.ms=a.mbase.Subclass({type:"ms",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:false,notParent:false,isEmbellished:function(){var f=false;for(var g=0,e=this.data.length;g<e;g++){if(this.data[g]==null){continue}if(this.data[g].isEmbellished()){if(f){return false}f=true;this.core=g}else{if(!this.data[g].isSpacelike()){return false}}}return f},NonSpaceLength:function(){var g=0;for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&!this.data[f].isSpacelike()){g++}}return g},FirstNonSpace:function(){for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&!this.data[f].isSpacelike()){return this.data[f]}}return null},LastNonSpace:function(){for(var e=this.data.length-1;e>=0;e--){if(this.data[0]&&!this.data[e].isSpacelike()){return this.data[e]}}return null},Core:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(g){var f,e=this.data.length;if((this.open||this.close)&&(!g||!g.fnOP)){this.getPrevClass(g);for(f=0;f<e;f++){if(this.data[f]){g=this.data[f].setTeXclass(g)}}this.texClass=a.TEXCLASS.INNER;return this}else{for(f=0;f<e;f++){if(this.data[f]){g=this.data[f].setTeXclass(g)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return g}},getAnnotation:function(e){if(this.data.length!=1){return null}return this.data[0].getAnnotation(e)}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,linebreakContainer:true,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:false},adjustChild_displaystyle:function(e){return false},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");if(!this.Get("displaystyle")||e>0){e++}return e},adjustChild_texprimestyle:function(e){if(e==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(e){return true}});a.mroot=a.mbase.Subclass({type:"mroot",linebreakContainer:true,texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(e){if(e===1){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");if(f===1){e+=2}return e},adjustChild_texprimestyle:function(e){if(e===0){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:true,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(g){var f=this.scriptlevel;if(f==null){f=this.Get("scriptlevel")}else{if(String(f).match(/^ *[-+]/)){delete this.scriptlevel;var e=this.Get("scriptlevel");this.scriptlevel=f;f=e+parseInt(f)}}return f},inheritFromMe:true,noInherit:{mpadded:{width:true,height:true,depth:true,lspace:true,voffset:true},mtable:{width:true,height:true,depth:true,align:true}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(h){this.getPrevClass(h);var f=this.getValues("open","close","separators");f.open=f.open.replace(/[ \t\n\r]/g,"");f.close=f.close.replace(/[ \t\n\r]/g,"");f.separators=f.separators.replace(/[ \t\n\r]/g,"");if(f.open!==""){this.SetData("open",a.mo(f.open).With({fence:true,form:a.FORM.PREFIX,texClass:a.TEXCLASS.OPEN}));this.data.open.useMMLspacing&=~this.data.open.SPACE_ATTR.form;h=this.data.open.setTeXclass(h)}if(f.separators!==""){while(f.separators.length<this.data.length){f.separators+=f.separators.charAt(f.separators.length-1)}}if(this.data[0]){h=this.data[0].setTeXclass(h)}for(var g=1,e=this.data.length;g<e;g++){if(this.data[g]){if(f.separators!==""){this.SetData("sep"+g,a.mo(f.separators.charAt(g-1)).With({separator:true}));h=this.data["sep"+g].setTeXclass(h)}h=this.data[g].setTeXclass(h)}}if(f.close!==""){this.SetData("close",a.mo(f.close).With({fence:true,form:a.FORM.POSTFIX,texClass:a.TEXCLASS.CLOSE}));this.data.close.useMMLspacing&=~this.data.close.SPACE_ATTR.form;h=this.data.close.setTeXclass(h)}this.updateTeXclass(this.data.open);this.texClass=a.TEXCLASS.INNER;return h}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:true,linebreakContainer:true,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(e){if(e==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(e):a.TEXCLASS.ORD)}return 0},adjustChild_displaystyle:function(e){if(e>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");if(f>0){e++}return e},adjustChild_texprimestyle:function(e){if(e===this.sub){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(e){if(e%2===1){return true}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(e){if(e==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(e):a.TEXCLASS.ORD)}if(e==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(e==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return false},adjustChild_displaystyle:function(e){if(e>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");var e=(this.data[this.base]&&!this.Get("displaystyle")&&this.data[this.base].CoreMO().Get("movablelimits"));if(g==this.under&&(e||!this.Get("accentunder"))){f++}if(g==this.over&&(e||!this.Get("accent"))){f++}return f},adjustChild_texprimestyle:function(e){if(e===this.base&&this.data[this.over]){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:true,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:false,equalcolumns:false,displaystyle:false,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:true,noInherit:{mover:{align:true},munder:{align:true},munderover:{align:true},mtable:{align:true,rowalign:true,columnalign:true,groupalign:true,alignmentscope:true,columnwidth:true,width:true,rowspacing:true,columnspacing:true,rowlines:true,columnlines:true,frame:true,framespacing:true,equalrows:true,equalcolumns:true,side:true,minlabelspacing:true,texClass:true,useHeight:1}},linebreakContainer:true,Append:function(){for(var f=0,e=arguments.length;f<e;f++){if(!((arguments[f] instanceof a.mtr)||(arguments[f] instanceof a.mlabeledtr))){arguments[f]=a.mtd(arguments[f])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{rowalign:true,columnalign:true,groupalign:true},mtable:{rowalign:true,columnalign:true,groupalign:true}},linebreakContainer:true,Append:function(){for(var f=0,e=arguments.length;f<e;f++){if(!(arguments[f] instanceof a.mtd)){arguments[f]=a.mtd(arguments[f])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:true,linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{groupalign:true},mtable:{groupalign:true}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return true}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(e){if(this.Get("actiontype")===a.ACTIONTYPE.TOOLTIP&&this.data[1]){this.data[1].setTeXclass()}return this.selected().setTeXclass(e)}});a.semantics=a.mbase.Subclass({type:"semantics",notParent:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass,getAnnotation:function(g){var l=MathJax.Hub.config.MathMenu.semanticsAnnotations[g];if(l){for(var h=0,e=this.data.length;h<e;h++){var k=this.data[h].Get("encoding");if(k){for(var f=0,o=l.length;f<o;f++){if(l[f]===k){return this.data[h]}}}}}return null}});a.annotation=a.mbase.Subclass({type:"annotation",isChars:true,linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,dir:"ltr",scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:false},autoDefault:function(e){if(e==="displaystyle"){return this.Get("display")==="block"}return""},linebreakContainer:true,setTeXclass:a.mbase.setChildTeXclass,getAnnotation:function(e){if(this.data.length!=1){return null}return this.data[0].getAnnotation(e)}});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var e=this.value();if(e<=65535){return String.fromCharCode(e)}e-=65536;return String.fromCharCode((e>>10)+55296)+String.fromCharCode((e&1023)+56320)}});a.xml=a.mbase.Subclass({type:"xml",Init:function(){this.div=document.createElement("div");return this.SUPER(arguments).Init.apply(this,arguments)},Append:function(){for(var f=0,e=arguments.length;f<e;f++){var g=this.Import(arguments[f]);this.data.push(g);this.div.appendChild(g)}},Import:function(j){if(document.importNode){return document.importNode(j,true)}var f,g,e;if(j.nodeType===1){f=document.createElement(j.nodeName);for(g=0,e=j.attributes.length;g<e;g++){var h=j.attributes[g];if(h.specified&&h.nodeValue!=null&&h.nodeValue!=""){f.setAttribute(h.nodeName,h.nodeValue)}if(h.nodeName==="style"){f.style.cssText=h.nodeValue}}if(j.className){f.className=j.className}}else{if(j.nodeType===3||j.nodeType===4){f=document.createTextNode(j.nodeValue)}else{if(j.nodeType===8){f=document.createComment(j.nodeValue)}else{return document.createTextNode("")}}}for(g=0,e=j.childNodes.length;g<e;g++){f.appendChild(this.Import(j.childNodes[g]))}return f},value:function(){return this.div},toString:function(){return this.div.innerHTML}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:true,notParent:true,texClass:a.TEXCLASS.ORD,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,isEmbellished:a.mbase.childEmbellished,setTeXclass:function(e){this.data[0].setTeXclass();return this.adjustTeXclass(e)},adjustTeXclass:a.mo.prototype.adjustTeXclass});a.NULL=a.mbase().With({type:"null"});var b=a.TEXCLASS;var d={ORD:[0,0,b.ORD],ORD11:[1,1,b.ORD],ORD21:[2,1,b.ORD],ORD02:[0,2,b.ORD],ORD55:[5,5,b.ORD],OP:[1,2,b.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,b.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,b.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,b.OP,{largeop:true,symmetric:true}],BIN3:[3,3,b.BIN],BIN4:[4,4,b.BIN],BIN01:[0,1,b.BIN],BIN5:[5,5,b.BIN],TALLBIN:[4,4,b.BIN,{stretchy:true}],BINOP:[4,4,b.BIN,{largeop:true,movablelimits:true}],REL:[5,5,b.REL],REL1:[1,1,b.REL,{stretchy:true}],REL4:[4,4,b.REL],RELSTRETCH:[5,5,b.REL,{stretchy:true}],RELACCENT:[5,5,b.REL,{accent:true}],WIDEREL:[5,5,b.REL,{accent:true,stretchy:true}],OPEN:[0,0,b.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,b.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,b.INNER],PUNCT:[0,3,b.PUNCT],ACCENT:[0,0,b.ORD,{accent:true}],WIDEACCENT:[0,0,b.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,b.REL,"BasicLatin"],[160,255,b.ORD,"Latin1Supplement"],[256,383,b.ORD],[384,591,b.ORD],[688,767,b.ORD,"SpacingModLetters"],[768,879,b.ORD,"CombDiacritMarks"],[880,1023,b.ORD,"GreekAndCoptic"],[7680,7935,b.ORD],[8192,8303,b.PUNCT,"GeneralPunctuation"],[8304,8351,b.ORD],[8352,8399,b.ORD],[8400,8447,b.ORD,"CombDiactForSymbols"],[8448,8527,b.ORD,"LetterlikeSymbols"],[8528,8591,b.ORD],[8592,8703,b.REL,"Arrows"],[8704,8959,b.BIN,"MathOperators"],[8960,9215,b.ORD,"MiscTechnical"],[9312,9471,b.ORD],[9472,9631,b.ORD],[9632,9727,b.ORD,"GeometricShapes"],[9984,10175,b.ORD,"Dingbats"],[10176,10223,b.ORD,"MiscMathSymbolsA"],[10224,10239,b.REL,"SupplementalArrowsA"],[10496,10623,b.REL,"SupplementalArrowsB"],[10624,10751,b.ORD,"MiscMathSymbolsB"],[10752,11007,b.BIN,"SuppMathOperators"],[11008,11263,b.ORD,"MiscSymbolsAndArrows"],[119808,120831,b.ORD]],OPTABLE:{prefix:{"\u2200":d.ORD21,"\u2202":d.ORD21,"\u2203":d.ORD21,"\u2207":d.ORD21,"\u220F":d.OP,"\u2210":d.OP,"\u2211":d.OP,"\u2212":d.BIN01,"\u2213":d.BIN01,"\u221A":[1,1,b.ORD,{stretchy:true}],"\u2220":d.ORD,"\u222B":d.INTEGRAL,"\u222E":d.INTEGRAL,"\u22C0":d.OP,"\u22C1":d.OP,"\u22C2":d.OP,"\u22C3":d.OP,"\u2308":d.OPEN,"\u230A":d.OPEN,"\u27E8":d.OPEN,"\u27EE":d.OPEN,"\u2A00":d.OP,"\u2A01":d.OP,"\u2A02":d.OP,"\u2A04":d.OP,"\u2A06":d.OP,"\u00AC":d.ORD21,"\u00B1":d.BIN01,"(":d.OPEN,"+":d.BIN01,"-":d.BIN01,"[":d.OPEN,"{":d.OPEN,"|":d.OPEN},postfix:{"!":[1,0,b.CLOSE],"&":d.ORD,"\u2032":d.ORD02,"\u203E":d.WIDEACCENT,"\u2309":d.CLOSE,"\u230B":d.CLOSE,"\u23DE":d.WIDEACCENT,"\u23DF":d.WIDEACCENT,"\u266D":d.ORD02,"\u266E":d.ORD02,"\u266F":d.ORD02,"\u27E9":d.CLOSE,"\u27EF":d.CLOSE,"\u02C6":d.WIDEACCENT,"\u02C7":d.WIDEACCENT,"\u02C9":d.WIDEACCENT,"\u02CA":d.ACCENT,"\u02CB":d.ACCENT,"\u02D8":d.ACCENT,"\u02D9":d.ACCENT,"\u02DC":d.WIDEACCENT,"\u0302":d.WIDEACCENT,"\u00A8":d.ACCENT,"\u00AF":d.WIDEACCENT,")":d.CLOSE,"]":d.CLOSE,"^":d.WIDEACCENT,_:d.WIDEACCENT,"`":d.ACCENT,"|":d.CLOSE,"}":d.CLOSE,"~":d.WIDEACCENT},infix:{"":d.ORD,"%":[3,3,b.ORD],"\u2022":d.BIN4,"\u2026":d.INNER,"\u2044":d.TALLBIN,"\u2061":d.ORD,"\u2062":d.ORD,"\u2063":[0,0,b.ORD,{linebreakstyle:"after",separator:true}],"\u2064":d.ORD,"\u2190":d.WIDEREL,"\u2191":d.RELSTRETCH,"\u2192":d.WIDEREL,"\u2193":d.RELSTRETCH,"\u2194":d.WIDEREL,"\u2195":d.RELSTRETCH,"\u2196":d.RELSTRETCH,"\u2197":d.RELSTRETCH,"\u2198":d.RELSTRETCH,"\u2199":d.RELSTRETCH,"\u21A6":d.WIDEREL,"\u21A9":d.WIDEREL,"\u21AA":d.WIDEREL,"\u21BC":d.WIDEREL,"\u21BD":d.WIDEREL,"\u21C0":d.WIDEREL,"\u21C1":d.WIDEREL,"\u21CC":d.WIDEREL,"\u21D0":d.WIDEREL,"\u21D1":d.RELSTRETCH,"\u21D2":d.WIDEREL,"\u21D3":d.RELSTRETCH,"\u21D4":d.WIDEREL,"\u21D5":d.RELSTRETCH,"\u2208":d.REL,"\u2209":d.REL,"\u220B":d.REL,"\u2212":d.BIN4,"\u2213":d.BIN4,"\u2215":d.TALLBIN,"\u2216":d.BIN4,"\u2217":d.BIN4,"\u2218":d.BIN4,"\u2219":d.BIN4,"\u221D":d.REL,"\u2223":d.REL,"\u2225":d.REL,"\u2227":d.BIN4,"\u2228":d.BIN4,"\u2229":d.BIN4,"\u222A":d.BIN4,"\u223C":d.REL,"\u2240":d.BIN4,"\u2243":d.REL,"\u2245":d.REL,"\u2248":d.REL,"\u224D":d.REL,"\u2250":d.REL,"\u2260":d.REL,"\u2261":d.REL,"\u2264":d.REL,"\u2265":d.REL,"\u226A":d.REL,"\u226B":d.REL,"\u227A":d.REL,"\u227B":d.REL,"\u2282":d.REL,"\u2283":d.REL,"\u2286":d.REL,"\u2287":d.REL,"\u228E":d.BIN4,"\u2291":d.REL,"\u2292":d.REL,"\u2293":d.BIN4,"\u2294":d.BIN4,"\u2295":d.BIN4,"\u2296":d.BIN4,"\u2297":d.BIN4,"\u2298":d.BIN4,"\u2299":d.BIN4,"\u22A2":d.REL,"\u22A3":d.REL,"\u22A4":d.ORD55,"\u22A5":d.REL,"\u22A8":d.REL,"\u22C4":d.BIN4,"\u22C5":d.BIN4,"\u22C6":d.BIN4,"\u22C8":d.REL,"\u22EE":d.ORD55,"\u22EF":d.INNER,"\u22F1":[5,5,b.INNER],"\u25B3":d.BIN4,"\u25B5":d.BIN4,"\u25B9":d.BIN4,"\u25BD":d.BIN4,"\u25BF":d.BIN4,"\u25C3":d.BIN4,"\u2758":d.REL,"\u27F5":d.WIDEREL,"\u27F6":d.WIDEREL,"\u27F7":d.WIDEREL,"\u27F8":d.WIDEREL,"\u27F9":d.WIDEREL,"\u27FA":d.WIDEREL,"\u27FC":d.WIDEREL,"\u2A2F":d.BIN4,"\u2A3F":d.BIN4,"\u2AAF":d.REL,"\u2AB0":d.REL,"\u00B1":d.BIN4,"\u00B7":d.BIN4,"\u00D7":d.BIN4,"\u00F7":d.BIN4,"*":d.BIN3,"+":d.BIN4,",":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"-":d.BIN4,".":[3,3,b.ORD],"/":d.ORD11,":":[1,2,b.REL],";":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"<":d.REL,"=":d.REL,">":d.REL,"?":[1,1,b.CLOSE],"\\":d.ORD,"^":d.ORD11,_:d.ORD11,"|":[2,2,b.ORD,{fence:true,stretchy:true,symmetric:true}],"#":d.ORD,"$":d.ORD,"\u002E":[0,3,b.PUNCT,{separator:true}],"\u02B9":d.ORD,"\u0300":d.ACCENT,"\u0301":d.ACCENT,"\u0303":d.WIDEACCENT,"\u0304":d.ACCENT,"\u0306":d.ACCENT,"\u0307":d.ACCENT,"\u0308":d.ACCENT,"\u030C":d.ACCENT,"\u0332":d.WIDEACCENT,"\u0338":d.REL4,"\u2015":[0,0,b.ORD,{stretchy:true}],"\u2017":[0,0,b.ORD,{stretchy:true}],"\u2020":d.BIN3,"\u2021":d.BIN3,"\u20D7":d.ACCENT,"\u2111":d.ORD,"\u2113":d.ORD,"\u2118":d.ORD,"\u211C":d.ORD,"\u2205":d.ORD,"\u221E":d.ORD,"\u2305":d.BIN3,"\u2306":d.BIN3,"\u2322":d.REL4,"\u2323":d.REL4,"\u2329":d.OPEN,"\u232A":d.CLOSE,"\u23AA":d.ORD,"\u23AF":[0,0,b.ORD,{stretchy:true}],"\u23B0":d.OPEN,"\u23B1":d.CLOSE,"\u2500":d.ORD,"\u25EF":d.BIN3,"\u2660":d.ORD,"\u2661":d.ORD,"\u2662":d.ORD,"\u2663":d.ORD,"\u3008":d.OPEN,"\u3009":d.CLOSE,"\uFE37":d.WIDEACCENT,"\uFE38":d.WIDEACCENT}}},{OPTYPES:d});var c=a.mo.prototype.OPTABLE;c.infix["^"]=d.WIDEREL;c.infix._=d.WIDEREL;c.prefix["\u2223"]=d.OPEN;c.prefix["\u2225"]=d.OPEN;c.postfix["\u2223"]=d.CLOSE;c.postfix["\u2225"]=d.CLOSE})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");
MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="2.4.0";var a=MathJax.ElementJax.mml;SETTINGS=MathJax.Hub.config.menuSettings;a.mbase.Augment({toMathML:function(k){var g=(this.inferred&&this.parent.inferRow);if(k==null){k=""}var e=this.type,d=this.toMathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[],h=(this.isToken?"":k+(g?"":"  "));for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken&&!this.isChars){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||(j.length===1&&j[0]==="")){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},toMathMLattributes:function(){var j=[],g=this.defaults;var c=(this.attrNames||a.copyAttributeNames),l=a.skipAttributes;if(this.type==="math"&&(!this.attr||!this.attr.xmlns)){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(!this.attrNames){if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=(d==="open"||d==="close"||d==="form");if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.toMathMLattribute(k)+'"')}this[d]=k}}}}for(var h=0,f=c.length;h<f;h++){if(c[h]==="class"){continue}k=(this.attr||{})[c[h]];if(k==null){k=this[c[h]]}if(k!=null){j.push(c[h]+'="'+this.toMathMLquote(k)+'"')}}this.toMathMLclass(j);if(j.length){return" "+j.join(" ")}else{return""}},toMathMLclass:function(c){var e=[];if(this["class"]){e.push(this["class"])}if(this.isa(a.TeXAtom)&&SETTINGS.texHints){var d=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(d){e.push("MJX-TeXAtom-"+d)}}if(this.mathvariant&&this.toMathMLvariants[this.mathvariant]){e.push("MJX"+this.mathvariant)}if(this.variantForm){e.push("MJX-variant")}if(e.length){c.unshift('class="'+e.join(" ")+'"')}},toMathMLattribute:function(c){if(typeof(c)==="string"&&c.replace(/ /g,"").match(/^(([-+])?(\d+(\.\d*)?|\.\d+))mu$/)){return RegExp.$2+((1/18)*RegExp.$3).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.toMathMLvariants[c]){return this.toMathMLvariants[c]}}return this.toMathMLquote(c)},toMathMLvariants:{"-tex-caligraphic":a.VARIANT.SCRIPT,"-tex-caligraphic-bold":a.VARIANT.BOLDSCRIPT,"-tex-oldstyle":a.VARIANT.NORMAL,"-tex-oldstyle-bold":a.VARIANT.BOLD,"-tex-mathit":a.VARIANT.ITALIC},toMathMLquote:function(f){f=String(f).split("");for(var g=0,d=f.length;g<d;g++){var k=f[g].charCodeAt(0);if(k<=55295||57344<=k){if(k<32||k>126){f[g]="&#x"+k.toString(16).toUpperCase()+";"}else{var j={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[f[g]];if(j){f[g]=j}}}else{if(g+1<d){var h=f[g+1].charCodeAt(0);var e=(((k-55296)<<10)+(h-56320)+65536);f[g]="&#x"+e.toString(16).toUpperCase()+";";f[g+1]="";g++}else{f[g]=""}}}return f.join("")}});a.math.Augment({toMathML:function(c,d){var f;if(c==null){c=""}if(d&&d.originalText&&SETTINGS.semantics){f=MathJax.InputJax[d.inputJax].annotationEncoding}var k=(this.data[0]&&this.data[0].data.length>1);var n=this.type,j=this.toMathMLattributes();var h=[],l=c+(f?"    ":"")+(k?"  ":"");for(var g=0,e=this.data.length;g<e;g++){if(this.data[g]){h.push(this.data[g].toMathML(l))}else{h.push(l+"<mrow />")}}if(h.length===0||(h.length===1&&h[0]==="")){if(!f){return"<"+n+j+" />"}h.push(l+"<mrow />")}if(f){if(k){h.unshift(c+"    <mrow>");h.push(c+"    </mrow>")}h.unshift(c+"  <semantics>");h.push(c+'    <annotation encoding="'+f+'">'+d.originalText+"</annotation>");h.push(c+"  </semantics>")}return c+"<"+n+j+">\n"+h.join("\n")+"\n"+c+"</"+n+">"}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(d){var c=this.toMathMLattributes();if(!c&&this.data[0].data.length===1){return d.substr(2)+this.data[0].toMathML(d)}return d+"<mrow"+c+">\n"+this.data[0].toMathML(d+"  ")+"\n"+d+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.toMathMLquote(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});a.xml.Augment({toMathML:function(c){return(c||"")+this.toString()}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");
(function(ag){var k;var aa=MathJax.Object.Subclass({firstChild:null,lastChild:null,Init:function(){this.childNodes=[]},appendChild:function(i){if(i.parent){i.parent.removeChild(i)}if(this.lastChild){this.lastChild.nextSibling=i}if(!this.firstChild){this.firstChild=i}this.childNodes.push(i);i.parent=this;this.lastChild=i;return i},removeChild:function(ak){for(var aj=0,ai=this.childNodes.length;aj<ai;aj++){if(this.childNodes[aj]===ak){break}}if(aj===ai){return}this.childNodes.splice(aj,1);if(ak===this.firstChild){this.firstChild=ak.nextSibling}if(ak===this.lastChild){if(!this.childNodes.length){this.lastChild=null}else{this.lastChild=this.childNodes[this.childNodes.length-1]}}if(aj){this.childNodes[aj-1].nextSibling=ak.nextSibling}ak.nextSibling=ak.parent=null;return ak},replaceChild:function(al,aj){for(var ak=0,ai=this.childNodes.length;ak<ai;ak++){if(this.childNodes[ak]===aj){break}}if(ak){this.childNodes[ak-1].nextSibling=al}else{this.firstChild=al}if(ak>=ai-1){this.lastChild=al}this.childNodes[ak]=al;al.nextSibling=aj.nextSibling;aj.nextSibling=aj.parent=null;return aj},toString:function(){return"{"+this.childNodes.join("")+"}"}});var E=function(){k=MathJax.ElementJax.mml;var i=k.mbase.prototype.Init;k.mbase.Augment({firstChild:null,lastChild:null,nodeValue:null,nextSibling:null,Init:function(){var ai=i.apply(this,arguments)||this;ai.childNodes=ai.data;ai.nodeName=ai.type;return ai},appendChild:function(al){if(al.parent){al.parent.removeChild(al)}var aj=arguments;if(al.isa(aa)){aj=al.childNodes;al.data=al.childNodes=[];al.firstChild=al.lastChild=null}for(var ak=0,ai=aj.length;ak<ai;ak++){al=aj[ak];if(this.lastChild){this.lastChild.nextSibling=al}if(!this.firstChild){this.firstChild=al}this.Append(al);this.lastChild=al}return al},removeChild:function(ak){for(var aj=0,ai=this.childNodes.length;aj<ai;aj++){if(this.childNodes[aj]===ak){break}}if(aj===ai){return}this.childNodes.splice(aj,1);if(ak===this.firstChild){this.firstChild=ak.nextSibling}if(ak===this.lastChild){if(!this.childNodes.length){this.lastChild=null}else{this.lastChild=this.childNodes[this.childNodes.length-1]}}if(aj){this.childNodes[aj-1].nextSibling=ak.nextSibling}ak.nextSibling=ak.parent=null;return ak},replaceChild:function(al,aj){for(var ak=0,ai=this.childNodes.length;ak<ai;ak++){if(this.childNodes[ak]===aj){break}}if(ak){this.childNodes[ak-1].nextSibling=al}else{this.firstChild=al}if(ak>=ai-1){this.lastChild=al}this.SetData(ak,al);al.nextSibling=aj.nextSibling;aj.nextSibling=aj.parent=null;return aj},setAttribute:function(ai,aj){this[ai]=aj}})};var S={};var g={getElementById:true,createElementNS:function(ai,i){var aj=k[i]();if(i==="mo"&&ag.config.useMathMLspacing){aj.useMMLspacing=128}return aj},createTextNode:function(i){return k.chars(i).With({nodeValue:i})},createDocumentFragment:function(){return aa()}};var O={appName:"MathJax"};var ac;var I="red";var ad="serif";var t=true;var C=true;var f=".";var q=g.createElementNS==null;function V(i){if(q){return g.createElement(i)}else{return g.createElementNS("http://www.w3.org/1999/xhtml",i)}}var J=[61237,8492,61238,61239,8496,8497,61240,8459,8464,61241,61242,8466,8499,61243,61244,61245,61246,8475,61247,61248,61249,61250,61251,61252,61253,61254];var N=[61277,61278,8493,61279,61280,61281,61282,8460,8465,61283,61284,61285,61286,61287,61288,61289,61290,8476,61291,61292,61293,61294,61295,61296,61297,8488];var D=[61324,61325,8450,61326,61327,61328,61329,8461,61330,61331,61332,61333,61334,8469,61335,8473,8474,8477,61336,61337,61338,61339,61340,61341,61342,8484];var d=0,H=1,X=2,m=3,b=4,l=5,a=6,P=7,Z=8,r=9,ab=10;var j={input:"sqrt",tag:"msqrt",output:"sqrt",tex:null,ttype:H},af={input:"root",tag:"mroot",output:"root",tex:null,ttype:X},A={input:"frac",tag:"mfrac",output:"/",tex:null,ttype:X},Q={input:"/",tag:"mfrac",output:"/",tex:null,ttype:m},o={input:"stackrel",tag:"mover",output:"stackrel",tex:null,ttype:X},s={input:"_",tag:"msub",output:"_",tex:null,ttype:m},h={input:"^",tag:"msup",output:"^",tex:null,ttype:m},ah={input:"text",tag:"mtext",output:"text",tex:null,ttype:ab},x={input:"mbox",tag:"mtext",output:"mbox",tex:null,ttype:ab},p={input:'"',tag:"mtext",output:"mbox",tex:null,ttype:ab};var G=[{input:"alpha",tag:"mi",output:"\u03B1",tex:null,ttype:d},{input:"beta",tag:"mi",output:"\u03B2",tex:null,ttype:d},{input:"chi",tag:"mi",output:"\u03C7",tex:null,ttype:d},{input:"delta",tag:"mi",output:"\u03B4",tex:null,ttype:d},{input:"Delta",tag:"mo",output:"\u0394",tex:null,ttype:d},{input:"epsi",tag:"mi",output:"\u03B5",tex:"epsilon",ttype:d},{input:"varepsilon",tag:"mi",output:"\u025B",tex:null,ttype:d},{input:"eta",tag:"mi",output:"\u03B7",tex:null,ttype:d},{input:"gamma",tag:"mi",output:"\u03B3",tex:null,ttype:d},{input:"Gamma",tag:"mo",output:"\u0393",tex:null,ttype:d},{input:"iota",tag:"mi",output:"\u03B9",tex:null,ttype:d},{input:"kappa",tag:"mi",output:"\u03BA",tex:null,ttype:d},{input:"lambda",tag:"mi",output:"\u03BB",tex:null,ttype:d},{input:"Lambda",tag:"mo",output:"\u039B",tex:null,ttype:d},{input:"mu",tag:"mi",output:"\u03BC",tex:null,ttype:d},{input:"nu",tag:"mi",output:"\u03BD",tex:null,ttype:d},{input:"omega",tag:"mi",output:"\u03C9",tex:null,ttype:d},{input:"Omega",tag:"mo",output:"\u03A9",tex:null,ttype:d},{input:"phi",tag:"mi",output:"\u03C6",tex:null,ttype:d},{input:"varphi",tag:"mi",output:"\u03D5",tex:null,ttype:d},{input:"Phi",tag:"mo",output:"\u03A6",tex:null,ttype:d},{input:"pi",tag:"mi",output:"\u03C0",tex:null,ttype:d},{input:"Pi",tag:"mo",output:"\u03A0",tex:null,ttype:d},{input:"psi",tag:"mi",output:"\u03C8",tex:null,ttype:d},{input:"Psi",tag:"mi",output:"\u03A8",tex:null,ttype:d},{input:"rho",tag:"mi",output:"\u03C1",tex:null,ttype:d},{input:"sigma",tag:"mi",output:"\u03C3",tex:null,ttype:d},{input:"Sigma",tag:"mo",output:"\u03A3",tex:null,ttype:d},{input:"tau",tag:"mi",output:"\u03C4",tex:null,ttype:d},{input:"theta",tag:"mi",output:"\u03B8",tex:null,ttype:d},{input:"vartheta",tag:"mi",output:"\u03D1",tex:null,ttype:d},{input:"Theta",tag:"mo",output:"\u0398",tex:null,ttype:d},{input:"upsilon",tag:"mi",output:"\u03C5",tex:null,ttype:d},{input:"xi",tag:"mi",output:"\u03BE",tex:null,ttype:d},{input:"Xi",tag:"mo",output:"\u039E",tex:null,ttype:d},{input:"zeta",tag:"mi",output:"\u03B6",tex:null,ttype:d},{input:"*",tag:"mo",output:"\u22C5",tex:"cdot",ttype:d},{input:"**",tag:"mo",output:"\u22C6",tex:"star",ttype:d},{input:"//",tag:"mo",output:"/",tex:null,ttype:d},{input:"\\\\",tag:"mo",output:"\\",tex:"backslash",ttype:d},{input:"setminus",tag:"mo",output:"\\",tex:null,ttype:d},{input:"xx",tag:"mo",output:"\u00D7",tex:"times",ttype:d},{input:"-:",tag:"mo",output:"\u00F7",tex:"divide",ttype:d},{input:"@",tag:"mo",output:"\u2218",tex:"circ",ttype:d},{input:"o+",tag:"mo",output:"\u2295",tex:"oplus",ttype:d},{input:"ox",tag:"mo",output:"\u2297",tex:"otimes",ttype:d},{input:"o.",tag:"mo",output:"\u2299",tex:"odot",ttype:d},{input:"sum",tag:"mo",output:"\u2211",tex:null,ttype:P},{input:"prod",tag:"mo",output:"\u220F",tex:null,ttype:P},{input:"^^",tag:"mo",output:"\u2227",tex:"wedge",ttype:d},{input:"^^^",tag:"mo",output:"\u22C0",tex:"bigwedge",ttype:P},{input:"vv",tag:"mo",output:"\u2228",tex:"vee",ttype:d},{input:"vvv",tag:"mo",output:"\u22C1",tex:"bigvee",ttype:P},{input:"nn",tag:"mo",output:"\u2229",tex:"cap",ttype:d},{input:"nnn",tag:"mo",output:"\u22C2",tex:"bigcap",ttype:P},{input:"uu",tag:"mo",output:"\u222A",tex:"cup",ttype:d},{input:"uuu",tag:"mo",output:"\u22C3",tex:"bigcup",ttype:P},{input:"!=",tag:"mo",output:"\u2260",tex:"ne",ttype:d},{input:":=",tag:"mo",output:":=",tex:null,ttype:d},{input:"lt",tag:"mo",output:"<",tex:null,ttype:d},{input:"<=",tag:"mo",output:"\u2264",tex:"le",ttype:d},{input:"lt=",tag:"mo",output:"\u2264",tex:"leq",ttype:d},{input:">=",tag:"mo",output:"\u2265",tex:"ge",ttype:d},{input:"geq",tag:"mo",output:"\u2265",tex:null,ttype:d},{input:"-<",tag:"mo",output:"\u227A",tex:"prec",ttype:d},{input:"-lt",tag:"mo",output:"\u227A",tex:null,ttype:d},{input:">-",tag:"mo",output:"\u227B",tex:"succ",ttype:d},{input:"in",tag:"mo",output:"\u2208",tex:null,ttype:d},{input:"!in",tag:"mo",output:"\u2209",tex:"notin",ttype:d},{input:"sub",tag:"mo",output:"\u2282",tex:"subset",ttype:d},{input:"sup",tag:"mo",output:"\u2283",tex:"supset",ttype:d},{input:"sube",tag:"mo",output:"\u2286",tex:"subseteq",ttype:d},{input:"supe",tag:"mo",output:"\u2287",tex:"supseteq",ttype:d},{input:"-=",tag:"mo",output:"\u2261",tex:"equiv",ttype:d},{input:"~=",tag:"mo",output:"\u2245",tex:"cong",ttype:d},{input:"~~",tag:"mo",output:"\u2248",tex:"approx",ttype:d},{input:"prop",tag:"mo",output:"\u221D",tex:"propto",ttype:d},{input:"and",tag:"mtext",output:"and",tex:null,ttype:a},{input:"or",tag:"mtext",output:"or",tex:null,ttype:a},{input:"not",tag:"mo",output:"\u00AC",tex:"neg",ttype:d},{input:"=>",tag:"mo",output:"\u21D2",tex:"implies",ttype:d},{input:"if",tag:"mo",output:"if",tex:null,ttype:a},{input:"<=>",tag:"mo",output:"\u21D4",tex:"iff",ttype:d},{input:"AA",tag:"mo",output:"\u2200",tex:"forall",ttype:d},{input:"EE",tag:"mo",output:"\u2203",tex:"exists",ttype:d},{input:"_|_",tag:"mo",output:"\u22A5",tex:"bot",ttype:d},{input:"TT",tag:"mo",output:"\u22A4",tex:"top",ttype:d},{input:"|--",tag:"mo",output:"\u22A2",tex:"vdash",ttype:d},{input:"|==",tag:"mo",output:"\u22A8",tex:"models",ttype:d},{input:"(",tag:"mo",output:"(",tex:null,ttype:b},{input:")",tag:"mo",output:")",tex:null,ttype:l},{input:"[",tag:"mo",output:"[",tex:null,ttype:b},{input:"]",tag:"mo",output:"]",tex:null,ttype:l},{input:"{",tag:"mo",output:"{",tex:null,ttype:b},{input:"}",tag:"mo",output:"}",tex:null,ttype:l},{input:"|",tag:"mo",output:"|",tex:null,ttype:r},{input:"(:",tag:"mo",output:"\u2329",tex:"langle",ttype:b},{input:":)",tag:"mo",output:"\u232A",tex:"rangle",ttype:l},{input:"<<",tag:"mo",output:"\u2329",tex:null,ttype:b},{input:">>",tag:"mo",output:"\u232A",tex:null,ttype:l},{input:"{:",tag:"mo",output:"{:",tex:null,ttype:b,invisible:true},{input:":}",tag:"mo",output:":}",tex:null,ttype:l,invisible:true},{input:"int",tag:"mo",output:"\u222B",tex:null,ttype:d},{input:"dx",tag:"mi",output:"{:d x:}",tex:null,ttype:Z},{input:"dy",tag:"mi",output:"{:d y:}",tex:null,ttype:Z},{input:"dz",tag:"mi",output:"{:d z:}",tex:null,ttype:Z},{input:"dt",tag:"mi",output:"{:d t:}",tex:null,ttype:Z},{input:"oint",tag:"mo",output:"\u222E",tex:null,ttype:d},{input:"del",tag:"mo",output:"\u2202",tex:"partial",ttype:d},{input:"grad",tag:"mo",output:"\u2207",tex:"nabla",ttype:d},{input:"+-",tag:"mo",output:"\u00B1",tex:"pm",ttype:d},{input:"O/",tag:"mo",output:"\u2205",tex:"emptyset",ttype:d},{input:"oo",tag:"mo",output:"\u221E",tex:"infty",ttype:d},{input:"aleph",tag:"mo",output:"\u2135",tex:null,ttype:d},{input:"...",tag:"mo",output:"...",tex:"ldots",ttype:d},{input:":.",tag:"mo",output:"\u2234",tex:"therefore",ttype:d},{input:"/_",tag:"mo",output:"\u2220",tex:"angle",ttype:d},{input:"\\ ",tag:"mo",output:"\u00A0",tex:null,ttype:d},{input:"quad",tag:"mo",output:"\u00A0\u00A0",tex:null,ttype:d},{input:"qquad",tag:"mo",output:"\u00A0\u00A0\u00A0\u00A0",tex:null,ttype:d},{input:"cdots",tag:"mo",output:"\u22EF",tex:null,ttype:d},{input:"vdots",tag:"mo",output:"\u22EE",tex:null,ttype:d},{input:"ddots",tag:"mo",output:"\u22F1",tex:null,ttype:d},{input:"diamond",tag:"mo",output:"\u22C4",tex:null,ttype:d},{input:"square",tag:"mo",output:"\u25A1",tex:null,ttype:d},{input:"|__",tag:"mo",output:"\u230A",tex:"lfloor",ttype:d},{input:"__|",tag:"mo",output:"\u230B",tex:"rfloor",ttype:d},{input:"|~",tag:"mo",output:"\u2308",tex:"lceiling",ttype:d},{input:"~|",tag:"mo",output:"\u2309",tex:"rceiling",ttype:d},{input:"CC",tag:"mo",output:"\u2102",tex:null,ttype:d},{input:"NN",tag:"mo",output:"\u2115",tex:null,ttype:d},{input:"QQ",tag:"mo",output:"\u211A",tex:null,ttype:d},{input:"RR",tag:"mo",output:"\u211D",tex:null,ttype:d},{input:"ZZ",tag:"mo",output:"\u2124",tex:null,ttype:d},{input:"f",tag:"mi",output:"f",tex:null,ttype:H,func:true},{input:"g",tag:"mi",output:"g",tex:null,ttype:H,func:true},{input:"lim",tag:"mo",output:"lim",tex:null,ttype:P},{input:"Lim",tag:"mo",output:"Lim",tex:null,ttype:P},{input:"sin",tag:"mo",output:"sin",tex:null,ttype:H,func:true},{input:"cos",tag:"mo",output:"cos",tex:null,ttype:H,func:true},{input:"tan",tag:"mo",output:"tan",tex:null,ttype:H,func:true},{input:"sinh",tag:"mo",output:"sinh",tex:null,ttype:H,func:true},{input:"cosh",tag:"mo",output:"cosh",tex:null,ttype:H,func:true},{input:"tanh",tag:"mo",output:"tanh",tex:null,ttype:H,func:true},{input:"cot",tag:"mo",output:"cot",tex:null,ttype:H,func:true},{input:"sec",tag:"mo",output:"sec",tex:null,ttype:H,func:true},{input:"csc",tag:"mo",output:"csc",tex:null,ttype:H,func:true},{input:"log",tag:"mo",output:"log",tex:null,ttype:H,func:true},{input:"ln",tag:"mo",output:"ln",tex:null,ttype:H,func:true},{input:"det",tag:"mo",output:"det",tex:null,ttype:H,func:true},{input:"dim",tag:"mo",output:"dim",tex:null,ttype:d},{input:"mod",tag:"mo",output:"mod",tex:null,ttype:d},{input:"gcd",tag:"mo",output:"gcd",tex:null,ttype:H,func:true},{input:"lcm",tag:"mo",output:"lcm",tex:null,ttype:H,func:true},{input:"lub",tag:"mo",output:"lub",tex:null,ttype:d},{input:"glb",tag:"mo",output:"glb",tex:null,ttype:d},{input:"min",tag:"mo",output:"min",tex:null,ttype:P},{input:"max",tag:"mo",output:"max",tex:null,ttype:P},{input:"uarr",tag:"mo",output:"\u2191",tex:"uparrow",ttype:d},{input:"darr",tag:"mo",output:"\u2193",tex:"downarrow",ttype:d},{input:"rarr",tag:"mo",output:"\u2192",tex:"rightarrow",ttype:d},{input:"->",tag:"mo",output:"\u2192",tex:"to",ttype:d},{input:"|->",tag:"mo",output:"\u21A6",tex:"mapsto",ttype:d},{input:"larr",tag:"mo",output:"\u2190",tex:"leftarrow",ttype:d},{input:"harr",tag:"mo",output:"\u2194",tex:"leftrightarrow",ttype:d},{input:"rArr",tag:"mo",output:"\u21D2",tex:"Rightarrow",ttype:d},{input:"lArr",tag:"mo",output:"\u21D0",tex:"Leftarrow",ttype:d},{input:"hArr",tag:"mo",output:"\u21D4",tex:"Leftrightarrow",ttype:d},j,af,A,Q,o,s,h,{input:"hat",tag:"mover",output:"\u005E",tex:null,ttype:H,acc:true},{input:"bar",tag:"mover",output:"\u00AF",tex:"overline",ttype:H,acc:true},{input:"vec",tag:"mover",output:"\u2192",tex:null,ttype:H,acc:true},{input:"dot",tag:"mover",output:".",tex:null,ttype:H,acc:true},{input:"ddot",tag:"mover",output:"..",tex:null,ttype:H,acc:true},{input:"ul",tag:"munder",output:"\u0332",tex:"underline",ttype:H,acc:true},ah,x,p,{input:"bb",tag:"mstyle",atname:"fontweight",atval:"bold",output:"bb",tex:null,ttype:H},{input:"mathbf",tag:"mstyle",atname:"fontweight",atval:"bold",output:"mathbf",tex:null,ttype:H},{input:"sf",tag:"mstyle",atname:"fontfamily",atval:"sans-serif",output:"sf",tex:null,ttype:H},{input:"mathsf",tag:"mstyle",atname:"fontfamily",atval:"sans-serif",output:"mathsf",tex:null,ttype:H},{input:"bbb",tag:"mstyle",atname:"mathvariant",atval:"double-struck",output:"bbb",tex:null,ttype:H,codes:D},{input:"mathbb",tag:"mstyle",atname:"mathvariant",atval:"double-struck",output:"mathbb",tex:null,ttype:H,codes:D},{input:"cc",tag:"mstyle",atname:"mathvariant",atval:"script",output:"cc",tex:null,ttype:H,codes:J},{input:"mathcal",tag:"mstyle",atname:"mathvariant",atval:"script",output:"mathcal",tex:null,ttype:H,codes:J},{input:"tt",tag:"mstyle",atname:"fontfamily",atval:"monospace",output:"tt",tex:null,ttype:H},{input:"mathtt",tag:"mstyle",atname:"fontfamily",atval:"monospace",output:"mathtt",tex:null,ttype:H},{input:"fr",tag:"mstyle",atname:"mathvariant",atval:"fraktur",output:"fr",tex:null,ttype:H,codes:N},{input:"mathfrak",tag:"mstyle",atname:"mathvariant",atval:"fraktur",output:"mathfrak",tex:null,ttype:H,codes:N}];function W(ai,i){if(ai.input>i.input){return 1}else{return -1}}var U=[];function v(){var aj=[],ai;for(ai=0;ai<G.length;ai++){if(G[ai].tex){aj[aj.length]={input:G[ai].tex,tag:G[ai].tag,output:G[ai].output,ttype:G[ai].ttype}}}G=G.concat(aj);G.sort(W);for(ai=0;ai<G.length;ai++){U[ai]=G[ai].input}}var Y="http://www.w3.org/1998/Math/MathML";function R(i){if(q){return g.createElement("m:"+i)}else{return g.createElementNS(Y,i)}}function M(i,aj){if(q){var ai=g.createElement("m:"+i)}else{ai=g.createElementNS(Y,i)}ai.appendChild(aj);return ai}function B(i,ai){G=G.concat([{input:i,tag:"mo",output:ai,tex:null,ttype:Z}]);G.sort(W);for(ac=0;ac<G.length;ac++){U[ac]=G[ac].input}}function u(ak,al){var ai;if(ak.charAt(al)=="\\"&&ak.charAt(al+1)!="\\"&&ak.charAt(al+1)!=" "){ai=ak.slice(al+1)}else{ai=ak.slice(al)}for(var aj=0;aj<ai.length&&ai.charCodeAt(aj)<=32;aj=aj+1){}return ai.slice(aj)}function c(aj,am,an){if(an==0){var al,ai;an=-1;al=aj.length;while(an+1<al){ai=(an+al)>>1;if(aj[ai]<am){an=ai}else{al=ai}}return al}else{for(var ak=an;ak<aj.length&&aj[ak]<am;ak++){}}return ak}function n(ao){var ai=0;var aj=0;var al;var ar;var aq;var am="";var an=true;for(var ak=1;ak<=ao.length&&an;ak++){ar=ao.slice(0,ak);aj=ai;ai=c(U,ar,aj);if(ai<U.length&&ao.slice(0,U[ai].length)==U[ai]){am=U[ai];al=ai;ak=am.length}an=ai<U.length&&ao.slice(0,U[ai].length)>=U[ai]}y=F;if(am!=""){F=G[al].ttype;return G[al]}F=d;ai=1;ar=ao.slice(0,1);var ap=true;while("0"<=ar&&ar<="9"&&ai<=ao.length){ar=ao.slice(ai,ai+1);ai++}if(ar==f){ar=ao.slice(ai,ai+1);if("0"<=ar&&ar<="9"){ap=false;ai++;while("0"<=ar&&ar<="9"&&ai<=ao.length){ar=ao.slice(ai,ai+1);ai++}}}if((ap&&ai>1)||ai>2){ar=ao.slice(0,ai-1);aq="mn"}else{ai=2;ar=ao.slice(0,1);aq=(("A">ar||ar>"Z")&&("a">ar||ar>"z")?"mo":"mi")}if(ar=="-"&&y==m){F=m;return{input:ar,tag:aq,output:ar,ttype:H,func:true}}return{input:ar,tag:aq,output:ar,ttype:d}}function T(ai){var i;if(ai.nodeName=="mrow"){i=ai.firstChild.firstChild.nodeValue;if(i=="("||i=="["||i=="{"){ai.removeChild(ai.firstChild)}}if(ai.nodeName=="mrow"){i=ai.lastChild.firstChild.nodeValue;if(i==")"||i=="]"||i=="}"){ai.removeChild(ai.lastChild)}}}var K,y,F;function L(ao){var ak,aj,ar,am,aq,an=g.createDocumentFragment();ao=u(ao,0);ak=n(ao);if(ak==null||ak.ttype==l&&K>0){return[null,ao]}if(ak.ttype==Z){ao=ak.output+u(ao,ak.input.length);ak=n(ao)}switch(ak.ttype){case P:case d:ao=u(ao,ak.input.length);return[M(ak.tag,g.createTextNode(ak.output)),ao];case b:K++;ao=u(ao,ak.input.length);ar=w(ao,true);K--;if(typeof ak.invisible=="boolean"&&ak.invisible){aj=M("mrow",ar[0])}else{aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);aj.appendChild(ar[0])}return[aj,ar[1]];case ab:if(ak!=p){ao=u(ao,ak.input.length)}if(ao.charAt(0)=="{"){am=ao.indexOf("}")}else{if(ao.charAt(0)=="("){am=ao.indexOf(")")}else{if(ao.charAt(0)=="["){am=ao.indexOf("]")}else{if(ak==p){am=ao.slice(1).indexOf('"')+1}else{am=0}}}}if(am==-1){am=ao.length}aq=ao.slice(1,am);if(aq.charAt(0)==" "){aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj)}an.appendChild(M(ak.tag,g.createTextNode(aq)));if(aq.charAt(aq.length-1)==" "){aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj)}ao=u(ao,am+1);return[M("mrow",an),ao];case H:ao=u(ao,ak.input.length);ar=L(ao);if(ar[0]==null){return[M(ak.tag,g.createTextNode(ak.output)),ao]}if(typeof ak.func=="boolean"&&ak.func){aq=ao.charAt(0);if(aq=="^"||aq=="_"||aq=="/"||aq=="|"||aq==","){return[M(ak.tag,g.createTextNode(ak.output)),ao]}else{aj=M("mrow",M(ak.tag,g.createTextNode(ak.output)));aj.appendChild(ar[0]);return[aj,ar[1]]}}T(ar[0]);if(ak.input=="sqrt"){return[M(ak.tag,ar[0]),ar[1]]}else{if(typeof ak.acc=="boolean"&&ak.acc){aj=M(ak.tag,ar[0]);aj.appendChild(M("mo",g.createTextNode(ak.output)));return[aj,ar[1]]}else{if(!q&&typeof ak.codes!="undefined"){for(am=0;am<ar[0].childNodes.length;am++){if(ar[0].childNodes[am].nodeName=="mi"||ar[0].nodeName=="mi"){aq=(ar[0].nodeName=="mi"?ar[0].firstChild.nodeValue:ar[0].childNodes[am].firstChild.nodeValue);var ap=[];for(var al=0;al<aq.length;al++){if(aq.charCodeAt(al)>64&&aq.charCodeAt(al)<91){ap=ap+String.fromCharCode(ak.codes[aq.charCodeAt(al)-65])}else{ap=ap+aq.charAt(al)}}if(ar[0].nodeName=="mi"){ar[0]=R("mo").appendChild(g.createTextNode(ap))}else{ar[0].replaceChild(R("mo").appendChild(g.createTextNode(ap)),ar[0].childNodes[am])}}}}aj=M(ak.tag,ar[0]);aj.setAttribute(ak.atname,ak.atval);return[aj,ar[1]]}}case X:ao=u(ao,ak.input.length);ar=L(ao);if(ar[0]==null){return[M("mo",g.createTextNode(ak.input)),ao]}T(ar[0]);var ai=L(ar[1]);if(ai[0]==null){return[M("mo",g.createTextNode(ak.input)),ao]}T(ai[0]);if(ak.input=="root"||ak.input=="stackrel"){an.appendChild(ai[0])}an.appendChild(ar[0]);if(ak.input=="frac"){an.appendChild(ai[0])}return[M(ak.tag,an),ai[1]];case m:ao=u(ao,ak.input.length);return[M("mo",g.createTextNode(ak.output)),ao];case a:ao=u(ao,ak.input.length);aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj);an.appendChild(M(ak.tag,g.createTextNode(ak.output)));aj=R("mspace");aj.setAttribute("width","1ex");an.appendChild(aj);return[M("mrow",an),ao];case r:K++;ao=u(ao,ak.input.length);ar=w(ao,false);K--;aq="";if(ar[0].lastChild!=null){aq=ar[0].lastChild.firstChild.nodeValue}if(aq=="|"){aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);aj.appendChild(ar[0]);return[aj,ar[1]]}else{aj=M("mo",g.createTextNode(ak.output));aj=M("mrow",aj);return[aj,ao]}default:ao=u(ao,ak.input.length);return[M(ak.tag,g.createTextNode(ak.output)),ao]}}function z(an){var al,ao,am,ak,i,aj;an=u(an,0);ao=n(an);i=L(an);ak=i[0];an=i[1];al=n(an);if(al.ttype==m&&al.input!="/"){an=u(an,al.input.length);i=L(an);if(i[0]==null){i[0]=M("mo",g.createTextNode("\u25A1"))}else{T(i[0])}an=i[1];if(al.input=="_"){am=n(an);aj=(ao.ttype==P);if(am.input=="^"){an=u(an,am.input.length);var ai=L(an);T(ai[0]);an=ai[1];ak=M((aj?"munderover":"msubsup"),ak);ak.appendChild(i[0]);ak.appendChild(ai[0]);ak=M("mrow",ak)}else{ak=M((aj?"munder":"msub"),ak);ak.appendChild(i[0])}}else{ak=M(al.tag,ak);ak.appendChild(i[0])}}return[ak,an]}function w(aq,ap){var av,ar,am,ay,an=g.createDocumentFragment();do{aq=u(aq,0);am=z(aq);ar=am[0];aq=am[1];av=n(aq);if(av.ttype==m&&av.input=="/"){aq=u(aq,av.input.length);am=z(aq);if(am[0]==null){am[0]=M("mo",g.createTextNode("\u25A1"))}else{T(am[0])}aq=am[1];T(ar);ar=M(av.tag,ar);ar.appendChild(am[0]);an.appendChild(ar);av=n(aq)}else{if(ar!=undefined){an.appendChild(ar)}}}while((av.ttype!=l&&(av.ttype!=r||ap)||K==0)&&av!=null&&av.output!="");if(av.ttype==l||av.ttype==r){var az=an.childNodes.length;if(az>0&&an.childNodes[az-1].nodeName=="mrow"&&az>1&&an.childNodes[az-2].nodeName=="mo"&&an.childNodes[az-2].firstChild.nodeValue==","){var aB=an.childNodes[az-1].lastChild.firstChild.nodeValue;if(aB==")"||aB=="]"){var aj=an.childNodes[az-1].firstChild.firstChild.nodeValue;if(aj=="("&&aB==")"&&av.output!="}"||aj=="["&&aB=="]"){var ak=[];var aw=true;var at=an.childNodes.length;for(ay=0;aw&&ay<at;ay=ay+2){ak[ay]=[];ar=an.childNodes[ay];if(aw){aw=ar.nodeName=="mrow"&&(ay==at-1||ar.nextSibling.nodeName=="mo"&&ar.nextSibling.firstChild.nodeValue==",")&&ar.firstChild.firstChild.nodeValue==aj&&ar.lastChild.firstChild.nodeValue==aB}if(aw){for(var ax=0;ax<ar.childNodes.length;ax++){if(ar.childNodes[ax].firstChild.nodeValue==","){ak[ay][ak[ay].length]=ax}}}if(aw&&ay>1){aw=ak[ay].length==ak[ay-2].length}}if(aw){var al,ai,ao,au,aA=g.createDocumentFragment();for(ay=0;ay<at;ay=ay+2){al=g.createDocumentFragment();ai=g.createDocumentFragment();ar=an.firstChild;ao=ar.childNodes.length;au=0;ar.removeChild(ar.firstChild);for(ax=1;ax<ao-1;ax++){if(typeof ak[ay][au]!="undefined"&&ax==ak[ay][au]){ar.removeChild(ar.firstChild);al.appendChild(M("mtd",ai));au++}else{ai.appendChild(ar.firstChild)}}al.appendChild(M("mtd",ai));if(an.childNodes.length>2){an.removeChild(an.firstChild);an.removeChild(an.firstChild)}aA.appendChild(M("mtr",al))}ar=M("mtable",aA);if(typeof av.invisible=="boolean"&&av.invisible){ar.setAttribute("columnalign","left")}an.replaceChild(ar,an.firstChild)}}}}aq=u(aq,av.input.length);if(typeof av.invisible!="boolean"||!av.invisible){ar=M("mo",g.createTextNode(av.output));an.appendChild(ar)}}return[an,aq]}function e(aj){var ai=R("mstyle");if(I!=""){ai.setAttribute("mathcolor",I)}if(t){ai.setAttribute("displaystyle","true")}if(ad!=""){ai.setAttribute("fontfamily",ad)}K=0;ai.appendChild(w(aj.replace(/^\s+/g,""),false)[0]);ai=M("math",ai);if(C){ai.setAttribute("title",aj.replace(/\s+/g," "))}if(ad!=""&&(q||ad!="serif")){var i=V("font");i.setAttribute("face",ad);i.appendChild(ai);return i}return ai}C=false;ad="";I="";(function(){for(var aj=0,ai=G.length;aj<ai;aj++){if(G[aj].codes){delete G[aj].codes}if(G[aj].func){G[aj].tag="mi"}if(G[aj].atname==="fontfamily"||G[aj].atname==="fontweight"){G[aj].atname="mathvariant"}}})();G.push({input:"gt",tag:"mo",output:">",tex:null,ttype:d},{input:"gt=",tag:"mo",output:"\u2265",tex:"geq",ttype:d},{input:"-<=",tag:"mo",output:"\u2AAF",tex:"preceq",ttype:d},{input:">-=",tag:"mo",output:"\u2AB0",tex:"succeq",ttype:d},{input:"'",tag:"mo",output:"\u2032",tex:"prime",ttype:d},{input:"arcsin",tag:"mi",output:"arcsin",tex:null,ttype:H,func:true},{input:"arccos",tag:"mi",output:"arccos",tex:null,ttype:H,func:true},{input:"arctan",tag:"mi",output:"arctan",tex:null,ttype:H,func:true},{input:"coth",tag:"mi",output:"coth",tex:null,ttype:H,func:true},{input:"sech",tag:"mi",output:"sech",tex:null,ttype:H,func:true},{input:"csch",tag:"mi",output:"csch",tex:null,ttype:H,func:true},{input:"abs",tag:"mi",output:"abs",tex:null,ttype:H,func:true},{input:"exp",tag:"mi",output:"exp",tex:null,ttype:H,func:true},{input:"tilde",tag:"mover",output:"~",tex:null,ttype:H,acc:true});ag.Augment({AM:{Init:function(){t=ag.config.displaystyle;f=(ag.config.decimal||ag.config.decimalsign);if(ag.config.fixphi){for(var aj=0,ai=G.length;aj<ai;aj++){if(G[aj].input==="phi"){G[aj].output="\u03D5"}if(G[aj].input==="varphi"){G[aj].output="\u03C6";aj=ai}}}E();v()},Augment:function(i){for(var ai in i){if(i.hasOwnProperty(ai)){switch(ai){case"displaystyle":t=i[ai];break;case"decimal":decimal=i[ai];break;case"parseMath":e=i[ai];break;case"parseExpr":w=i[ai];break;case"parseIexpr":z=i[ai];break;case"parseSexpr":L=i[ai];break;case"removeBrackets":T=i[ai];break;case"getSymbol":n=i[ai];break;case"position":c=i[ai];break;case"removeCharsAndBlanks":u=i[ai];break;case"createMmlNode":M=i[ai];break;case"createElementMathML":R=i[ai];break;case"createElementXHTML":V=i[ai];break;case"initSymbols":v=i[ai];break;case"compareNames":comareNames=i[ai];break}this[ai]=i[ai]}}},parseMath:e,parseExpr:w,parseIexpr:z,parseSexr:L,removeBrackets:T,getSymbol:n,position:c,removeCharsAndBlanks:u,createMmlNode:M,createElementMathML:R,createElementXHTML:V,initSymbols:v,compareNames:W,createDocumentFragment:aa,document:g,define:B,symbols:G,names:U,TOKEN:{CONST:d,UNARY:H,BINARY:X,INFIX:m,LEFTBRACKET:b,RIGHTBRACKET:l,SPACE:a,UNDEROVER:P,DEFINITION:Z,LEFTRIGHT:r,TEXT:ab}}});var ae=[S,O];ae=null})(MathJax.InputJax.AsciiMath);(function(b){var a;b.Augment({sourceMenuTitle:["AsciiMathInput","AsciiMath Input"],annotationEncoding:"text/x-asciimath",prefilterHooks:MathJax.Callback.Hooks(true),postfilterHooks:MathJax.Callback.Hooks(true),Translate:function(c){var d,f=MathJax.HTML.getScript(c);var g={math:f,script:c};this.prefilterHooks.Execute(g);f=g.math;try{d=this.AM.parseMath(f)}catch(e){if(!e.asciimathError){throw e}d=this.formatError(e,f)}g.math=a(d);this.postfilterHooks.Execute(g);return g.math},formatError:function(f,e,c){var d=f.message.replace(/\n.*/,"");MathJax.Hub.signal.Post(["AsciiMath Jax - parse error",d,e,c]);return a.Error(d)},Error:function(c){throw MathJax.Hub.Insert(Error(c),{asciimathError:true})},Startup:function(){a=MathJax.ElementJax.mml;this.AM.Init()}});b.loadComplete("jax.js")})(MathJax.InputJax.AsciiMath);
(function(l,c,g,e){var f,i=c.Browser.isMSIE;var h,b,d,k;c.Register.StartupHook("MathZoom Ready",function(){k=MathJax.Extension.MathZoom});var j=function(m,o){var n=e.Element("span");m="padding"+m;if(o){n.style.cssText=(o.getAttribute("style")||"");if(n.style.padding===""&&(n.style[m]||"")===""){n.style[m]="0px";o.setAttribute("style",n.style.cssText)}}};var a=function(r,m,p){if(r){var o=e.Element("span");o.style.cssText=(r.getAttribute("style")||"");if(o.style.padding===""){var q={paddingLeft:p,paddingTop:m,paddingRight:"0px",paddingBottom:"0px"};for(var n in q){if(q.hasOwnProperty(n)){if((o.style[n]||"")===""){o.style[n]=q[n]}}}}r.setAttribute("style",o.style.cssText)}};l.Augment({config:{styles:{".MathJax_MathML":{"font-style":"normal","font-weight":"normal","line-height":"normal","font-size":"100%","font-size-adjust":"none","text-indent":0,"text-align":"left","text-transform":"none","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none",direction:"ltr","max-width":"none","max-height":"none","min-width":0,"min-height":0,border:0,padding:0,margin:0},"span.MathJax_MathML":{display:"inline!important"},"div.MathJax_MathML":{display:"block!important"},".MathJax_mmlExBox":{display:"block!important",overflow:"hidden",height:"1px",width:"60ex","min-height":0,"max-height":"none",padding:0,border:0,margin:0}}},handlesVariants:false,settings:c.config.menuSettings,ex:1,scale:1,adjustWidths:[],Config:function(){this.SUPER(arguments).Config.call(this);if(this.settings.scale){this.config.scale=this.settings.scale}if(c.config.displayAlign!=="center"){var o=c.config.displayAlign,m=c.config.displayIndent;var n={"text-align":o+"!important"};n["margin-"+o]=m+"!important";c.Insert(this.config.styles,{"div.MathJax_MathML":n,"div.MathJax_MathML math":{"text-align":o},"div.MathJax_MathContainer > span":{"text-align":o+"!important"}})}if(!this.require){this.require=[]}this.require.push(MathJax.OutputJax.extensionDir+"/MathEvents.js")},Startup:function(){h=MathJax.Extension.MathEvents.Event;b=MathJax.Extension.MathEvents.Touch;d=MathJax.Extension.MathEvents.Hover;this.ContextMenu=h.ContextMenu;this.Mousedown=h.AltContextMenu;this.Mouseover=d.Mouseover;this.Mouseout=d.Mouseout;this.Mousemove=d.Mousemove;if(!i){this.EmExSpan=e.Element("span",{style:{position:"absolute","font-size-adjust":"none"}},[["div",{className:"MathJax_mmlExBox"}],["span",{className:"MathJax_MathML"}]]);f.math(f.mspace().With({width:"60ex"})).toNativeMML(this.EmExSpan.lastChild)}return g.Styles(this.config.styles)},InitializeMML:function(){this.initialized=true;if(i){try{if(!c.Browser.mpNamespace){var m=document.createElement("object");m.id="mathplayer";m.classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987";document.getElementsByTagName("head")[0].appendChild(m);document.namespaces.add("m","http://www.w3.org/1998/Math/MathML");c.Browser.mpNamespace=true}if(!c.Browser.mpImported){document.namespaces.m.doImport("#mathplayer");c.Browser.mpImported=true}}catch(n){if(!this.config.noMathPlayerWarning){alert(MathJax.Localization._(["MathML","MathPlayer"],"MathJax was not able to set up MathPlayer.\n\nIf MathPlayer is not installed, you need to install it first.\nOtherwise, your security settings may be preventing ActiveX     \ncontrols from running.  Use the Internet Options item under\nthe Tools menu and select the Security tab, then press the\nCustom Level button. Check that the settings for\n'Run ActiveX Controls', and 'Binary and script behaviors'\nare enabled.\n\nCurrently you will see error messages rather than\ntypeset mathematics."))}}}else{document.body.appendChild(this.EmExSpan);this.defaultEx=this.EmExSpan.firstChild.offsetWidth/60;this.defaultMEx=this.EmExSpan.lastChild.offsetWidth/60;document.body.removeChild(this.EmExSpan)}},preTranslate:function(o){var t=o.jax[this.id],u,p=t.length,y,r,A,w,z,n,v,s,q;for(u=0;u<p;u++){y=t[u];if(!y.parentNode){continue}if(!this.initialized){this.InitializeMML()}r=y.previousSibling;if(r&&r.className==="MathJax_MathML"){r.parentNode.removeChild(r)}n=y.MathJax.elementJax;if(!n){continue}z=n.root;n.NativeMML={};var x=(z.Get("display")==="block"?"div":"span");A=e.Element(x,{className:"MathJax_MathML",id:n.inputID+"-Frame"},[["span",{className:"MathJax_MathContainer",isMathJax:true,jaxID:this.id,style:{position:"relative",display:"inline-block","white-space":"nowrap"}},[["span",{isMathJax:true,style:{display:"inline-block"}}]]]]);y.parentNode.insertBefore(A,y);if(!i){y.parentNode.insertBefore(this.EmExSpan.cloneNode(true),y)}}for(u=0;u<p;u++){y=t[u];if(!y.parentNode){continue}n=y.MathJax.elementJax;if(!n){continue}if(!i){w=y.previousSibling;v=w.firstChild.offsetWidth/60;s=w.lastChild.offsetWidth/60;if(v===0||v==="NaN"){v=this.defaultEx;s=this.defaultMEx}q=(this.config.matchFontHeight&&s>1?v/s:1);q=Math.floor(Math.max(this.config.minScaleAdjust/100,q)*this.config.scale);n.NativeMML.ex=v;n.NativeMML.mex=s}else{q=100}n.NativeMML.fontSize=q+"%";n.NativeMML.scale=q/100}if(!i){for(u=0;u<p;u++){y=t[u];if(y.parentNode&&y.MathJax.elementJax){y.parentNode.removeChild(y.previousSibling)}}}},Translate:function(s){if(!s.parentNode){return}var m=s.MathJax.elementJax,t=m.root;var u=document.getElementById(m.inputID+"-Frame");if(!u){return}var n=u.firstChild,q=n.firstChild;this.ex=m.NativeMML.ex||this.defaultEx;this.scale=m.NativeMML.scale||1;if(this.scale!==1){u.style.fontSize=m.NativeMML.fontSize}try{t.toNativeMML(q,m)}catch(r){if(r.restart){while(q.firstChild){q.removeChild(q.firstChild)}}throw r}if(i){if(n.addEventListener){for(var o in this.MSIE9events){if(this.MSIE9events.hasOwnProperty(o)){n.addEventListener(o,this.MSIE9event,true)}}}else{var p=(this.config.showMathMenuMSIE!=null?this:c).config;if(p.showMathMenuMSIE&&!this.settings.mpContext&&!this.settings.mpMouse){this.MSIEoverlay(n)}else{n.style.position="";q.firstChild.onmousedown=this.MSIEaltMenu}}}else{n.oncontextmenu=h.Menu;n.onmouseover=h.Mouseover;n.onmouseout=h.Mouseout;n.onmousedown=h.Mousedown;n.onclick=h.Click;n.ondblclick=h.DblClick;if(c.Browser.noContextMenu){n.ontouchstart=b.start;n.ontouchend=b.end}}},postTranslate:function(n){if(this.forceReflow){var m=(document.styleSheets||[])[0]||{};m.disabled=true;m.disabled=false}},Remove:function(m){var n=m.SourceElement();if(!n){return}n=n.previousSibling;if(!n){return}if(n.className.match(/MathJax_MathML/)){n.parentNode.removeChild(n)}},MMLnamespace:"http://www.w3.org/1998/Math/MathML",MSIEoverlay:function(m){var n=m.firstChild;if(n.nodeName.toLowerCase()==="span"){n=n.firstChild}var o=this.getHoverBBox(null,n,{});e.addElement(m,"span",{style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{isMathJax:true,className:"MathJax_MathPlayer_Overlay",style:{display:"inline-block",position:"absolute",left:d.Px(-o.w),top:d.Px(-o.h-(o.y||0)-1),width:d.Px(o.w),height:d.Px(o.h+o.d),cursor:"pointer","background-color":"white",filter:"alpha(opacity=0)"}}]]);c.Insert(m,{msieMath:n,onmousedown:this.MSIEevent,oncontextmenu:this.MSIEevent,onclick:this.MSIEevent,onmouseup:this.MSIEevent,onmousemove:this.MSIEevent,ondblclick:this.MSIEevent,onmouseover:this.MSIEevent,onmouseout:this.MSIEevent})},MSIEevents:{mousedown:"Mousedown",contextmenu:"ContextMenu",click:"Click",mouseup:"Mouseup",mousemove:"Mousemove",dblclick:"DblClick",mouseover:"Mouseover",mouseout:"Mouseout"},MSIEevent:function(){var n=window.event;var m=l.MSIEevents[n.type];if(l[m]&&l[m](n,this)===false){return false}if(k&&k.HandleEvent(n,m,this)===false){return false}if(n.srcElement.className==="MathJax_MathPlayer_Overlay"&&this.msieMath.fireEvent){if(m==="ContextMenu"||m==="Mouseover"||m==="Mouseout"){this.msieMath.fireEvent("on"+n.type,n)}}return h.False(n)},MSIEaltMenu:function(){var m=this.parentNode.parentNode;while(!m.jaxID){m=m.parentNode}h.AltContextMenu(window.event,m)},MSIE9events:{contextmenu:"Menu",click:"Click",dblclick:"DblClick",mouseup:"False",mouseover:"Mouseover",mouseout:"Mouseout"},MSIE9event:function(n){if(n.type==="contextmenu"&&l.settings.mpContext){return true}if(n.type==="mouseup"&&l.settings.mpMouse){return true}if(n.type==="click"&&l.settings.mpContext){return h.AltContextMenu(n,this)}var m=l.MSIE9events[n.type];return h[m].call(this,n)},getJaxFromMath:function(m){m=m.parentNode;do{m=m.nextSibling}while(m&&m.nodeName.toLowerCase()!=="script");return c.getJaxFor(m)},getHoverSpan:function(m,n){return n.firstChild},getHoverBBox:function(m,n,o){return h.getBBox(n.parentNode)},Zoom:function(n,u,s,m,r){n.root.toNativeMML(u);if(this.msieIE8HeightBug){u.style.position="absolute"}if(l.widthBug){u.style.width=u.parentNode.style.width=""}var p=s.offsetWidth||s.scrollWidth,v=s.offsetHeight||s.scrollHeight;var t=u.offsetWidth,q=u.offsetHeight;if(l.widthBug){var o=u.firstChild.firstChild.scrollWidth;if(o>t){t=o;u.style.width=t+"px"}}if(this.msieIE8HeightBug){u.style.position=""}return{Y:-h.getBBox(u.parentNode).h,mW:p,mH:v,zW:t,zH:q}},NAMEDSPACE:{negativeveryverythinmathspace:"-.0556em",negativeverythinmathspace:"-.1111em",negativethinmathspace:"-.1667em",negativemediummathspace:"-.2222em",negativethickmathspace:"-.2778em",negativeverythickmathspace:"-.3333em",negativeveryverythickmathspace:"-.3889em",veryverythinmathspace:".0556em",verythinmathspace:".1111em",thinmathspace:".1667em",mediummathspace:".2222em",thickmathspace:".2778em",verythickmathspace:".3333em",veryverythickmathspace:".3889em"}});c.Register.StartupHook("mml Jax Ready",function(){f=MathJax.ElementJax.mml;f.mbase.Augment({toNativeMML:function(r){var p=this.NativeMMLelement(this.type);this.NativeMMLattributes(p);for(var q=0,o=this.data.length;q<o;q++){if(this.data[q]){this.data[q].toNativeMML(p)}else{p.appendChild(this.NativeMMLelement("mrow"))}}r.appendChild(p)},NativeMMLattributes:function(p){var t=this.defaults;var v=(this.attrNames||f.copyAttributeNames),r=f.skipAttributes;if(!this.attrNames){if(this.type==="mstyle"){t=f.math.prototype.defaults}for(var u in t){if(!r[u]&&t.hasOwnProperty(u)){if(this[u]!=null){p.setAttribute(u,this.NativeMMLattribute(this[u]))}}}}for(var q=0,o=v.length;q<o;q++){var s=(this.attr||{})[v[q]];if(s==null){s=this[v[q]]}if(s!=null){p.setAttribute(v[q],this.NativeMMLattribute(s))}}this.NativeMMLclass(p)},NativeMMLclass:function(o){var q=[];if(this["class"]){q.push(this["class"])}if(this.isa(f.TeXAtom)){var p=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(p){q.push("MJX-TeXAtom-"+p)}}if(this.mathvariant&&this.NativeMMLvariants[this.mathvariant]){q.push("MJX"+this.mathvariant)}if(this.variantForm){q.push("MJX-variant")}if(q.length){o.setAttribute("class",q.join(" "))}},NativeMMLattribute:function(o){o=String(o);if(l.NAMEDSPACE[o]){o=l.NAMEDSPACE[o]}else{if(o.match(/^\s*(([-+])?(\d+(\.\d*)?|\.\d+))\s*mu\s*$/)){o=RegExp.$2+((1/18)*RegExp.$3).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.NativeMMLvariants[o]){o=this.NativeMMLvariants[o]}}}return o},NativeMMLvariants:{"-tex-caligraphic":f.VARIANT.SCRIPT,"-tex-caligraphic-bold":f.VARIANT.BOLDSCRIPT,"-tex-oldstyle":f.VARIANT.NORMAL,"-tex-oldstyle-bold":f.VARIANT.BOLD,"-tex-mathit":f.VARIANT.ITALIC},NativeMMLelement:function(o){var p=(i?document.createElement("m:"+o):document.createElementNS(l.MMLnamespace,o));p.isMathJax=true;return p}});f.mrow.Augment({toNativeMML:function(s){var r,p;if(this.inferred&&this.parent.inferRow){for(r=0,p=this.data.length;r<p;r++){if(this.data[r]){this.data[r].toNativeMML(s)}else{s.appendChild(this.NativeMMLelement("mrow"))}}}else{if(l.stretchyMoBug&&(this.open||this.close)){var q=this.NativeMMLelement("mfenced");this.NativeMMLattributes(q);r=0,p=this.data.length;if(this.open){q.setAttribute("open",this.open);r++}if(this.close){q.setAttribute("close",this.close);p--}var o=q;if(p-r+1>1){o=this.NativeMMLelement("mrow");s.appendChild(q);s=q}for(;r<p;r++){if(this.data[r]){this.data[r].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}}s.appendChild(o)}else{this.SUPER(arguments).toNativeMML.call(this,s)}}}});f.msubsup.Augment({toNativeMML:function(s){var r=this.type;if(this.data[this.sup]==null){r="msub"}if(this.data[this.sub]==null){r="msup"}var p=this.NativeMMLelement(r);this.NativeMMLattributes(p);if(this.data[0]){delete this.data[0].inferred}for(var q=0,o=this.data.length;q<o;q++){if(this.data[q]){this.data[q].toNativeMML(p)}}s.appendChild(p)}});f.munderover.Augment({toNativeMML:function(s){var r=this.type;if(this.data[this.under]==null){r="mover"}if(this.data[this.over]==null){r="munder"}var p=this.NativeMMLelement(r);this.NativeMMLattributes(p);if(this.data[0]){delete this.data[0].inferred}for(var q=0,o=this.data.length;q<o;q++){if(this.data[q]){this.data[q].toNativeMML(p)}}s.appendChild(p)}});if(!i){var m=c.SplitList;f.mtable.Augment({toNativeMML:function(z){var s,q;if(l.tableSpacingBug){var A=this.getValues("rowspacing","columnspacing");this.nMMLtopPadding=m("0px "+A.rowspacing);this.nMMLleftPadding=m("0px "+A.columnspacing);var y=this.nMMLtopPadding,v=y.length;for(s=0,q=this.data.length;s<q;s++){if(this.data[s]){this.data[s].nMMLtopPadding=y[s<v?s:v-1]}}}if(l.tableLabelBug){for(s=0,q=this.data.length;s<q;s++){if(this.data[s]&&this.data[s].isa(f.mlabeledtr)){var u=c.config.displayAlign.charAt(0),w=this.Get("side").charAt(0);this.nMMLhasLabels=true;this.nMMLlaMatch=(u===w);this.nMMLforceWidth=(u==="c"||!!((this.width||"").match("%")));break}}}if(this.width&&this.ffTableWidthBug){var B=(this.style||"").replace(/;\s*$/,"").split(";");if(B[0]===""){B.shift()}B.push("width:"+this.width);this.style=B.join(";")}this.SUPER(arguments).toNativeMML.call(this,z);if(this.nMMLhasLabels){var r=z.firstChild;if(this.nMMLforceWidth||w!=="r"){var p=(u!=="l"?1:0)+(w==="l"?1:0);if(p){var t={columnalign:"left",columnwidth:"auto",columnspacing:"0px",columnlines:"none"};for(var o in t){if(t.hasOwnProperty(o)&&this[o]){var x=[t[o],t[o]].slice(2-p).join(" ")+" ";r.setAttribute(o,x+r.getAttribute(o))}}}}if(this.nMMLforceWidth||!this.nMMLlaMatch){r.setAttribute("width","100%")}}}});f.mtr.Augment({toNativeMML:function(v){this.SUPER(arguments).toNativeMML.call(this,v);var p=v.lastChild;if(l.tableSpacingBug){var r=this.parent.nMMLleftPadding,t=r.length;for(var w=p.firstChild,q=0;w;w=w.nextSibling,q++){a(w,this.nMMLtopPadding,r[q<t?q:t-1])}}if(l.tableLabelBug){var o=this.parent.nMMLforceWidth,u=this.parent.Get("side").charAt(0),s=c.config.displayAlign.charAt(0);if(this.parent.nMMLhasLabels&&p.firstChild){if(o||u!=="r"){j("Left",p.firstChild);if(s!=="l"){p.insertBefore(this.NativeMMLelement("mtd"),p.firstChild).setAttribute("style","padding:0")}if(u==="l"){p.insertBefore(this.NativeMMLelement("mtd"),p.firstChild).setAttribute("style","padding:0")}}if(o||u!=="l"){j("Right",p.lastChild)}}}}});f.mlabeledtr.Augment({toNativeMML:function(C){var t=this.NativeMMLelement("mtr");this.NativeMMLattributes(t);for(var u=1,s=this.data.length;u<s;u++){if(this.data[u]){this.data[u].toNativeMML(t)}else{t.appendChild(this.NativeMMLelement("mtd"))}}if(l.tableSpacingBug){var v=this.parent.nMMLleftPadding,y=v.length;u=0;for(var D=t.firstChild;D;D=D.nextSibling,u++){a(D,this.nMMLtopPadding,v[u<y?u:y-1])}}if(l.tableLabelBug&&this.data[0]){var z=this.parent.Get("side").charAt(0),x=c.config.displayAlign.charAt(0),q=c.config.displayIndent;this.data[0].toNativeMML(t);var A=t.lastChild,r=A;if(z===x){A.setAttribute("style","width:"+q);A.setAttribute("columnalign",c.config.displayAlign)}else{r=this.NativeMMLelement("mpadded");r.setAttribute("style","width:0");r.setAttribute("width","0px");r.appendChild(A.firstChild);A.appendChild(r)}j("",A);t.removeChild(A);var o=100,p=this.parent.nMMLforceWidth;if((this.parent.width||"").match(/%/)){o-=parseFloat(this.parent.width)}var B=o;if(p||z!=="r"){j("Left",t.firstChild);if(x!=="l"){if(x==="c"){B/=2}o-=B;t.insertBefore(this.NativeMMLelement("mtd"),t.firstChild).setAttribute("style","padding:0;width:"+B+"%")}if(z==="l"){t.insertBefore(A,t.firstChild)}}if(p||z!=="l"){j("Right",t.lastChild);if(x!=="r"){t.appendChild(this.NativeMMLelement("mtd")).setAttribute("style","padding:0;width:"+o+"%")}if(z==="r"){if(z!==x){r.setAttribute("lspace","-1width")}t.appendChild(A)}}}C.appendChild(t)}});f.mtd.Augment({toNativeMML:function(r){var p=r.appendChild(this.NativeMMLelement(this.type));this.NativeMMLattributes(p);if(l.mtdWidthBug){l.adjustWidths.push(p);p=p.appendChild(this.NativeMMLelement("mrow"))}for(var q=0,o=this.data.length;q<o;q++){if(this.data[q]){this.data[q].toNativeMML(p)}else{p.appendChild(this.NativeMMLelement("mrow"))}}}});f.mspace.Augment({toNativeMML:function(q){this.SUPER(arguments).toNativeMML.call(this,q);if(l.spaceWidthBug&&this.width){var r=q.lastChild;var p=r.getAttribute("width");var o=(r.getAttribute("style")||"").replace(/;?\s*/,"; ");r.setAttribute("style",o+"width:"+p)}}});var n=g.fileURL(MathJax.OutputJax.fontDir+"/HTML-CSS/TeX/otf");l.Augment({config:{styles:{'[class="MJX-tex-oldstyle"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB"},'[class="MJX-tex-oldstyle-bold"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB","font-weight":"bold"},'[class="MJX-tex-caligraphic"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB"},'[class="MJX-tex-caligraphic-bold"]':{"font-family":"MathJax_Caligraphic, MathJax_Caligraphic-WEB","font-weight":"bold"},"@font-face /*1*/":{"font-family":"MathJax_Caligraphic-WEB",src:"url('"+n+"/MathJax_Caligraphic-Regular.otf')"},"@font-face /*2*/":{"font-family":"MathJax_Caligraphic-WEB","font-weight":"bold",src:"url('"+n+"/MathJax_Caligraphic-Bold.otf')"}}}});if(!this.handlesVariants){l.Augment({config:{styles:{'[mathvariant="double-struck"]':{"font-family":"MathJax_AMS, MathJax_AMS-WEB"},'[mathvariant="script"]':{"font-family":"MathJax_Script, MathJax_Script-WEB"},'[mathvariant="fraktur"]':{"font-family":"MathJax_Fraktur, MathJax_Fraktur-WEB"},'[mathvariant="bold-script"]':{"font-family":"MathJax_Script, MathJax_Caligraphic-WEB","font-weight":"bold"},'[mathvariant="bold-fraktur"]':{"font-family":"MathJax_Fraktur, MathJax_Fraktur-WEB","font-weight":"bold"},'[mathvariant="monospace"]':{"font-family":"monospace"},'[mathvariant="sans-serif"]':{"font-family":"sans-serif"},'[mathvariant="bold-sans-serif"]':{"font-family":"sans-serif","font-weight":"bold"},'[mathvariant="sans-serif-italic"]':{"font-family":"sans-serif","font-style":"italic"},'[mathvariant="sans-serif-bold-italic"]':{"font-family":"sans-serif","font-style":"italic","font-weight":"bold"},"@font-face /*3*/":{"font-family":"MathJax_AMS-WEB",src:"url('"+n+"/MathJax_AMS-Regular.otf')"},"@font-face /*4*/":{"font-family":"MathJax_Script-WEB",src:"url('"+n+"/MathJax_Script-Regular.otf')"},"@font-face /*5*/":{"font-family":"MathJax_Fraktur-WEB",src:"url('"+n+"/MathJax_Fraktur-Regular.otf')"},"@font-face /*6*/":{"font-family":"MathJax_Fraktur-WEB","font-weight":"bold",src:"url('"+n+"/MathJax_Fraktur-Bold.otf')"}}}})}}f.math.Augment({toNativeMML:function(x,p){var z=this.NativeMMLelement(this.type),w=z;var u=(p?MathJax.InputJax[p.inputJax].annotationEncoding:null);var v,r;l.adjustWidths=[];z.setAttribute("xmlns",l.MMLnamespace);this.NativeMMLattributes(z);if(l.widthBug){z=z.appendChild(this.NativeMMLelement("mrow"))}if(u){z=z.appendChild(this.NativeMMLelement("semantics"));z.appendChild(this.NativeMMLelement("mrow"));var s=z.appendChild(this.NativeMMLelement("annotation"));s.appendChild(document.createTextNode(p.originalText));s.setAttribute("encoding",u);z=z.firstChild}for(v=0,r=this.data.length;v<r;v++){if(this.data[v]){this.data[v].toNativeMML(z)}else{z.appendChild(this.NativeMMLelement("mrow"))}}var t=((this.data[0]||[]).data[0]||{});if(t.nMMLhasLabels){if(t.nMMLforceWidth||!t.nMMLlaMatch){z.setAttribute("style","width:100%");x.style.width=x.parentNode.style.width="100%"}if(t.nMMLlaMatch){if(x.parentNode.parentNode.nodeName.toLowerCase()==="div"){x.parentNode.parentNode.style.setProperty("margin-"+c.config.displayAlign,"0px","important")}}}x.appendChild(w);if(l.widthBug&&!(t.nMMLhasLabels&&(t.nMMLforceWidth||!t.nMMLlaMatch))){x.style.width=(w.firstChild.scrollWidth/l.ex/l.scale).toFixed(3)+"ex";if(p){p.NativeMML.scrollWidth=w.firstChild.scrollWidth}}if(l.adjustWidths.length){var y=[];for(v=0,r=l.adjustWidths.length;v<r;v++){z=l.adjustWidths[v];var o=z.getAttribute("style")||"";if(!o.match(/(^|;)\s*min-width:/)){var q=z.firstChild.scrollWidth;y.push(q);q=(q/l.ex).toFixed(3)+"ex";o=o.replace(/;?\s*$/,"; ");z.setAttribute("style",o+"min-width:"+q)}}if(!p){p=c.getJaxFor(x)}if(p){p.NativeMML.mtds=y}w.MathJaxMtds=l.adjustWidths;l.adjustWidths=[]}}});f.mfenced.Augment({toNativeMML:function(w){if(!l.mfencedBug){this.SUPER(arguments).toNativeMML.call(this,w);return}var t=c.Browser.isOpera;var u,p,r;var q=this.getValues("open","close","separators");q.open=q.open.replace(/^\s+/,"").replace(/\s+$/,"");q.close=q.close.replace(/^\s+/,"").replace(/\s+$/,"");q.separators=q.separators.replace(/\s+/g,"").split("");if(q.separators.length==0){q.separators=null}else{if(q.separators.length<this.data.length-1){var v=q.separators[q.separators.length-1];for(u=this.data.length-1-q.separators.length;u>0;u--){q.separators.push(v)}}}var o=this.NativeMMLelement(t?this.type:"mrow");this.NativeMMLattributes(o);o.removeAttribute("separators");if(t){o.setAttribute("open",q.open);o.setAttribute("close",q.close);if(this.data.length>1){w.appendChild(o);w=o;o=this.NativeMMLelement("mrow")}}else{o.removeAttribute("open");o.removeAttribute("close")}if(!t){r=this.NativeMMLelement("mo");r.setAttribute("fence","true");r.textContent=q.open;o.appendChild(r)}for(u=0,p=this.data.length;u<p;u++){if(q.separators&&u>0){r=this.NativeMMLelement("mo");r.setAttribute("separator","true");r.textContent=q.separators[u-1];o.appendChild(r)}if(this.data[u]){this.data[u].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}}if(!t){r=this.NativeMMLelement("mo");r.setAttribute("fence","true");r.textContent=q.close;o.appendChild(r)}w.appendChild(o)}});f.TeXAtom.Augment({toNativeMML:function(p){var o=this.NativeMMLelement("mrow");this.NativeMMLattributes(o);this.data[0].toNativeMML(o);p.appendChild(o)}});f.chars.Augment({toNativeMML:function(o){o.appendChild(document.createTextNode(this.toString()))}});f.entity.Augment({toNativeMML:function(o){o.appendChild(document.createTextNode(this.toString()))}});f.xml.Augment({toNativeMML:function(q){for(var p=0,o=this.data.length;p<o;p++){q.appendChild(this.data[p].cloneNode(true))}}});f.mi.Augment({toNativeMML:function(p){this.SUPER(arguments).toNativeMML.call(this,p);if(l.miItalicBug){if(this.Get("mathvariant")===f.VARIANT.NORMAL){var o=p.lastChild;o.setAttribute("mathvariant",f.VARIANT.NORMAL)}}}});f.mo.Augment({toNativeMML:function(t){this.SUPER(arguments).toNativeMML.call(this,t);if(l.webkitMoSpacingBug){var o=0,s=0,v=this.parent;if(v&&v.type==="mrow"&&(v.inferred||!v.isEmbellished())){var q=this.getValues("lspace","rspace");o=q.lspace,s=q.rspace;if(l.NAMEDSPACE[o]){o=l.NAMEDSPACE[o]}if(l.NAMEDSPACE[s]){s=l.NAMEDSPACE[s]}}var u=t.lastChild;var r=e.Element("span");r.style.cssText=(u.getAttribute("style")||"");r.style.setProperty("-webkit-margin-start",o);r.style.setProperty("-webkit-margin-end",s);u.setAttribute("style",r.style.cssText)}}});f.mmultiscripts.Augment({toNativeMML:function(s){if(!l.mmultiscriptsBug||this.data.length===0){this.SUPER(arguments).toNativeMML.call(this,s);return}var q=this.NativeMMLelement("mrow");this.NativeMMLattributes(q);if(this.data[0]){this.data[0].toNativeMML(q)}else{q.appendChild(this.NativeMMLelement("mrow"))}base=q.removeChild(q.lastChild);var p=this.data.length,r,o;for(r=1;r<p;r+=2){if(this.data[r].type==="mprescripts"){break}o=this.NativeMMLelement("msubsup");o.appendChild(base);if(this.data[r]){this.data[r].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}if(r+1<p&&this.data[r+1]){this.data[r+1].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}base=o}q.appendChild(base);for(r++;r<p;r+=2){o=this.NativeMMLelement("msubsup");o.appendChild(this.NativeMMLelement("mrow"));if(this.data[r]){this.data[r].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}if(r+1<p&&this.data[r+1]){this.data[r+1].toNativeMML(o)}else{o.appendChild(this.NativeMMLelement("mrow"))}q.insertBefore(o,base)}s.appendChild(q)}});c.Register.StartupHook("TeX mathchoice Ready",function(){f.TeXmathchoice.Augment({toNativeMML:function(o){this.Core().toNativeMML(o)}})});setTimeout(MathJax.Callback(["loadComplete",l,"jax.js"]),0)});c.Browser.Select({MSIE:function(m){var n=(document.documentMode||0);l.msieIE8HeightBug=(n===8)},Opera:function(m){l.operaPositionBug=true;l.stretchyMoBug=true;l.tableLabelBug=true;l.mfencedBug=true;l.miBug=true;l.mmultiscriptsBug=true},Firefox:function(m){var n=m.versionAtLeast("29.0");l.ffTableWidthBug=!m.versionAtLeast("13.0");l.forceReflow=!n;l.widthBug=!n;l.mtdWidthBug=true;l.handlesVariants=n;l.spaceWidthBug=!m.versionAtLeast("20.0");l.tableSpacingBug=true;l.tableLabelBug=true;l.mfencedBug=true},Chrome:function(m){l.tableSpacingBug=true;l.tableLabelBug=true;l.mfencedBug=true},Safari:function(m){l.tableSpacingBug=true;l.tableLabelBug=true;l.mfencedBug=true;l.miItalicBug=true;l.webkitMoSpacingBug=true;l.spaceWidthBug=true;l.mmultiscriptsBug=true}});c.Register.StartupHook("End Cookie",function(){if(c.config.menuSettings.zoom!=="None"){g.Require("[MathJax]/extensions/MathZoom.js")}})})(MathJax.OutputJax.NativeMML,MathJax.Hub,MathJax.Ajax,MathJax.HTML);
(function(h,b,d){var g,i=b.Browser.isMobile;var e=function(){var k=[].slice.call(arguments,0);k[0][0]=["HTML-CSS",k[0][0]];return MathJax.Message.Set.apply(MathJax.Message,k)};var f=MathJax.Object.Subclass({timeout:(i?15:8)*1000,comparisonFont:["sans-serif","monospace","script","Times","Courier","Arial","Helvetica"],testSize:["40px","50px","60px","30px","20px"],FedoraSTIXcheck:{family:"STIXSizeOneSym",testString:"abcABC",noStyleChar:true},Init:function(){this.div=MathJax.HTML.addElement(document.body,"div",{style:{position:"absolute",width:0,height:0,overflow:"hidden",padding:0,border:0,margin:0}},[["div",{id:"MathJax_Font_Test",style:{position:"absolute",visibility:"hidden",top:0,left:0,width:"auto",padding:0,border:0,margin:0,whiteSpace:"nowrap",textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal",fontSize:this.testSize[0],fontWeight:"normal",fontStyle:"normal",fontSizeAdjust:"none"}},[""]]]).firstChild;this.text=this.div.firstChild},findFont:function(p,l){var o=null;if(l&&this.testCollection(l)){o=l}else{for(var n=0,k=p.length;n<k;n++){if(p[n]===l){continue}if(this.testCollection(p[n])){o=p[n];break}}}if(o==="STIX"&&this.testFont(this.FedoraSTIXcheck)){o=null}return o},testCollection:function(l){var k={testString:"() {} []"};k.family={TeX:"MathJax_Size1",STIX:"STIXSizeOneSym"}[l]||l.replace(/-(Math)?/,"")+"MathJax_Size1";if(l==="STIX"){k.noStyleChar=true}return this.testFont(k)},testFont:function(n){if(n.isWebFont&&d.FontFaceBug){this.div.style.fontWeight=this.div.style.fontStyle="normal"}else{this.div.style.fontWeight=(n.weight||"normal");this.div.style.fontStyle=(n.style||"normal")}var p=n.familyFixed||n.family;if(!p.match(/^(STIX|MathJax)|'/)){p=p.replace(/_/g," ").replace(/([a-z])([A-Z])/g,"$1 $2").replace(/ Jax/,"Jax")+"','"+p+"','"+p+"-";if(n.weight){p+="Bold"}if(n.style){p+="Italic"}if(!n.weight&&!n.style){p+="Regular"}n.familyFixed=p="'"+p+"'"}var l=this.getComparisonWidths(n.testString,n.noStyleChar);var q=null;if(l){this.div.style.fontFamily=p+","+this.comparisonFont[0];if(this.div.offsetWidth==l[0]){this.div.style.fontFamily=p+","+this.comparisonFont[l[2]];if(this.div.offsetWidth==l[1]){q=false}}if(q===null&&(this.div.offsetWidth!=l[3]||this.div.offsetHeight!=l[4])){if(!n.noStyleChar&&d.FONTDATA&&d.FONTDATA.hasStyleChar){for(var o=0,k=this.testSize.length;o<k;o++){if(this.testStyleChar(n,this.testSize[o])){q=true;k=0}}}else{q=true}}}if(d.safariTextNodeBug){this.div.innerHTML=""}else{this.text.nodeValue=""}return q},styleChar:"\uEFFD",versionChar:"\uEFFE",compChar:"\uEFFF",testStyleChar:function(m,p){var s=3+(m.weight?2:0)+(m.style?4:0);var l="",o=0;var r=this.div.style.fontSize;this.div.style.fontSize=p;if(d.msieItalicWidthBug&&m.style==="italic"){this.text.nodeValue=l=this.compChar;o=this.div.offsetWidth}if(d.safariTextNodeBug){this.div.innerHTML=this.compChar+l}else{this.text.nodeValue=this.compChar+l}var k=this.div.offsetWidth-o;if(d.safariTextNodeBug){this.div.innerHTML=this.styleChar+l}else{this.text.nodeValue=this.styleChar+l}var q=Math.floor((this.div.offsetWidth-o)/k+0.5);if(q===s){if(d.safariTextNodeBug){this.div.innerHTML=this.versionChar+l}else{this.text.nodeValue=this.versionChar+l}m.version=Math.floor((this.div.offsetWidth-o)/k+1.5)/2}this.div.style.fontSize=r;return(q===s)},getComparisonWidths:function(p,n){if(d.FONTDATA&&d.FONTDATA.hasStyleChar&&!n){p+=this.styleChar+" "+this.compChar}if(d.safariTextNodeBug){this.div.innerHTML=p}else{this.text.nodeValue=p}this.div.style.fontFamily=this.comparisonFont[0];var l=this.div.offsetWidth;this.div.style.fontFamily=d.webFontDefault;var r=this.div.offsetWidth,o=this.div.offsetHeight;for(var q=1,k=this.comparisonFont.length;q<k;q++){this.div.style.fontFamily=this.comparisonFont[q];if(this.div.offsetWidth!=l){return[l,this.div.offsetWidth,q,r,o]}}return null},loadWebFont:function(l){b.Startup.signal.Post("HTML-CSS Jax - Web-Font "+d.fontInUse+"/"+l.directory);var o=e(["LoadWebFont","Loading web-font %1",d.fontInUse+"/"+l.directory]);var k=MathJax.Callback({});var m=MathJax.Callback(["loadComplete",this,l,o,k]);h.timer.start(h,[this.checkWebFont,l,m],0,this.timeout);return k},loadComplete:function(m,p,l,k){MathJax.Message.Clear(p);if(k===h.STATUS.OK){this.webFontLoaded=true;l();return}this.loadError(m);if(b.Browser.isFirefox&&d.allowWebFonts){var o=document.location.protocol+"//"+document.location.hostname;if(document.location.port!=""){o+=":"+document.location.port}o+="/";if(h.fileURL(d.webfontDir).substr(0,o.length)!==o){this.firefoxFontError(m)}}if(!this.webFontLoaded){d.loadWebFontError(m,l)}else{l()}},loadError:function(k){e(["CantLoadWebFont","Can't load web font %1",d.fontInUse+"/"+k.directory],null,2000);b.Startup.signal.Post(["HTML-CSS Jax - web font error",d.fontInUse+"/"+k.directory,k])},firefoxFontError:function(k){e(["FirefoxCantLoadWebFont","Firefox can't load web fonts from a remote host"],null,3000);b.Startup.signal.Post("HTML-CSS Jax - Firefox web fonts on remote host error")},checkWebFont:function(k,l,m){if(k.time(m)){return}if(d.Font.testFont(l)){m(k.STATUS.OK)}else{setTimeout(k,k.delay)}},fontFace:function(o){var p=d.allowWebFonts;var r=d.FONTDATA.FONTS[o];if(d.msieFontCSSBug&&!r.family.match(/-Web$/)){r.family+="-Web"}var k=d.webfontDir+"/"+p;var n=h.fileURL(k);var m=o.replace(/-b/,"-B").replace(/-i/,"-I").replace(/-Bold-/,"-Bold");if(!m.match(/-/)){m+="-Regular"}if(p==="svg"){m+=".svg#"+m}else{m+="."+p}var l=h.fileRev(k+"/"+m.replace(/#.*/,""));var q={"font-family":r.family,src:"url('"+n+"/"+m+l+"')"};if(p==="otf"){m=m.replace(/otf$/,"woff");l=h.fileRev(k+"/"+m);q.src+=" format('opentype')";n=h.fileURL(d.webfontDir+"/woff");q.src="url('"+n+"/"+m+l+"') format('woff'), "+q.src}else{if(p!=="eot"){q.src+=" format('"+p+"')"}}if(!(d.FontFaceBug&&r.isWebFont)){if(o.match(/-bold/)){q["font-weight"]="bold"}if(o.match(/-italic/)){q["font-style"]="italic"}}return q}});var j,a,c;d.Augment({config:{styles:{".MathJax":{display:"inline","font-style":"normal","font-weight":"normal","line-height":"normal","font-size":"100%","font-size-adjust":"none","text-indent":0,"text-align":"left","text-transform":"none","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none",direction:"ltr","max-width":"none","max-height":"none","min-width":0,"min-height":0,border:0,padding:0,margin:0},".MathJax_Display":{position:"relative",display:"block!important","text-indent":0,"max-width":"none","max-height":"none","min-width":0,"min-height":0,width:"100%"},".MathJax img, .MathJax nobr, .MathJax a":{border:0,padding:0,margin:0,"max-width":"none","max-height":"none","min-width":0,"min-height":0,"vertical-align":0,"line-height":"normal","text-decoration":"none"},"img.MathJax_strut":{border:"0!important",padding:"0!important",margin:"0!important","vertical-align":"0!important"},".MathJax span":{display:"inline",position:"static",border:0,padding:0,margin:0,"vertical-align":0,"line-height":"normal","text-decoration":"none"},".MathJax nobr":{"white-space":"nowrap!important"},".MathJax img":{display:"inline!important","float":"none!important"},".MathJax *":{transition:"none","-webkit-transition":"none","-moz-transition":"none","-ms-transition":"none","-o-transition":"none"},".MathJax_Processing":{visibility:"hidden",position:"fixed",width:0,height:0,overflow:"hidden"},".MathJax_Processed":{display:"none!important"},".MathJax_ExBox":{display:"block!important",overflow:"hidden",width:"1px",height:"60ex","min-height":0,"max-height":"none"},".MathJax .MathJax_EmBox":{display:"block!important",overflow:"hidden",width:"1px",height:"60em","min-height":0,"max-height":"none"},".MathJax .MathJax_HitBox":{cursor:"text",background:"white",opacity:0,filter:"alpha(opacity=0)"},".MathJax .MathJax_HitBox *":{filter:"none",opacity:1,background:"transparent"},"#MathJax_Tooltip":{position:"absolute",left:0,top:0,width:"auto",height:"auto",display:"none"},"#MathJax_Tooltip *":{filter:"none",opacity:1,background:"transparent"},"@font-face":{"font-family":"MathJax_Blank",src:"url('about:blank')"}}},settings:b.config.menuSettings,hideProcessedMath:true,Font:null,webFontDefault:"MathJax_Blank",allowWebFonts:"otf",maxStretchyParts:1000,fontName:{TeXLocal:"TeX",TeXWeb:["","TeX"],TeXImage:["",""],STIXLocal:["STIX","STIX-Web"],STIXWeb:"STIX-Web",AsanaMathWeb:"Asana-Math",GyrePagellaWeb:"Gyre-Pagella",GyreTermesWeb:"Gyre-Termes",LatinModernWeb:"Latin-Modern",NeoEulerWeb:"Neo-Euler"},fontInUse:"generic",FONTDATA:{TeX_factor:1,baselineskip:1.2,lineH:0.8,lineD:0.2,ffLineH:0.8,FONTS:{},VARIANT:{normal:{fonts:[]},"-generic-variant":{},"-largeOp":{},"-smallOp":{}},RANGES:[],DELIMITERS:{},RULECHAR:45,REMAP:{}},Config:function(){if(!this.require){this.require=[]}this.Font=f();this.SUPER(arguments).Config.call(this);var m=this.settings,l=this.config,k=m.font;if(this.adjustAvailableFonts){this.adjustAvailableFonts(l.availableFonts)}if(m.scale){l.scale=m.scale}if(k&&k!=="Auto"&&this.fontName[k]){l.availableFonts=[];delete l.fonts;if(this.fontName[k] instanceof Array){l.preferredFont=this.fontName[k][0];l.webFont=this.fontName[k][1]}else{l.preferredFont=l.webFont=this.fontName[k]}if(l.preferredFont){l.availableFonts[0]=l.preferredFont}}if(l.fonts){l.availableFonts=l.fonts;l.preferredFont=l.webFont=l.fonts[0];if(l.webFont==="STIX"){l.webFont+="-Web"}}k=this.Font.findFont(l.availableFonts,l.preferredFont);if(!k&&this.allowWebFonts){k=l.webFont;if(k){this.webFonts=true}}if(!k&&this.config.imageFont){k=l.imageFont;this.imgFonts=true}if(k){this.fontInUse=k;this.fontDir+="/"+k;this.webfontDir+="/"+k;this.require.push(this.fontDir+"/fontdata.js");if(this.imgFonts){this.require.push(this.directory+"/imageFonts.js");b.Startup.signal.Post("HTML-CSS Jax - using image fonts")}}else{e(["CantFindFontUsing","Can't find a valid font using %1","["+this.config.availableFonts.join(", ")+"]"],null,3000);b.Startup.signal.Post("HTML-CSS Jax - no valid font")}this.require.push(MathJax.OutputJax.extensionDir+"/MathEvents.js")},Startup:function(){j=MathJax.Extension.MathEvents.Event;a=MathJax.Extension.MathEvents.Touch;c=MathJax.Extension.MathEvents.Hover;this.ContextMenu=j.ContextMenu;this.Mousedown=j.AltContextMenu;this.Mouseover=c.Mouseover;this.Mouseout=c.Mouseout;this.Mousemove=c.Mousemove;this.hiddenDiv=this.Element("div",{style:{visibility:"hidden",overflow:"hidden",position:"absolute",top:0,height:"1px",width:"auto",padding:0,border:0,margin:0,textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal"}});if(!document.body.firstChild){document.body.appendChild(this.hiddenDiv)}else{document.body.insertBefore(this.hiddenDiv,document.body.firstChild)}this.hiddenDiv=this.addElement(this.hiddenDiv,"div",{id:"MathJax_Hidden"});var l=this.addElement(this.hiddenDiv,"div",{style:{width:"5in"}});this.pxPerInch=l.offsetWidth/5;this.hiddenDiv.removeChild(l);this.startMarker=this.createStrut(this.Element("span"),10,true);this.endMarker=this.addText(this.Element("span"),"x").parentNode;this.HDspan=this.Element("span");if(this.operaHeightBug){this.createStrut(this.HDspan,0)}if(this.msieInlineBlockAlignBug){this.HDimg=this.addElement(this.HDspan,"img",{style:{height:"0px",width:"1px"}});try{this.HDimg.src="about:blank"}catch(k){}}else{this.HDimg=this.createStrut(this.HDspan,0)}this.EmExSpan=this.Element("span",{style:{position:"absolute","font-size-adjust":"none"}},[["span",{className:"MathJax_ExBox"}],["span",{className:"MathJax"},[["span",{className:"MathJax_EmBox"}]]]]);this.linebreakSpan=this.Element("span",null,[["hr",{style:{width:"100%",size:1,padding:0,border:0,margin:0}}]]);return h.Styles(this.config.styles,["InitializeHTML",this])},removeSTIXfonts:function(n){for(var l=0,k=n.length;l<k;l++){if(n[l]==="STIX"){n.splice(l,1);k--;l--}}if(this.config.preferredFont==="STIX"){this.config.preferredFont=n[0]}},PreloadWebFonts:function(){if(!d.allowWebFonts||!d.config.preloadWebFonts){return}for(var l=0,k=d.config.preloadWebFonts.length;l<k;l++){var n=d.FONTDATA.FONTS[d.config.preloadWebFonts[l]];if(!n.available){d.Font.testFont(n)}}},InitializeHTML:function(){this.PreloadWebFonts();this.getDefaultExEm();if(this.defaultEm){return}var k=MathJax.Callback();h.timer.start(h,function(l){if(l.time(k)){b.signal.Post("HTML-CSS Jax - no default em size");return}d.getDefaultExEm();if(d.defaultEm){k()}else{setTimeout(l,l.delay)}},this.defaultEmDelay,this.defaultEmTimeout);return k},defaultEmDelay:100,defaultEmTimeout:1000,getDefaultExEm:function(){document.body.appendChild(this.EmExSpan);document.body.appendChild(this.linebreakSpan);this.defaultEx=this.EmExSpan.firstChild.offsetHeight/60;this.defaultEm=this.EmExSpan.lastChild.firstChild.offsetHeight/60;this.defaultWidth=this.linebreakSpan.firstChild.offsetWidth;document.body.removeChild(this.linebreakSpan);document.body.removeChild(this.EmExSpan)},preTranslate:function(o){var u=o.jax[this.id],v,r=u.length,z,t,A,n,y,l,x,q,s,k,w=false,B=this.config.linebreaks.automatic,p=this.config.linebreaks.width;if(B){w=(p.match(/^\s*(\d+(\.\d*)?%\s*)?container\s*$/)!=null);if(w){p=p.replace(/\s*container\s*/,"")}else{k=this.defaultWidth}if(p===""){p="100%"}}else{k=100000}for(v=0;v<r;v++){z=u[v];if(!z.parentNode){continue}t=z.previousSibling;if(t&&String(t.className).match(/^MathJax(_Display)?( MathJax_Processing)?$/)){t.parentNode.removeChild(t)}l=z.MathJax.elementJax;if(!l){continue}l.HTMLCSS={display:(l.root.Get("display")==="block")};A=n=this.Element("span",{className:"MathJax",id:l.inputID+"-Frame",isMathJax:true,jaxID:this.id,oncontextmenu:j.Menu,onmousedown:j.Mousedown,onmouseover:j.Mouseover,onmouseout:j.Mouseout,onmousemove:j.Mousemove,onclick:j.Click,ondblclick:j.DblClick});if(b.Browser.noContextMenu){A.ontouchstart=a.start;A.ontouchend=a.end}if(l.HTMLCSS.display){n=this.Element("div",{className:"MathJax_Display"});n.appendChild(A)}else{if(this.msieDisappearingBug){A.style.display="inline-block"}}n.setAttribute("role","textbox");n.setAttribute("aria-readonly","true");n.className+=" MathJax_Processing";z.parentNode.insertBefore(n,z);z.parentNode.insertBefore(this.EmExSpan.cloneNode(true),z);if(w){n.parentNode.insertBefore(this.linebreakSpan.cloneNode(true),n)}}for(v=0;v<r;v++){z=u[v];if(!z.parentNode){continue}y=z.previousSibling;n=y.previousSibling;l=z.MathJax.elementJax;if(!l){continue}x=y.firstChild.offsetHeight/60;q=y.lastChild.firstChild.offsetHeight/60;if(w){k=n.previousSibling.firstChild.offsetWidth}if(x===0||x==="NaN"){this.hiddenDiv.appendChild(n);l.HTMLCSS.isHidden=true;x=this.defaultEx;q=this.defaultEm;if(w){k=this.defaultWidth}}s=(this.config.matchFontHeight?x/this.TeX.x_height/q:1);s=Math.floor(Math.max(this.config.minScaleAdjust/100,s)*this.config.scale);l.HTMLCSS.scale=s/100;l.HTMLCSS.fontSize=s+"%";l.HTMLCSS.em=l.HTMLCSS.outerEm=q;this.em=q*s/100;l.HTMLCSS.ex=x;l.HTMLCSS.lineWidth=(B?this.length2em(p,1,k/this.em):1000000)}for(v=0;v<r;v++){z=u[v];if(!z.parentNode){continue}y=u[v].previousSibling;l=u[v].MathJax.elementJax;if(!l){continue}if(w){A=y.previousSibling;if(!l.HTMLCSS.isHidden){A=A.previousSibling}A.parentNode.removeChild(A)}y.parentNode.removeChild(y)}o.HTMLCSSeqn=o.HTMLCSSlast=0;o.HTMLCSSi=-1;o.HTMLCSSchunk=this.config.EqnChunk;o.HTMLCSSdelay=false},Translate:function(l,p){if(!l.parentNode){return}if(p.HTMLCSSdelay){p.HTMLCSSdelay=false;b.RestartAfter(MathJax.Callback.Delay(this.config.EqnChunkDelay))}var k=l.MathJax.elementJax,o=k.root,m=document.getElementById(k.inputID+"-Frame"),q=(k.HTMLCSS.display?(m||{}).parentNode:m);if(!q){return}this.em=g.mbase.prototype.em=k.HTMLCSS.em*k.HTMLCSS.scale;this.outerEm=k.HTMLCSS.em;this.scale=k.HTMLCSS.scale;this.linebreakWidth=k.HTMLCSS.lineWidth;if(this.scale!==1){m.style.fontSize=k.HTMLCSS.fontSize}this.initImg(m);this.initHTML(o,m);o.setTeXclass();try{o.toHTML(m,q)}catch(n){if(n.restart){while(m.firstChild){m.removeChild(m.firstChild)}}throw n}if(k.HTMLCSS.isHidden){l.parentNode.insertBefore(q,l)}q.className=q.className.split(/ /)[0];if(this.hideProcessedMath){q.className+=" MathJax_Processed";if(l.MathJax.preview){k.HTMLCSS.preview=l.MathJax.preview;delete l.MathJax.preview}p.HTMLCSSeqn+=(p.i-p.HTMLCSSi);p.HTMLCSSi=p.i;if(p.HTMLCSSeqn>=p.HTMLCSSlast+p.HTMLCSSchunk){this.postTranslate(p,true);p.HTMLCSSchunk=Math.floor(p.HTMLCSSchunk*this.config.EqnChunkFactor);p.HTMLCSSdelay=true}}},postTranslate:function(s,o){var l=s.jax[this.id];if(!this.hideProcessedMath){return}for(var q=s.HTMLCSSlast,k=s.HTMLCSSeqn;q<k;q++){var n=l[q];if(n&&n.MathJax.elementJax){n.previousSibling.className=n.previousSibling.className.split(/ /)[0];var r=n.MathJax.elementJax.HTMLCSS;if(r.preview){r.preview.innerHTML="";n.MathJax.preview=r.preview;delete r.preview}}}if(this.forceReflow){var p=(document.styleSheets||[])[0]||{};p.disabled=true;p.disabled=false}s.HTMLCSSlast=s.HTMLCSSeqn},getJaxFromMath:function(k){if(k.parentNode.className==="MathJax_Display"){k=k.parentNode}do{k=k.nextSibling}while(k&&k.nodeName.toLowerCase()!=="script");return b.getJaxFor(k)},getHoverSpan:function(k,l){return k.root.HTMLspanElement()},getHoverBBox:function(k,n,o){var p=n.bbox,m=k.HTMLCSS.outerEm;var l={w:p.w*m,h:p.h*m,d:p.d*m};if(p.width){l.width=p.width}return l},Zoom:function(l,w,v,k,t){w.className="MathJax";w.style.fontSize=l.HTMLCSS.fontSize;var y=w.appendChild(this.EmExSpan.cloneNode(true));var o=y.lastChild.firstChild.offsetHeight/60;this.em=g.mbase.prototype.em=o;this.outerEm=o/l.HTMLCSS.scale;y.parentNode.removeChild(y);this.zoomScale=parseInt(b.config.menuSettings.zscale)/100;this.idPostfix="-zoom";l.root.toHTML(w,w);this.idPostfix="";this.zoomScale=1;var n=l.root.HTMLspanElement().bbox.width;if(n){w.style.width=Math.floor(k-1.5*d.em)+"px";w.style.display="inline-block";var m=(l.root.id||"MathJax-Span-"+l.root.spanID)+"-zoom";var p=document.getElementById(m).firstChild;while(p&&p.style.width!==n){p=p.nextSibling}if(p){var s=p.offsetWidth;p.style.width="100%";if(s>k){w.style.width=(s+100)+"px"}}}w.style.position="absolute";if(!n){v.style.position="absolute"}var u=w.offsetWidth,r=w.offsetHeight,x=v.offsetHeight,q=v.offsetWidth;if(q===0){q=v.parentNode.offsetWidth}w.style.position=v.style.position="";return{Y:-j.getBBox(w).h,mW:q,mH:x,zW:u,zH:r}},initImg:function(k){},initHTML:function(l,k){},initFont:function(k){var m=d.FONTDATA.FONTS,l=d.config.availableFonts;if(l&&l.length&&d.Font.testFont(m[k])){m[k].available=true;if(m[k].familyFixed){m[k].family=m[k].familyFixed;delete m[k].familyFixed}return null}if(!this.allowWebFonts){return null}m[k].isWebFont=true;if(d.FontFaceBug){m[k].family=k;if(d.msieFontCSSBug){m[k].family+="-Web"}}return h.Styles({"@font-face":this.Font.fontFace(k)})},Remove:function(k){var l=document.getElementById(k.inputID+"-Frame");if(l){if(k.HTMLCSS.display){l=l.parentNode}l.parentNode.removeChild(l)}delete k.HTMLCSS},getHD:function(l){var k=l.style.position;l.style.position="absolute";this.HDimg.style.height="0px";l.appendChild(this.HDspan);var m={h:l.offsetHeight};this.HDimg.style.height=m.h+"px";m.d=l.offsetHeight-m.h;m.h-=m.d;m.h/=this.em;m.d/=this.em;l.removeChild(this.HDspan);l.style.position=k;return m},getW:function(o){var l,n,m=(o.bbox||{}).w,p=o;if(o.bbox&&o.bbox.exactW){return m}if((o.bbox&&m>=0&&!this.initialSkipBug&&!this.msieItalicWidthBug)||this.negativeBBoxes||!o.firstChild){l=o.offsetWidth;n=o.parentNode.offsetHeight}else{if(o.bbox&&m<0&&this.msieNegativeBBoxBug){l=-o.offsetWidth,n=o.parentNode.offsetHeight}else{var k=o.style.position;o.style.position="absolute";p=this.startMarker;o.insertBefore(p,o.firstChild);o.appendChild(this.endMarker);l=this.endMarker.offsetLeft-p.offsetLeft;o.removeChild(this.endMarker);o.removeChild(p);o.style.position=k}}if(n!=null){o.parentNode.HH=n/this.em}return l/this.em},Measured:function(m,l){var n=m.bbox;if(n.width==null&&n.w&&!n.isMultiline){var k=this.getW(m);n.rw+=k-n.w;n.w=k;n.exactW=true}if(!l){l=m.parentNode}if(!l.bbox){l.bbox=n}return m},Remeasured:function(l,k){k.bbox=this.Measured(l,k).bbox},MeasureSpans:function(o){var r=[],t,q,n,u,k,p,l,s;for(q=0,n=o.length;q<n;q++){t=o[q];if(!t){continue}u=t.bbox;s=this.parentNode(t);if(u.exactW||u.width||u.w===0||u.isMultiline){if(!s.bbox){s.bbox=u}continue}if(this.negativeBBoxes||!t.firstChild||(u.w>=0&&!this.initialSkipBug)||(u.w<0&&this.msieNegativeBBoxBug)){r.push([t])}else{if(this.initialSkipBug){k=this.startMarker.cloneNode(true);p=this.endMarker.cloneNode(true);t.insertBefore(k,t.firstChild);t.appendChild(p);r.push([t,k,p,t.style.position]);t.style.position="absolute"}else{p=this.endMarker.cloneNode(true);t.appendChild(p);r.push([t,null,p])}}}for(q=0,n=r.length;q<n;q++){t=r[q][0];u=t.bbox;s=this.parentNode(t);if((u.w>=0&&!this.initialSkipBug)||this.negativeBBoxes||!t.firstChild){l=t.offsetWidth;s.HH=s.offsetHeight/this.em}else{if(u.w<0&&this.msieNegativeBBoxBug){l=-t.offsetWidth,s.HH=s.offsetHeight/this.em}else{l=r[q][2].offsetLeft-((r[q][1]||{}).offsetLeft||0)}}l/=this.em;u.rw+=l-u.w;u.w=l;u.exactW=true;if(!s.bbox){s.bbox=u}}for(q=0,n=r.length;q<n;q++){t=r[q];if(t[1]){t[1].parentNode.removeChild(t[1]),t[0].style.position=t[3]}if(t[2]){t[2].parentNode.removeChild(t[2])}}},Em:function(k){if(Math.abs(k)<0.0006){return"0em"}return k.toFixed(3).replace(/\.?0+$/,"")+"em"},EmRounded:function(k){k=(Math.round(k*d.em)+0.05)/d.em;if(Math.abs(k)<0.0006){return"0em"}return k.toFixed(3).replace(/\.?0+$/,"")+"em"},unEm:function(k){return parseFloat(k)},Px:function(k){k*=this.em;var l=(k<0?"-":"");return l+Math.abs(k).toFixed(1).replace(/\.?0+$/,"")+"px"},unPx:function(k){return parseFloat(k)/this.em},Percent:function(k){return(100*k).toFixed(1).replace(/\.?0+$/,"")+"%"},length2em:function(r,l,p){if(typeof(r)!=="string"){r=r.toString()}if(r===""){return""}if(r===g.SIZE.NORMAL){return 1}if(r===g.SIZE.BIG){return 2}if(r===g.SIZE.SMALL){return 0.71}if(r==="infinity"){return d.BIGDIMEN}var o=this.FONTDATA.TeX_factor,s=(d.zoomScale||1)/d.em;if(r.match(/mathspace$/)){return d.MATHSPACE[r]*o}var n=r.match(/^\s*([-+]?(?:\.\d+|\d+(?:\.\d*)?))?(pt|em|ex|mu|px|pc|in|mm|cm|%)?/);var k=parseFloat(n[1]||"1"),q=n[2];if(p==null){p=1}if(l==null){l=1}if(q==="em"){return k*o}if(q==="ex"){return k*d.TeX.x_height*o}if(q==="%"){return k/100*p}if(q==="px"){return k*s}if(q==="pt"){return k/10*o}if(q==="pc"){return k*1.2*o}if(q==="in"){return k*this.pxPerInch*s}if(q==="cm"){return k*this.pxPerInch*s/2.54}if(q==="mm"){return k*this.pxPerInch*s/25.4}if(q==="mu"){return k/18*o*l}return k*p},thickness2em:function(l,k){var m=d.TeX.rule_thickness;if(l===g.LINETHICKNESS.MEDIUM){return m}if(l===g.LINETHICKNESS.THIN){return 0.67*m}if(l===g.LINETHICKNESS.THICK){return 1.67*m}return this.length2em(l,k,m)},getPadding:function(l){var n={top:0,right:0,bottom:0,left:0},k=false;for(var o in n){if(n.hasOwnProperty(o)){var m=l.style["padding"+o.charAt(0).toUpperCase()+o.substr(1)];if(m){n[o]=this.length2em(m);k=true}}}return(k?n:false)},getBorders:function(p){var m={top:0,right:0,bottom:0,left:0},n={},l=false;for(var q in m){if(m.hasOwnProperty(q)){var k="border"+q.charAt(0).toUpperCase()+q.substr(1);var o=p.style[k+"Style"];if(o){l=true;m[q]=this.length2em(p.style[k+"Width"]);n[k]=[p.style[k+"Width"],p.style[k+"Style"],p.style[k+"Color"]].join(" ")}}}m.css=n;return(l?m:false)},setBorders:function(k,l){if(l){for(var m in l.css){if(l.css.hasOwnProperty(m)){k.style[m]=l.css[m]}}}},createStrut:function(m,l,n){var k=this.Element("span",{isMathJax:true,style:{display:"inline-block",overflow:"hidden",height:l+"px",width:"1px",marginRight:"-1px"}});if(n){m.insertBefore(k,m.firstChild)}else{m.appendChild(k)}return k},createBlank:function(l,k,m){var n=this.Element("span",{isMathJax:true,style:{display:"inline-block",overflow:"hidden",height:"1px",width:this.Em(k)}});if(m){l.insertBefore(n,l.firstChild)}else{l.appendChild(n)}return n},createShift:function(l,k,n){var m=this.Element("span",{style:{marginLeft:this.Em(k)},isMathJax:true});if(n){l.insertBefore(m,l.firstChild)}else{l.appendChild(m)}return m},createSpace:function(p,n,o,q,m,s){if(n<-o){o=-n}var r=this.Em(n+o),k=this.Em(-o);if(this.msieInlineBlockAlignBug){k=this.Em(d.getHD(p.parentNode).d-o)}if(p.isBox||s){var l=(p.scale==null?1:p.scale);p.bbox={exactW:true,h:n*l,d:o*l,w:q*l,rw:q*l,lw:0};p.style.height=r;p.style.verticalAlign=k;p.HH=(n+o)*l}else{p=this.addElement(p,"span",{style:{height:r,verticalAlign:k},isMathJax:true})}if(q>=0){p.style.width=this.Em(q);p.style.display="inline-block";p.style.overflow="hidden"}else{if(this.msieNegativeSpaceBug){p.style.height=""}p.style.marginLeft=this.Em(q);if(d.safariNegativeSpaceBug&&p.parentNode.firstChild==p){this.createBlank(p,0,true)}}if(m&&m!==g.COLOR.TRANSPARENT){p.style.backgroundColor=m;p.style.position="relative"}return p},createRule:function(r,n,p,s,l){if(n<-p){p=-n}var m=d.TeX.min_rule_thickness,o=1;if(s>0&&s*this.em<m){s=m/this.em}if(n+p>0&&(n+p)*this.em<m){o=1/(n+p)*(m/this.em);n*=o;p*=o}if(!l){l="solid"}else{l="solid "+l}l=this.Em(s)+" "+l;var t=(o===1?this.Em(n+p):m+"px"),k=this.Em(-p);var q=this.addElement(r,"span",{style:{borderLeft:l,display:"inline-block",overflow:"hidden",width:0,height:t,verticalAlign:k},bbox:{h:n,d:p,w:s,rw:s,lw:0,exactW:true},noAdjust:true,HH:n+p,isMathJax:true});if(s>0&&q.offsetWidth==0){q.style.width=this.Em(s)}if(r.isBox||r.className=="mspace"){r.bbox=q.bbox,r.HH=n+p}return q},createFrame:function(s,q,r,u,x,l){if(q<-r){r=-q}var p=2*x;if(this.msieFrameSizeBug){if(u<p){u=p}if(q+r<p){q=p-r}}if(this.msieBorderWidthBug){p=0}var v=this.Em(q+r-p),k=this.Em(-r-x),o=this.Em(u-p);var m=this.Em(x)+" "+l;var n=this.addElement(s,"span",{style:{border:m,display:"inline-block",overflow:"hidden",width:o,height:v},bbox:{h:q,d:r,w:u,rw:u,lw:0,exactW:true},noAdjust:true,HH:q+r,isMathJax:true});if(k){n.style.verticalAlign=k}return n},parentNode:function(l){var k=l.parentNode;if(k.nodeName.toLowerCase()==="a"){k=k.parentNode}return k},createStack:function(m,o,l){if(this.msiePaddingWidthBug){this.createStrut(m,0)}var n=String(l).match(/%$/);var k=(!n&&l!=null?l:0);m=this.addElement(m,"span",{noAdjust:true,HH:0,isMathJax:true,style:{display:"inline-block",position:"relative",width:(n?"100%":this.Em(k)),height:0}});if(!o){m.parentNode.bbox=m.bbox={exactW:true,h:-this.BIGDIMEN,d:-this.BIGDIMEN,w:k,lw:this.BIGDIMEN,rw:(!n&&l!=null?l:-this.BIGDIMEN)};if(n){m.bbox.width=l}}return m},createBox:function(l,k){var m=this.addElement(l,"span",{style:{position:"absolute"},isBox:true,isMathJax:true});if(k!=null){m.style.width=k}return m},addBox:function(k,l){l.style.position="absolute";l.isBox=l.isMathJax=true;return k.appendChild(l)},placeBox:function(u,s,q,o){u.isMathJax=true;var v=d.parentNode(u),C=u.bbox,z=v.bbox;if(this.msiePlaceBoxBug){this.addText(u,this.NBSP)}if(this.imgSpaceBug){this.addText(u,this.imgSpace)}var w,F=0;if(u.HH!=null){w=u.HH}else{if(C){w=Math.max(3,C.h+C.d)}else{w=u.offsetHeight/this.em}}if(!u.noAdjust){w+=1;w=Math.round(w*this.em)/this.em;if(this.msieInlineBlockAlignBug){this.addElement(u,"img",{className:"MathJax_strut",border:0,src:"about:blank",isMathJax:true,style:{width:0,height:this.Em(w)}})}else{this.addElement(u,"span",{isMathJax:true,style:{display:"inline-block",width:0,height:this.Em(w)}});if(d.chromeHeightBug){w-=(u.lastChild.offsetHeight-Math.round(w*this.em))/this.em}}}if(C){if(this.initialSkipBug){if(C.lw<0){F=C.lw;d.createBlank(u,-F,true)}if(C.rw>C.w){d.createBlank(u,C.rw-C.w+0.1)}}if(!this.msieClipRectBug&&!C.noclip&&!o){var B=3/this.em;var A=(C.H==null?C.h:C.H),m=(C.D==null?C.d:C.D);var E=w-A-B,p=w+m+B,n=C.lw-3*B,k=1000;if(this.initialSkipBug&&C.lw<0){n=-3*B}if(C.isFixed){k=C.width-n}u.style.clip="rect("+this.Em(E)+" "+this.Em(k)+" "+this.Em(p)+" "+this.Em(n)+")"}}u.style.top=this.Em(-q-w);u.style.left=this.Em(s+F);if(C&&z){if(C.H!=null&&(z.H==null||C.H+q>z.H)){z.H=C.H+q}if(C.D!=null&&(z.D==null||C.D-q>z.D)){z.D=C.D-q}if(C.h+q>z.h){z.h=C.h+q}if(C.d-q>z.d){z.d=C.d-q}if(z.H!=null&&z.H<=z.h){delete z.H}if(z.D!=null&&z.D<=z.d){delete z.D}if(C.w+s>z.w){z.w=C.w+s;if(z.width==null){v.style.width=this.Em(z.w)}}if(C.rw+s>z.rw){z.rw=C.rw+s}if(C.lw+s<z.lw){z.lw=C.lw+s}if(C.width!=null&&!C.isFixed){if(z.width==null){v.style.width=z.width="100%";if(C.minWidth){v.style.minWidth=z.minWidth=C.minWidth}}u.style.width=C.width}}},alignBox:function(s,o,q){this.placeBox(s,0,q);if(this.msiePlaceBoxBug){var m=s.lastChild;while(m&&m.nodeName!=="#text"){m=m.previousSibling}if(m){s.removeChild(m)}}var u=s.bbox;if(u.isMultiline){return}var t=u.width!=null&&!u.isFixed;var k=0,p=-u.w/2,n="50%";if(this.initialSkipBug){k=u.w-u.rw-0.1;p+=u.lw}if(this.msieMarginScaleBug){p=(p*this.em)+"px"}else{p=this.Em(p)}if(t){p="";n=(50-parseFloat(u.width)/2)+"%"}b.Insert(s.style,({right:{left:"",right:this.Em(k)},center:{left:n,marginLeft:p}})[o])},setStackWidth:function(l,k){if(typeof(k)==="number"){l.style.width=this.Em(Math.max(0,k));var m=l.bbox;if(m){m.w=k;m.exactW=true}m=l.parentNode.bbox;if(m){m.w=k;m.exactW=true}}else{l.style.width=l.parentNode.style.width="100%";if(l.bbox){l.bbox.width=k}if(l.parentNode.bbox){l.parentNode.bbox.width=k}}},createDelimiter:function(u,k,n,q,o){if(!k){u.bbox={h:0,d:0,w:this.TeX.nulldelimiterspace,lw:0};u.bbox.rw=u.bbox.w;this.createSpace(u,u.bbox.h,u.bbox.d,u.bbox.w);return}if(!q){q=1}if(!(n instanceof Array)){n=[n,n]}var t=n[1];n=n[0];var l={alias:k};while(l.alias){k=l.alias;l=this.FONTDATA.DELIMITERS[k];if(!l){l={HW:[0,this.FONTDATA.VARIANT[g.VARIANT.NORMAL]]}}}if(l.load){b.RestartAfter(h.Require(this.fontDir+"/fontdata-"+l.load+".js"))}for(var s=0,p=l.HW.length;s<p;s++){if(l.HW[s][0]*q>=n-0.01||(s==p-1&&!l.stretch)){if(l.HW[s][2]){q*=l.HW[s][2]}if(l.HW[s][3]){k=l.HW[s][3]}var r=this.addElement(u,"span");this.createChar(r,[k,l.HW[s][1]],q,o);u.bbox=r.bbox;u.offset=0.65*u.bbox.w;u.scale=q;return}}if(l.stretch){this["extendDelimiter"+l.dir](u,t,l.stretch,q,o)}},extendDelimiterV:function(A,t,E,F,w){var o=this.createStack(A,true);var v=this.createBox(o),u=this.createBox(o);this.createChar(v,(E.top||E.ext),F,w);this.createChar(u,(E.bot||E.ext),F,w);var m={bbox:{w:0,lw:0,rw:0}},D=m,p;var B=v.bbox.h+v.bbox.d+u.bbox.h+u.bbox.d;var r=-v.bbox.h;this.placeBox(v,0,r,true);r-=v.bbox.d;if(E.mid){D=this.createBox(o);this.createChar(D,E.mid,F,w);B+=D.bbox.h+D.bbox.d}if(E.min&&t<B*E.min){t=B*E.min}if(t>B){m=this.Element("span");this.createChar(m,E.ext,F,w);var C=m.bbox.h+m.bbox.d,l=C-0.05,x,q,z=(E.mid?2:1);q=x=Math.min(Math.ceil((t-B)/(z*l)),this.maxStretchyParts);if(!E.fullExtenders){l=(t-B)/(z*x)}var s=(x/(x+1))*(C-l);l=C-s;r+=s+l-m.bbox.h;while(z-->0){while(x-->0){if(!this.msieCloneNodeBug){p=m.cloneNode(true)}else{p=this.Element("span");this.createChar(p,E.ext,F,w)}p.bbox=m.bbox;r-=l;this.placeBox(this.addBox(o,p),0,r,true)}r+=s-m.bbox.d;if(E.mid&&z){this.placeBox(D,0,r-D.bbox.h,true);x=q;r+=-(D.bbox.h+D.bbox.d)+s+l-m.bbox.h}}}else{r+=(B-t)/2;if(E.mid){this.placeBox(D,0,r-D.bbox.h,true);r+=-(D.bbox.h+D.bbox.d)}r+=(B-t)/2}this.placeBox(u,0,r-u.bbox.h,true);r-=u.bbox.h+u.bbox.d;A.bbox={w:Math.max(v.bbox.w,m.bbox.w,u.bbox.w,D.bbox.w),lw:Math.min(v.bbox.lw,m.bbox.lw,u.bbox.lw,D.bbox.lw),rw:Math.max(v.bbox.rw,m.bbox.rw,u.bbox.rw,D.bbox.rw),h:0,d:-r,exactW:true};A.scale=F;A.offset=0.55*A.bbox.w;A.isMultiChar=true;this.setStackWidth(o,A.bbox.w)},extendDelimiterH:function(B,o,E,G,y){var r=this.createStack(B,true);var p=this.createBox(r),C=this.createBox(r);this.createChar(p,(E.left||E.rep),G,y);this.createChar(C,(E.right||E.rep),G,y);var l=this.Element("span");this.createChar(l,E.rep,G,y);var D={bbox:{h:-this.BIGDIMEN,d:-this.BIGDIMEN}},m;this.placeBox(p,-p.bbox.lw,0,true);var u=(p.bbox.rw-p.bbox.lw)+(C.bbox.rw-C.bbox.lw)-0.05,t=p.bbox.rw-p.bbox.lw-0.025,v;if(E.mid){D=this.createBox(r);this.createChar(D,E.mid,G,y);u+=D.bbox.w}if(E.min&&o<u*E.min){o=u*E.min}if(o>u){var F=l.bbox.rw-l.bbox.lw,q=F-0.05,z,s,A=(E.mid?2:1);s=z=Math.min(Math.ceil((o-u)/(A*q)),this.maxStretchyParts);if(!E.fillExtenders){q=(o-u)/(A*z)}v=(z/(z+1))*(F-q);q=F-v;t-=l.bbox.lw+v;while(A-->0){while(z-->0){if(!this.cloneNodeBug){m=l.cloneNode(true)}else{m=this.Element("span");this.createChar(m,E.rep,G,y)}m.bbox=l.bbox;this.placeBox(this.addBox(r,m),t,0,true);t+=q}if(E.mid&&A){this.placeBox(D,t,0,true);t+=D.bbox.w-v;z=s}}}else{t-=(u-o)/2;if(E.mid){this.placeBox(D,t,0,true);t+=D.bbox.w}t-=(u-o)/2}this.placeBox(C,t,0,true);B.bbox={w:t+C.bbox.rw,lw:0,rw:t+C.bbox.rw,H:Math.max(p.bbox.h,l.bbox.h,C.bbox.h,D.bbox.h),D:Math.max(p.bbox.d,l.bbox.d,C.bbox.d,D.bbox.d),h:l.bbox.h,d:l.bbox.d,exactW:true};B.scale=G;B.isMultiChar=true;this.setStackWidth(r,B.bbox.w)},createChar:function(s,p,n,k){s.isMathJax=true;var r=s,t="",o={fonts:[p[1]],noRemap:true};if(k&&k===g.VARIANT.BOLD){o.fonts=[p[1]+"-bold",p[1]]}if(typeof(p[1])!=="string"){o=p[1]}if(p[0] instanceof Array){for(var q=0,l=p[0].length;q<l;q++){t+=String.fromCharCode(p[0][q])}}else{t=String.fromCharCode(p[0])}if(p[4]){n*=p[4]}if(n!==1||p[3]){r=this.addElement(s,"span",{style:{fontSize:this.Percent(n)},scale:n,isMathJax:true});this.handleVariant(r,o,t);s.bbox=r.bbox}else{this.handleVariant(s,o,t)}if(p[2]){s.style.marginLeft=this.Em(p[2])}if(p[3]){s.firstChild.style.verticalAlign=this.Em(p[3]);s.bbox.h+=p[3];if(s.bbox.h<0){s.bbox.h=0}}if(p[5]){s.bbox.h+=p[5]}if(p[6]){s.bbox.d+=p[6]}if(this.AccentBug&&s.bbox.w===0){r.firstChild.nodeValue+=this.NBSP}},positionDelimiter:function(l,k){k-=l.bbox.h;l.bbox.d-=k;l.bbox.h+=k;if(k){if(this.safariVerticalAlignBug||this.konquerorVerticalAlignBug||(this.operaVerticalAlignBug&&l.isMultiChar)){if(l.firstChild.style.display===""&&l.style.top!==""){l=l.firstChild;k-=d.unEm(l.style.top)}l.style.position="relative";l.style.top=this.Em(-k)}else{l.style.verticalAlign=this.Em(k);if(d.ffVerticalAlignBug){d.createRule(l.parentNode,l.bbox.h,0,0);delete l.parentNode.bbox}}}},handleVariant:function(z,o,r){var y="",w,B,s,C,k=z,l=!!z.style.fontFamily;if(r.length===0){return}if(!z.bbox){z.bbox={w:0,h:-this.BIGDIMEN,d:-this.BIGDIMEN,rw:-this.BIGDIMEN,lw:this.BIGDIMEN}}if(!o){o=this.FONTDATA.VARIANT[g.VARIANT.NORMAL]}C=o;for(var A=0,x=r.length;A<x;A++){o=C;w=r.charCodeAt(A);B=r.charAt(A);if(w>=55296&&w<56319){A++;w=(((w-55296)<<10)+(r.charCodeAt(A)-56320))+65536;if(this.FONTDATA.RemapPlane1){var D=this.FONTDATA.RemapPlane1(w,o);w=D.n;o=D.variant}}else{var t,q,u=this.FONTDATA.RANGES;for(t=0,q=u.length;t<q;t++){if(u[t].name==="alpha"&&o.noLowerCase){continue}var p=o["offset"+u[t].offset];if(p&&w>=u[t].low&&w<=u[t].high){if(u[t].remap&&u[t].remap[w]){w=p+u[t].remap[w]}else{w=w-u[t].low+p;if(u[t].add){w+=u[t].add}}if(o["variant"+u[t].offset]){o=this.FONTDATA.VARIANT[o["variant"+u[t].offset]]}break}}}if(o.remap&&o.remap[w]){w=o.remap[w];if(o.remap.variant){o=this.FONTDATA.VARIANT[o.remap.variant]}}else{if(this.FONTDATA.REMAP[w]&&!o.noRemap){w=this.FONTDATA.REMAP[w]}}if(w instanceof Array){o=this.FONTDATA.VARIANT[w[1]];w=w[0]}if(typeof(w)==="string"){r=w+r.substr(A+1);x=r.length;A=-1;continue}s=this.lookupChar(o,w);B=s[w];if(l||(!this.checkFont(s,k.style)&&!B[5].img)){if(y.length){this.addText(k,y);y=""}var v=!!k.style.fontFamily||!!z.style.fontStyle||!!z.style.fontWeight||!s.directory||l;l=false;if(k!==z){v=!this.checkFont(s,z.style);k=z}if(v){k=this.addElement(z,"span",{isMathJax:true,subSpan:true})}this.handleFont(k,s,k!==z)}y=this.handleChar(k,s,B,w,y);if(!(B[5]||{}).space){if(B[0]/1000>z.bbox.h){z.bbox.h=B[0]/1000}if(B[1]/1000>z.bbox.d){z.bbox.d=B[1]/1000}}if(z.bbox.w+B[3]/1000<z.bbox.lw){z.bbox.lw=z.bbox.w+B[3]/1000}if(z.bbox.w+B[4]/1000>z.bbox.rw){z.bbox.rw=z.bbox.w+B[4]/1000}z.bbox.w+=B[2]/1000}if(y.length){this.addText(k,y)}if(z.scale&&z.scale!==1){z.bbox.h*=z.scale;z.bbox.d*=z.scale;z.bbox.w*=z.scale;z.bbox.lw*=z.scale;z.bbox.rw*=z.scale}if(r.length==1&&s.skew&&s.skew[w]){z.bbox.skew=s.skew[w]}},checkFont:function(k,l){var m=(l.fontWeight||"normal");if(m.match(/^\d+$/)){m=(parseInt(m)>=600?"bold":"normal")}return(k.family.replace(/'/g,"")===l.fontFamily.replace(/'/g,"")&&(k.style||"normal")===(l.fontStyle||"normal")&&(k.weight||"normal")===m)},handleFont:function(m,k,o){m.style.fontFamily=k.family;if(!k.directory){m.style.fontSize=Math.floor(100/d.scale+0.5)+"%"}if(!(d.FontFaceBug&&k.isWebFont)){var l=k.style||"normal",n=k.weight||"normal";if(l!=="normal"||o){m.style.fontStyle=l}if(n!=="normal"||o){m.style.fontWeight=n}}},handleChar:function(l,k,s,r,q){var p=s[5];if(p.space){if(q.length){this.addText(l,q)}d.createShift(l,s[2]/1000);return""}if(p.img){return this.handleImg(l,k,s,r,q)}if(p.isUnknown&&this.FONTDATA.DELIMITERS[r]){if(q.length){this.addText(l,q)}var o=l.scale;d.createDelimiter(l,r,0,1,k);if(this.FONTDATA.DELIMITERS[r].dir==="V"){l.style.verticalAlign=this.Em(l.bbox.d);l.bbox.h+=l.bbox.d;l.bbox.d=0}l.scale=o;s[0]=l.bbox.h*1000;s[1]=l.bbox.d*1000;s[2]=l.bbox.w*1000;s[3]=l.bbox.lw*1000;s[4]=l.bbox.rw*1000;return""}if(p.c==null){if(r<=65535){p.c=String.fromCharCode(r)}else{var m=r-65536;p.c=String.fromCharCode((m>>10)+55296)+String.fromCharCode((m&1023)+56320)}}if(p.rfix){this.addText(l,q+p.c);d.createShift(l,p.rfix/1000);return""}if(s[2]||!this.msieAccentBug||q.length){return q+p.c}d.createShift(l,s[3]/1000);d.createShift(l,(s[4]-s[3])/1000);this.addText(l,p.c);d.createShift(l,-s[4]/1000);return""},handleImg:function(l,k,p,o,m){return m},lookupChar:function(p,s){var o,k;if(!p.FONTS){var r=this.FONTDATA.FONTS;var q=(p.fonts||this.FONTDATA.VARIANT.normal.fonts);if(!(q instanceof Array)){q=[q]}if(p.fonts!=q){p.fonts=q}p.FONTS=[];for(o=0,k=q.length;o<k;o++){if(r[q[o]]){p.FONTS.push(r[q[o]]);r[q[o]].name=q[o]}}}for(o=0,k=p.FONTS.length;o<k;o++){var l=p.FONTS[o];if(typeof(l)==="string"){delete p.FONTS;this.loadFont(l)}if(l[s]){if(l[s].length===5){l[s][5]={}}if(d.allowWebFonts&&!l.available){this.loadWebFont(l)}else{return l}}else{this.findBlock(l,s)}}return this.unknownChar(p,s)},unknownChar:function(k,m){var l=(k.defaultFont||{family:d.config.undefinedFamily});if(k.bold){l.weight="bold"}if(k.italic){l.style="italic"}if(!l[m]){l[m]=[800,200,500,0,500,{isUnknown:true}]}b.signal.Post(["HTML-CSS Jax - unknown char",m,k]);return l},findBlock:function(l,q){if(l.Ranges){for(var p=0,k=l.Ranges.length;p<k;p++){if(q<l.Ranges[p][0]){return}if(q<=l.Ranges[p][1]){var o=l.Ranges[p][2];for(var n=l.Ranges.length-1;n>=0;n--){if(l.Ranges[n][2]==o){l.Ranges.splice(n,1)}}this.loadFont(l.directory+"/"+o+".js")}}}},loadFont:function(l){var k=MathJax.Callback.Queue();k.Push(["Require",h,this.fontDir+"/"+l]);if(this.imgFonts){if(!MathJax.isPacked){l=l.replace(/\/([^\/]*)$/,d.imgPacked+"/$1")}k.Push(["Require",h,this.webfontDir+"/png/"+l])}b.RestartAfter(k.Push({}))},loadWebFont:function(k){k.available=k.isWebFont=true;if(d.FontFaceBug){k.family=k.name;if(d.msieFontCSSBug){k.family+="-Web"}}b.RestartAfter(this.Font.loadWebFont(k))},loadWebFontError:function(l,k){b.Startup.signal.Post("HTML-CSS Jax - disable web fonts");l.isWebFont=false;if(this.config.imageFont&&this.config.imageFont===this.fontInUse){this.imgFonts=true;b.Startup.signal.Post("HTML-CSS Jax - switch to image fonts");b.Startup.signal.Post("HTML-CSS Jax - using image fonts");e(["WebFontNotAvailable","Web-Fonts not available -- using image fonts instead"],null,3000);h.Require(this.directory+"/imageFonts.js",k)}else{this.allowWebFonts=false;k()}},Element:MathJax.HTML.Element,addElement:MathJax.HTML.addElement,TextNode:MathJax.HTML.TextNode,addText:MathJax.HTML.addText,ucMatch:MathJax.HTML.ucMatch,BIGDIMEN:10000000,ID:0,idPostfix:"",GetID:function(){this.ID++;return this.ID},MATHSPACE:{veryverythinmathspace:1/18,verythinmathspace:2/18,thinmathspace:3/18,mediummathspace:4/18,thickmathspace:5/18,verythickmathspace:6/18,veryverythickmathspace:7/18,negativeveryverythinmathspace:-1/18,negativeverythinmathspace:-2/18,negativethinmathspace:-3/18,negativemediummathspace:-4/18,negativethickmathspace:-5/18,negativeverythickmathspace:-6/18,negativeveryverythickmathspace:-7/18},TeX:{x_height:0.430554,quad:1,num1:0.676508,num2:0.393732,num3:0.44373,denom1:0.685951,denom2:0.344841,sup1:0.412892,sup2:0.362892,sup3:0.288888,sub1:0.15,sub2:0.247217,sup_drop:0.386108,sub_drop:0.05,delim1:2.39,delim2:1,axis_height:0.25,rule_thickness:0.06,big_op_spacing1:0.111111,big_op_spacing2:0.166666,big_op_spacing3:0.2,big_op_spacing4:0.6,big_op_spacing5:0.1,scriptspace:0.1,nulldelimiterspace:0.12,delimiterfactor:901,delimitershortfall:0.1,min_rule_thickness:1.25},NBSP:"\u00A0",rfuzz:0});MathJax.Hub.Register.StartupHook("mml Jax Ready",function(){g=MathJax.ElementJax.mml;g.mbase.Augment({toHTML:function(o){o=this.HTMLcreateSpan(o);if(this.type!="mrow"){o=this.HTMLhandleSize(o)}for(var l=0,k=this.data.length;l<k;l++){if(this.data[l]){this.data[l].toHTML(o)}}var s=this.HTMLcomputeBBox(o);var n=o.bbox.h,r=o.bbox.d,p=false;for(l=0,k=s.length;l<k;l++){var q=s[l].HTMLspanElement().bbox;if(s[l].forceStretch||q.h!==n||q.d!==r){s[l].HTMLstretchV(o,n,r);p=true}}if(p){this.HTMLcomputeBBox(o,true)}if(this.HTMLlineBreaks(o)){o=this.HTMLmultiline(o)}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);return o},HTMLlineBreaks:function(){return false},HTMLmultiline:function(){g.mbase.HTMLautoloadFile("multiline")},HTMLcomputeBBox:function(q,p,o,k){if(o==null){o=0}if(k==null){k=this.data.length}var n=q.bbox={exactW:true},r=[];while(o<k){var l=this.data[o];if(!l){continue}if(!p&&l.HTMLcanStretch("Vertical")){r.push(l);l=(l.CoreMO()||l)}this.HTMLcombineBBoxes(l,n);o++}this.HTMLcleanBBox(n);return r},HTMLcombineBBoxes:function(k,l){if(l.w==null){this.HTMLemptyBBox(l)}var n=(k.bbox?k:k.HTMLspanElement());if(!n||!n.bbox){return}var m=n.bbox;if(m.d>l.d){l.d=m.d}if(m.h>l.h){l.h=m.h}if(m.D!=null&&m.D>l.D){l.D=m.D}if(m.H!=null&&m.H>l.H){l.H=m.H}if(n.style.paddingLeft){l.w+=d.unEm(n.style.paddingLeft)*(n.scale||1)}if(l.w+m.lw<l.lw){l.lw=l.w+m.lw}if(l.w+m.rw>l.rw){l.rw=l.w+m.rw}l.w+=m.w;if(n.style.paddingRight){l.w+=d.unEm(n.style.paddingRight)*(n.scale||1)}if(m.width){l.width=m.width;l.minWidth=m.minWidth}if(m.ic){l.ic=m.ic}else{delete l.ic}if(l.exactW&&!m.exactW){delete l.exactW}},HTMLemptyBBox:function(k){k.h=k.d=k.H=k.D=k.rw=-d.BIGDIMEN;k.w=0;k.lw=d.BIGDIMEN;return k},HTMLcleanBBox:function(k){if(k.h===this.BIGDIMEN){k.h=k.d=k.H=k.D=k.w=k.rw=k.lw=0}if(k.D<=k.d){delete k.D}if(k.H<=k.h){delete k.H}},HTMLzeroBBox:function(){return{h:0,d:0,w:0,lw:0,rw:0}},HTMLcanStretch:function(l){if(this.isEmbellished()){var k=this.Core();if(k&&k!==this){return k.HTMLcanStretch(l)}}return false},HTMLstretchH:function(l,k){return this.HTMLspanElement()},HTMLstretchV:function(l,k,m){return this.HTMLspanElement()},HTMLnotEmpty:function(k){while(k){if((k.type!=="mrow"&&k.type!=="texatom")||k.data.length>1){return true}k=k.data[0]}return false},HTMLmeasureChild:function(l,k){if(this.data[l]){d.Measured(this.data[l].toHTML(k),k)}else{k.bbox=this.HTMLzeroBBox()}},HTMLboxChild:function(l,k){if(!this.data[l]){this.SetData(l,g.mrow())}return this.data[l].toHTML(k)},HTMLcreateSpan:function(k){if(this.spanID){var l=this.HTMLspanElement();if(l&&(l.parentNode===k||(l.parentNode||{}).parentNode===k)){while(l.firstChild){l.removeChild(l.firstChild)}l.bbox=this.HTMLzeroBBox();l.scale=1;l.isMultChar=l.HH=null;l.style.cssText="";return l}}if(this.href){k=d.addElement(k,"a",{href:this.href,isMathJax:true})}k=d.addElement(k,"span",{className:this.type,isMathJax:true});if(d.imgHeightBug){k.style.display="inline-block"}if(this["class"]){k.className+=" "+this["class"]}if(!this.spanID){this.spanID=d.GetID()}k.id=(this.id||"MathJax-Span-"+this.spanID)+d.idPostfix;k.bbox=this.HTMLzeroBBox();this.styles={};if(this.style){k.style.cssText=this.style;if(k.style.fontSize){this.mathsize=k.style.fontSize;k.style.fontSize=""}this.styles={border:d.getBorders(k),padding:d.getPadding(k)};if(this.styles.border){k.style.border=""}if(this.styles.padding){k.style.padding=""}}if(this.href){k.parentNode.bbox=k.bbox}return k},HTMLspanElement:function(){if(!this.spanID){return null}return document.getElementById((this.id||"MathJax-Span-"+this.spanID)+d.idPostfix)},HTMLhandleVariant:function(l,k,m){d.handleVariant(l,k,m)},HTMLhandleSize:function(k){if(!k.scale){k.scale=this.HTMLgetScale();if(k.scale!==1){k.style.fontSize=d.Percent(k.scale)}}return k},HTMLhandleDir:function(l){var k=this.Get("dir",true);if(k){l.dir=k}return l},HTMLhandleColor:function(w){var y=this.getValues("mathcolor","color");if(this.mathbackground){y.mathbackground=this.mathbackground}if(this.background){y.background=this.background}if(this.style&&w.style.backgroundColor){y.mathbackground=w.style.backgroundColor;w.style.backgroundColor="transparent"}var t=(this.styles||{}).border,v=(this.styles||{}).padding;if(y.color&&!this.mathcolor){y.mathcolor=y.color}if(y.background&&!this.mathbackground){y.mathbackground=y.background}if(y.mathcolor){w.style.color=y.mathcolor}if((y.mathbackground&&y.mathbackground!==g.COLOR.TRANSPARENT)||t||v){var A=w.bbox,z=(A.exact?0:1/d.em),u=0,s=0,m=w.style.paddingLeft,q=w.style.paddingRight;if(this.isToken){u=A.lw;s=A.rw-A.w}if(m!==""){u+=d.unEm(m)*(w.scale||1)}if(q!==""){s-=d.unEm(q)*(w.scale||1)}var l=(d.PaddingWidthBug||A.keepPadding||A.exactW?0:s-u);var o=Math.max(0,d.getW(w)+l);var x=A.h+A.d,k=-A.d,r=0,p=0;if(o>0){o+=2*z;u-=z}if(x>0){x+=2*z;k-=z}s=-o-u;if(t){s-=t.right;k-=t.bottom;r+=t.left;p+=t.right;A.h+=t.top;A.d+=t.bottom;A.w+=t.left+t.right;A.lw-=t.left;A.rw+=t.right}if(v){x+=v.top+v.bottom;o+=v.left+v.right;s-=v.right;k-=v.bottom;r+=v.left;p+=v.right;A.h+=v.top;A.d+=v.bottom;A.w+=v.left+v.right;A.lw-=v.left;A.rw+=v.right}if(p){w.style.paddingRight=d.Em(p)}var n=d.Element("span",{id:"MathJax-Color-"+this.spanID+d.idPostfix,isMathJax:true,style:{display:"inline-block",backgroundColor:y.mathbackground,width:d.Em(o),height:d.Em(x),verticalAlign:d.Em(k),marginLeft:d.Em(u),marginRight:d.Em(s)}});d.setBorders(n,t);if(A.width){n.style.width=A.width;n.style.marginRight="-"+A.width}if(d.msieInlineBlockAlignBug){n.style.position="relative";n.style.width=n.style.height=0;n.style.verticalAlign=n.style.marginLeft=n.style.marginRight="";n.style.border=n.style.padding="";if(t&&d.msieBorderWidthBug){x+=t.top+t.bottom;o+=t.left+t.right}n.style.width=d.Em(r+z);d.placeBox(d.addElement(n,"span",{noAdjust:true,isMathJax:true,style:{display:"inline-block",position:"absolute",overflow:"hidden",background:(y.mathbackground||"transparent"),width:d.Em(o),height:d.Em(x)}}),u,A.h+z);d.setBorders(n.firstChild,t)}w.parentNode.insertBefore(n,w);if(d.msieColorPositionBug){w.style.position="relative"}return n}return null},HTMLremoveColor:function(){var k=document.getElementById("MathJax-Color-"+this.spanID+d.idPostfix);if(k){k.parentNode.removeChild(k)}},HTMLhandleSpace:function(o){if(this.useMMLspacing){if(this.type!=="mo"){return}var m=this.getValues("scriptlevel","lspace","rspace");if(m.scriptlevel<=0||this.hasValue("lspace")||this.hasValue("rspace")){var l=this.HTMLgetMu(o);m.lspace=Math.max(0,d.length2em(m.lspace,l));m.rspace=Math.max(0,d.length2em(m.rspace,l));var k=this,n=this.Parent();while(n&&n.isEmbellished()&&n.Core()===k){k=n;n=n.Parent();o=k.HTMLspanElement()}if(m.lspace){o.style.paddingLeft=d.Em(m.lspace)}if(m.rspace){o.style.paddingRight=d.Em(m.rspace)}}}else{var p=this.texSpacing();if(p!==""){this.HTMLgetScale();p=d.length2em(p,this.scale)/(o.scale||1)*this.mscale;if(o.style.paddingLeft){p+=d.unEm(o.style.paddingLeft)}o.style.paddingLeft=d.Em(p)}}},HTMLgetScale:function(){if(this.scale){return this.scale*this.mscale}var m=1,k=this.getValues("scriptlevel","fontsize");k.mathsize=(this.isToken?this:this.Parent()).Get("mathsize");if(this.style){var l=this.HTMLspanElement();if(l.style.fontSize!=""){k.fontsize=l.style.fontSize}}if(k.fontsize&&!this.mathsize){k.mathsize=k.fontsize}if(k.scriptlevel!==0){if(k.scriptlevel>2){k.scriptlevel=2}m=Math.pow(this.Get("scriptsizemultiplier"),k.scriptlevel);k.scriptminsize=d.length2em(this.Get("scriptminsize"));if(m<k.scriptminsize){m=k.scriptminsize}}this.scale=m;this.mscale=d.length2em(k.mathsize);return m*this.mscale},HTMLgetMu:function(m){var k=1,l=this.getValues("scriptlevel","scriptsizemultiplier");if(m.scale&&m.scale!==1){k=1/m.scale}if(l.scriptlevel!==0){if(l.scriptlevel>2){l.scriptlevel=2}k=Math.sqrt(Math.pow(l.scriptsizemultiplier,l.scriptlevel))}return k},HTMLgetVariant:function(){var k=this.getValues("mathvariant","fontfamily","fontweight","fontstyle");k.hasVariant=this.Get("mathvariant",true);if(!k.hasVariant){k.family=k.fontfamily;k.weight=k.fontweight;k.style=k.fontstyle}if(this.style){var m=this.HTMLspanElement();if(!k.family&&m.style.fontFamily){k.family=m.style.fontFamily}if(!k.weight&&m.style.fontWeight){k.weight=m.style.fontWeight}if(!k.style&&m.style.fontStyle){k.style=m.style.fontStyle}}if(k.weight&&k.weight.match(/^\d+$/)){k.weight=(parseInt(k.weight)>600?"bold":"normal")}var l=k.mathvariant;if(this.variantForm){l="-"+d.fontInUse+"-variant"}if(k.family&&!k.hasVariant){if(!k.weight&&k.mathvariant.match(/bold/)){k.weight="bold"}if(!k.style&&k.mathvariant.match(/italic/)){k.style="italic"}return{FONTS:[],fonts:[],noRemap:true,defaultFont:{family:k.family,style:k.style,weight:k.weight}}}if(k.weight==="bold"){l={normal:g.VARIANT.BOLD,italic:g.VARIANT.BOLDITALIC,fraktur:g.VARIANT.BOLDFRAKTUR,script:g.VARIANT.BOLDSCRIPT,"sans-serif":g.VARIANT.BOLDSANSSERIF,"sans-serif-italic":g.VARIANT.SANSSERIFBOLDITALIC}[l]||l}else{if(k.weight==="normal"){l={bold:g.VARIANT.normal,"bold-italic":g.VARIANT.ITALIC,"bold-fraktur":g.VARIANT.FRAKTUR,"bold-script":g.VARIANT.SCRIPT,"bold-sans-serif":g.VARIANT.SANSSERIF,"sans-serif-bold-italic":g.VARIANT.SANSSERIFITALIC}[l]||l}}if(k.style==="italic"){l={normal:g.VARIANT.ITALIC,bold:g.VARIANT.BOLDITALIC,"sans-serif":g.VARIANT.SANSSERIFITALIC,"bold-sans-serif":g.VARIANT.SANSSERIFBOLDITALIC}[l]||l}else{if(k.style==="normal"){l={italic:g.VARIANT.NORMAL,"bold-italic":g.VARIANT.BOLD,"sans-serif-italic":g.VARIANT.SANSSERIF,"sans-serif-bold-italic":g.VARIANT.BOLDSANSSERIF}[l]||l}}if(!(l in d.FONTDATA.VARIANT)){l="normal"}return d.FONTDATA.VARIANT[l]}},{HTMLautoload:function(){var k=d.autoloadDir+"/"+this.type+".js";b.RestartAfter(h.Require(k))},HTMLautoloadFile:function(k){var l=d.autoloadDir+"/"+k+".js";b.RestartAfter(h.Require(l))},HTMLstretchH:function(l,k){this.HTMLremoveColor();return this.toHTML(l,k)},HTMLstretchV:function(l,k,m){this.HTMLremoveColor();return this.toHTML(l,k,m)}});g.chars.Augment({toHTML:function(n,m,l,o){var r=this.data.join("").replace(/[\u2061-\u2064]/g,"");if(l){r=l(r,o)}if(m.fontInherit){var q=Math.floor(100/d.scale+0.5)+"%";d.addElement(n,"span",{style:{"font-size":q}},[r]);if(m.bold){n.lastChild.style.fontWeight="bold"}if(m.italic){n.lastChild.style.fontStyle="italic"}var p=d.getHD(n),k=d.getW(n);n.bbox={h:p.h,d:p.d,w:k,lw:0,rw:k,exactW:true}}else{this.HTMLhandleVariant(n,m,r)}}});g.entity.Augment({toHTML:function(n,m,l,o){var r=this.toString().replace(/[\u2061-\u2064]/g,"");if(l){r=l(r,o)}if(m.fontInherit){var q=Math.floor(100/d.scale+0.5)+"%";d.addElement(n,"span",{style:{"font-size":q}},[r]);if(m.bold){n.lastChild.style.fontWeight="bold"}if(m.italic){n.lastChild.style.fontStyle="italic"}var p=d.getHD(n),k=d.getW(n);n.bbox={h:p.h,d:p.d,w:k,lw:0,rw:k,exactW:true}}else{this.HTMLhandleVariant(n,m,r)}}});g.mi.Augment({toHTML:function(o){o=this.HTMLhandleSize(this.HTMLcreateSpan(o));o.bbox=null;var n=this.HTMLgetVariant();for(var l=0,k=this.data.length;l<k;l++){if(this.data[l]){this.data[l].toHTML(o,n)}}if(!o.bbox){o.bbox=this.HTMLzeroBBox()}var q=this.data.join(""),p=o.bbox;if(p.skew&&q.length!==1){delete p.skew}if(p.rw>p.w&&q.length===1&&!n.noIC){p.ic=p.rw-p.w;d.createBlank(o,p.ic/this.mscale);p.w=p.rw}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);this.HTMLhandleDir(o);return o}});g.mn.Augment({toHTML:function(o){o=this.HTMLhandleSize(this.HTMLcreateSpan(o));o.bbox=null;var n=this.HTMLgetVariant();for(var l=0,k=this.data.length;l<k;l++){if(this.data[l]){this.data[l].toHTML(o,n)}}if(!o.bbox){o.bbox=this.HTMLzeroBBox()}if(this.data.join("").length!==1){delete o.bbox.skew}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);this.HTMLhandleDir(o);return o}});g.mo.Augment({toHTML:function(v){v=this.HTMLhandleSize(this.HTMLcreateSpan(v));if(this.data.length==0){return v}else{v.bbox=null}var y=this.data.join("");var q=this.HTMLgetVariant();var x=this.getValues("largeop","displaystyle");if(x.largeop){q=d.FONTDATA.VARIANT[x.displaystyle?"-largeOp":"-smallOp"]}var w=this.CoreParent(),o=(w&&w.isa(g.msubsup)&&this!==w.data[w.base]),l=(o?this.HTMLremapChars:null);if(y.length===1&&w&&w.isa(g.munderover)&&this.CoreText(w.data[w.base]).length===1){var s=w.data[w.over],u=w.data[w.under];if(s&&this===s.CoreMO()&&w.Get("accent")){l=d.FONTDATA.REMAPACCENT}else{if(u&&this===u.CoreMO()&&w.Get("accentunder")){l=d.FONTDATA.REMAPACCENTUNDER}}}if(o&&y.match(/['`"\u00B4\u2032-\u2037\u2057]/)){q=d.FONTDATA.VARIANT["-"+d.fontInUse+"-variant"]}for(var r=0,n=this.data.length;r<n;r++){if(this.data[r]){this.data[r].toHTML(v,q,this.HTMLremap,l)}}if(!v.bbox){v.bbox=this.HTMLzeroBBox()}if(y.length!==1){delete v.bbox.skew}if(d.AccentBug&&v.bbox.w===0&&y.length===1&&v.firstChild){v.firstChild.nodeValue+=d.NBSP;d.createSpace(v,0,0,-v.offsetWidth/d.em)}if(x.largeop){var t=d.TeX.axis_height*this.scale*this.mscale;var k=(v.bbox.h-v.bbox.d)/2-t;if(d.safariVerticalAlignBug&&v.lastChild.nodeName==="IMG"){v.lastChild.style.verticalAlign=d.Em(d.unEm(v.lastChild.style.verticalAlign||0)/d.em-k/v.scale)}else{if(d.konquerorVerticalAlignBug&&v.lastChild.nodeName==="IMG"){v.style.position="relative";v.lastChild.style.position="relative";v.lastChild.style.top=d.Em(k/v.scale)}else{v.style.verticalAlign=d.Em(-k/v.scale)}}v.bbox.h-=k;v.bbox.d+=k;if(v.bbox.rw>v.bbox.w){v.bbox.ic=v.bbox.rw-v.bbox.w;d.createBlank(v,v.bbox.ic/this.mscale);v.bbox.w=v.bbox.rw}}this.HTMLhandleSpace(v);this.HTMLhandleColor(v);this.HTMLhandleDir(v);return v},CoreParent:function(){var k=this;while(k&&k.isEmbellished()&&k.CoreMO()===this&&!k.isa(g.math)){k=k.Parent()}return k},CoreText:function(k){if(!k){return""}if(k.isEmbellished()){return k.CoreMO().data.join("")}while((k.isa(g.mrow)||k.isa(g.TeXAtom)||k.isa(g.mstyle)||k.isa(g.mphantom))&&k.data.length===1&&k.data[0]){k=k.data[0]}if(!k.isToken){return""}else{return k.data.join("")}},HTMLremapChars:{"*":"\u2217",'"':"\u2033","\u00B0":"\u2218","\u00B2":"2","\u00B3":"3","\u00B4":"\u2032","\u00B9":"1"},HTMLremap:function(l,k){l=l.replace(/-/g,"\u2212");if(k){l=l.replace(/'/g,"\u2032").replace(/`/g,"\u2035");if(l.length===1){l=k[l]||l}}return l},HTMLcanStretch:function(o){if(!this.Get("stretchy")){return false}var p=this.data.join("");if(p.length>1){return false}var m=this.CoreParent();if(m&&m.isa(g.munderover)&&this.CoreText(m.data[m.base]).length===1){var n=m.data[m.over],l=m.data[m.under];if(n&&this===n.CoreMO()&&m.Get("accent")){p=d.FONTDATA.REMAPACCENT[p]||p}else{if(l&&this===l.CoreMO()&&m.Get("accentunder")){p=d.FONTDATA.REMAPACCENTUNDER[p]||p}}}p=d.FONTDATA.DELIMITERS[p.charCodeAt(0)];var k=(p&&p.dir===o.substr(0,1));this.forceStretch=(k&&(this.Get("minsize",true)||this.Get("maxsize",true)));return k},HTMLstretchV:function(m,n,o){this.HTMLremoveColor();var r=this.getValues("symmetric","maxsize","minsize");var p=this.HTMLspanElement(),s=this.HTMLgetMu(p),q;var l=this.HTMLgetScale(),k=d.TeX.axis_height*l;if(r.symmetric){q=2*Math.max(n-k,o+k)}else{q=n+o}r.maxsize=d.length2em(r.maxsize,s,p.bbox.h+p.bbox.d);r.minsize=d.length2em(r.minsize,s,p.bbox.h+p.bbox.d);q=Math.max(r.minsize,Math.min(r.maxsize,q));p=this.HTMLcreateSpan(m);d.createDelimiter(p,this.data.join("").charCodeAt(0),q,l);if(r.symmetric){q=(p.bbox.h+p.bbox.d)/2+k}else{q=(p.bbox.h+p.bbox.d)*n/(n+o)}d.positionDelimiter(p,q);this.HTMLhandleSpace(p);this.HTMLhandleColor(p);return p},HTMLstretchH:function(o,k){this.HTMLremoveColor();var m=this.getValues("maxsize","minsize","mathvariant","fontweight");if((m.fontweight==="bold"||parseInt(m.fontweight)>=600)&&!this.Get("mathvariant",true)){m.mathvariant=g.VARIANT.BOLD}var n=this.HTMLspanElement(),l=this.HTMLgetMu(n),p=n.scale;m.maxsize=d.length2em(m.maxsize,l,n.bbox.w);m.minsize=d.length2em(m.minsize,l,n.bbox.w);k=Math.max(m.minsize,Math.min(m.maxsize,k));n=this.HTMLcreateSpan(o);d.createDelimiter(n,this.data.join("").charCodeAt(0),k,p,m.mathvariant);this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n}});g.mtext.Augment({toHTML:function(o){o=this.HTMLhandleSize(this.HTMLcreateSpan(o));var n=this.HTMLgetVariant();if(d.config.mtextFontInherit||this.Parent().type==="merror"){var p=this.Get("mathvariant");if(p==="monospace"){o.className+=" MJX-monospace"}else{if(p.match(/sans-serif/)){o.className+=" MJX-sans-serif"}}n={bold:n.bold,italic:n.italic,fontInherit:true}}for(var l=0,k=this.data.length;l<k;l++){if(this.data[l]){this.data[l].toHTML(o,n)}}if(!o.bbox){o.bbox=this.HTMLzeroBBox()}if(this.data.join("").length!==1){delete o.bbox.skew}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);this.HTMLhandleDir(o);return o}});g.merror.Augment({toHTML:function(l){var n=MathJax.HTML.addElement(l,"span",{style:{display:"inline-block"}});l=this.SUPER(arguments).toHTML.call(this,n);var m=d.getHD(n),k=d.getW(n);n.bbox={h:m.h,d:m.d,w:k,lw:0,rw:k,exactW:true};n.id=l.id;l.id=null;return n}});g.ms.Augment({toHTML:g.mbase.HTMLautoload});g.mglyph.Augment({toHTML:g.mbase.HTMLautoload});g.mspace.Augment({toHTML:function(o){o=this.HTMLcreateSpan(o);var m=this.getValues("height","depth","width");var l=this.HTMLgetMu(o);this.HTMLgetScale();m.mathbackground=this.mathbackground;if(this.background&&!this.mathbackground){m.mathbackground=this.background}var n=d.length2em(m.height,l)*this.mscale,p=d.length2em(m.depth,l)*this.mscale,k=d.length2em(m.width,l)*this.mscale;d.createSpace(o,n,p,k,m.mathbackground,true);return o}});g.mphantom.Augment({toHTML:function(o,l,q){o=this.HTMLcreateSpan(o);if(this.data[0]!=null){var p=this.data[0].toHTML(o);if(q!=null){d.Remeasured(this.data[0].HTMLstretchV(o,l,q),o)}else{if(l!=null){d.Remeasured(this.data[0].HTMLstretchH(o,l),o)}else{p=d.Measured(p,o)}}o.bbox={w:p.bbox.w,h:p.bbox.h,d:p.bbox.d,lw:0,rw:0,exactW:true};for(var n=0,k=o.childNodes.length;n<k;n++){o.childNodes[n].style.visibility="hidden"}}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);return o},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});g.mpadded.Augment({toHTML:function(s,m,k){s=this.HTMLcreateSpan(s);if(this.data[0]!=null){var q=d.createStack(s,true);var n=d.createBox(q);var l=this.data[0].toHTML(n);if(k!=null){d.Remeasured(this.data[0].HTMLstretchV(n,m,k),n)}else{if(m!=null){d.Remeasured(this.data[0].HTMLstretchH(n,m),n)}else{d.Measured(l,n)}}var t=this.getValues("height","depth","width","lspace","voffset"),r=0,p=0,u=this.HTMLgetMu(s);this.HTMLgetScale();if(t.lspace){r=this.HTMLlength2em(n,t.lspace,u)}if(t.voffset){p=this.HTMLlength2em(n,t.voffset,u)}d.placeBox(n,r,p);r/=this.mscale;p/=this.mscale;s.bbox={h:n.bbox.h,d:n.bbox.d,w:n.bbox.w,exactW:true,lw:Math.min(0,n.bbox.lw+r),rw:Math.max(n.bbox.w,n.bbox.rw+r),H:Math.max((n.bbox.H==null?-d.BIGDIMEN:n.bbox.H),n.bbox.h+p),D:Math.max((n.bbox.D==null?-d.BIGDIMEN:n.bbox.D),n.bbox.d-p)};if(t.height!==""){s.bbox.h=this.HTMLlength2em(n,t.height,u,"h",0)}if(t.depth!==""){s.bbox.d=this.HTMLlength2em(n,t.depth,u,"d",0)}if(t.width!==""){s.bbox.w=this.HTMLlength2em(n,t.width,u,"w",0)}if(s.bbox.H<=s.bbox.h){delete s.bbox.H}if(s.bbox.D<=s.bbox.d){delete s.bbox.D}var o=/^\s*(\d+(\.\d*)?|\.\d+)\s*(pt|em|ex|mu|px|pc|in|mm|cm)\s*$/;s.bbox.exact=!!((this.data[0]&&this.data[0].data.length==0)||o.exec(t.height)||o.exec(t.width)||o.exec(t.depth));d.setStackWidth(q,s.bbox.w)}this.HTMLhandleSpace(s);this.HTMLhandleColor(s);return s},HTMLlength2em:function(q,r,l,s,k){if(k==null){k=-d.BIGDIMEN}var o=String(r).match(/width|height|depth/);var p=(o?q.bbox[o[0].charAt(0)]:(s?q.bbox[s]:0));var n=d.length2em(r,l,p/this.mscale)*this.mscale;if(s&&String(r).match(/^\s*[-+]/)){return Math.max(k,q.bbox[s]+n)}else{return n}},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});g.mrow.Augment({HTMLlineBreaks:function(k){if(!this.parent.linebreakContainer){return false}return(d.config.linebreaks.automatic&&k.bbox.w>d.linebreakWidth)||this.hasNewline()},HTMLstretchH:function(m,k){this.HTMLremoveColor();var l=this.HTMLspanElement();this.data[this.core].HTMLstretchH(l,k);this.HTMLcomputeBBox(l,true);this.HTMLhandleColor(l);return l},HTMLstretchV:function(m,l,n){this.HTMLremoveColor();var k=this.HTMLspanElement();this.data[this.core].HTMLstretchV(k,l,n);this.HTMLcomputeBBox(k,true);this.HTMLhandleColor(k);return k}});g.mstyle.Augment({toHTML:function(l,k,m){l=this.HTMLcreateSpan(l);if(this.data[0]!=null){var n=this.data[0].toHTML(l);if(m!=null){this.data[0].HTMLstretchV(l,k,m)}else{if(k!=null){this.data[0].HTMLstretchH(l,k)}}l.bbox=n.bbox}this.HTMLhandleSpace(l);this.HTMLhandleColor(l);return l},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});g.mfrac.Augment({toHTML:function(D){D=this.HTMLcreateSpan(D);var m=d.createStack(D);var r=d.createBox(m),o=d.createBox(m);d.MeasureSpans([this.HTMLboxChild(0,r),this.HTMLboxChild(1,o)]);var k=this.getValues("displaystyle","linethickness","numalign","denomalign","bevelled");var I=this.HTMLgetScale(),C=k.displaystyle;var G=d.TeX.axis_height*I;if(k.bevelled){var F=(C?0.4:0.15);var s=Math.max(r.bbox.h+r.bbox.d,o.bbox.h+o.bbox.d)+2*F;var E=d.createBox(m);d.createDelimiter(E,47,s);d.placeBox(r,0,(r.bbox.d-r.bbox.h)/2+G+F);d.placeBox(E,r.bbox.w-F/2,(E.bbox.d-E.bbox.h)/2+G);d.placeBox(o,r.bbox.w+E.bbox.w-F,(o.bbox.d-o.bbox.h)/2+G-F)}else{var l=Math.max(r.bbox.w,o.bbox.w);var y=d.thickness2em(k.linethickness,this.scale)*this.mscale,A,z,x,w;var B=d.TeX.min_rule_thickness/this.em;if(C){x=d.TeX.num1;w=d.TeX.denom1}else{x=(y===0?d.TeX.num3:d.TeX.num2);w=d.TeX.denom2}x*=I;w*=I;if(y===0){A=Math.max((C?7:3)*d.TeX.rule_thickness,2*B);z=(x-r.bbox.d)-(o.bbox.h-w);if(z<A){x+=(A-z)/2;w+=(A-z)/2}}else{A=Math.max((C?2:0)*B+y,y/2+1.5*B);z=(x-r.bbox.d)-(G+y/2);if(z<A){x+=A-z}z=(G-y/2)-(o.bbox.h-w);if(z<A){w+=A-z}var n=d.createBox(m);d.createRule(n,y,0,l+2*y);d.placeBox(n,0,G-y/2)}d.alignBox(r,k.numalign,x);d.alignBox(o,k.denomalign,-w)}this.HTMLhandleSpace(D);this.HTMLhandleColor(D);return D},HTMLcanStretch:function(k){return false},HTMLhandleSpace:function(l){if(!this.texWithDelims&&!this.useMMLspacing){var m=d.TeX.nulldelimiterspace*this.mscale;var k=l.childNodes[d.msiePaddingWidthBug?1:0].style;k.marginLeft=k.marginRight=d.Em(m);l.bbox.w+=2*m;l.bbox.r+=2*m}this.SUPER(arguments).HTMLhandleSpace.call(this,l)}});g.msqrt.Augment({toHTML:function(w){w=this.HTMLcreateSpan(w);var z=d.createStack(w);var n=d.createBox(z),u=d.createBox(z),s=d.createBox(z);var r=this.HTMLgetScale();var A=d.TeX.rule_thickness*r,m,l,y,o;if(this.Get("displaystyle")){m=d.TeX.x_height*r}else{m=A}l=Math.max(A+m/4,1.5*d.TeX.min_rule_thickness/this.em);var k=this.HTMLboxChild(0,n);y=k.bbox.h+k.bbox.d+l+A;d.createDelimiter(s,8730,y,r);d.MeasureSpans([k,s]);o=k.bbox.w;var v=0;if(s.isMultiChar||(d.AdjustSurd&&d.imgFonts)){s.bbox.w*=0.95}if(s.bbox.h+s.bbox.d>y){l=((s.bbox.h+s.bbox.d)-(y-A))/2}var B=d.FONTDATA.DELIMITERS[d.FONTDATA.RULECHAR];if(!B||o<B.HW[0][0]*r||r<0.75){d.createRule(u,0,A,o)}else{d.createDelimiter(u,d.FONTDATA.RULECHAR,o,r)}y=k.bbox.h+l+A;l=y*d.rfuzz;if(s.isMultiChar){l=d.rfuzz}v=this.HTMLaddRoot(z,s,v,s.bbox.h+s.bbox.d-y,r);d.placeBox(s,v,y-s.bbox.h);d.placeBox(u,v+s.bbox.w,y-u.bbox.h+l);d.placeBox(n,v+s.bbox.w,0);this.HTMLhandleSpace(w);this.HTMLhandleColor(w);return w},HTMLaddRoot:function(m,l,k,o,n){return k}});g.mroot.Augment({toHTML:g.msqrt.prototype.toHTML,HTMLaddRoot:function(s,l,q,o,k){var m=d.createBox(s);if(this.data[1]){var p=this.data[1].toHTML(m);p.style.paddingRight=p.style.paddingLeft="";d.Measured(p,m)}else{m.bbox=this.HTMLzeroBBox()}var n=this.HTMLrootHeight(l.bbox.h+l.bbox.d,k,m)-o;var r=Math.min(m.bbox.w,m.bbox.rw);q=Math.max(r,l.offset);d.placeBox(m,q-r,n);return q-l.offset},HTMLrootHeight:function(m,l,k){return 0.45*(m-0.9*l)+0.6*l+Math.max(0,k.bbox.d-0.075)}});g.mfenced.Augment({toHTML:function(o){o=this.HTMLcreateSpan(o);if(this.data.open){this.data.open.toHTML(o)}if(this.data[0]!=null){this.data[0].toHTML(o)}for(var l=1,k=this.data.length;l<k;l++){if(this.data[l]){if(this.data["sep"+l]){this.data["sep"+l].toHTML(o)}this.data[l].toHTML(o)}}if(this.data.close){this.data.close.toHTML(o)}var q=this.HTMLcomputeBBox(o);var n=o.bbox.h,p=o.bbox.d;for(l=0,k=q.length;l<k;l++){q[l].HTMLstretchV(o,n,p)}if(q.length){this.HTMLcomputeBBox(o,true)}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);return o},HTMLcomputeBBox:function(p,o){var l=p.bbox={},q=[];this.HTMLcheckStretchy(this.data.open,l,q,o);this.HTMLcheckStretchy(this.data[0],l,q,o);for(var n=1,k=this.data.length;n<k;n++){if(this.data[n]){this.HTMLcheckStretchy(this.data["sep"+n],l,q,o);this.HTMLcheckStretchy(this.data[n],l,q,o)}}this.HTMLcheckStretchy(this.data.close,l,q,o);this.HTMLcleanBBox(l);return q},HTMLcheckStretchy:function(k,l,n,m){if(k){if(!m&&k.HTMLcanStretch("Vertical")){n.push(k);k=(k.CoreMO()||k)}this.HTMLcombineBBoxes(k,l)}}});g.menclose.Augment({toHTML:g.mbase.HTMLautoload});g.maction.Augment({toHTML:g.mbase.HTMLautoload});g.semantics.Augment({toHTML:function(l,k,m){l=this.HTMLcreateSpan(l);if(this.data[0]!=null){var n=this.data[0].toHTML(l);if(m!=null){this.data[0].HTMLstretchV(l,k,m)}else{if(k!=null){this.data[0].HTMLstretchH(l,k)}}l.bbox=n.bbox}this.HTMLhandleSpace(l);return l},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});g.munderover.Augment({toHTML:function(L,H,F){var l=this.getValues("displaystyle","accent","accentunder","align");if(!l.displaystyle&&this.data[this.base]!=null&&this.data[this.base].CoreMO().Get("movablelimits")){return g.msubsup.prototype.toHTML.call(this,L)}L=this.HTMLcreateSpan(L);var P=this.HTMLgetScale();var q=d.createStack(L);var r=[],o=[],N=[],w,M,I;for(M=0,I=this.data.length;M<I;M++){if(this.data[M]!=null){w=r[M]=d.createBox(q);o[M]=this.data[M].toHTML(w);if(M==this.base){if(F!=null){this.data[this.base].HTMLstretchV(w,H,F)}else{if(H!=null){this.data[this.base].HTMLstretchH(w,H)}}N[M]=(F==null&&H!=null?false:this.data[M].HTMLcanStretch("Horizontal"))}else{N[M]=this.data[M].HTMLcanStretch("Horizontal");o[M].style.paddingLeft=o[M].style.paddingRight=""}}}d.MeasureSpans(o);var n=-d.BIGDIMEN,K=n;for(M=0,I=this.data.length;M<I;M++){if(this.data[M]){if(r[M].bbox.w>K){K=r[M].bbox.w}if(!N[M]&&K>n){n=K}}}if(F==null&&H!=null){n=H}else{if(n==-d.BIGDIMEN){n=K}}for(M=K=0,I=this.data.length;M<I;M++){if(this.data[M]){w=r[M];if(N[M]){w.bbox=this.data[M].HTMLstretchH(w,n).bbox;if(M!==this.base){o[M].style.paddingLeft=o[M].style.paddingRight=""}}if(w.bbox.w>K){K=w.bbox.w}}}var E=d.TeX.rule_thickness*this.mscale,G=d.FONTDATA.TeX_factor;var p=r[this.base]||{bbox:this.HTMLzeroBBox()};var v,s,A,z,u,C,J,O=0;if(p.bbox.ic){O=1.3*p.bbox.ic+0.05}for(M=0,I=this.data.length;M<I;M++){if(this.data[M]!=null){w=r[M];u=d.TeX.big_op_spacing5*P;var B=(M!=this.base&&l[this.ACCENTS[M]]);if(B&&w.bbox.w<=1/d.em+0.0001){w.bbox.w=w.bbox.rw-w.bbox.lw;w.bbox.noclip=true;if(w.bbox.lw){w.insertBefore(d.createSpace(w.parentNode,0,0,-w.bbox.lw),w.firstChild)}d.createBlank(w,0,0,w.bbox.rw+0.1)}C={left:0,center:(K-w.bbox.w)/2,right:K-w.bbox.w}[l.align];v=C;s=0;if(M==this.over){if(B){J=Math.max(E*P*G,2.5/this.em);u=0;if(p.bbox.skew){v+=p.bbox.skew}}else{A=d.TeX.big_op_spacing1*P*G;z=d.TeX.big_op_spacing3*P*G;J=Math.max(A,z-Math.max(0,w.bbox.d))}J=Math.max(J,1.5/this.em);v+=O/2;s=p.bbox.h+w.bbox.d+J;w.bbox.h+=u}else{if(M==this.under){if(B){J=3*E*P*G;u=0}else{A=d.TeX.big_op_spacing2*P*G;z=d.TeX.big_op_spacing4*P*G;J=Math.max(A,z-w.bbox.h)}J=Math.max(J,1.5/this.em);v-=O/2;s=-(p.bbox.d+w.bbox.h+J);w.bbox.d+=u}}d.placeBox(w,v,s)}}this.HTMLhandleSpace(L);this.HTMLhandleColor(L);return L},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});g.msubsup.Augment({toHTML:function(K,I,C){K=this.HTMLcreateSpan(K);var N=this.HTMLgetScale(),H=this.HTMLgetMu(K);var w=d.createStack(K),l,n=[];var o=d.createBox(w);if(this.data[this.base]){n.push(this.data[this.base].toHTML(o));if(C!=null){this.data[this.base].HTMLstretchV(o,I,C)}else{if(I!=null){this.data[this.base].HTMLstretchH(o,I)}}}else{o.bbox=this.HTMLzeroBBox()}var L=d.TeX.x_height*N,B=d.TeX.scriptspace*N*0.75;var k,x;if(this.HTMLnotEmpty(this.data[this.sup])){k=d.createBox(w);n.push(this.data[this.sup].toHTML(k))}if(this.HTMLnotEmpty(this.data[this.sub])){x=d.createBox(w);n.push(this.data[this.sub].toHTML(x))}d.MeasureSpans(n);if(k){k.bbox.w+=B;k.bbox.rw=Math.max(k.bbox.w,k.bbox.rw)}if(x){x.bbox.w+=B;x.bbox.rw=Math.max(x.bbox.w,x.bbox.rw)}d.placeBox(o,0,0);var m=N;if(k){m=this.data[this.sup].HTMLgetScale()}else{if(x){m=this.data[this.sub].HTMLgetScale()}}var F=d.TeX.sup_drop*m,E=d.TeX.sub_drop*m;var z=o.bbox.h-F,y=o.bbox.d+E,M=0,G;if(o.bbox.ic){o.bbox.w-=o.bbox.ic;M=1.3*o.bbox.ic+0.05}if(this.data[this.base]&&(this.data[this.base].type==="mi"||this.data[this.base].type==="mo")){if(this.data[this.base].data.join("").length===1&&o.bbox.scale===1&&!this.data[this.base].Get("largeop")){z=y=0}}var J=this.getValues("subscriptshift","superscriptshift");J.subscriptshift=(J.subscriptshift===""?0:d.length2em(J.subscriptshift,H));J.superscriptshift=(J.superscriptshift===""?0:d.length2em(J.superscriptshift,H));if(!k){if(x){y=Math.max(y,d.TeX.sub1*N,x.bbox.h-(4/5)*L,J.subscriptshift);d.placeBox(x,o.bbox.w,-y,x.bbox)}}else{if(!x){l=this.getValues("displaystyle","texprimestyle");G=d.TeX[(l.displaystyle?"sup1":(l.texprimestyle?"sup3":"sup2"))];z=Math.max(z,G*N,k.bbox.d+(1/4)*L,J.superscriptshift);d.placeBox(k,o.bbox.w+M,z,k.bbox)}else{y=Math.max(y,d.TeX.sub2*N);var A=d.TeX.rule_thickness*N;if((z-k.bbox.d)-(x.bbox.h-y)<3*A){y=3*A-z+k.bbox.d+x.bbox.h;F=(4/5)*L-(z-k.bbox.d);if(F>0){z+=F;y-=F}}d.placeBox(k,o.bbox.w+M,Math.max(z,J.superscriptshift));d.placeBox(x,o.bbox.w,-Math.max(y,J.subscriptshift))}}this.HTMLhandleSpace(K);this.HTMLhandleColor(K);return K},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});g.mmultiscripts.Augment({toHTML:g.mbase.HTMLautoload});g.mtable.Augment({toHTML:g.mbase.HTMLautoload});g["annotation-xml"].Augment({toHTML:g.mbase.HTMLautoload});g.math.Augment({toHTML:function(u,l){var r=this.Get("alttext");if(r&&r!==""){l.setAttribute("aria-label",r)}var m=d.addElement(u,"nobr",{isMathJax:true});u=this.HTMLcreateSpan(m);var s=d.createStack(u),n=d.createBox(s),t;s.style.fontSize=m.parentNode.style.fontSize;m.parentNode.style.fontSize="";if(this.data[0]!=null){if(d.msieColorBug){if(this.background){this.data[0].background=this.background;delete this.background}if(this.mathbackground){this.data[0].mathbackground=this.mathbackground;delete this.mathbackground}}g.mbase.prototype.displayAlign=b.config.displayAlign;g.mbase.prototype.displayIndent=b.config.displayIndent;var o=this.data[0].toHTML(n);o.bbox.exactW=false;t=d.Measured(o,n)}d.placeBox(n,0,0);u.style.width=d.Em((Math.round(t.bbox.w*this.em)+0.25)/d.outerEm);u.style.display="inline-block";var k=1/d.em,q=d.em/d.outerEm;d.em/=q;u.bbox.h*=q;u.bbox.d*=q;u.bbox.w*=q;u.bbox.lw*=q;u.bbox.rw*=q;if(t&&t.bbox.width!=null){u.style.minWidth=(t.bbox.minWidth||u.style.width);u.style.width=s.style.width=t.bbox.width;n.style.width="100%"}this.HTMLhandleColor(u);if(t){d.createRule(u,(t.bbox.h+k)*q,(t.bbox.d+k)*q,0)}if(!this.isMultiline&&this.Get("display")==="block"&&u.bbox.width==null){var v=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(v.indentalignfirst!==g.INDENTALIGN.INDENTALIGN){v.indentalign=v.indentalignfirst}if(v.indentalign===g.INDENTALIGN.AUTO){v.indentalign=this.displayAlign}l.style.textAlign=v.indentalign;if(v.indentshiftfirst!==g.INDENTSHIFT.INDENTSHIFT){v.indentshift=v.indentshiftfirst}if(v.indentshift==="auto"){v.indentshift=this.displayIndent}if(v.indentshift&&v.indentalign!==g.INDENTALIGN.CENTER){u.style[{left:"marginLeft",right:"marginRight"}[v.indentalign]]=d.Em(d.length2em(v.indentshift))}}return u},HTMLspanElement:g.mbase.prototype.HTMLspanElement});g.TeXAtom.Augment({toHTML:function(o,m,q){o=this.HTMLcreateSpan(o);if(this.data[0]!=null){if(this.texClass===g.TEXCLASS.VCENTER){var k=d.createStack(o);var p=d.createBox(k);var r=this.data[0].toHTML(p);if(q!=null){d.Remeasured(this.data[0].HTMLstretchV(p,m,q),p)}else{if(m!=null){d.Remeasured(this.data[0].HTMLstretchH(p,m),p)}else{d.Measured(r,p)}}var l=d.TeX.axis_height*this.HTMLgetScale();d.placeBox(p,0,l-(p.bbox.h+p.bbox.d)/2+p.bbox.d)}else{var n=this.data[0].toHTML(o,m,q);if(q!=null){n=this.data[0].HTMLstretchV(p,m,q)}else{if(m!=null){n=this.data[0].HTMLstretchH(p,m)}}o.bbox=n.bbox}}this.HTMLhandleSpace(o);this.HTMLhandleColor(o);return o},HTMLstretchH:g.mbase.HTMLstretchH,HTMLstretchV:g.mbase.HTMLstretchV});MathJax.Hub.Register.StartupHook("onLoad",function(){setTimeout(MathJax.Callback(["loadComplete",d,"jax.js"]),0)})});b.Register.StartupHook("End Config",function(){b.Browser.Select({MSIE:function(k){var o=(document.documentMode||0);var n=k.versionAtLeast("7.0");var m=k.versionAtLeast("8.0")&&o>7;var l=(document.compatMode==="BackCompat");if(o<9){d.config.styles[".MathJax .MathJax_HitBox"]["background-color"]="white";d.config.styles[".MathJax .MathJax_HitBox"].opacity=0;d.config.styles[".MathJax .MathJax_HitBox"].filter="alpha(opacity=0)"}d.Augment({PaddingWidthBug:true,msieAccentBug:true,msieColorBug:true,msieColorPositionBug:true,msieRelativeWidthBug:l,msieDisappearingBug:(o>=8),msieMarginScaleBug:(o<8),msiePaddingWidthBug:true,msieBorderWidthBug:l,msieFrameSizeBug:(o<=8),msieInlineBlockAlignBug:(!m||l),msiePlaceBoxBug:(m&&!l),msieClipRectBug:!m,msieNegativeSpaceBug:l,cloneNodeBug:(m&&k.version==="8.0"),msieItalicWidthBug:true,initialSkipBug:(o<8),msieNegativeBBoxBug:(o>=8),msieIE6:!n,msieItalicWidthBug:true,FontFaceBug:true,msieFontCSSBug:k.isIE9,allowWebFonts:(o>=9?"woff":"eot")})},Firefox:function(l){var m=false;if(l.versionAtLeast("3.5")){var k=String(document.location).replace(/[^\/]*$/,"");if(document.location.protocol!=="file:"||b.config.root.match(/^https?:\/\//)||(b.config.root+"/").substr(0,k.length)===k){m="otf"}}d.Augment({ffVerticalAlignBug:!l.versionAtLeast("20.0"),AccentBug:true,allowWebFonts:m})},Safari:function(p){var n=p.versionAtLeast("3.0");var m=p.versionAtLeast("3.1");var k=navigator.appVersion.match(/ Safari\/\d/)&&navigator.appVersion.match(/ Version\/\d/)&&navigator.vendor.match(/Apple/);var l=(navigator.appVersion.match(/ Android (\d+)\.(\d+)/));var q=(m&&p.isMobile&&((navigator.platform.match(/iPad|iPod|iPhone/)&&!p.versionAtLeast("5.0"))||(l!=null&&(l[1]<2||(l[1]==2&&l[2]<2)))));d.Augment({config:{styles:{".MathJax img, .MathJax nobr, .MathJax a":{"max-width":"5000em","max-height":"5000em"}}},rfuzz:0.011,AccentBug:true,AdjustSurd:true,negativeBBoxes:true,safariNegativeSpaceBug:true,safariVerticalAlignBug:!m,safariTextNodeBug:!n,forceReflow:true,allowWebFonts:(m&&!q?"otf":false)});if(k){d.Augment({webFontDefault:(p.isMobile?"sans-serif":"serif")})}if(p.isPC){d.Augment({adjustAvailableFonts:d.removeSTIXfonts,checkWebFontsTwice:true})}if(q){var o=b.config["HTML-CSS"];if(o){o.availableFonts=[];o.preferredFont=null}else{b.config["HTML-CSS"]={availableFonts:[],preferredFont:null}}}},Chrome:function(k){d.Augment({Em:d.EmRounded,cloneNodeBug:true,rfuzz:-0.02,AccentBug:true,AdjustSurd:true,FontFaceBug:k.versionAtLeast("32.0"),negativeBBoxes:true,safariNegativeSpaceBug:true,safariWebFontSerif:[""],forceReflow:true,allowWebFonts:(k.versionAtLeast("4.0")?"otf":"svg")})},Opera:function(k){k.isMini=(navigator.appVersion.match("Opera Mini")!=null);d.config.styles[".MathJax .merror"]["vertical-align"]=null;d.config.styles[".MathJax span"]["z-index"]=0;d.Augment({operaHeightBug:true,operaVerticalAlignBug:true,operaFontSizeBug:k.versionAtLeast("10.61"),initialSkipBug:true,FontFaceBug:true,PaddingWidthBug:true,allowWebFonts:(k.versionAtLeast("10.0")&&!k.isMini?"otf":false),adjustAvailableFonts:d.removeSTIXfonts})},Konqueror:function(k){d.Augment({konquerorVerticalAlignBug:true})}})});MathJax.Hub.Register.StartupHook("End Cookie",function(){if(b.config.menuSettings.zoom!=="None"){h.Require("[MathJax]/extensions/MathZoom.js")}})})(MathJax.Ajax,MathJax.Hub,MathJax.OutputJax["HTML-CSS"]);
MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){var c="2.4.0";var a=MathJax.ElementJax.mml,b=MathJax.OutputJax["HTML-CSS"];a.mtable.Augment({toHTML:function(t){t=this.HTMLcreateSpan(t);if(this.data.length===0){return t}var K=this.getValues("columnalign","rowalign","columnspacing","rowspacing","columnwidth","equalcolumns","equalrows","columnlines","rowlines","frame","framespacing","align","useHeight","width","side","minlabelspacing");var aI=K.width.match(/%$/);var ax=b.createStack(t);var aF=this.HTMLgetScale(),az=this.HTMLgetMu(t),aA=-1;var ap=[],at=[],ak=[],av=[],au=[],af,ae,ao=-1,ad,an,Z,aE,R,aB,aN=[],aS;var I=b.FONTDATA.lineH*aF*K.useHeight,O=b.FONTDATA.lineD*aF*K.useHeight;for(af=0,ad=this.data.length;af<ad;af++){aE=this.data[af];Z=(aE.type==="mlabeledtr"?aA:0);av[af]=[];ap[af]=I;at[af]=O;for(ae=Z,an=aE.data.length+Z;ae<an;ae++){if(ak[ae]==null){if(ae>ao){ao=ae}au[ae]=b.createStack(b.createBox(ax));ak[ae]=-b.BIGDIMEN}av[af][ae]=b.createBox(au[ae]);aN.push(aE.data[ae-Z].toHTML(av[af][ae]))}}b.MeasureSpans(aN);for(af=0,ad=this.data.length;af<ad;af++){aE=this.data[af];Z=(aE.type==="mlabeledtr"?aA:0);for(ae=Z,an=aE.data.length+Z;ae<an;ae++){R=aE.data[ae-Z];if(R.isMultiline){av[af][ae].style.width="100%"}if(R.isEmbellished()){aB=R.CoreMO();var aR=aB.Get("minsize",true);if(aR){var aK=aB.HTMLspanElement().bbox;if(aB.HTMLcanStretch("Vertical")){aS=aK.h+aK.d;if(aS){aR=b.length2em(aR,az,aS);if(aR*aK.h/aS>ap[af]){ap[af]=aR*aK.h/aS}if(aR*aK.d/aS>at[af]){at[af]=aR*aK.d/aS}}}else{if(aB.HTMLcanStretch("Horizontal")){aR=b.length2em(aR,az,aK.w);if(aR>ak[ae]){ak[ae]=aR}}}}}if(av[af][ae].bbox.h>ap[af]){ap[af]=av[af][ae].bbox.h}if(av[af][ae].bbox.d>at[af]){at[af]=av[af][ae].bbox.d}if(av[af][ae].bbox.w>ak[ae]){ak[ae]=av[af][ae].bbox.w}}}var aD=MathJax.Hub.SplitList;var ay=aD(K.columnspacing),aP=aD(K.rowspacing),e=aD(K.columnalign),E=aD(K.rowalign),d=aD(K.columnlines),z=aD(K.rowlines),aL=aD(K.columnwidth),V=[];for(af=0,ad=ay.length;af<ad;af++){ay[af]=b.length2em(ay[af],az)}for(af=0,ad=aP.length;af<ad;af++){aP[af]=b.length2em(aP[af],az)}while(ay.length<ao){ay.push(ay[ay.length-1])}while(e.length<=ao){e.push(e[e.length-1])}while(d.length<ao){d.push(d[d.length-1])}while(aL.length<=ao){aL.push(aL[aL.length-1])}while(aP.length<av.length){aP.push(aP[aP.length-1])}while(E.length<=av.length){E.push(E[E.length-1])}while(z.length<av.length){z.push(z[z.length-1])}if(au[aA]){e[aA]=(K.side.substr(0,1)==="l"?"left":"right");ay[aA]=-ak[aA]}for(af=0,ad=av.length;af<ad;af++){aE=this.data[af];V[af]=[];if(aE.rowalign){E[af]=aE.rowalign}if(aE.columnalign){V[af]=aD(aE.columnalign);while(V[af].length<=ao){V[af].push(V[af][V[af].length-1])}}}if(K.equalrows){var aC=Math.max.apply(Math,ap),X=Math.max.apply(Math,at);for(af=0,ad=av.length;af<ad;af++){Z=((aC+X)-(ap[af]+at[af]))/2;ap[af]+=Z;at[af]+=Z}}aS=ap[0]+at[av.length-1];for(af=0,ad=av.length-1;af<ad;af++){aS+=Math.max(0,at[af]+ap[af+1]+aP[af])}var aH=0,aG=0,aU,g=aS;if(K.frame!=="none"||(K.columnlines+K.rowlines).match(/solid|dashed/)){var w=aD(K.framespacing);if(w.length!=2){w=aD(this.defaults.framespacing)}aH=b.length2em(w[0],az);aG=b.length2em(w[1],az);g=aS+2*aG}var aj,aT,ab="";if(typeof(K.align)!=="string"){K.align=String(K.align)}if(K.align.match(/(top|bottom|center|baseline|axis)( +(-?\d+))?/)){ab=RegExp.$3;K.align=RegExp.$1}else{K.align=this.defaults.align}if(ab!==""){ab=parseInt(ab);if(ab<0){ab=av.length+1+ab}if(ab<1){ab=1}else{if(ab>av.length){ab=av.length}}aj=0;aT=-(aS+aG)+ap[0];for(af=0,ad=ab-1;af<ad;af++){var N=Math.max(0,at[af]+ap[af+1]+aP[af]);aj+=N;aT+=N}}else{aj=({top:-(ap[0]+aG),bottom:aS+aG-ap[0],center:aS/2-ap[0],baseline:aS/2-ap[0],axis:aS/2+b.TeX.axis_height*aF-ap[0]})[K.align];aT=({top:-(aS+2*aG),bottom:0,center:-(aS/2+aG),baseline:-(aS/2+aG),axis:b.TeX.axis_height*aF-aS/2-aG})[K.align]}var ac,ag=0,B=0,L=0,aa=0,ah=0,am=[],ar=[],S=1;if(K.equalcolumns&&K.width!=="auto"){if(aI){ac=(100/(ao+1)).toFixed(2).replace(/\.?0+$/,"")+"%";for(af=0,ad=Math.min(ao+1,aL.length);af<ad;af++){aL[af]=ac}ac=0;ag=1;ah=ao+1;for(af=0,ad=Math.min(ao+1,ay.length);af<ad;af++){ac+=ay[af]}}else{ac=b.length2em(K.width,az);for(af=0,ad=Math.min(ao+1,ay.length);af<ad;af++){ac-=ay[af]}ac/=ao+1;for(af=0,ad=Math.min(ao+1,aL.length);af<ad;af++){ak[af]=ac}}}else{for(af=0,ad=Math.min(ao+1,aL.length);af<ad;af++){if(aL[af]==="auto"){B+=ak[af]}else{if(aL[af]==="fit"){ar[ah]=af;ah++;B+=ak[af]}else{if(aL[af].match(/%$/)){am[aa]=af;aa++;L+=ak[af];ag+=b.length2em(aL[af],az,1)}else{ak[af]=b.length2em(aL[af],az);B+=ak[af]}}}}if(aI){ac=0;for(af=0,ad=Math.min(ao,ay.length);af<ad;af++){ac+=ay[af]}if(ag>0.98){S=0.98/ag;ag=0.98}}else{if(K.width==="auto"){if(ag>0.98){S=L/(B+L);ac=B+L}else{ac=B/(1-ag)}}else{ac=b.length2em(K.width,az);for(af=0,ad=Math.min(ao+1,ay.length);af<ad;af++){ac-=ay[af]}}for(af=0,ad=am.length;af<ad;af++){ak[am[af]]=b.length2em(aL[am[af]],az,ac*S);B+=ak[am[af]]}if(Math.abs(ac-B)>0.01){if(ah&&ac>B){ac=(ac-B)/ah;for(af=0,ad=ar.length;af<ad;af++){ak[ar[af]]+=ac}}else{ac=ac/B;for(ae=0;ae<=ao;ae++){ak[ae]*=ac}}}if(K.equalcolumns){var Q=Math.max.apply(Math,ak);for(ae=0;ae<=ao;ae++){ak[ae]=Q}}}}var T=aj,o,r,aQ;Z=(au[aA]?aA:0);for(ae=Z;ae<=ao;ae++){for(af=0,ad=av.length;af<ad;af++){if(av[af][ae]){Z=(this.data[af].type==="mlabeledtr"?aA:0);R=this.data[af].data[ae-Z];if(R.HTMLcanStretch("Horizontal")){av[af][ae].bbox=R.HTMLstretchH(au[ae],ak[ae]).bbox}else{if(R.HTMLcanStretch("Vertical")){aB=R.CoreMO();var aJ=aB.symmetric;aB.symmetric=false;av[af][ae].bbox=R.HTMLstretchV(au[ae],ap[af],at[af]).bbox;av[af][ae].HH=null;if(av[af][ae].bbox.h>ap[af]){av[af][ae].bbox.H=av[af][ae].bbox.h;av[af][ae].bbox.h=ap[af]}if(av[af][ae].bbox.d>at[af]){av[af][ae].bbox.D=av[af][ae].bbox.d;av[af][ae].bbox.d=at[af]}aB.symmetric=aJ}}aQ=R.rowalign||this.data[af].rowalign||E[af];o=({top:ap[af]-av[af][ae].bbox.h,bottom:av[af][ae].bbox.d-at[af],center:((ap[af]-at[af])-(av[af][ae].bbox.h-av[af][ae].bbox.d))/2,baseline:0,axis:0})[aQ]||0;aQ=(R.columnalign||V[af][ae]||e[ae]);b.alignBox(av[af][ae],aQ,T+o)}if(af<av.length-1){T-=Math.max(0,at[af]+ap[af+1]+aP[af])}}T=aj}if(aI){var G=b.createBox(ax);G.style.left=G.style.top=0;G.style.right=b.Em(ac+2*aH);G.style.display="inline-block";G.style.height="0px";if(b.msieRelativeWidthBug){G=b.createBox(G);G.style.position="relative";G.style.height="1em";G.style.width="100%";G.bbox=ax.bbox}var aO=0,aV=aH,k,l;if(ah){k=100*(1-ag)/ah,l=B/ah}else{k=100*(1-ag)/(ao+1);l=B/(ao+1)}for(ae=0;ae<=ao;ae++){b.placeBox(au[ae].parentNode,0,0);au[ae].style.position="relative";au[ae].style.left=b.Em(aV);au[ae].style.width="100%";au[ae].parentNode.parentNode.removeChild(au[ae].parentNode);var al=b.createBox(G);b.addBox(al,au[ae]);au[ae]=al;var h=al.style;h.display="inline-block";h.left=aO+"%";if(aL[ae].match(/%$/)){var u=parseFloat(aL[ae])*S;if(ah===0){h.width=(k+u)+"%";aO+=k+u;al=b.createBox(al);b.addBox(al,au[ae].firstChild);al.style.left=0;al.style.right=b.Em(l);aV-=l}else{h.width=u+"%";aO+=u}}else{if(aL[ae]==="fit"||ah===0){h.width=k+"%";al=b.createBox(al);b.addBox(al,au[ae].firstChild);al.style.left=0;al.style.right=b.Em(l-ak[ae]);aV+=ak[ae]-l;aO+=k}else{h.width=b.Em(ak[ae]);aV+=ak[ae]}}if(b.msieRelativeWidthBug){b.addText(al.firstChild,b.NBSP);al.firstChild.style.position="relative"}aV+=ay[ae];if(d[ae]!=="none"&&ae<ao&&ae!==aA){r=b.createBox(G);r.style.left=aO+"%";r=b.createRule(r,g,0,1.25/b.em);r.style.position="absolute";r.bbox={h:g,d:0,w:0,rw:1.25/b.em,lw:0};r.parentNode.bbox=ax.bbox;b.placeBox(r,aV-ay[ae]/2,aT,true);r.style.borderStyle=d[ae]}}}else{var U=aH;for(ae=0;ae<=ao;ae++){if(!au[ae].bbox.width){b.setStackWidth(au[ae],ak[ae])}if(aL[ae]!=="auto"&&aL[ae]!=="fit"){au[ae].bbox.width=ak[ae];au[ae].bbox.isFixed=true}b.placeBox(au[ae].parentNode,U,0);U+=ak[ae]+ay[ae];if(d[ae]!=="none"&&ae<ao&&ae!==aA){r=b.createRule(ax,g,0,1.25/b.em);b.addBox(ax,r);r.bbox={h:g,d:0,w:0,rw:1.25/b.em,lw:0};b.placeBox(r,U-ay[ae]/2,aT,true);r.style.borderStyle=d[ae]}}}ax.bbox.d=-aT;ax.bbox.h=g+aT;b.setStackWidth(ax,ax.bbox.w+aH);aU=ax.bbox.w;var ai;if(K.frame!=="none"){ai=b.createFrame(ax,g,0,aU,1.25/b.em,K.frame);b.addBox(ax,ai);b.placeBox(ai,0,aT,true);if(aI){ai.style.width="100%"}}T=aj;for(af=0,ad=av.length-1;af<ad;af++){o=Math.max(0,at[af]+ap[af+1]+aP[af]);if(z[af]!=="none"){r=b.createRule(ax,1.25/b.em,0,aU);b.addBox(ax,r);r.bbox={h:1.25/b.em,d:0,w:aU,rw:aU,lw:0};b.placeBox(r,0,T-at[af]-(o-at[af]-ap[af+1])/2,true);if(z[af]==="dashed"||aI){r.style.borderTop=r.style.height+" "+z[af];r.style.height=0;r.style.width=r.style.borderLeftWidth;r.style.borderLeft="";if(aI){r.style.width="100%"}}}T-=o}if(aI){t.bbox.width=K.width;ax.style.width="100%"}if(au[aA]){var aw=ax.bbox.w,q;var aq=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(aq.indentalignfirst!==a.INDENTALIGN.INDENTALIGN){aq.indentalign=aq.indentalignfirst}if(aq.indentalign===a.INDENTALIGN.AUTO){aq.indentalign=this.displayAlign}if(aq.indentshiftfirst!==a.INDENTSHIFT.INDENTSHIFT){aq.indentshift=aq.indentshiftfirst}if(aq.indentshift==="auto"){aq.indentshift=this.displayIndent}var aM=b.createStack(t,false,"100%");b.addBox(aM,ax);b.alignBox(ax,aq.indentalign,0);if(aq.indentshift&&aq.indentalign!==a.INDENTALIGN.CENTER){q=b.length2em(aq.indentshift,az);aw+=q;ax.style[aq.indentalign]=b.Em(q)}au[aA].parentNode.parentNode.removeChild(au[aA].parentNode);b.addBox(aM,au[aA]);b.alignBox(au[aA],e[aA],0);if(b.msieRelativeWidthBug){ax.style.top=au[aA].style.top=""}if(aI){ax.style.width=K.width;t.bbox.width="100%"}q=b.length2em(K.minlabelspacing,az);au[aA].style.marginRight=au[aA].style.marginLeft=b.Em(q);if(aq.indentalign===a.INDENTALIGN.CENTER){aw+=4*q+2*au[aA].bbox.w}else{if(aq.indentalign!==e[aA]){aw+=2*q+au[aA].bbox.w}}t.style.minWidth=t.bbox.minWidth=aM.style.minWidth=aM.bbox.minWidth=b.Em(aw)}if(!aI){this.HTMLhandleSpace(t)}var v=this.HTMLhandleColor(t);if(v&&aI){if(!ai){ai=b.createFrame(ax,g,0,aU,0,"none");b.addBox(ax,ai);b.placeBox(ai,0,aT,true);ai.style.width="100%"}ai.style.backgroundColor=v.style.backgroundColor;ai.parentNode.insertBefore(ai,ai.parentNode.firstChild);v.parentNode.removeChild(v)}return t},HTMLhandleSpace:function(d){d.bbox.keepPadding=true;d.bbox.exact=true;if(!this.hasFrame&&d.bbox.width==null){d.style.paddingLeft=d.style.paddingRight=b.Em(1/6)}this.SUPER(arguments).HTMLhandleSpace.call(this,d)}});a.mtd.Augment({toHTML:function(e,d,g){e=this.HTMLcreateSpan(e);if(this.data[0]){var f=this.data[0].toHTML(e);if(g!=null){f=this.data[0].HTMLstretchV(e,d,g)}else{if(d!=null){f=this.data[0].HTMLstretchH(e,d)}}e.bbox=f.bbox}this.HTMLhandleSpace(e);this.HTMLhandleColor(e);return e},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});MathJax.Hub.Startup.signal.Post("HTML-CSS mtable Ready");MathJax.Ajax.loadComplete(b.autoloadDir+"/mtable.js")});
MathJax.Ajax.loadComplete("[MathJax]/config/AM_HTMLorMML-full.js");
