// license:BSD-3-Clause
// copyright-holders:Ryan Holtz

/***************************************************************************

  Netlist (stuntcyc) included from atarittl.cpp

***************************************************************************/

#include "netlist/devices/net_lib.h"

NETLIST_START(stuntcyc)

	SOLVER(Solver, 48000)
	PARAM(Solver.PARALLEL, 0) // Don't do parallel solvers
	PARAM(Solver.ACCURACY, 1e-4) // works and is sufficient
	PARAM(NETLIST.USE_DEACTIVATE, 1)

	ANALOG_INPUT(V5, 5)
	ALIAS(VCC, V5)

	TTL_INPUT(high, 1)
	TTL_INPUT(low, 0)

	MAINCLOCK(main_clk, 14258400)
	//MAINCLOCK(main_clk, 14318181)
	ALIAS(Y1, main_clk)

#if 1
	TTL_7404_INVERT(N3_6, main_clk)
	ALIAS(HF_CLOCK, N3_6.Q)

	ALIAS(P, high)
	ALIAS(GROUND, low)

	TTL_7474(N4_2, N3_6.Q, N4_2.QQ, P, P)
	ALIAS(CLOCK,  N4_2.Q)
	ALIAS(CLOCK_Q, N4_2.QQ)

	TTL_9316(M4, N4_2.Q,     P, P, P, J6_1.Q, GROUND, GROUND, GROUND, GROUND)
	TTL_9316(L4, N4_2.Q, M4.RC, P, P, J6_1.Q, GROUND, GROUND, GROUND, GROUND)
	ALIAS(  1H, M4.QA)
	ALIAS(  2H, M4.QB)
	ALIAS(  4H, M4.QC)
	ALIAS(  8H, M4.QD)
	ALIAS( 16H, L4.QA)
	ALIAS( 32H, L4.QB)
	ALIAS( 64H, L4.QC)
	ALIAS(128H, L4.QD)

	TTL_74107(K4_1, 128H, P, P, P)
	ALIAS(256H,  K4_1.Q)
	ALIAS(256H_Q, K4_1.QQ)

	TTL_7420_NAND(J6_1, 8H, 64H, 128H, 256H)
	ALIAS(HRESET_Q, J6_1.Q)

	TTL_7404_INVERT(H6_3, HRESET_Q)
	ALIAS(HRESET, H6_3.Q)

	TTL_7493(L3, HRESET, L3.QA, VRESET, VRESET)
	TTL_7493(K3, L3.QD,  K3.QA, VRESET, VRESET)
	ALIAS(  1V, L3.QA)
	ALIAS(  2V, L3.QB)
	ALIAS(  4V, L3.QC)
	ALIAS(  8V, L3.QD)
	ALIAS( 16V, K3.QA)
	ALIAS( 32V, K3.QB)
	ALIAS( 64V, K3.QC)
	ALIAS(128V, K3.QD)

	TTL_74107(K4_2, 128V, P, P, VRESET_Q)
	ALIAS(256V, K4_2.Q)
	ALIAS(256V_Q, K4_2.QQ)

	TTL_7410_NAND(M5_3, 256V, 2V, 1V)
	TTL_7474(M3_2, HRESET, M5_3.Q, P, P)
	ALIAS(VRESET, M3_2.QQ)
	ALIAS(VRESET_Q, M3_2.Q)

	TTL_7402_NOR(J5_2, HSYNC,  HRESET)
	TTL_7402_NOR(J5_1, 32H,    HSYNC_Q)
	TTL_7402_NOR(J5_3,  8V,    VSYNC_Q)
	TTL_7402_NOR(J5_4, VSYNC,  VRESET)
	ALIAS(HSYNC,  J5_1.Q)
	ALIAS(HSYNC_Q, J5_2.Q)
	ALIAS(VSYNC,  J5_3.Q)
	ALIAS(VSYNC_Q, J5_4.Q)

	TTL_7486_XOR(J4_1, HSYNC, VSYNC_Q)
	ALIAS(COMP_SYNC_Q, J4_1.Q)

	TTL_7400_NAND(N5_2, FIXED_RAMP_ZONE, H_WINDOW)
	ALIAS(RAMP_WINDOW_HIT_Q, N5_2.Q)

	TTL_7474(N4_1, H_WINDOW, HSYNC, RAMP_WINDOW_HIT_Q, N4_1.QQ)
	TTL_7474(M3_1, N4_1.Q, DIRECTION_Q, CYCLE_RESET_Q, P)
	ALIAS(DIRECTION, M3_1.Q)
	ALIAS(DIRECTION_Q, M3_1.QQ)

	TTL_7404_INVERT(N3_3, 32V)
	ALIAS(32V_Q, N3_3.Q)
	TTL_7474(J2_2, 32V_Q, J2_1.Q, P, P)
	TTL_7474(J2_1, N4_1.Q, P, J2_2.QQ, P)

	TTL_7408_AND(H5_2, 256V_Q, VSYNC_Q)
	TTL_9316(K1, HSYNC,     P, H5_2.Q,  V_COUNTER_RESET_Q, L2_3.Q,  Av,  Bv,  Cv,  Dv)
	TTL_9316(K2, HSYNC, K1.RC, J2_2.QQ, V_COUNTER_RESET_Q, L2_3.Q, GROUND, GROUND, GROUND, GROUND)
	TTL_7400_NAND(L2_3, K1.RC, V_WINDOW)
	ALIAS(V1, K1.QA)
	ALIAS(V2, K1.QB)
	ALIAS(V3, K1.QC)
	ALIAS(V4, K1.QD)
	ALIAS(V_WINDOW, K2.RC)

	TTL_7402_NOR(D4_3, DIRECTION_Q, H6)   // Schematic says DIRECTION
	TTL_7408_AND(B5_1, DIRECTION_Q, H5_AND_H6) // Schematic says DIRECTION
	TTL_7402_NOR(D4_4, D4_3.Q, B5_1.Q)
	TTL_7400_NAND(H2_1, HSYNC_Q, D4_4.Q)
	TTL_7400_NAND(H2_2, HSYNC_Q, H5)

	TTL_9322(J1, HSYNC, V4, P, V3, 4V, V1, 1V, V2, 2V, GROUND)
	PROM_82S115(hf1, GROUND, P, J1.Y3, J1.Y4, J1.Y2, J1.Y1, H2_2.Q, H2_1.Q, R2, R3, R4, P)
	PARAM(hf1.ROM, "004275.f1")

	CLOCK(PROBECLK, 7129200)
	ALIAS(probe_bit0, WHITE_VIDEO)
	ALIAS(probe_bit1, WHITE_VIDEO)
	ALIAS(probe_bit2, WHITE_VIDEO)
	ALIAS(probe_bit3, WHITE_VIDEO)
	ALIAS(probe_bit4, BLACK_VIDEO)
	ALIAS(probe_bit5, BLACK_VIDEO)
	ALIAS(probe_bit6, BLACK_VIDEO)
	ALIAS(probe_clock, PROBECLK)

	TTL_7404_INVERT(D3_5, H1)
	TTL_74194(E1, D3_5.Q, MS_1, MS_2, GROUND,   hf1.O1, hf1.O2, hf1.O3, hf1.O4, E2.QA, CYCLE_RESET_A_Q)
	TTL_74194(E2, D3_5.Q, MS_1, MS_2, E1.QD, hf1.O4, hf1.O5, hf1.O6, hf1.O7, GROUND,   CYCLE_RESET_A_Q)

	TTL_74165(F2, CLOCK, GROUND, HSYNC_Q, F2.QH, hf1.O1, hf1.O2, hf1.O3, hf1.O4, hf1.O5, hf1.O6, hf1.O7, hf1.O8)
	TTL_7474(D2_1, CLOCK, F2.QH, OBJECT_ZONE, P)
	ALIAS(OBJECTS_Q, D2_1.QQ)

	TTL_7450_ANDORINVERT(D1_2, E1.QA, DIRECTION, E2.QD, DIRECTION_Q)
	TTL_7474(D2_2, H1, D1_2.Q, P, V_WINDOW)
	ALIAS(CYCLE, D2_2.QQ)
	ALIAS(CYCLE_Q, D2_2.Q)

	/* Coin circuitry */
	TTL_7404_INVERT(K8_6, K8_5.Q)
	TTL_7404_INVERT(K8_5, K8_6.Q)

	DIODE(D20, "1N4001")
	DIODE(D21, "1N914")
	DIODE(D22, "1N914")

	SWITCH2(coinsw)
	NET_C(K8_6.Q, coinsw.1)
	NET_C(D21.K, coinsw.2)
	NET_C(coinsw.Q, GND)

	NET_C(K8_6.Q, D21.A)
	NET_C(K8_6.Q, D22.A)
	NET_C(D21.K, D20.A)
	NET_C(D20.K, V5)
	NET_C(D22.K, V5)

	TTL_7474(H8_2, 64V, K8_5.Q, K8_5.Q, P)

	SWITCH2(creditsw)
	NET_C(creditsw.1, GND)
	NET_C(creditsw.2, P)

	TTL_7474(F8_1, END_GAME, F8_2.QQ, H9_3.Q,    H8_2.QQ)
	TTL_7474(F8_2, F8_1.QQ,  P,       ATTRACT_Q, P)
	ALIAS(FREE_COIN, F8_2.Q)
	ALIAS(FREE_COIN_Q, F8_2.QQ)
	ALIAS(FREE_PLAY, F8_1.QQ)
	ALIAS(FREE_PLAY_Q, F8_1.Q)

	SWITCH2(freegamesw)
	NET_C(freegamesw.1, P)
	NET_C(freegamesw.2, GND)
	TTL_7410_NAND(H9_3, ATTRACT_Q, freegamesw.Q, FREE_GAME)

	/* Antenna to suppress player attempts at glitching in a credit via a piezo spark */
	/* Has a diode to clamp negative voltages - omitted here */

	TTL_INPUT(ANTENNA, 0)

	QBJT_SW(Q9, "2N3643")
	RES(R9, 330)
	RES(R10, 100)
	CAP(CX3, CAP_U(0.1))
	NET_C(ANTENNA, Q9.B)
	NET_C(Q9.E, GND)

	NET_C(R10.1, CX3.1, Q9.C, R9.1)
	NET_C(R10.2, GND)
	NET_C(CX3.2, GND)
	QBJT_SW(Q10, "2N3643")
	NET_C(Q10.B, R10.1)
	NET_C(Q10.E, GND)

	DIODE(D2, "1N914")
	RES(R7, 100)
	RES(R8, 330)
	CAP(C2, CAP_U(0.1))
	QBJT_SW(Q11, "2N3644")

	NET_C(D2.A, R8.1, Q10.C)
	ALIAS(COIN_Q, D2.K)

	NET_C(R8.2, R7.2, C2.2, Q11.B)
	NET_C(R7.1, C2.1, Q11.E, V5)
	NET_C(R9.2, Q11.C)

	TTL_7486_XOR(C8_4, Q11.C, P)
	ALIAS(QQ, C8_4.Q)

	/* Start buttons, etc. */
	SWITCH(START1)
	RES(R11, RES_K(1))
	NET_C(START1.2, GND)
	NET_C(R11.1, V5)
	NET_C(START1.1, R11.2)
	TTL_7410_NAND(H9_1, 2_PLAYER_CREDIT, START, R11.2)

	SWITCH(START2)
	RES(R12, RES_K(1))
	NET_C(START2.2, GND)
	NET_C(R12.1, V5)
	NET_C(START2.1, R12.2)
	TTL_7410_NAND(H9_2, H9_1.Q, START, R12.2)

	TTL_7400_NAND(J8_2, FREE_COIN_Q, H8_2.QQ)
	TTL_74107(J9_2, 64V, J8_2.Q, J9_1.QQ, J8_2.Q)
	TTL_7450_ANDORINVERT(K9_2, creditsw.Q, K8_5.Q, FREE_COIN, 2_PLAYER_MODE_Q)
	TTL_7400_NAND(J8_1, K9_2.Q, J9_2.QQ)
	TTL_74107(J9_1, 64V, J8_1.Q, GROUND, J8_2.Q)

	TTL_7402_NOR(F9_4, END_GAME, QQ)
	TTL_7474(D9_2, 256V, START, F9_4.Q, ATTRACT)
	ALIAS(ATTRACT, D9_2.QQ)
	ALIAS(ATTRACT_Q, D9_2.Q)

	TTL_7402_NOR(F9_1, R11.2, R12.2)
	TTL_7427_NOR(D8_1, J8_2.Q, CREDIT_Q, ATTRACT_Q)
	TTL_7474(D9_1, 256V, F9_1.Q, P, D8_1.Q)
	ALIAS(START, D9_1.QQ)
	ALIAS(START_Q, D9_1.Q)

	TTL_7474(H8_1, ATTRACT, GROUND, H9_2.Q, H9_1.Q)
	ALIAS(2_PLAYER_MODE, H8_1.Q)
	ALIAS(2_PLAYER_MODE_Q, H8_1.QQ)
	TTL_7400_NAND(J8_4, 2_PLAYER_MODE, V_RAMP)
	TTL_7400_NAND(J8_3, START, J8_4.Q)

	TTL_74193(E8, P, P, P, P, QQ, E8.CARRYQ, COIN_Q, J8_3.Q)
	TTL_7427_NOR(D8_2, E8.QB, E8.QC, E8.QD)
	TTL_7404_INVERT(K8_4, D8_2.Q)
	ALIAS(2_PLAYER_CREDIT, K8_4.Q)
	TTL_7402_NOR(F9_3, E8.QA, 2_PLAYER_CREDIT)
	ALIAS(CREDIT_Q, F9_3.Q)
	TTL_7402_NOR(F9_2, CREDIT_Q, CREDIT_Q)
	ALIAS(CREDIT, F9_2.Q)

	/* Score Window */

	TTL_7402_NOR(L1_4,  64V, 128V)
	TTL_7410_NAND(H4_1, 16V, 32V, L1_4.Q)
	ALIAS(V_SCORE_Q, H4_1.Q)

	TTL_7486_XOR(J4_2,  32H, 256H)
	ALIAS(32H_XOR_256H, J4_2.Q)

	TTL_7486_XOR(J4_3, 128H, 256H)
	ALIAS(128H_XOR_256H, J4_3.Q)

	TTL_7486_XOR(J4_4,  64H, 256H_Q)
	TTL_7410_NAND(H4_3, J4_3.Q, J4_2.Q, J4_4.Q)
	ALIAS(H_SCORE_Q, H4_3.Q)

	TTL_7402_NOR(J3_1, V_SCORE_Q, H_SCORE_Q)
	ALIAS(SCORE_WINDOW, J3_1.Q)

	/* Video Generation */

	TTL_7400_NAND(H2_4, 8V, 32V)
	TTL_7474(H3_2, VSYNC_Q, P, H2_4.Q, P)
	TTL_7474(H3_1, 1V, 32V, P, H3_2.QQ)
	TTL_7402_NOR(J3_4, H3_2.QQ, HSYNC)
	TTL_7400_NAND(H2_3, J3_4.Q, 128H_XOR_256H)
	TTL_7410_NAND(H4_2, 1H, H3_1.QQ, 32V)
	ALIAS(ROAD_Q, H4_2.Q)

	TTL_7402_NOR(J3_2, 256H_Q, H2_3.Q)
	TTL_7402_NOR(J3_3, H2_3.Q, 256H)
	TTL_7486_XOR(C8_3, PLAYER_CONTROL, 256H)
	TTL_7450_ANDORINVERT(F3_2, RETURN_THROTTLE,   J3_2.Q, J3_3.Q, FREE_PLAY)
	TTL_7450_ANDORINVERT(F3_1, RETURN_THROTTLE_Q, J3_2.Q, FREE_PLAY_Q, J3_3.Q)

	TTL_7427_NOR(K5_3, 64H, 32H_XOR_256H, V_SCORE_Q)
	TTL_7400_NAND(F4_4, 128H_XOR_256H, K5_3.Q)

	TTL_7402_NOR(D4_1, PLAYER_CONTROL, CYCLE_Q)
	TTL_7402_NOR(D4_2, F4_4.Q, C8_3.Q)
	TTL_7404_INVERT(D3_3, F3_2.Q)
	TTL_7427_NOR(E4_3, D3_3.Q, D4_2.Q, D4_1.Q)
	TTL_7410_NAND(E3_1, SCORE_1_Q, OBJECTS_Q, E4_3.Q)
	ALIAS(WHITE_VIDEO, E3_1.Q)

	TTL_7400_NAND(F4_2, PLAYER_CONTROL, CYCLE)
	TTL_7404_INVERT(D3_1, F4_4.Q)
	TTL_7400_NAND(F4_3, C8_3.Q, D3_1.Q)
	TTL_7410_NAND(E3_2, F4_2.Q, F4_3.Q, F3_1.Q)
	TTL_7400_NAND(F4_1, RAMPS_Q, ROAD_Q)
	TTL_7427_NOR(E4_2, F4_1.Q, SCORE_2, E3_2.Q)
	ALIAS(BLACK_VIDEO, E4_2.Q)

	RES(R13, RES_K(1))
	NET_C(R13.1, E3_1.Q)
	RES(R14, RES_K(1))
	NET_C(R14.1, V5)
	RES(R15, RES_K(1))
	NET_C(R15.1, E4_2.Q)
	//RES(R107, RES_K(1))

	DIODE(D17, "1N914")
	NET_C(D17.K, COMP_SYNC_Q)
	//NET_C(D17.A, R107.1, R13.2, R14.2, R15.2)
	NET_C(D17.A, R13.2, R14.2, R15.2)

	//NET_C(R107.2, GND)
	ALIAS(VIDEO_OUT, R13.2)

	/* Horizontal movement */

	TTL_7474(C2_1, SPEED_PULSES, P, C2_2.QQ, P)
	TTL_7474(C2_2, A3_2.Q, C2_1.Q, P, P)
	TTL_7493(C1, C2_1.Q, C1.QA, FLIP, FLIP)
	ALIAS(MOTOR_PULSE, C1.QA)
	ALIAS(R4, C1.QD)

	TTL_7400_NAND(B2_2, DIRECTION_Q, C2_2.Q)
	TTL_9316(C3, HF_CLOCK, P,     P, H_COUNTER_RESET_Q, A3_2.Q, C2_2.Q, B2_2.Q, P, P)
	TTL_9316(B3, HF_CLOCK, C3.RC, P, H_COUNTER_RESET_Q, A3_2.Q, GROUND,    P,      P, GROUND)
	ALIAS(H1, C3.QA)
	ALIAS(H2, C3.QB)
	ALIAS(H3, C3.QC)
	ALIAS(H4, C3.QD)
	ALIAS(H5, B3.QA)
	ALIAS(H6, B3.QB)
	ALIAS(H7, B3.QC)
	ALIAS(H8, B3.QD)

	TTL_7408_AND(B5_3, H5, H6)
	ALIAS(H5_AND_H6, B5_3.Q)

	TTL_74107(B4_2, B3.RC,  P, P, H_COUNTER_RESET_Q)
	TTL_74107(B4_1, B4_2.Q, P, P, H_COUNTER_RESET_Q)

	TTL_7410_NAND(C4_1, B4_1.QQ, B3.RC, B4_2.Q)
	TTL_7404_INVERT(D3_6, C4_1.Q)
	TTL_7400_NAND(A3_2, D3_6.Q, C3.RC)

	TTL_7410_NAND(C4_3, B4_2.Q,  H8,    B4_1.Q)
	TTL_7427_NOR(E4_1, H5_AND_H6, H7, C4_3.Q)
	ALIAS(H_WINDOW, E4_1.Q)

	TTL_7474(A4_1, H4, E4_1.Q, P,      P)
	TTL_7474(A4_2, H2, H4,     A4_1.Q, P)
	ALIAS(H_WINDOW_DELAYED, A4_1.Q)

	TTL_7402_NOR(A8_4, H4, A4_2.QQ)
	TTL_7404_INVERT(D3_4, A8_4.Q)
	TTL_7400_NAND(B2_4, DIRECTION,   D3_4.Q)
	TTL_7400_NAND(B2_1, DIRECTION_Q, D3_4.Q)
	ALIAS(MS_1, B2_4.Q)
	ALIAS(MS_2, B2_1.Q)

	/* Scoring, etc. logic */

	TTL_7400_NAND(A3_1, C4_2.Q, CYCLE_RESET_A_Q)
	TTL_7410_NAND(C4_2, A3_1.Q, BAD_JUMP_Q, FLIP_Q)
	TTL_7410_NAND(D6_3, E5.QA,  VRESET, 2_PLAYER_MODE_Q)
	TTL_7474(C5_1, A3_1.Q, GROUND, D6_3.Q, COMP_SCORE_Q)
	TTL_7400_NAND(D5_3, OUT_OF_SEQUENCE_RESET_Q, C5_1.Q)

	TTL_INPUT(MISS_SW_B0, 1)
	TTL_INPUT(MISS_SW_B1, 1)
	TTL_INPUT(MISS_SW_B2, 1)
	TTL_74193(E5, GROUND, MISS_SW_B0, MISS_SW_B1, MISS_SW_B2, GROUND, START_Q, P, D5_3.Q)
	ALIAS(END_GAME_Q, E5.BORROWQ)

	TTL_7408_AND(H5_4, ATTRACT_Q, 128V)
	TTL_7474(C5_2, GOOD_JUMP_Q, MAX_SCORE_Q, H5_4.Q, P)

	TTL_7402_NOR(A8_2, E5.QA, C5_2.QQ)
	TTL_74192(B8, GROUND, GROUND, GROUND, P, GROUND, START_Q, A8_2.Q, P)
	TTL_7474(A9_2, B8.CARRYQ, A9_2.QQ, START_Q, P)
	TTL_7402_NOR(A8_3, A9_2.Q, B8.QD)
	ALIAS(A, B8.QA)
	ALIAS(B, B8.QB)
	ALIAS(C, B8.QC)
	ALIAS(D, B8.QD)
	ALIAS(E, A9_2.Q)
	ALIAS(F, A8_3.Q)

	TTL_7408_AND(B5_2, E5.QA, C5_2.Q)
	TTL_74192(B9, GROUND, GROUND, GROUND, P, GROUND, START_Q, B5_2.Q, P)
	TTL_7474(A9_1, B9.CARRYQ, A9_1.QQ, START_Q, P)
	TTL_7402_NOR(A8_1, A9_1.Q, B9.QD)
	ALIAS(G, B9.QA)
	ALIAS(H, B9.QB)
	ALIAS(J, B9.QC)
	ALIAS(K, B9.QD)
	ALIAS(L, A9_1.Q)
	ALIAS(M, A8_1.Q)

	TTL_7400_NAND(D5_4, E5.QA, 2_PLAYER_MODE)
	ALIAS(PLAYER_CONTROL_Q, D5_4.Q)
	TTL_7404_INVERT(H6_4, PLAYER_CONTROL_Q)
	ALIAS(PLAYER_CONTROL, H6_4.Q)

	TTL_7404_INVERT(D3_2, 128V)
	TTL_7450_ANDORINVERT(D1_1, D3_2.Q, 256H_Q, D5_4.Q, 128V)

	TTL_9322(B7, D1_1.Q, A, G, B, H, D,   K,   C,   J,   GROUND)
	TTL_9322(A7, D1_1.Q, E, L, M, F, GROUND, GROUND, GROUND, GROUND, GROUND)
	ALIAS(S1, B7.Y1)
	ALIAS(S2, B7.Y2)
	ALIAS(S3, B7.Y4)
	ALIAS(S4, B7.Y3)
	ALIAS(S5, A7.Y1)
	ALIAS(S6, A7.Y2)

	TTL_9322(C7, 16H, S5, S1, S6, S2, GROUND, S4, GROUND, S3, GROUND)
	TTL_7448(C6, C7.Y1, C7.Y2, C7.Y4, C7.Y3, P, SCORE_WINDOW, 16H)
	DM9312(B6, 2H, 4H, 8H, 8H, C6.f, GROUND, GROUND, C6.b, C6.e, GROUND, GROUND, C6.c)
	DM9312(A6, 2V, 4V, 8V, 8H, C6.a, GROUND, GROUND, C6.g, GROUND,  GROUND, GROUND, C6.d)
	TTL_7408_AND(B5_4, A6.YQ, B6.YQ)
	TTL_7474(A5_1, CLOCK, B5_4.Q, P, P)
	ALIAS(COMP_SCORE_Q, A5_1.Q)

	TTL_7400_NAND(M7_2, 128H, A5_1.QQ)
	ALIAS(SCORE_1_Q, M7_2.Q)

	TTL_7402_NOR(K6_1, A5_1.Q, 128H)
	ALIAS(SCORE_2, K6_1.Q)

	PROM_82S123(d7, GROUND, S1, S2, S3, S4, S5)
	PARAM(d7.ROM, "004811.d7")

	ALIAS(MAX_SCORE_Q, d7.O6)

	TTL_7410_NAND(D6_1, 256H_Q, 128H, 128H)
	TTL_7427_NOR(D8_3, 64H, 32H, D6_1.Q)
	TTL_7486_XOR(C8_2, D6_1.Q, d7.O5)
	ALIAS(FIXED_RAMP_ZONE, D8_3.Q)

	TTL_INPUT(FREESCORE_SW_B0, 0)
	TTL_INPUT(FREESCORE_SW_B1, 0)
	TTL_INPUT(FREESCORE_SW_B2, 0)
	TTL_INPUT(FREESCORE_SW_B3, 1)
	TTL_7402_NOR(K6_4, d7.O5, OBJECT_ZONE_Q)
	TTL_7485(E6, d7.O1, d7.O2, d7.O3, d7.O4, 8H, 16H, 32H, 64H, GROUND, C8_2.Q, GROUND)
	TTL_7485(E7, d7.O1, d7.O2, d7.O3, d7.O4, FREESCORE_SW_B0, FREESCORE_SW_B1, FREESCORE_SW_B2, FREESCORE_SW_B3, GROUND, K6_4.Q, GROUND)
	ALIAS(FREE_GAME, E7.EQOUT)

	TTL_7474(F6_1, CLOCK_Q, E6.EQOUT, 128H_XOR_256H, P)
	TTL_9316(H7, 1H, H6_1.Q, P, P, F6_1.QQ, P, P, GROUND, GROUND)
	TTL_7404_INVERT(H6_1, H7.RC)
	TTL_7474(A5_2, H7.RC, P, HRESET_Q, P)
	TTL_7474(J7_1, H_WINDOW, A5_2.QQ, BAD_JUMP_Q, P)
	TTL_7474(K7_1, JUMP_Q, J7_1.Q,  CYCLE_RESET_A_Q, P)
	TTL_7474(K7_2, JUMP_Q, J7_1.QQ, CYCLE_RESET_A_Q, OBJECT_HIT_Q)
	ALIAS(GOOD_JUMP, K7_1.Q)
	ALIAS(GOOD_JUMP_Q, K7_1.QQ)
	ALIAS(BAD_JUMP, K7_2.Q)
	ALIAS(BAD_JUMP_Q, K7_2.QQ)

	TTL_7404_INVERT(H6_2, FIXED_RAMP_ZONE)
	TTL_7474(J7_2, H6_2.Q, V_RAMP, H7.RC, P)
	ALIAS(OBJECT_ZONE, J7_2.Q)
	ALIAS(OBJECT_ZONE_Q, J7_2.QQ)
	ALIAS(FIXED_RAMP_ZONE_Q, H6_2.Q)

	TTL_7408_AND(H5_3, F6_1.QQ, H7.RC)
	TTL_7408_AND(H5_1, FIXED_RAMP_ZONE_Q, H7.RC)

	TTL_7486_XOR(M2_2, 1V, H5_3.Q)
	TTL_7486_XOR(M2_4, 2V, H5_3.Q)
	TTL_7486_XOR(M2_1, 4V, H5_3.Q)

	TTL_7493(N1, 2H, N1.QA, H5_1.Q, H5_1.Q)
	TTL_7485(N2, M2_2.Q, M2_4.Q, M2_1.Q, GROUND, N1.QA, N1.QB, N1.QC, N1.QD, GROUND, GROUND, GROUND)
	TTL_7486_XOR(M2_3, N2.GTOUT, H5_3.Q)
	TTL_7400_NAND(L2_1, 16V, 64V)
	TTL_7402_NOR(L1_1, L2_1.Q, 32V)
	TTL_7400_NAND(L2_4, CYCLE_RESET, VRESET)
	TTL_7410_NAND(E3_3, 8V, 128V, L1_1.Q)
	TTL_7404_INVERT(N3_4, E3_3.Q)
	TTL_7474(M1_1, 8V, L1_1.Q, L2_4.Q, M1_1.QQ)
	TTL_7474(M1_2, 1H, M2_3.Q, V_RAMP, P)
	TTL_7400_NAND(L2_2, M1_1.QQ, L1_1.Q)
	TTL_7402_NOR(L1_2, H5_1.Q, M1_2.QQ)
	ALIAS(V_RAMP, N3_4.Q)
	ALIAS(V_RAMP_Q, E3_3.Q)
	ALIAS(V_COUNTER_RESET_Q, L2_2.Q)
	ALIAS(RAMPS, L1_2.Q)

	TTL_7402_NOR(L1_3, RAMPS, RAMPS)
	ALIAS(RAMPS_Q, L1_3.Q)

	TTL_7400_NAND(D5_1, FIXED_RAMP_ZONE_Q, D5_2.Q)
	TTL_7400_NAND(D5_2, CYCLE_RESET_Q, D5_1.Q)
	ALIAS(H_COUNTER_RESET_Q, D5_1.Q)

	TTL_7404_INVERT(H6_6, END_GAME_Q)
	ALIAS(END_GAME, H6_6.Q)

	TTL_7404_INVERT(K8_1, RETURN_THROTTLE)
	ALIAS(RETURN_THROTTLE_Q, K8_1.Q)

	/* Controls */

	CLOCK(SPEED_PULSES, 1000) // FIXME: Should be output of a 566 VCO
	TTL_INPUT(R38_2, 0) // FIXME: Should be output of the resistor connected to LM747 L10_1
	TTL_INPUT(R39_2, 0) // FIXME: Should be output of the resistor connected to LM747 L10_2

	// FIXME: Hack
	TTL_7400_NAND(N5_4, SPEED_KILL_Q, CYCLE_RESET_Q)
	TTL_7410_NAND(M5_2, P, ATTRACT_Q, N5_4.Q)
	ALIAS(SPEED_KILL_Q, M5_2.Q)

	TTL_7402_NOR(K6_2, CYCLE_RESET, SPEED_KILL_Q)
	ALIAS(RETURN_THROTTLE, K6_2.Q)

	TTL_7408_AND(N8_1, CYCLE_WINDOW, RAMPS)
	ALIAS(RAMPS_AND_CYCLE_WINDOW, N8_1.Q)

	TTL_7400_NAND(M7_1, OBJECT_ZONE, CYCLE)
	ALIAS(OBJECT_HIT_Q, M7_1.Q)

	TTL_7400_NAND(N9_2, FIXED_RAMP_ZONE, RAMPS_AND_CYCLE_WINDOW)
	TTL_7408_AND(N8_4, OBJECT_HIT_Q, N9_2.Q)
	ALIAS(LOAD_Q, N8_4.Q)

	RES(R106, 330)
	CAP(C57, CAP_P(220))
	NET_C(R106.1, LOAD_Q)
	NET_C(R106.2, C57.1)
	NET_C(C57.2, GND)

	TTL_7400_NAND(N9_4, R106.2, N9_1.Q)
	TTL_7400_NAND(N9_1, MS_3, N9_4.Q)
	ALIAS(JUMP, N9_4.Q)
	ALIAS(JUMP_Q, N9_1.Q)

	TTL_7400_NAND(N9_3, JUMP, BAD_JUMP_Q)

	TTL_7400_NAND(L9_1, R39_2, BAD_JUMP_Q)
	TTL_7400_NAND(L9_2, BAD_JUMP, 64V)
	TTL_7420_NAND(M9_1, R38_2, GRAVITY, BAD_JUMP_Q, SPEED_KILL_Q)
	TTL_7420_NAND(M9_2, L9_2.Q, SPEED_KILL_Q, L9_1.Q, GRAVITY)

	TTL_7408_AND(L6_4, H_WINDOW_DELAYED, V_WINDOW)
	ALIAS(CYCLE_WINDOW, L6_4.Q)

	TTL_7474(N7_2, V_RAMP_Q, V_WINDOW, P, CYCLE_RESET_A_Q)
	ALIAS(MS_3, N7_2.QQ)

	TTL_7408_AND(N8_3, M8.QD, N7_2.Q)
	ALIAS(SFX_CRASH, N8_3.Q)

	TTL_7400_NAND(M7_4, MS_3, M8.BORROWQ)
	TTL_7400_NAND(L9_4, BAD_JUMP_Q, M7_4.Q)
	TTL_7400_NAND(L9_3, CYCLE_RESET_Q, L9_4.Q)
	TTL_74193(M8, P, P, GROUND, GROUND, L9_3.Q, N9_3.Q, M9_1.Q, M9_2.Q)
	ALIAS(R2, M8.QB)
	ALIAS(R3, M8.QC)

	TTL_74193(L8, FIXED_RAMP_ZONE_Q, FIXED_RAMP_ZONE, GROUND, GROUND, JUMP_Q, LOAD_Q, P, GRAVITY) // Schematics say C and D should be to VCC?
	ALIAS(Av, L8.QA)
	ALIAS(Bv, L8.QB)
	ALIAS(Cv, L8.QC)

	TTL_7404_INVERT(K8_3, L8.QD)
	ALIAS(Dv, K8_3.Q)

	TTL_7400_NAND(M6_1, JUMP_Q, FLIP)
	TTL_7408_AND(N8_2, R2, R3)
	TTL_7474(N7_1, VRESET_Q, N8_2.Q, CYCLE_RESET_Q, FLIP_Q)
	ALIAS(FLIP, N7_1.Q)
	ALIAS(FLIP_Q, N7_1.QQ)

	TTL_7402_NOR(L7_4, BAD_JUMP, FLIP_Q)
	ALIAS(SFX_SCREECH, L7_4.Q)

	TTL_7402_NOR(L7_3, FLIP, JUMP)
	ALIAS(FLIP_OR_JUMP_Q, L7_3.Q)

	TTL_7402_NOR(L7_2, FLIP, RAMPS_AND_CYCLE_WINDOW)
	TTL_7402_NOR(L7_1, BAD_JUMP, L7_2.Q)

	TTL_7493(L5, VRESET_Q, L5.QA, L7_1.Q, L7_1.Q)
	TTL_7474(F6_2, HSYNC_Q, L5.QD, BAD_JUMP_Q, P)
	TTL_7408_AND(L6_3, L5.QD, F6_2.QQ)
	ALIAS(GRAVITY, L6_3.Q)

	TTL_7427_NOR(K5_1, 2V, L5.QA, 32V)
	ALIAS(SFX_BOUNCE_SOUND, K5_1.Q)

	TTL_7400_NAND(M7_3, MS_3, BAD_JUMP_Q)
	TTL_7410_NAND(M5_1, M7_3.Q, HRESET, CYCLE)
	TTL_7427_NOR(K5_2, 16V, HSYNC, 128V)
	TTL_7400_NAND(M6_3, CYCLE, K5_2.Q)
	ALIAS(OUT_OF_SEQUENCE_RESET_Q, M6_3.Q)

	TTL_7408_AND(L6_1, M5_1.Q, OUT_OF_SEQUENCE_RESET_Q)
	TTL_7400_NAND(M6_4, SFX_SCREECH, JUMP)
	TTL_7408_AND(L6_2, L6_1.Q, M6_4.Q)

	RES(R40, RES_K(47))
	RES(R41, RES_K(2.2))
	RES(R42, RES_K(2.2))
	RES(R43, RES_K(47))
	CAP(C12, CAP_U(100))
	CAP(C13, CAP_P(470))
	CAP(C14, CAP_U(1))
	TTL_9602_DIP(N6)
	ALIAS(CYCLE_RESET, N6.9)
	ALIAS(CYCLE_RESET_Q, N6.10)
	ALIAS(FLIP_TIMER_Q, N6.7)

	NET_C(R40.1, V5)
	NET_C(R41.1, V5)
	NET_C(R42.2, GND)
	NET_C(R43.1, V5)
	NET_C(C14.1, R43.2)
	NET_C(C12.1, R40.2)
	NET_C(C13.2, R41.2, R42.1)
	NET_C(N6.4, BAD_JUMP)
	NET_C(N6.5, M6_1.Q)
	NET_C(N6.1, C12.2)
	NET_C(N6.2, R40.2)
	NET_C(N6.3, N6.9)
	NET_C(N6.6, C13.1)
	NET_C(N6.15, C14.2)
	NET_C(N6.14, R43.2)
	NET_C(N6.13, P)
	NET_C(N6.11, L6_2.Q)

	TTL_7400_NAND(M6_2, START_Q, R42.1)
	NET_C(N6.12, M6_2.Q)

	TTL_7404_INVERT(K8_2, CYCLE_RESET)
	ALIAS(CYCLE_RESET_A_Q, K8_2.Q)

	// Power terminals

	NET_C(VCC, high.VCC, low.VCC, ANTENNA.VCC, FREESCORE_SW_B0.VCC, FREESCORE_SW_B1.VCC, FREESCORE_SW_B2.VCC, FREESCORE_SW_B3.VCC,
		MISS_SW_B0.VCC, MISS_SW_B1.VCC, MISS_SW_B2.VCC, R38_2.VCC, R39_2.VCC)
	NET_C(GND, high.GND, low.GND, ANTENNA.GND, FREESCORE_SW_B0.GND, FREESCORE_SW_B1.GND, FREESCORE_SW_B2.GND, FREESCORE_SW_B3.GND,
		MISS_SW_B0.GND, MISS_SW_B1.GND, MISS_SW_B2.GND, R38_2.GND, R39_2.GND)
#endif
NETLIST_END()
