using System;
using System.Runtime.InteropServices;
 
//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html An SBML <em>species</em> &ndash; a pool of entities.
 *
 * A @em species in SBML refers to a pool of entities that (a) are
 * considered indistinguishable from each other for the purposes of the
 * model, (b) participate in reactions, and (c) are located in a specific
 * @em compartment.  The SBML Species object class is intended to represent
 * these pools.
 *
 * As with other major constructs in SBML, Species has a mandatory
 * attribute, 'id', used to give the species type an identifier in the
 * model.  The identifier must be a text string conforming to the identifer
 * syntax permitted in SBML.  Species also has an optional 'name'
 * attribute, of type @c string.  The 'id' and 'name' must be used
 * according to the guidelines described in the SBML specifications.
 *
 * The required attribute 'compartment' is used to identify the compartment
 * in which the species is located.  The attribute's value must be the
 * identifier of an existing Compartment object.  It is important to note
 * that there is no default value for the 'compartment' attribute on
 * Species; every species in an SBML model must be assigned a compartment
 * @em explicitly.  (This also implies that every model with one or more
 * Species objects must define at least one Compartment object.)
 *
 * 
 * @section species-amounts The initial amount and concentration of a species
 *
 * The optional attributes 'initialAmount' and 'initialConcentration', both
 * having a data type of @c double, can be used to set the @em initial
 * quantity of the species in the compartment where the species is located.
 * These attributes are mutually exclusive; i.e., <em>only one</em> can
 * have a value on any given instance of a Species object.  Missing
 * 'initialAmount' and 'initialConcentration' values implies that their
 * values either are unknown, or to be obtained from an external source, or
 * determined by an InitialAssignment or other SBML construct elsewhere in
 * the model.
 *
 * A species' initial quantity in SBML is set by the 'initialAmount' or
 * 'initialConcentration' attribute exactly once.  If the 'constant'
 * attribute is @c true, then the value of the species' quantity is fixed
 * and cannot be changed except by an InitialAssignment.  These methods
 * differ in that the 'initialAmount' and 'initialConcentration' attributes
 * can only be used to set the species quantity to a literal floating-point
 * number, whereas the use of an InitialAssignment object allows the value
 * to be set using an arbitrary mathematical expression (which, thanks to
 * MathML's expressiveness, may evaluate to a rational number).  If the
 * species' 'constant' attribute is @c false, the species' quantity value
 * may be overridden by an InitialAssignment or changed by AssignmentRule
 * or AlgebraicRule, and in addition, for <em>t &gt; 0</em>, it may also be
 * changed by a RateRule, Event objects, and as a result of being a
 * reactant or product in one or more Reaction objects.  (However, some
 * constructs are mutually exclusive; see the SBML specifications for the
 * precise details.)  It is not an error to define 'initialAmount' or
 * 'initialConcentration' on a species and also redefine the value using an
 * InitialAssignment, but the 'initialAmount' or 'initialConcentration'
 * setting in that case is ignored.  The SBML specifications provide
 * additional information about the semantics of assignments, rules and
 * values for simulation time <em>t</em> <= <em>0</em>.
 * 
 * SBML Level&nbsp;2 additionally stipulates that in cases where a species'
 * compartment has a 'spatialDimensions' value of @c 0 (zero), the species
 * cannot have a value for 'initialConcentration' because the concepts of
 * concentration and density break down when a container has zero
 * dimensions.
 *
 * @section species-units The units of a species' amount or concentration
 * 
 * When the attribute 'initialAmount' is set, the unit of measurement
 * associated with the value of 'initialAmount' is specified by the Species
 * attribute 'substanceUnits'.  When the 'initialConcentration' attribute
 * is set, the unit of measurement associated with this concentration value
 * is {<em>unit of amount</em>} divided by {<em>unit of size</em>}, where
 * the {<em>unit of amount</em>} is specified by the Species
 * 'substanceUnits' attribute, and the {<em>unit of size</em>} is specified
 * by the 'units' attribute of the Compartment object in which the species
 * is located.  Note that in either case, a unit of <em>amount</em> is
 * involved and determined by the 'substanceUnits' attribute.  Note
 * <strong>these two attributes alone do not determine the units of the
 * species when the species identifier appears in a mathematical
 * expression</strong>; <em>that</em> aspect is determined by the attribute
 * 'hasOnlySubstanceUnits' discussed below.
 * 
 * In SBML Level&nbsp;3, if the 'substanceUnits' attribute is not set on a
 * given Species object instance, then the unit of <em>amount</em> for that
 * species is inherited from the 'substanceUnits' attribute on the
 * enclosing Model object instance.  If that attribute on Model is not set
 * either, then the unit associated with the species' quantity is
 * undefined.
 *
 * In SBML Level&nbsp;2, if the 'substanceUnits' attribute is not set on a
 * given Species object instance, then the unit of <em>amount</em> for that
 * species is taken from the predefined SBML unit identifier
 * @c 'substance'.  The value assigned to 'substanceUnits' must be chosen from
 * one of the following possibilities: one of the base unit identifiers
 * defined in SBML, the built-in unit identifier @c 'substance', or the
 * identifier of a new unit defined in the list of unit definitions in the
 * enclosing Model object.  The chosen units for 'substanceUnits' must be
 * be @c 'dimensionless', @c 'mole', @c 'item', @c 'kilogram', @c 'gram',
 * or units derived from these.
 * 
 * As noted at the beginning of this section, simply setting
 * 'initialAmount' or 'initialConcentration' alone does @em not determine
 * whether a species identifier represents an amount or a concentration
 * when it appears elsewhere in an SBML model.  The role of the attribute
 * 'hasOnlySubstanceUnits' is to indicate whether the units of the species,
 * when the species identifier appears in mathematical formulas, are
 * intended to be concentration or amount.  The attribute takes on a
 * boolean value.  In SBML Level&nbsp;3, the attribute has no default value
 * and must always be set in a model; in SBML Level&nbsp;2, it has a
 * default value of @c false.
 *
 * The <em>units of the species</em> are used in the following ways:
 * <ul>

 * <li> When the species' identifier appears in a MathML formula, it
 * represents the species' quantity, and the unit of measurement associated
 * with the quantity is as described above.
 * 
 * <li> The 'math' elements of AssignmentRule, InitialAssignment and
 * EventAssignment objects referring to this species should all have the
 * same units as the unit of measurement associated with the species
 * quantity.
 * 
 * <li> In a RateRule object that defines the rate of change of the
 * species' quantity, the unit associated with the rule's 'math' element
 * should be equal to the unit of the species' quantity divided by the
 * model-wide unit of <em>time</em>; in other words, {<em>unit of species
 * quantity</em>}/{<em>unit of time</em>}.
 * 
 * </ul>
 *
 *
 * @section species-constant The 'constant' and 'boundaryCondition' attributes
 *
 * The Species object class has two boolean attributes named 'constant' and
 * 'boundaryCondition', used to indicate whether and how the quantity of
 * that species can vary during a simulation.  In SBML Level&nbsp;2 they
 * are optional; in SBML Level&nbsp;3 they are mandatory.  The following
 * table shows how to interpret the combined values of these attributes.
 *
 * @htmlinclude species-boundarycondition.html
 * 
 * By default, when a species is a product or reactant of one or more
 * reactions, its quantity is determined by those reactions.  In SBML, it
 * is possible to indicate that a given species' quantity is <em>not</em>
 * determined by the set of reactions even when that species occurs as a
 * product or reactant; i.e., the species is on the <em>boundary</em> of
 * the reaction system, and its quantity is not determined by the
 * reactions.  The boolean attribute 'boundaryCondition' can be used to
 * indicate this.  A value of @c false indicates that the species @em is
 * part of the reaction system.  In SBML Level&nbsp;2, the attribute has a
 * default value of @c false, while in SBML Level&nbsp;3, it has no
 * default.
 *
 * The 'constant' attribute indicates whether the species' quantity can be
 * changed at all, regardless of whether by reactions, rules, or constructs
 * other than InitialAssignment.  A value of @c false indicates that the
 * species' quantity can be changed.  (This is also a common value because
 * the purpose of most simulations is precisely to calculate changes in
 * species quantities.)  In SBML Level&nbsp;2, the attribute has a default
 * value of @c false, while in SBML Level&nbsp;3, it has no default.  Note
 * that the initial quantity of a species can be set by an
 * InitialAssignment irrespective of the value of the 'constant' attribute.
 *
 * In practice, a 'boundaryCondition' value of @c true means a differential
 * equation derived from the reaction definitions should not be generated
 * for the species.  However, the species' quantity may still be changed by
 * AssignmentRule, RateRule, AlgebraicRule, Event, and InitialAssignment
 * constructs if its 'constant' attribute is @c false.  Conversely, if the
 * species' 'constant' attribute is @c true, then its value cannot be
 * changed by anything except InitialAssignment.
 *
 * A species having 'boundaryCondition'=@c false and 'constant'=@c false
 * can appear as a product and/or reactant of one or more reactions in the
 * model.  If the species is a reactant or product of a reaction, it must
 * @em not also appear as the target of any AssignmentRule or RateRule
 * object in the model.  If instead the species has 'boundaryCondition'=
 * @c false and 'constant'=@c true, then it cannot appear as a reactant or
 * product, or as the target of any AssignmentRule, RateRule or
 * EventAssignment object in the model.
 *
 * Finally, it is worth clarifying that while the constant and 
 * boundaryCondition attributes restrict whether and how the species 
 * amount changes, the same is not true of a species' concentration. In 
 * SBML, the concentration of a species is a quantity that depends on the 
 * size of the compartment in which it is located. A compartment's size 
 * may change, and therefore, so can the concentration of a species even 
 * if the amount of the species remains unchanged. A species' concentration 
 * may therefore vary even if the Species object's constant attribute is 
 * set to @c true in a model.
 *
 * @section species-l2-convfactor The conversionFactor attribute in SBML Level&nbsp;3
 * 
 * In SBML Level&nbsp;3, Species has an additional optional attribute,
 * 'conversionFactor', that defines a conversion factor that applies to a
 * particular species.  The value must be the identifier of a Parameter
 * object instance defined in the model.  That Parameter object must be a
 * constant, meaning its 'constant' attribute must be set to @c true.
 * If a given Species object definition defines a value for its
 * 'conversionFactor' attribute, it takes precedence over any factor
 * defined by the Model object's 'conversionFactor' attribute.
 * 
 * The unit of measurement associated with a species' quantity can be
 * different from the unit of extent of reactions in the model.  SBML
 * Level&nbsp;3 avoids implicit unit conversions by providing an explicit
 * way to indicate any unit conversion that might be required.  The use of
 * a conversion factor in computing the effects of reactions on a species'
 * quantity is explained in detail in the SBML Level&nbsp;3 specification
 * document.  Because the value of the 'conversionFactor' attribute is the
 * identifier of a Parameter object, and because parameters can have units
 * attached to them, the transformation from reaction extent units to
 * species units can be completely specified using this approach.
 * 
 * Note that the unit conversion factor is <strong>only applied when
 * calculating the effect of a reaction on a species</strong>.  It is not
 * used in any rules or other SBML constructs that affect the species, and
 * it is also not used when the value of the species is referenced in a
 * mathematical expression.
 * 
 *
 * @section species-l2-type The speciesType attribute in SBML Level&nbsp;2 Versions&nbsp;2&ndash;4
 *
 * In SBML Level&nbsp;2 Versions&nbsp;2&ndash;4, each species in a model
 * may optionally be designated as belonging to a particular species type.
 * The optional attribute 'speciesType' is used to identify the species
 * type of the chemical entities that make up the pool represented by the
 * Species objects.  The attribute's value must be the identifier of an
 * existing SpeciesType object in the model.  If the 'speciesType'
 * attribute is not present on a particular species definition, it means
 * the pool contains chemical entities of a type unique to that pool; in
 * effect, a virtual species type is assumed for that species, and no other
 * species can belong to that species type.  The value of 'speciesType'
 * attributes on species have no effect on the numerical interpretation of
 * a model; simulators and other numerical analysis software may ignore
 * 'speciesType' attributes.
 * 
 * There can be only one species of a given species type in any given
 * compartment of a model.  More specifically, for all Species objects
 * having a value for the 'speciesType' attribute, the pair
 * <center>
 * ('speciesType' attribute value, 'compartment' attribute value)
 * </center>
 * 
 * must be unique across the set of all Species object in a model.
 *
 * 
 * @section species-other The spatialSizeUnits attribute in SBML Level&nbsp;2 Versions&nbsp;1&ndash;2
 *
 * In versions of SBML Level&nbsp;2 before Version&nbsp;3, the class
 * Species included an attribute called 'spatialSizeUnits', which allowed
 * explicitly setting the units of size for initial concentration.  LibSBML
 * retains this attribute for compatibility with older definitions of
 * Level&nbsp;2, but its use is strongly discouraged because many software
 * tools do no properly interpret this unit declaration and it is
 * incompatible with all SBML specifications after Level&nbsp;2
 * Version&nbsp;3.
 *
 * 
 * @section species-math Additional considerations for interpreting the numerical value of a species
 * 
 * Species are unique in SBML in that they have a kind of duality: a
 * species identifier may stand for either substance amount (meaning, a
 * count of the number of individual entities) or a concentration or
 * density (meaning, amount divided by a compartment size).  The previous
 * sections explain the meaning of a species identifier when it is
 * referenced in a mathematical formula or in rules or other SBML
 * constructs; however, it remains to specify what happens to a species
 * when the compartment in which it is located changes in size.
 * 
 * When a species definition has a 'hasOnlySubstanceUnits' attribute value
 * of @c false and the size of the compartment in which the species is
 * located changes, the default in SBML is to assume that it is the
 * concentration that must be updated to account for the size change.  This
 * follows from the principle that, all other things held constant, if a
 * compartment simply changes in size, the size change does not in itself
 * cause an increase or decrease in the number of entities of any species
 * in that compartment.  In a sense, the default is that the @em amount of
 * a species is preserved across compartment size changes.  Upon such size
 * changes, the value of the concentration or density must be recalculated
 * from the simple relationship <em>concentration = amount / size</em> if
 * the value of the concentration is needed (for example, if the species
 * identifier appears in a mathematical formula or is otherwise referenced
 * in an SBML construct).  There is one exception: if the species' quantity
 * is determined by an AssignmentRule, RateRule, AlgebraicRule, or an
 * EventAssignment and the species has a 'hasOnlySubstanceUnits' attribute
 * value of @c false, it means that the <em>concentration</em> is assigned
 * by the rule or event; in that case, the <em>amount</em> must be
 * calculated when the compartment size changes.  (Events also require
 * additional care in this situation, because an event with multiple
 * assignments could conceivably reassign both a species quantity and a
 * compartment size simultaneously.  Please refer to the SBML
 * specifications for the details.)
 * 
 * Note that the above only matters if a species has a
 * 'hasOnlySubstanceUnits' attribute value of @c false, meaning that the
 * species identifier refers to a concentration wherever the identifier
 * appears in a mathematical formula.  If instead the attribute's value is
 * @c true, then the identifier of the species <em>always</em> stands for
 * an amount wherever it appears in a mathematical formula or is referenced
 * by an SBML construct.  In that case, there is never a question about
 * whether an assignment or event is meant to affect the amount or
 * concentration: it is always the amount.
 * 
 * A particularly confusing situation can occur when the species has
 * 'constant' attribute value of @c true in combination with a
 * 'hasOnlySubstanceUnits' attribute value of @c false.  Suppose this
 * species is given a value for 'initialConcentration'.  Does a 'constant'
 * value of @c true mean that the concentration is held constant if the
 * compartment size changes?  No; it is still the amount that is kept
 * constant across a compartment size change.  The fact that the species
 * was initialized using a concentration value is irrelevant.
 * 
 *
 * 
 */

public class Species : SBase {
	private HandleRef swigCPtr;
	
	internal Species(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Species_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.SpeciesUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Species obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Species obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Species() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Species(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new Species using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this Species.
   *
   * @param version a long integer, the SBML Version to assign to this
   * Species.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Species(long level, long version) : this(libsbmlPINVOKE.new_Species__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Species using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 * 
   *
   * It is worth emphasizing that although this constructor does not take
   * an identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a Species is required to have a value.
   * Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method Species::setId(@if java String@endif).
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Species(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Species__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this Species object.
   *
   * @param orig the object to copy.
   */ public
 Species(Species orig) : this(libsbmlPINVOKE.new_Species__SWIG_2(Species.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Species object.
   *
   * @return the (deep) copy of this Species object.
   */ public new
 Species clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Species_clone(swigCPtr);
    Species ret = (cPtr == global::System.IntPtr.Zero) ? null : new Species(cPtr, true);
    return ret;
  }

  
/**
   * Initializes the fields of this Species object to 'typical' defaults
   * values.
   *
   * The SBML Species component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets 'boundaryCondition' to @c false
   * <li> Sets 'constant' to @c false
   * <li> sets 'hasOnlySubstanceUnits' to @c false
   * <li> (Applies to Level&nbsp;3 models only) Sets attribute 'substanceUnits' to @c mole
   * </ul>
   */ public
 void initDefaults() {
    libsbmlPINVOKE.Species_initDefaults(swigCPtr);
  }

  
/**
   * Returns the value of the 'id' attribute of this Species.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
   *
   * @return the id of this Species.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Species_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this Species object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.Species_getName(swigCPtr);
    return ret;
  }

  
/**
   * Get the type of this Species object object.
   * 
   * @return the value of the 'speciesType' attribute of this
   * Species as a string.
   * 
   * @note The 'speciesType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 string getSpeciesType() {
    string ret = libsbmlPINVOKE.Species_getSpeciesType(swigCPtr);
    return ret;
  }

  
/**
   * Get the compartment in which this species is located.
   *
   * The compartment is designated by its identifier.
   * 
   * @return the value of the 'compartment' attribute of this Species
   * object, as a string.
   */ public
 string getCompartment() {
    string ret = libsbmlPINVOKE.Species_getCompartment(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'initialAmount' attribute.
   * 
   * @return the initialAmount of this Species, as a floating point number.
   */ public
 double getInitialAmount() {
    double ret = libsbmlPINVOKE.Species_getInitialAmount(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'initialConcentration' attribute.
   * 
   * @return the initialConcentration of this Species,, as a floating point
   * number.
   *
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 double getInitialConcentration() {
    double ret = libsbmlPINVOKE.Species_getInitialConcentration(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'substanceUnits' attribute.
   * 
   * @return the value of the 'substanceUnits' attribute of this Species,
   * as a string.  An empty string indicates that no units have been
   * assigned.
   *
   *
 * @note There is an important distinction to be made between <em>no units
 * assigned</em>, and assuming a value without units has any specific unit
 * such as <code>dimensionless</code>.  In SBML, default units are never
 * attributed to numbers, and numbers without units are not automatically
 * assumed to have the unit <code>dimensionless</code>.  Please consult the
 * relevant SBML specification document for a more in-depth explanation of
 * this topic and the SBML unit system.
 *
 *
   *
   * @see isSetSubstanceUnits()
   * @see setSubstanceUnits(string sid)
   */ public
 string getSubstanceUnits() {
    string ret = libsbmlPINVOKE.Species_getSubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'spatialSizeUnits' attribute.
   * 
   * @return the value of the 'spatialSizeUnits' attribute of this Species
   * object, as a string.
   *
   *
 * @warning <span class='warning'>In versions of SBML Level&nbsp;2 before
 * Version&nbsp;3, the class Species included an attribute called
 * 'spatialSizeUnits', which allowed explicitly setting the units of size for
 * initial concentration.  This attribute was removed in SBML Level&nbsp;2
 * Version&nbsp;3.  LibSBML retains this attribute for compatibility with
 * older definitions of Level&nbsp;2, but its use is strongly discouraged
 * because it is incompatible with levels and versions of SBML beyond
 * Level&nbsp;2 Version&nbsp;2.</span>
 *
   */ public
 string getSpatialSizeUnits() {
    string ret = libsbmlPINVOKE.Species_getSpatialSizeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'units' attribute.
   * 
   * @return the units of this Species (L1 only).
   *
   *
 * @note The 'units' attribute is defined only in SBML Level&nbsp;1.  In
 * SBML Level&nbsp;2 and Level&nbsp;3, it has been replaced by a
 * combination of 'substanceUnits' and the units of the Compartment
 * object in which a species is located.  In SBML Level&nbsp;2
 * Versions&nbsp;1&ndash;2, an additional attribute 'spatialSizeUnits'
 * helps determine the units of the species quantity, but this attribute
 * was removed in later versions of SBML Level&nbsp;2.
 * 
   */ public
 string getUnits() {
    string ret = libsbmlPINVOKE.Species_getUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'hasOnlySubstanceUnits' attribute.
   * 
   * @return @c true if this Species' 'hasOnlySubstanceUnits' attribute
   * value is @c true, @c false otherwise.
   *
   * @note The 'hasOnlySubstanceUnits' attribute does not exist in SBML
   * Level&nbsp;1.
   */ public
 bool getHasOnlySubstanceUnits() {
    bool ret = libsbmlPINVOKE.Species_getHasOnlySubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'boundaryCondition' attribute.
   * 
   * @return @c true if this Species' 'boundaryCondition' attribute value
   * is @c true, @c false otherwise.
   */ public
 bool getBoundaryCondition() {
    bool ret = libsbmlPINVOKE.Species_getBoundaryCondition(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'charge' attribute.
   * 
   * @return the charge of this Species object.
   *
   *
 * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
 * attribute on Species is deprecated and in SBML Level&nbsp;3 it does
 * not exist at all.  Its use strongly discouraged.  Its presence is
 * considered a misfeature in earlier definitions of SBML because its
 * implications for the mathematics of a model were never defined, and in
 * any case, no known modeling system ever used it.  Instead, models take
 * account of charge values directly in their definitions of species by
 * (for example) having separate species identities for the charged and
 * uncharged versions of the same species.  This allows the condition to
 * affect model mathematics directly.  LibSBML retains this method for
 * easier compatibility with SBML Level&nbsp;1.
   */ public
 int getCharge() {
    int ret = libsbmlPINVOKE.Species_getCharge(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'constant' attribute.
   * 
   * @return @c true if this Species's 'constant' attribute value is
   * @c true, @c false otherwise.
   *
   * @note The attribute 'constant' is only available in SBML Levels&nbsp;2
   * and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 bool getConstant() {
    bool ret = libsbmlPINVOKE.Species_getConstant(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'conversionFactor' attribute.
   * 
   * @return the conversionFactor of this Species, as a string.
   * 
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 string getConversionFactor() {
    string ret = libsbmlPINVOKE.Species_getConversionFactor(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'id' attribute is set.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
 *
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.Species_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'name' attribute is set.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.Species_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Species object's
   * 'speciesType' attribute is set.
   *
   * @return @c true if the 'speciesType' attribute of this Species is
   * set, @c false otherwise.
   * 
   * @note The 'speciesType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 bool isSetSpeciesType() {
    bool ret = libsbmlPINVOKE.Species_isSetSpeciesType(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'compartment' attribute is set.
   *
   * @return @c true if the 'compartment' attribute of this Species is
   * set, @c false otherwise.
   */ public
 bool isSetCompartment() {
    bool ret = libsbmlPINVOKE.Species_isSetCompartment(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'initialAmount' attribute is set.
   *
   * @return @c true if the 'initialAmount' attribute of this Species is
   * set, @c false otherwise.
   *
   * @note In SBML Level&nbsp;1, Species' 'initialAmount' is required and
   * therefore <em>should always be set</em>.  (However, in Level&nbsp;1, the
   * attribute has no default value either, so this method will not return
   * @c true until a value has been assigned.)  In SBML Level&nbsp;2,
   * 'initialAmount' is optional and as such may or may not be set.
   */ public
 bool isSetInitialAmount() {
    bool ret = libsbmlPINVOKE.Species_isSetInitialAmount(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'initialConcentration' attribute is set.
   *
   * @return @c true if the 'initialConcentration' attribute of this Species is
   * set, @c false otherwise.
   *
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 bool isSetInitialConcentration() {
    bool ret = libsbmlPINVOKE.Species_isSetInitialConcentration(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'substanceUnits' attribute is set.
   *
   * @return @c true if the 'substanceUnits' attribute of this Species is
   * set, @c false otherwise.
   */ public
 bool isSetSubstanceUnits() {
    bool ret = libsbmlPINVOKE.Species_isSetSubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'spatialSizeUnits' attribute is set.
   *
   * @return @c true if the 'spatialSizeUnits' attribute of this Species is
   * set, @c false otherwise.
   *
   *
 * @warning <span class='warning'>In versions of SBML Level&nbsp;2 before
 * Version&nbsp;3, the class Species included an attribute called
 * 'spatialSizeUnits', which allowed explicitly setting the units of size for
 * initial concentration.  This attribute was removed in SBML Level&nbsp;2
 * Version&nbsp;3.  LibSBML retains this attribute for compatibility with
 * older definitions of Level&nbsp;2, but its use is strongly discouraged
 * because it is incompatible with levels and versions of SBML beyond
 * Level&nbsp;2 Version&nbsp;2.</span>
 *
   */ public
 bool isSetSpatialSizeUnits() {
    bool ret = libsbmlPINVOKE.Species_isSetSpatialSizeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * this Species object's 'units' attribute is set.
   *
   * @return @c true if the 'units' attribute of this Species is
   * set, @c false otherwise.
   */ public
 bool isSetUnits() {
    bool ret = libsbmlPINVOKE.Species_isSetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'charge' attribute is set.
   *
   * @return @c true if the 'charge' attribute of this Species is
   * set, @c false otherwise.
   *
   *
 * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
 * attribute on Species is deprecated and in SBML Level&nbsp;3 it does
 * not exist at all.  Its use strongly discouraged.  Its presence is
 * considered a misfeature in earlier definitions of SBML because its
 * implications for the mathematics of a model were never defined, and in
 * any case, no known modeling system ever used it.  Instead, models take
 * account of charge values directly in their definitions of species by
 * (for example) having separate species identities for the charged and
 * uncharged versions of the same species.  This allows the condition to
 * affect model mathematics directly.  LibSBML retains this method for
 * easier compatibility with SBML Level&nbsp;1. 
   */ public
 bool isSetCharge() {
    bool ret = libsbmlPINVOKE.Species_isSetCharge(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'conversionFactor' attribute is set.
   *
   * @return @c true if the 'conversionFactor' attribute of this Species is
   * set, @c false otherwise.
   * 
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 bool isSetConversionFactor() {
    bool ret = libsbmlPINVOKE.Species_isSetConversionFactor(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'boundaryCondition' attribute is set.
   *
   * @return @c true if the 'boundaryCondition' attribute of this Species is
   * set, @c false otherwise.
   */ public
 bool isSetBoundaryCondition() {
    bool ret = libsbmlPINVOKE.Species_isSetBoundaryCondition(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'hasOnlySubstanceUnits' attribute is set.
   *
   * @return @c true if the 'hasOnlySubstanceUnits' attribute of this Species is
   * set, @c false otherwise.
   *
   * @note The 'hasOnlySubstanceUnits' attribute does not exist in SBML
   * Level&nbsp;1.
   */ public
 bool isSetHasOnlySubstanceUnits() {
    bool ret = libsbmlPINVOKE.Species_isSetHasOnlySubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Species object's 'constant' attribute is set.
   *
   * @return @c true if the 'constant' attribute of this Species is
   * set, @c false otherwise.
   *
   * @note The attribute 'constant' is only available in SBML Levels&nbsp;2
   * and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 bool isSetConstant() {
    bool ret = libsbmlPINVOKE.Species_isSetConstant(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this Species.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.Species_setId(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this Species.
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.Species_setName(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'speciesType' attribute of this Species object.
   *
   * @param sid the identifier of a SpeciesType object defined elsewhere
   * in this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * 
   * @note The 'speciesType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 int setSpeciesType(string sid) {
    int ret = libsbmlPINVOKE.Species_setSpeciesType(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'compartment' attribute of this Species object.
   *
   * @param sid the identifier of a Compartment object defined elsewhere
   * in this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setCompartment(string sid) {
    int ret = libsbmlPINVOKE.Species_setCompartment(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'initialAmount' attribute of this Species and marks the field
   * as set.
   *
   * This method also unsets the 'initialConcentration' attribute.
   *
   * @param value the value to which the 'initialAmount' attribute should
   * be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setInitialAmount(double value) {
    int ret = libsbmlPINVOKE.Species_setInitialAmount(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'initialConcentration' attribute of this Species and marks
   * the field as set.
   *
   * This method also unsets the 'initialAmount' attribute.
   *
   * @param value the value to which the 'initialConcentration' attribute
   * should be set.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 int setInitialConcentration(double value) {
    int ret = libsbmlPINVOKE.Species_setInitialConcentration(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'substanceUnits' attribute of this Species object.
   *
   * @param sid the identifier of the unit to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   */ public
 int setSubstanceUnits(string sid) {
    int ret = libsbmlPINVOKE.Species_setSubstanceUnits(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * (SBML Level&nbsp;2 Versions&nbsp;1&ndash;2) Sets the 'spatialSizeUnits' attribute of this Species object.
   *
   * @param sid the identifier of the unit to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @warning <span class='warning'>In versions of SBML Level&nbsp;2 before
 * Version&nbsp;3, the class Species included an attribute called
 * 'spatialSizeUnits', which allowed explicitly setting the units of size for
 * initial concentration.  This attribute was removed in SBML Level&nbsp;2
 * Version&nbsp;3.  LibSBML retains this attribute for compatibility with
 * older definitions of Level&nbsp;2, but its use is strongly discouraged
 * because it is incompatible with levels and versions of SBML beyond
 * Level&nbsp;2 Version&nbsp;2.</span>
 *
   */ public
 int setSpatialSizeUnits(string sid) {
    int ret = libsbmlPINVOKE.Species_setSpatialSizeUnits(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * (SBML Level&nbsp;1 only) Sets the units of this Species object.
   *
   * @param sname the identifier of the unit to use.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
  */ public
 int setUnits(string sname) {
    int ret = libsbmlPINVOKE.Species_setUnits(swigCPtr, sname);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Sets the 'hasOnlySubstanceUnits' attribute of this Species object.
   *
   * @param value boolean value for the 'hasOnlySubstanceUnits' attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The 'hasOnlySubstanceUnits' attribute does not exist in SBML
   * Level&nbsp;1.
   */ public
 int setHasOnlySubstanceUnits(bool value) {
    int ret = libsbmlPINVOKE.Species_setHasOnlySubstanceUnits(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'boundaryCondition' attribute of this Species object.
   *
   * @param value boolean value for the 'boundaryCondition' attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   */ public
 int setBoundaryCondition(bool value) {
    int ret = libsbmlPINVOKE.Species_setBoundaryCondition(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'charge' attribute of this Species object.
   *
   * @param value an integer to which to set the 'charge' to.
   *
   *
 * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
 * attribute on Species is deprecated and in SBML Level&nbsp;3 it does
 * not exist at all.  Its use strongly discouraged.  Its presence is
 * considered a misfeature in earlier definitions of SBML because its
 * implications for the mathematics of a model were never defined, and in
 * any case, no known modeling system ever used it.  Instead, models take
 * account of charge values directly in their definitions of species by
 * (for example) having separate species identities for the charged and
 * uncharged versions of the same species.  This allows the condition to
 * affect model mathematics directly.  LibSBML retains this method for
 * easier compatibility with SBML Level&nbsp;1. 
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   */ public
 int setCharge(int value) {
    int ret = libsbmlPINVOKE.Species_setCharge(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'constant' attribute of this Species object.
   *
   * @param value a boolean value for the 'constant' attribute.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The attribute 'constant' is only available in SBML Levels&nbsp;2
   * and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 int setConstant(bool value) {
    int ret = libsbmlPINVOKE.Species_setConstant(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the value of the 'conversionFactor' attribute of this Species object.
   *
   * The string in @p sid is copied.
   *
   * @param sid the new conversionFactor for the Species.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * 
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 int setConversionFactor(string sid) {
    int ret = libsbmlPINVOKE.Species_setConversionFactor(swigCPtr, sid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Unsets the value of the 'name' attribute of this Species object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.Species_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'constant' attribute of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isSetConstant()
   * @see setConstant(@if java boolean@endif)
   * @see getConstant()
   */ public
 int unsetConstant() {
    int ret = libsbmlPINVOKE.Species_unsetConstant(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'speciesType' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The attribute 'speciesType' is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   */ public
 int unsetSpeciesType() {
    int ret = libsbmlPINVOKE.Species_unsetSpeciesType(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'initialAmount' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetInitialAmount() {
    int ret = libsbmlPINVOKE.Species_unsetInitialAmount(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'initialConcentration' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The attribute 'initialConcentration' is only available in SBML
   * Level&nbsp;2 and&nbsp;3.  It does not exist on Species in Level&nbsp;1.
   */ public
 int unsetInitialConcentration() {
    int ret = libsbmlPINVOKE.Species_unsetInitialConcentration(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'substanceUnits' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetSubstanceUnits() {
    int ret = libsbmlPINVOKE.Species_unsetSubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'spatialSizeUnits' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @warning <span class='warning'>In versions of SBML Level&nbsp;2 before
 * Version&nbsp;3, the class Species included an attribute called
 * 'spatialSizeUnits', which allowed explicitly setting the units of size for
 * initial concentration.  This attribute was removed in SBML Level&nbsp;2
 * Version&nbsp;3.  LibSBML retains this attribute for compatibility with
 * older definitions of Level&nbsp;2, but its use is strongly discouraged
 * because it is incompatible with levels and versions of SBML beyond
 * Level&nbsp;2 Version&nbsp;2.</span>
 *
   */ public
 int unsetSpatialSizeUnits() {
    int ret = libsbmlPINVOKE.Species_unsetSpatialSizeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'units' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetUnits() {
    int ret = libsbmlPINVOKE.Species_unsetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'charge' attribute
   * value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note Beginning in SBML Level&nbsp;2 Version&nbsp;2, the 'charge'
 * attribute on Species is deprecated and in SBML Level&nbsp;3 it does
 * not exist at all.  Its use strongly discouraged.  Its presence is
 * considered a misfeature in earlier definitions of SBML because its
 * implications for the mathematics of a model were never defined, and in
 * any case, no known modeling system ever used it.  Instead, models take
 * account of charge values directly in their definitions of species by
 * (for example) having separate species identities for the charged and
 * uncharged versions of the same species.  This allows the condition to
 * affect model mathematics directly.  LibSBML retains this method for
 * easier compatibility with SBML Level&nbsp;1. 
   */ public
 int unsetCharge() {
    int ret = libsbmlPINVOKE.Species_unsetCharge(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'conversionFactor' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * 
   * @note The 'conversionFactor' attribute was introduced in SBML
   * Level&nbsp;3.  It does not exist on Species in SBML Levels&nbsp;1
   * and&nbsp;2.
   */ public
 int unsetConversionFactor() {
    int ret = libsbmlPINVOKE.Species_unsetConversionFactor(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'compartment' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetCompartment() {
    int ret = libsbmlPINVOKE.Species_unsetCompartment(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'boundaryCondition' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetBoundaryCondition() {
    int ret = libsbmlPINVOKE.Species_unsetBoundaryCondition(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the 'hasOnlySubstanceUnits' attribute value of this Species object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public
 int unsetHasOnlySubstanceUnits() {
    int ret = libsbmlPINVOKE.Species_unsetHasOnlySubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Constructs and returns a UnitDefinition that corresponds to the units
   * of this Species' amount or concentration.
   *
   * Species in SBML have an attribute ('substanceUnits') for declaring the
   * units of measurement intended for the species' amount or concentration
   * (depending on which one applies).  In the absence of a value given for
   * 'substanceUnits', the units are taken from the enclosing Model's
   * definition of @c 'substance' or @c 'substance'/<em>(size of the
   * compartment)</em> in which the species is located, or finally, if
   * these are not redefined by the Model, the relevant SBML default units
   * for those quantities.  Following that procedure, the method
   * @if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif
   * returns a UnitDefinition based on the
   * interpreted units of this species's amount or concentration.
   *
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return @c null.
   *
   * Note also that unit declarations for Species are in terms of the @em
   * identifier of a unit, but this method returns a UnitDefinition object,
   * not a unit identifier.  It does this by constructing an appropriate
   * UnitDefinition.  Callers may find this particularly useful when used
   * in conjunction with the helper methods on UnitDefinition for comparing
   * different UnitDefinition objects.
   * 
   * In SBML Level&nbsp;2 specifications prior to Version&nbsp;3, Species
   * includes an additional attribute named 'spatialSizeUnits', which
   * allows explicitly setting the units of size for initial concentration.
   * The @if java Species::getDerivedUnitDefinition()@else getDerivedUnitDefinition()@endif
   * takes this into account for models
   * expressed in SBML Level&nbsp;2 Versions&nbsp;1 and&nbsp;2.
   *
   * @return a UnitDefinition that expresses the units of this 
   * Species, or @c null if one cannot be constructed.
   *
   * @see getSubstanceUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Species_getDerivedUnitDefinition__SWIG_0(swigCPtr);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   * 
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 * The exception to this is lists:  all SBML-style list elements have the type 
 * @link libsbml#SBML_LIST_OF SBML_LIST_OF@endlink, regardless of what package they 
 * are from.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_SPECIES SBML_SPECIES@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * ListOf::getItemTypeCode()).</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Species_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for Species, is
   * always @c 'species'.
   * 
   * @return the name of this element, i.e., @c 'species'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Species_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * all the required attributes for this Species object
   * have been set.
   *
   * The required attributes for a Species object are:
   * @li 'id' (or 'name' in SBML Level&nbsp;1)
   * @li 'compartment'
   * @li 'initialAmount' (required in SBML Level&nbsp;1 only; optional otherwise)
   * @li 'hasOnlySubstanceUnits' (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
   * @li 'boundaryCondition' (required in SBML Level&nbsp;3; optional in Levels&nbsp;1 and&nbsp;2)
   * @li 'constant' (required in SBML Level&nbsp;3; optional in SBML Level&nbsp;2)
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Species_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Species_renameSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   *
 * Replaces all uses of a given @c UnitSIdRef type attribute value with
 * another value.
 *
 *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of @p oldid.  If any matches
 * are found, the matching values are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Species_renameUnitSIdRefs(swigCPtr, oldid, newid);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

}

}
