#ifndef CONF_H
#define CONF_H 1
/*#include "util.h"*/

/* No "PAM_" prefix here because I suspect it might be 
 * reserved for PAM. I do not know for sure, though.
 */

#define CONF_PAM_PROMPT_MAXLEN 128
#define CONF_MAXLINES 1024

/* pamrsaconf_parse() returns one of these */
enum { CONF_SUCCESS, CONF_SYSFAIL, CONF_PARSEFAIL };

typedef enum { HASH_INITIALIZED, HASH_SHA1, HASH_NONE } hashtype;

struct pamrsaconf {
	char *pubkey_dir;
	char *privkey_dir;
	char *pam_prompt;
	hashtype privkey_name_hash;
	int log_auth_result;
};


/* struct opt_pamrsaconf must mirror struct pamrsaconf,
   so that we know which options have already been set
   when parsing configuration file. Options can be set
   only once. More than once is considered an error */

struct opt_pamrsaconf {
	int pubkey_dir;
	int privkey_dir;
	int pam_prompt;
	int privkey_name_hash;
	int log_auth_result;
};


/* NOTE: ask_pass and ask_passphrase are mutually exclusive arguments */
struct pamrsaarg {
	int debug;
	int ask_pass; /* stored for other PAM modules */
	int ask_passphrase; /* used when opening passphrase encrypted RSA private keys */
};


struct pamrsaconf *pamrsaconf_alloc(void);
int pamrsaconf_set_defaults(struct pamrsaconf *cf);
int pamrsaconf_read(struct pamrsaconf *cf, const char *fn);
void pamrsaconf_free(struct pamrsaconf *cf);

struct pamrsaarg *pamrsaarg_alloc(void);
int pamrsaarg_read(struct pamrsaarg *ar, int argc, const char *argv[]);
void pamrsaarg_free(struct pamrsaarg *ar);



#endif /* CONF_H */
