/* NBD client library in userspace
 * WARNING: THIS FILE IS GENERATED FROM
 * generator/generator
 * ANY CHANGES YOU MAKE TO THIS FILE WILL BE LOST.
 *
 * Copyright (C) 2013-2019 Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>
#include <errno.h>

#include <pthread.h>

#include "libnbd.h"
#include "internal.h"

int
nbd_set_debug (struct nbd_handle *h, bool debug)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_debug");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: debug=%s", debug ? "true" : "false");

  ret = nbd_unlocked_set_debug (h, debug);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_get_debug (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  pthread_mutex_lock (&h->lock);
  ret = nbd_unlocked_get_debug (h);
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_set_debug_callback (struct nbd_handle *h,
                        nbd_debug_callback debug_callback)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_debug_callback");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: debug=<fun>");

  if (CALLBACK_IS_NULL (debug_callback)) {
    set_error (EFAULT, "%s cannot be NULL", "debug");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_debug_callback (h, debug_callback);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_clear_debug_callback (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_clear_debug_callback");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_clear_debug_callback (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_set_handle_name (struct nbd_handle *h, const char *handle_name)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_handle_name");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: handle_name=\"%s\"", handle_name ? handle_name : "NULL");

  if (handle_name == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "handle_name");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_handle_name (h, handle_name);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

char *
nbd_get_handle_name (struct nbd_handle *h)
{
  char * ret;

  nbd_internal_set_error_context ("nbd_get_handle_name");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_get_handle_name (h);

  if_debug (h) {
    if (ret == NULL)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=\"%s\"", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_export_name_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_export_name (struct nbd_handle *h, const char *export_name)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_export_name");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: export_name=\"%s\"", export_name ? export_name : "NULL");

  if (unlikely (!set_export_name_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (export_name == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "export_name");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_export_name (h, export_name);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

char *
nbd_get_export_name (struct nbd_handle *h)
{
  char * ret;

  nbd_internal_set_error_context ("nbd_get_export_name");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_get_export_name (h);

  if_debug (h) {
    if (ret == NULL)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=\"%s\"", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_tls_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_tls (struct nbd_handle *h, int tls)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_tls");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: tls=%d", tls);

  if (unlikely (!set_tls_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  switch (tls) {
  case LIBNBD_TLS_DISABLE:
  case LIBNBD_TLS_ALLOW:
  case LIBNBD_TLS_REQUIRE:
    break;
  default:
    set_error (EINVAL, "%s: invalid value for parameter: %d",
               "tls", tls);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_tls (h, tls);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_get_tls (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  pthread_mutex_lock (&h->lock);
  ret = nbd_unlocked_get_tls (h);
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
get_tls_negotiated_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_get_tls_negotiated (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_get_tls_negotiated");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!get_tls_negotiated_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_get_tls_negotiated (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_tls_certificates_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_tls_certificates (struct nbd_handle *h, const char *dir)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_tls_certificates");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: dir=\"%s\"", dir ? dir : "NULL");

  if (unlikely (!set_tls_certificates_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_tls_certificates (h, dir);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_tls_verify_peer_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_tls_verify_peer (struct nbd_handle *h, bool verify)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_tls_verify_peer");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: verify=%s", verify ? "true" : "false");

  if (unlikely (!set_tls_verify_peer_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_tls_verify_peer (h, verify);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_get_tls_verify_peer (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  pthread_mutex_lock (&h->lock);
  ret = nbd_unlocked_get_tls_verify_peer (h);
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_tls_username_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_tls_username (struct nbd_handle *h, const char *username)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_tls_username");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: username=\"%s\"", username ? username : "NULL");

  if (unlikely (!set_tls_username_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (username == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "username");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_tls_username (h, username);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

char *
nbd_get_tls_username (struct nbd_handle *h)
{
  char * ret;

  nbd_internal_set_error_context ("nbd_get_tls_username");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_get_tls_username (h);

  if_debug (h) {
    if (ret == NULL)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=\"%s\"", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_tls_psk_file_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_tls_psk_file (struct nbd_handle *h, const char *filename)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_tls_psk_file");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: filename=\"%s\"", filename ? filename : "NULL");

  if (unlikely (!set_tls_psk_file_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_tls_psk_file (h, filename);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_request_structured_replies_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_request_structured_replies (struct nbd_handle *h, bool request)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_request_structured_replies");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: request=%s", request ? "true" : "false");

  if (unlikely (!set_request_structured_replies_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_request_structured_replies (h, request);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_get_request_structured_replies (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  pthread_mutex_lock (&h->lock);
  ret = nbd_unlocked_get_request_structured_replies (h);
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
get_structured_replies_negotiated_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_get_structured_replies_negotiated (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_get_structured_replies_negotiated");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!get_structured_replies_negotiated_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_get_structured_replies_negotiated (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_handshake_flags_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_handshake_flags (struct nbd_handle *h, uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_handshake_flags");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: flags=0x%x", flags);

  if (unlikely (!set_handshake_flags_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~3) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_handshake_flags (h, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

unsigned
nbd_get_handshake_flags (struct nbd_handle *h)
{
  unsigned ret;

  /* This function must not call set_error. */
  pthread_mutex_lock (&h->lock);
  ret = nbd_unlocked_get_handshake_flags (h);
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
add_meta_context_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_add_meta_context (struct nbd_handle *h, const char *name)
{
  int ret;

  nbd_internal_set_error_context ("nbd_add_meta_context");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: name=\"%s\"", name ? name : "NULL");

  if (unlikely (!add_meta_context_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (name == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "name");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_add_meta_context (h, name);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_uri_allow_transports_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_uri_allow_transports (struct nbd_handle *h, uint32_t mask)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_uri_allow_transports");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: mask=0x%x", mask);

  if (unlikely (!set_uri_allow_transports_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((mask & ~7) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "mask", mask);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_uri_allow_transports (h, mask);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_uri_allow_tls_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_uri_allow_tls (struct nbd_handle *h, int tls)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_uri_allow_tls");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: tls=%d", tls);

  if (unlikely (!set_uri_allow_tls_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  switch (tls) {
  case LIBNBD_TLS_DISABLE:
  case LIBNBD_TLS_ALLOW:
  case LIBNBD_TLS_REQUIRE:
    break;
  default:
    set_error (EINVAL, "%s: invalid value for parameter: %d",
               "tls", tls);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_uri_allow_tls (h, tls);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
set_uri_allow_local_file_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_set_uri_allow_local_file (struct nbd_handle *h, bool allow)
{
  int ret;

  nbd_internal_set_error_context ("nbd_set_uri_allow_local_file");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: allow=%s", allow ? "true" : "false");

  if (unlikely (!set_uri_allow_local_file_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_set_uri_allow_local_file (h, allow);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_uri_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_uri (struct nbd_handle *h, const char *uri)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_uri");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: uri=\"%s\"", uri ? uri : "NULL");

  if (unlikely (!connect_uri_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (uri == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "uri");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_uri (h, uri);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_unix_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_unix (struct nbd_handle *h, const char *unixsocket)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_unix");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: unixsocket=\"%s\"", unixsocket ? unixsocket : "NULL");

  if (unlikely (!connect_unix_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_unix (h, unixsocket);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_vsock_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_vsock (struct nbd_handle *h, uint32_t cid, uint32_t port)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_vsock");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: cid=%" PRIu32 " port=%" PRIu32 "", cid, port);

  if (unlikely (!connect_vsock_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_vsock (h, cid, port);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_tcp_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_tcp (struct nbd_handle *h, const char *hostname,
                 const char *port)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_tcp");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: hostname=\"%s\" port=\"%s\"", hostname ? hostname : "NULL", port ? port : "NULL");

  if (unlikely (!connect_tcp_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (hostname == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "hostname");
    ret = -1;
    goto out;
  }
  if (port == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "port");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_tcp (h, hostname, port);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_socket_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_socket (struct nbd_handle *h, int sock)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_socket");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: sock=%d", sock);

  if (unlikely (!connect_socket_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_socket (h, sock);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_command_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_command (struct nbd_handle *h, char **argv)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_command");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: argv=<list>");

  if (unlikely (!connect_command_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_command (h, argv);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
connect_systemd_socket_activation_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_connect_systemd_socket_activation (struct nbd_handle *h, char **argv)
{
  int ret;

  nbd_internal_set_error_context ("nbd_connect_systemd_socket_activation");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: argv=<list>");

  if (unlikely (!connect_systemd_socket_activation_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_connect_systemd_socket_activation (h, argv);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
is_read_only_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_is_read_only (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_is_read_only");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!is_read_only_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_is_read_only (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_flush_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_flush (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_flush");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_flush_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_flush (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_fua_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_fua (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_fua");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_fua_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_fua (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
is_rotational_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_is_rotational (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_is_rotational");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!is_rotational_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_is_rotational (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_trim_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_trim (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_trim");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_trim_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_trim (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_zero_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_zero (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_zero");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_zero_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_zero (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_fast_zero_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_fast_zero (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_fast_zero");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_fast_zero_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_fast_zero (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_can_df (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_df");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_can_df (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_multi_conn_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_multi_conn (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_multi_conn");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_multi_conn_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_multi_conn (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_cache_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_cache (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_cache");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!can_cache_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_cache (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
can_meta_context_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int
nbd_can_meta_context (struct nbd_handle *h, const char *metacontext)
{
  int ret;

  nbd_internal_set_error_context ("nbd_can_meta_context");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: metacontext=\"%s\"", metacontext ? metacontext : "NULL");

  if (unlikely (!can_meta_context_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (metacontext == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "metacontext");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_can_meta_context (h, metacontext);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
get_protocol_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

const char *
nbd_get_protocol (struct nbd_handle *h)
{
  const char * ret;

  nbd_internal_set_error_context ("nbd_get_protocol");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!get_protocol_in_permitted_state (h))) {
    ret = NULL;
    goto out;
  }
  ret = nbd_unlocked_get_protocol (h);

  if_debug (h) {
    if (ret == NULL)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=\"%s\"", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
get_size_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down");
    return false;
  }
  return true;
}

int64_t
nbd_get_size (struct nbd_handle *h)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_get_size");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!get_size_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_get_size (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
pread_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_pread (struct nbd_handle *h, void *buf, size_t count, uint64_t offset,
           uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_pread");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: buf=<buf> count=%zu offset=%" PRIu64 " flags=0x%x", count, offset, flags);

  if (unlikely (!pread_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_pread (h, buf, count, offset, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
pread_structured_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_pread_structured (struct nbd_handle *h, void *buf, size_t count,
                      uint64_t offset, nbd_chunk_callback chunk_callback,
                      uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_pread_structured");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: buf=<buf> count=%zu offset=%" PRIu64 " chunk=<fun> flags=0x%x", count, offset, flags);

  if (unlikely (!pread_structured_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (CALLBACK_IS_NULL (chunk_callback)) {
    set_error (EFAULT, "%s cannot be NULL", "chunk");
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_pread_structured (h, buf, count, offset,
                                       chunk_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
pwrite_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_pwrite (struct nbd_handle *h, const void *buf, size_t count,
            uint64_t offset, uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_pwrite");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: buf=<buf> count=%zu offset=%" PRIu64 " flags=0x%x", count, offset, flags);

  if (unlikely (!pwrite_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_pwrite (h, buf, count, offset, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
shutdown_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_shutdown (struct nbd_handle *h, uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_shutdown");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: flags=0x%x", flags);

  if (unlikely (!shutdown_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_shutdown (h, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
flush_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_flush (struct nbd_handle *h, uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_flush");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: flags=0x%x", flags);

  if (unlikely (!flush_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_flush (h, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
trim_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_trim (struct nbd_handle *h, uint64_t count, uint64_t offset,
          uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_trim");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " flags=0x%x", count, offset, flags);

  if (unlikely (!trim_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_trim (h, count, offset, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
cache_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_cache (struct nbd_handle *h, uint64_t count, uint64_t offset,
           uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_cache");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " flags=0x%x", count, offset, flags);

  if (unlikely (!cache_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_cache (h, count, offset, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
zero_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_zero (struct nbd_handle *h, uint64_t count, uint64_t offset,
          uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_zero");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " flags=0x%x", count, offset, flags);

  if (unlikely (!zero_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_zero (h, count, offset, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
block_status_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_block_status (struct nbd_handle *h, uint64_t count, uint64_t offset,
                  nbd_extent_callback extent_callback, uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_block_status");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " extent=<fun> flags=0x%x", count, offset, flags);

  if (unlikely (!block_status_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (CALLBACK_IS_NULL (extent_callback)) {
    set_error (EFAULT, "%s cannot be NULL", "extent");
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_block_status (h, count, offset, extent_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_poll (struct nbd_handle *h, int timeout)
{
  int ret;

  nbd_internal_set_error_context ("nbd_poll");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: timeout=%d", timeout);

  ret = nbd_unlocked_poll (h, timeout);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect (struct nbd_handle *h, const struct sockaddr *addr,
                 socklen_t addrlen)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: addr=<sockaddr> addrlen=%d", (int) addrlen);

  if (unlikely (!aio_connect_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect (h, addr, addrlen);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_uri_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_uri (struct nbd_handle *h, const char *uri)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_uri");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: uri=\"%s\"", uri ? uri : "NULL");

  if (unlikely (!aio_connect_uri_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (uri == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "uri");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_uri (h, uri);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_unix_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_unix (struct nbd_handle *h, const char *unixsocket)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_unix");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: unixsocket=\"%s\"", unixsocket ? unixsocket : "NULL");

  if (unlikely (!aio_connect_unix_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_unix (h, unixsocket);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_vsock_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_vsock (struct nbd_handle *h, uint32_t cid, uint32_t port)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_vsock");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: cid=%" PRIu32 " port=%" PRIu32 "", cid, port);

  if (unlikely (!aio_connect_vsock_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_vsock (h, cid, port);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_tcp_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_tcp (struct nbd_handle *h, const char *hostname,
                     const char *port)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_tcp");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: hostname=\"%s\" port=\"%s\"", hostname ? hostname : "NULL", port ? port : "NULL");

  if (unlikely (!aio_connect_tcp_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (hostname == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "hostname");
    ret = -1;
    goto out;
  }
  if (port == NULL) {
    set_error (EFAULT, "%s cannot be NULL", "port");
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_tcp (h, hostname, port);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_socket_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_socket (struct nbd_handle *h, int sock)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_socket");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: sock=%d", sock);

  if (unlikely (!aio_connect_socket_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_socket (h, sock);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_command_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_command (struct nbd_handle *h, char **argv)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_command");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: argv=<list>");

  if (unlikely (!aio_connect_command_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_command (h, argv);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_connect_systemd_socket_activation_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_created (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "newly created");
    return false;
  }
  return true;
}

int
nbd_aio_connect_systemd_socket_activation (struct nbd_handle *h,
                                           char **argv)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_connect_systemd_socket_activation");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: argv=<list>");

  if (unlikely (!aio_connect_systemd_socket_activation_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_connect_systemd_socket_activation (h, argv);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_pread_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_pread (struct nbd_handle *h, void *buf, size_t count,
               uint64_t offset, nbd_completion_callback completion_callback,
               uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_pread");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: buf=<buf> count=%zu offset=%" PRIu64 " completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_pread_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_pread (h, buf, count, offset, completion_callback,
                                flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_pread_structured_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_pread_structured (struct nbd_handle *h, void *buf, size_t count,
                          uint64_t offset,
                          nbd_chunk_callback chunk_callback,
                          nbd_completion_callback completion_callback,
                          uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_pread_structured");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: buf=<buf> count=%zu offset=%" PRIu64 " chunk=<fun> completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_pread_structured_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (CALLBACK_IS_NULL (chunk_callback)) {
    set_error (EFAULT, "%s cannot be NULL", "chunk");
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_pread_structured (h, buf, count, offset,
                                           chunk_callback,
                                           completion_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_pwrite_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_pwrite (struct nbd_handle *h, const void *buf, size_t count,
                uint64_t offset,
                nbd_completion_callback completion_callback, uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_pwrite");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: buf=<buf> count=%zu offset=%" PRIu64 " completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_pwrite_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_pwrite (h, buf, count, offset, completion_callback,
                                 flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_disconnect_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int
nbd_aio_disconnect (struct nbd_handle *h, uint32_t flags)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_disconnect");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: flags=0x%x", flags);

  if (unlikely (!aio_disconnect_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_disconnect (h, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_flush_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_flush (struct nbd_handle *h,
               nbd_completion_callback completion_callback, uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_flush");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: completion=%s flags=0x%x", CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_flush_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_flush (h, completion_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_trim_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_trim (struct nbd_handle *h, uint64_t count, uint64_t offset,
              nbd_completion_callback completion_callback, uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_trim");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_trim_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_trim (h, count, offset, completion_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_cache_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_cache (struct nbd_handle *h, uint64_t count, uint64_t offset,
               nbd_completion_callback completion_callback, uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_cache");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_cache_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_cache (h, count, offset, completion_callback,
                                flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_zero_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_zero (struct nbd_handle *h, uint64_t count, uint64_t offset,
              nbd_completion_callback completion_callback, uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_zero");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_zero_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_zero (h, count, offset, completion_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_block_status_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server");
    return false;
  }
  return true;
}

int64_t
nbd_aio_block_status (struct nbd_handle *h, uint64_t count, uint64_t offset,
                      nbd_extent_callback extent_callback,
                      nbd_completion_callback completion_callback,
                      uint32_t flags)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_block_status");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: count=%" PRIu64 " offset=%" PRIu64 " extent=<fun> completion=%s flags=0x%x", count, offset, CALLBACK_IS_NULL (completion_callback) ? "<fun>" : "NULL", flags);

  if (unlikely (!aio_block_status_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  if (CALLBACK_IS_NULL (extent_callback)) {
    set_error (EFAULT, "%s cannot be NULL", "extent");
    ret = -1;
    goto out;
  }
  if (unlikely ((flags & ~31) != 0)) {
    set_error (EINVAL, "%s: invalid value for flag: %d",
               "flags", flags);
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_block_status (h, count, offset, extent_callback,
                                       completion_callback, flags);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_aio_get_fd (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_get_fd");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_aio_get_fd (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

unsigned
nbd_aio_get_direction (struct nbd_handle *h)
{
  unsigned ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_get_direction (h);
  return ret;
}

int
nbd_aio_notify_read (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_notify_read");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_aio_notify_read (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_aio_notify_write (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_notify_write");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_aio_notify_write (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_aio_is_created (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_is_created (h);
  return ret;
}

int
nbd_aio_is_connecting (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_is_connecting (h);
  return ret;
}

int
nbd_aio_is_ready (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_is_ready (h);
  return ret;
}

int
nbd_aio_is_processing (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_is_processing (h);
  return ret;
}

int
nbd_aio_is_dead (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_is_dead (h);
  return ret;
}

int
nbd_aio_is_closed (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_aio_is_closed (h);
  return ret;
}

int
nbd_aio_command_completed (struct nbd_handle *h, int64_t cookie)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_command_completed");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: cookie=%" PRIi64 "", cookie);

  ret = nbd_unlocked_aio_command_completed (h, cookie);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int64_t
nbd_aio_peek_command_completed (struct nbd_handle *h)
{
  int64_t ret;

  nbd_internal_set_error_context ("nbd_aio_peek_command_completed");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_aio_peek_command_completed (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%" PRIi64 "", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

static inline bool
aio_in_flight_in_permitted_state (struct nbd_handle *h)
{
  const enum state state = get_public_state (h);

  if (!(nbd_internal_is_state_ready (state) || nbd_internal_is_state_processing (state) ||
        nbd_internal_is_state_closed (state) ||
        nbd_internal_is_state_dead (state))) {
    set_error (nbd_internal_is_state_created (state) ? ENOTCONN : EINVAL,
               "invalid state: %s: the handle must be %s",
               nbd_internal_state_short_string (state),
               "connected and finished handshaking with the server, or shut down, or dead");
    return false;
  }
  return true;
}

int
nbd_aio_in_flight (struct nbd_handle *h)
{
  int ret;

  nbd_internal_set_error_context ("nbd_aio_in_flight");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  if (unlikely (!aio_in_flight_in_permitted_state (h))) {
    ret = -1;
    goto out;
  }
  ret = nbd_unlocked_aio_in_flight (h);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

 out:
  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

const char *
nbd_connection_state (struct nbd_handle *h)
{
  const char * ret;

  nbd_internal_set_error_context ("nbd_connection_state");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter:");

  ret = nbd_unlocked_connection_state (h);

  if_debug (h) {
    if (ret == NULL)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=\"%s\"", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

const char *
nbd_get_package_name (struct nbd_handle *h)
{
  const char * ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_get_package_name (h);
  return ret;
}

const char *
nbd_get_version (struct nbd_handle *h)
{
  const char * ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_get_version (h);
  return ret;
}

int
nbd_kill_subprocess (struct nbd_handle *h, int signum)
{
  int ret;

  nbd_internal_set_error_context ("nbd_kill_subprocess");

  pthread_mutex_lock (&h->lock);
  debug (h, "enter: signum=%d", signum);

  ret = nbd_unlocked_kill_subprocess (h, signum);

  if_debug (h) {
    if (ret == -1)
      debug (h, "leave: error=\"%s\"", nbd_get_error ());
    else
      debug (h, "leave: ret=%d", ret);
  }

  if (h->public_state != get_next_state (h))
    h->public_state = get_next_state (h);
  pthread_mutex_unlock (&h->lock);
  return ret;
}

int
nbd_supports_tls (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_supports_tls (h);
  return ret;
}

int
nbd_supports_uri (struct nbd_handle *h)
{
  int ret;

  /* This function must not call set_error. */
  ret = nbd_unlocked_supports_uri (h);
  return ret;
}

