/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;

public class FieldsOfPrimitivechar { 
  public int identifier;
  private char char0;
  private char char1;
  private char char2;
  private char char3;
  private char char4;
  private char char5;
  private char char6;
  private char char7;
  private static char char8;
  private transient char char9;
  private transient char char10;
  private transient char char11;
  private transient char char12;
  private transient char char13;
  private transient char char14;
  private final char char15 = 'a';
  private volatile char char16;
  private volatile char char17;
  private volatile char char18;
  private volatile char char19;
  private volatile char char20;
  private volatile char char21;
  private volatile char char22;
  private volatile char char23;
  private static transient char char24;
  private static final char char25 = 'a';
  private static volatile char char26;
  private transient final char char27 = 'a';
  private transient volatile char char28;
  private transient volatile char char29;
  private transient volatile char char30;
  private transient volatile char char31;
  private transient volatile char char32;
  private transient volatile char char33;
  private static transient final char char34 = 'a';
  private static transient volatile char char35;
  public char char36;
  public char char37;
  public char char38;
  public char char39;
  public char char40;
  public char char41;
  public char char42;
  public char char43;
  public static char char44;
  public transient char char45;
  public transient char char46;
  public transient char char47;
  public transient char char48;
  public transient char char49;
  public transient char char50;
  public final char char51 = 'a';
  public volatile char char52;
  public volatile char char53;
  public volatile char char54;
  public volatile char char55;
  public volatile char char56;
  public volatile char char57;
  public volatile char char58;
  public volatile char char59;
  public static transient char char60;
  public static final char char61 = 'a';
  public static volatile char char62;
  public transient final char char63 = 'a';
  public transient volatile char char64;
  public transient volatile char char65;
  public transient volatile char char66;
  public transient volatile char char67;
  public transient volatile char char68;
  public transient volatile char char69;
  public static transient final char char70 = 'a';
  public static transient volatile char char71;
  protected char char72;
  protected char char73;
  protected char char74;
  protected char char75;
  protected char char76;
  protected char char77;
  protected char char78;
  protected char char79;
  protected static char char80;
  protected transient char char81;
  protected transient char char82;
  protected transient char char83;
  protected transient char char84;
  protected transient char char85;
  protected transient char char86;
  protected final char char87 = 'a';
  protected volatile char char88;
  protected volatile char char89;
  protected volatile char char90;
  protected volatile char char91;
  protected volatile char char92;
  protected volatile char char93;
  protected volatile char char94;
  protected volatile char char95;
  protected static transient char char96;
  protected static final char char97 = 'a';
  protected static volatile char char98;
  protected transient final char char99 = 'a';
  protected transient volatile char char100;
  protected transient volatile char char101;
  protected transient volatile char char102;
  protected transient volatile char char103;
  protected transient volatile char char104;
  protected transient volatile char char105;
  protected static transient final char char106 = 'a';
  protected static transient volatile char char107;
  char char108;
  char char109;
  char char110;
  char char111;
  char char112;
  char char113;
  char char114;
  char char115;
  static char char116;
  transient char char117;
  transient char char118;
  transient char char119;
  transient char char120;
  transient char char121;
  transient char char122;
  final char char123 = 'a';
  volatile char char124;
  volatile char char125;
  volatile char char126;
  volatile char char127;
  volatile char char128;
  volatile char char129;
  volatile char char130;
  volatile char char131;
  static transient char char132;
  static final char char133 = 'a';
  static volatile char char134;
  transient final char char135 = 'a';
  transient volatile char char136;
  transient volatile char char137;
  transient volatile char char138;
  transient volatile char char139;
  transient volatile char char140;
  transient volatile char char141;
  static transient final char char142 = 'a';
  static transient volatile char char143;

public static final boolean [] isPersistent = { 
true,true,true,false,true,true,true,false,false,false,
false,true,true,true,false,false,true,true,true,false,
true,true,true,false,false,false,false,false,false,false,
true,true,true,false,false,false,true,true,true,false,
true,true,true,false,false,false,false,true,true,true,
false,false,true,true,true,false,true,true,true,false,
false,false,false,false,false,false,true,true,true,false,
false,false,true,true,true,false,true,true,true,false,
false,false,false,true,true,true,false,false,true,true,
true,false,true,true,true,false,false,false,false,false,
false,false,true,true,true,false,false,false,true,true,
true,false,true,true,true,false,false,false,false,true,
true,true,false,false,true,true,true,false,true,true,
true,false,false,false,false,false,false,false,true,true,
true,false,false,false
 };

public static final boolean [] isStatic = { 
false,false,false,false,false,false,false,false,true,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,true,true,true,false,false,false,
false,false,false,false,true,true,false,false,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
true,true,true,false,false,false,false,false,false,false,
true,true,false,false,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,true,true,true,false,
false,false,false,false,false,false,true,true,false,false,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,false,false,false,false,false,
false,false,true,true
 };

public static final boolean [] isFinal = { 
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,true,false,false,false,false,
false,false,false,false,false,true,false,true,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,true,false,false,false,false,false,false,false,false,
false,true,false,true,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,false,true,false,false,
false,false,false,false,false,false,false,true,false,true,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,true,false,false,false,false,false,false,
false,false,false,true,false,true,false,false,false,false,
false,false,true,false
 };

  public static final String [] fieldSpecs = { 
  "private char char0",
  "embedded= true   private char char1",
  "embedded= false   private char char2",
  "persistence-modifier= none    private char char3",
  "persistence-modifier= persistent    private char char4",
  "persistence-modifier= persistent  embedded= true   private char char5",
  "persistence-modifier= persistent  embedded= false   private char char6",
  "persistence-modifier= transactional    private char char7",
  "private static char char8",
  "private transient char char9",
  "persistence-modifier= none    private transient char char10",
  "persistence-modifier= persistent    private transient char char11",
  "persistence-modifier= persistent  embedded= true   private transient char char12",
  "persistence-modifier= persistent  embedded= false   private transient char char13",
  "persistence-modifier= transactional    private transient char char14",
  "private final char char15",
  "private volatile char char16",
  "embedded= true   private volatile char char17",
  "embedded= false   private volatile char char18",
  "persistence-modifier= none    private volatile char char19",
  "persistence-modifier= persistent    private volatile char char20",
  "persistence-modifier= persistent  embedded= true   private volatile char char21",
  "persistence-modifier= persistent  embedded= false   private volatile char char22",
  "persistence-modifier= transactional    private volatile char char23",
  "private static transient char char24",
  "private static final char char25",
  "private static volatile char char26",
  "private transient final char char27",
  "private transient volatile char char28",
  "persistence-modifier= none    private transient volatile char char29",
  "persistence-modifier= persistent    private transient volatile char char30",
  "persistence-modifier= persistent  embedded= true   private transient volatile char char31",
  "persistence-modifier= persistent  embedded= false   private transient volatile char char32",
  "persistence-modifier= transactional    private transient volatile char char33",
  "private static transient final char char34",
  "private static transient volatile char char35",
  "public char char36",
  "embedded= true   public char char37",
  "embedded= false   public char char38",
  "persistence-modifier= none    public char char39",
  "persistence-modifier= persistent    public char char40",
  "persistence-modifier= persistent  embedded= true   public char char41",
  "persistence-modifier= persistent  embedded= false   public char char42",
  "persistence-modifier= transactional    public char char43",
  "public static char char44",
  "public transient char char45",
  "persistence-modifier= none    public transient char char46",
  "persistence-modifier= persistent    public transient char char47",
  "persistence-modifier= persistent  embedded= true   public transient char char48",
  "persistence-modifier= persistent  embedded= false   public transient char char49",
  "persistence-modifier= transactional    public transient char char50",
  "public final char char51",
  "public volatile char char52",
  "embedded= true   public volatile char char53",
  "embedded= false   public volatile char char54",
  "persistence-modifier= none    public volatile char char55",
  "persistence-modifier= persistent    public volatile char char56",
  "persistence-modifier= persistent  embedded= true   public volatile char char57",
  "persistence-modifier= persistent  embedded= false   public volatile char char58",
  "persistence-modifier= transactional    public volatile char char59",
  "public static transient char char60",
  "public static final char char61",
  "public static volatile char char62",
  "public transient final char char63",
  "public transient volatile char char64",
  "persistence-modifier= none    public transient volatile char char65",
  "persistence-modifier= persistent    public transient volatile char char66",
  "persistence-modifier= persistent  embedded= true   public transient volatile char char67",
  "persistence-modifier= persistent  embedded= false   public transient volatile char char68",
  "persistence-modifier= transactional    public transient volatile char char69",
  "public static transient final char char70",
  "public static transient volatile char char71",
  "protected char char72",
  "embedded= true   protected char char73",
  "embedded= false   protected char char74",
  "persistence-modifier= none    protected char char75",
  "persistence-modifier= persistent    protected char char76",
  "persistence-modifier= persistent  embedded= true   protected char char77",
  "persistence-modifier= persistent  embedded= false   protected char char78",
  "persistence-modifier= transactional    protected char char79",
  "protected static char char80",
  "protected transient char char81",
  "persistence-modifier= none    protected transient char char82",
  "persistence-modifier= persistent    protected transient char char83",
  "persistence-modifier= persistent  embedded= true   protected transient char char84",
  "persistence-modifier= persistent  embedded= false   protected transient char char85",
  "persistence-modifier= transactional    protected transient char char86",
  "protected final char char87",
  "protected volatile char char88",
  "embedded= true   protected volatile char char89",
  "embedded= false   protected volatile char char90",
  "persistence-modifier= none    protected volatile char char91",
  "persistence-modifier= persistent    protected volatile char char92",
  "persistence-modifier= persistent  embedded= true   protected volatile char char93",
  "persistence-modifier= persistent  embedded= false   protected volatile char char94",
  "persistence-modifier= transactional    protected volatile char char95",
  "protected static transient char char96",
  "protected static final char char97",
  "protected static volatile char char98",
  "protected transient final char char99",
  "protected transient volatile char char100",
  "persistence-modifier= none    protected transient volatile char char101",
  "persistence-modifier= persistent    protected transient volatile char char102",
  "persistence-modifier= persistent  embedded= true   protected transient volatile char char103",
  "persistence-modifier= persistent  embedded= false   protected transient volatile char char104",
  "persistence-modifier= transactional    protected transient volatile char char105",
  "protected static transient final char char106",
  "protected static transient volatile char char107",
  "char char108",
  "embedded= true   char char109",
  "embedded= false   char char110",
  "persistence-modifier= none    char char111",
  "persistence-modifier= persistent    char char112",
  "persistence-modifier= persistent  embedded= true   char char113",
  "persistence-modifier= persistent  embedded= false   char char114",
  "persistence-modifier= transactional    char char115",
  "static char char116",
  "transient char char117",
  "persistence-modifier= none    transient char char118",
  "persistence-modifier= persistent    transient char char119",
  "persistence-modifier= persistent  embedded= true   transient char char120",
  "persistence-modifier= persistent  embedded= false   transient char char121",
  "persistence-modifier= transactional    transient char char122",
  "final char char123",
  "volatile char char124",
  "embedded= true   volatile char char125",
  "embedded= false   volatile char char126",
  "persistence-modifier= none    volatile char char127",
  "persistence-modifier= persistent    volatile char char128",
  "persistence-modifier= persistent  embedded= true   volatile char char129",
  "persistence-modifier= persistent  embedded= false   volatile char char130",
  "persistence-modifier= transactional    volatile char char131",
  "static transient char char132",
  "static final char char133",
  "static volatile char char134",
  "transient final char char135",
  "transient volatile char char136",
  "persistence-modifier= none    transient volatile char char137",
  "persistence-modifier= persistent    transient volatile char char138",
  "persistence-modifier= persistent  embedded= true   transient volatile char char139",
  "persistence-modifier= persistent  embedded= false   transient volatile char char140",
  "persistence-modifier= transactional    transient volatile char char141",
  "static transient final char char142",
  "static transient volatile char char143"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public char get(int index)
  {
    switch (index)
    {
      case(0):
        return char0;
      case(1):
        return char1;
      case(2):
        return char2;
      case(3):
        return char3;
      case(4):
        return char4;
      case(5):
        return char5;
      case(6):
        return char6;
      case(7):
        return char7;
      case(8):
        return char8;
      case(9):
        return char9;
      case(10):
        return char10;
      case(11):
        return char11;
      case(12):
        return char12;
      case(13):
        return char13;
      case(14):
        return char14;
      case(15):
        return char15;
      case(16):
        return char16;
      case(17):
        return char17;
      case(18):
        return char18;
      case(19):
        return char19;
      case(20):
        return char20;
      case(21):
        return char21;
      case(22):
        return char22;
      case(23):
        return char23;
      case(24):
        return char24;
      case(25):
        return char25;
      case(26):
        return char26;
      case(27):
        return char27;
      case(28):
        return char28;
      case(29):
        return char29;
      case(30):
        return char30;
      case(31):
        return char31;
      case(32):
        return char32;
      case(33):
        return char33;
      case(34):
        return char34;
      case(35):
        return char35;
      case(36):
        return char36;
      case(37):
        return char37;
      case(38):
        return char38;
      case(39):
        return char39;
      case(40):
        return char40;
      case(41):
        return char41;
      case(42):
        return char42;
      case(43):
        return char43;
      case(44):
        return char44;
      case(45):
        return char45;
      case(46):
        return char46;
      case(47):
        return char47;
      case(48):
        return char48;
      case(49):
        return char49;
      case(50):
        return char50;
      case(51):
        return char51;
      case(52):
        return char52;
      case(53):
        return char53;
      case(54):
        return char54;
      case(55):
        return char55;
      case(56):
        return char56;
      case(57):
        return char57;
      case(58):
        return char58;
      case(59):
        return char59;
      case(60):
        return char60;
      case(61):
        return char61;
      case(62):
        return char62;
      case(63):
        return char63;
      case(64):
        return char64;
      case(65):
        return char65;
      case(66):
        return char66;
      case(67):
        return char67;
      case(68):
        return char68;
      case(69):
        return char69;
      case(70):
        return char70;
      case(71):
        return char71;
      case(72):
        return char72;
      case(73):
        return char73;
      case(74):
        return char74;
      case(75):
        return char75;
      case(76):
        return char76;
      case(77):
        return char77;
      case(78):
        return char78;
      case(79):
        return char79;
      case(80):
        return char80;
      case(81):
        return char81;
      case(82):
        return char82;
      case(83):
        return char83;
      case(84):
        return char84;
      case(85):
        return char85;
      case(86):
        return char86;
      case(87):
        return char87;
      case(88):
        return char88;
      case(89):
        return char89;
      case(90):
        return char90;
      case(91):
        return char91;
      case(92):
        return char92;
      case(93):
        return char93;
      case(94):
        return char94;
      case(95):
        return char95;
      case(96):
        return char96;
      case(97):
        return char97;
      case(98):
        return char98;
      case(99):
        return char99;
      case(100):
        return char100;
      case(101):
        return char101;
      case(102):
        return char102;
      case(103):
        return char103;
      case(104):
        return char104;
      case(105):
        return char105;
      case(106):
        return char106;
      case(107):
        return char107;
      case(108):
        return char108;
      case(109):
        return char109;
      case(110):
        return char110;
      case(111):
        return char111;
      case(112):
        return char112;
      case(113):
        return char113;
      case(114):
        return char114;
      case(115):
        return char115;
      case(116):
        return char116;
      case(117):
        return char117;
      case(118):
        return char118;
      case(119):
        return char119;
      case(120):
        return char120;
      case(121):
        return char121;
      case(122):
        return char122;
      case(123):
        return char123;
      case(124):
        return char124;
      case(125):
        return char125;
      case(126):
        return char126;
      case(127):
        return char127;
      case(128):
        return char128;
      case(129):
        return char129;
      case(130):
        return char130;
      case(131):
        return char131;
      case(132):
        return char132;
      case(133):
        return char133;
      case(134):
        return char134;
      case(135):
        return char135;
      case(136):
        return char136;
      case(137):
        return char137;
      case(138):
        return char138;
      case(139):
        return char139;
      case(140):
        return char140;
      case(141):
        return char141;
      case(142):
        return char142;
      case(143):
        return char143;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,char value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        char0= value;
         break;
      case(1):
        char1= value;
         break;
      case(2):
        char2= value;
         break;
      case(3):
        char3= value;
         break;
      case(4):
        char4= value;
         break;
      case(5):
        char5= value;
         break;
      case(6):
        char6= value;
         break;
      case(7):
        char7= value;
         break;
      case(8):
        char8= value;
         break;
      case(9):
        char9= value;
         break;
      case(10):
        char10= value;
         break;
      case(11):
        char11= value;
         break;
      case(12):
        char12= value;
         break;
      case(13):
        char13= value;
         break;
      case(14):
        char14= value;
         break;
      case(16):
        char16= value;
         break;
      case(17):
        char17= value;
         break;
      case(18):
        char18= value;
         break;
      case(19):
        char19= value;
         break;
      case(20):
        char20= value;
         break;
      case(21):
        char21= value;
         break;
      case(22):
        char22= value;
         break;
      case(23):
        char23= value;
         break;
      case(24):
        char24= value;
         break;
      case(26):
        char26= value;
         break;
      case(28):
        char28= value;
         break;
      case(29):
        char29= value;
         break;
      case(30):
        char30= value;
         break;
      case(31):
        char31= value;
         break;
      case(32):
        char32= value;
         break;
      case(33):
        char33= value;
         break;
      case(35):
        char35= value;
         break;
      case(36):
        char36= value;
         break;
      case(37):
        char37= value;
         break;
      case(38):
        char38= value;
         break;
      case(39):
        char39= value;
         break;
      case(40):
        char40= value;
         break;
      case(41):
        char41= value;
         break;
      case(42):
        char42= value;
         break;
      case(43):
        char43= value;
         break;
      case(44):
        char44= value;
         break;
      case(45):
        char45= value;
         break;
      case(46):
        char46= value;
         break;
      case(47):
        char47= value;
         break;
      case(48):
        char48= value;
         break;
      case(49):
        char49= value;
         break;
      case(50):
        char50= value;
         break;
      case(52):
        char52= value;
         break;
      case(53):
        char53= value;
         break;
      case(54):
        char54= value;
         break;
      case(55):
        char55= value;
         break;
      case(56):
        char56= value;
         break;
      case(57):
        char57= value;
         break;
      case(58):
        char58= value;
         break;
      case(59):
        char59= value;
         break;
      case(60):
        char60= value;
         break;
      case(62):
        char62= value;
         break;
      case(64):
        char64= value;
         break;
      case(65):
        char65= value;
         break;
      case(66):
        char66= value;
         break;
      case(67):
        char67= value;
         break;
      case(68):
        char68= value;
         break;
      case(69):
        char69= value;
         break;
      case(71):
        char71= value;
         break;
      case(72):
        char72= value;
         break;
      case(73):
        char73= value;
         break;
      case(74):
        char74= value;
         break;
      case(75):
        char75= value;
         break;
      case(76):
        char76= value;
         break;
      case(77):
        char77= value;
         break;
      case(78):
        char78= value;
         break;
      case(79):
        char79= value;
         break;
      case(80):
        char80= value;
         break;
      case(81):
        char81= value;
         break;
      case(82):
        char82= value;
         break;
      case(83):
        char83= value;
         break;
      case(84):
        char84= value;
         break;
      case(85):
        char85= value;
         break;
      case(86):
        char86= value;
         break;
      case(88):
        char88= value;
         break;
      case(89):
        char89= value;
         break;
      case(90):
        char90= value;
         break;
      case(91):
        char91= value;
         break;
      case(92):
        char92= value;
         break;
      case(93):
        char93= value;
         break;
      case(94):
        char94= value;
         break;
      case(95):
        char95= value;
         break;
      case(96):
        char96= value;
         break;
      case(98):
        char98= value;
         break;
      case(100):
        char100= value;
         break;
      case(101):
        char101= value;
         break;
      case(102):
        char102= value;
         break;
      case(103):
        char103= value;
         break;
      case(104):
        char104= value;
         break;
      case(105):
        char105= value;
         break;
      case(107):
        char107= value;
         break;
      case(108):
        char108= value;
         break;
      case(109):
        char109= value;
         break;
      case(110):
        char110= value;
         break;
      case(111):
        char111= value;
         break;
      case(112):
        char112= value;
         break;
      case(113):
        char113= value;
         break;
      case(114):
        char114= value;
         break;
      case(115):
        char115= value;
         break;
      case(116):
        char116= value;
         break;
      case(117):
        char117= value;
         break;
      case(118):
        char118= value;
         break;
      case(119):
        char119= value;
         break;
      case(120):
        char120= value;
         break;
      case(121):
        char121= value;
         break;
      case(122):
        char122= value;
         break;
      case(124):
        char124= value;
         break;
      case(125):
        char125= value;
         break;
      case(126):
        char126= value;
         break;
      case(127):
        char127= value;
         break;
      case(128):
        char128= value;
         break;
      case(129):
        char129= value;
         break;
      case(130):
        char130= value;
         break;
      case(131):
        char131= value;
         break;
      case(132):
        char132= value;
         break;
      case(134):
        char134= value;
         break;
      case(136):
        char136= value;
         break;
      case(137):
        char137= value;
         break;
      case(138):
        char138= value;
         break;
      case(139):
        char139= value;
         break;
      case(140):
        char140= value;
         break;
      case(141):
        char141= value;
         break;
      case(143):
        char143= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }

    }   
}
