/*
 *  @(#)FactorParserCollator.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.itf.impl;

import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecord;
import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecordSet;
import net.sourceforge.groboutils.pmti.v1.itf.ITestIssueRecordCollator;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;

/**
 * Collates the parsers' parsed records into record sets based on their
 * containment in some factor of the test issue record.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:59 $
 * @since      July 7, 2002
 */
public abstract class AbstractTestIssueRecordCollator
        implements ITestIssueRecordCollator
{
    public ITestIssueRecordSet[] collate( ITestIssueRecord[] r )
    {
        if (r == null || r.length <= 0)
        {
            return new ITestIssueRecordSet[0];
        }
        
        Hashtable suites = new Hashtable();
        for (int i = 0; i < r.length; ++i)
        {
            if (r[i] != null)
            {
                Object s = getFactor( r[i] );
                Vector v = (Vector)suites.get( s );
                if (v == null)
                {
                    v = new Vector();
                    suites.put( s, v );
                }
                v.addElement( r[i] );
            }
        }
        
        ITestIssueRecordSet sets[] = new ITestIssueRecordSet[ suites.size() ];
        Enumeration enum = suites.elements();
        for (int i = 0; enum.hasMoreElements(); ++i)
        {
            Vector v = (Vector)enum.nextElement();
            ITestIssueRecord[] rset = new ITestIssueRecord[ v.size() ];
            v.copyInto( rset );
            sets[i] = new DefaultTestIssueRecordSet( rset );
        }
        return sets;
    }
    
    
    /**
     * Discovers the sorting factor from the given record.
     */
    protected abstract Object getFactor( ITestIssueRecord r );
}

