/* dialog.c generated by valac 0.44.7, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;

#define GAMES_SCORES_TYPE_CONTEXT (games_scores_context_get_type ())
#define GAMES_SCORES_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext))
#define GAMES_SCORES_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))
#define GAMES_SCORES_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))

typedef struct _GamesScoresContext GamesScoresContext;
typedef struct _GamesScoresContextClass GamesScoresContextClass;

#define GAMES_SCORES_TYPE_CATEGORY (games_scores_category_get_type ())
#define GAMES_SCORES_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory))
#define GAMES_SCORES_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))
#define GAMES_SCORES_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))

typedef struct _GamesScoresCategory GamesScoresCategory;
typedef struct _GamesScoresCategoryClass GamesScoresCategoryClass;
typedef enum  {
	GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER
} GamesScoresStyle;

#define GAMES_SCORES_TYPE_STYLE (games_scores_style_get_type ())

#define GAMES_SCORES_TYPE_SCORE (games_scores_score_get_type ())
#define GAMES_SCORES_SCORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScore))
#define GAMES_SCORES_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))
#define GAMES_SCORES_IS_SCORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_IS_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_SCORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))

typedef struct _GamesScoresScore GamesScoresScore;
typedef struct _GamesScoresScoreClass GamesScoresScoreClass;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

struct _GamesScoresDialog {
	GtkDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	GtkDialogClass parent_class;
};

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GamesScoresCategory* active_category;
	gint rows_to_display;
	GtkComboBoxText* combo;
	GtkLabel* category_label;
	GtkHeaderBar* headerbar;
	GtkGrid* grid;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	GamesScoresCategory* scores_active_category;
};

struct _Block4Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresScore* score;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkEntry* entry;
};

static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

GType games_scores_dialog_get_type (void) G_GNUC_CONST;
GType games_scores_context_get_type (void) G_GNUC_CONST;
GType games_scores_category_get_type (void) G_GNUC_CONST;
GType games_scores_style_get_type (void) G_GNUC_CONST;
GType games_scores_score_get_type (void) G_GNUC_CONST;
GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            GtkWindow* window,
                                            const gchar* app_name);
GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  GtkWindow* window,
                                                  const gchar* app_name);
gboolean games_scores_context_has_scores (GamesScoresContext* self);
GList* games_scores_context_get_categories (GamesScoresContext* self);
const gchar* games_scores_category_get_name (GamesScoresCategory* self);
static void games_scores_dialog_load_scores (GamesScoresDialog* self);
static void _games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self);
static void games_scores_dialog_load_categories (GamesScoresDialog* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda10_ (GamesScoresDialog* self,
                  GamesScoresCategory* x);
const gchar* games_scores_category_get_key (GamesScoresCategory* self);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
GamesScoresCategory* games_scores_category_new (const gchar* key,
                                                const gchar* name);
GamesScoresCategory* games_scores_category_construct (GType object_type,
                                                      const gchar* key,
                                                      const gchar* name);
void games_scores_category_set_key (GamesScoresCategory* self,
                                    const gchar* value);
void games_scores_category_set_name (GamesScoresCategory* self,
                                     const gchar* value);
GeeList* games_scores_context_get_high_scores (GamesScoresContext* self,
                                               GamesScoresCategory* category,
                                               gint n);
static void games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                               GamesScoresScore* score,
                                               gint row_count,
                                               guint no_scores);
static void games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                      gint row_count);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
glong games_scores_score_get_score (GamesScoresScore* self);
gboolean games_scores_score_equals (GamesScoresScore* a,
                                    GamesScoresScore* b);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
const gchar* games_scores_score_get_user (GamesScoresScore* self);
static void ___lambda9_ (Block5Data* _data5_);
void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
void games_scores_score_set_user (GamesScoresScore* self,
                                  const gchar* value);
static void ____lambda9__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void games_scores_dialog_finalize (GObject * obj);

static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
	games_scores_dialog_load_scores ((GamesScoresDialog*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               GtkWindow* window,
                               const gchar* app_name)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GtkWidget* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkHeaderBar* _tmp5_;
	gboolean _tmp12_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp41_;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkBox* catbar = NULL;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GList* categories = NULL;
	GList* _tmp47_;
	GList* _tmp48_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkLabel* _tmp58_;
	GtkGrid* _tmp73_;
	GtkBox* _tmp74_;
	GtkGrid* _tmp75_;
	GtkGrid* _tmp76_;
	GtkGrid* _tmp77_;
	GtkGrid* _tmp78_;
	GtkGrid* _tmp79_;
	gchar* string_rank = NULL;
	gchar* _tmp80_;
	GtkLabel* label_column_1 = NULL;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	GtkLabel* _tmp86_;
	GtkLabel* _tmp87_;
	GtkLabel* _tmp88_;
	GtkGrid* _tmp89_;
	GtkLabel* _tmp90_;
	gchar* score_or_time = NULL;
	gchar* _tmp91_;
	gboolean _tmp92_ = FALSE;
	GamesScoresStyle _tmp93_;
	GtkLabel* label_column_2 = NULL;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	GtkLabel* _tmp102_;
	GtkLabel* _tmp103_;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkLabel* _tmp106_;
	gchar* string_player = NULL;
	gchar* _tmp107_;
	GtkLabel* label_column_3 = NULL;
	const gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	GtkLabel* _tmp113_;
	GtkLabel* _tmp114_;
	GtkLabel* _tmp115_;
	GtkGrid* _tmp116_;
	GtkLabel* _tmp117_;
	GtkGrid* _tmp118_;
	GtkBox* _tmp121_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (app_name != NULL, NULL);
	self = (GamesScoresDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	_tmp1_ = _g_object_ref0 (new_high_score);
	_g_object_unref0 (self->priv->new_high_score);
	self->priv->new_high_score = _tmp1_;
	self->priv->scores_style = style;
	_tmp2_ = _g_object_ref0 (current_cat);
	_g_object_unref0 (self->priv->scores_active_category);
	self->priv->scores_active_category = _tmp2_;
	_tmp3_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp4_;
	_tmp5_ = self->priv->headerbar;
	gtk_header_bar_set_show_close_button (_tmp5_, new_high_score == NULL);
	if (new_high_score != NULL) {
		GtkHeaderBar* _tmp6_;
		_tmp6_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp6_, _ ("Congratulations!"));
	} else {
		gboolean _tmp7_ = FALSE;
		GamesScoresStyle _tmp8_;
		_tmp8_ = self->priv->scores_style;
		if (_tmp8_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
			_tmp7_ = TRUE;
		} else {
			GamesScoresStyle _tmp9_;
			_tmp9_ = self->priv->scores_style;
			_tmp7_ = _tmp9_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
		}
		if (_tmp7_) {
			GtkHeaderBar* _tmp10_;
			_tmp10_ = self->priv->headerbar;
			gtk_header_bar_set_title (_tmp10_, _ ("High Scores"));
		} else {
			GtkHeaderBar* _tmp11_;
			_tmp11_ = self->priv->headerbar;
			gtk_header_bar_set_title (_tmp11_, _ ("Best Times"));
		}
	}
	if (!games_scores_context_has_scores (context)) {
		_tmp12_ = new_high_score == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkBox* vbox = NULL;
		GtkBox* _tmp13_;
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		GtkBox* _tmp16_;
		GtkBox* _tmp17_;
		GtkBox* _tmp18_;
		GtkStyleContext* _tmp19_;
		GtkImage* image = NULL;
		GtkImage* _tmp20_;
		GtkImage* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GtkImage* _tmp24_;
		GtkImage* _tmp25_;
		GtkBox* _tmp26_;
		GtkImage* _tmp27_;
		GtkLabel* title_label = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GtkLabel* _tmp32_;
		GtkLabel* _tmp33_;
		GtkLabel* _tmp34_;
		GtkBox* _tmp35_;
		GtkLabel* _tmp36_;
		GtkLabel* description_label = NULL;
		GtkLabel* _tmp37_;
		GtkBox* _tmp38_;
		GtkLabel* _tmp39_;
		GtkBox* _tmp40_;
		_tmp13_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		vbox = _tmp14_;
		_tmp15_ = vbox;
		gtk_box_set_spacing (_tmp15_, 4);
		_tmp16_ = vbox;
		gtk_container_set_border_width ((GtkContainer*) _tmp16_, (guint) 10);
		_tmp17_ = vbox;
		gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
		_tmp18_ = vbox;
		_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
		gtk_style_context_add_class (_tmp19_, "dim-label");
		_tmp20_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp20_);
		image = _tmp20_;
		_tmp21_ = image;
		_tmp22_ = g_strconcat (app_name, "-symbolic", NULL);
		_tmp23_ = _tmp22_;
		g_object_set (_tmp21_, "icon-name", _tmp23_, NULL);
		_g_free0 (_tmp23_);
		_tmp24_ = image;
		gtk_image_set_pixel_size (_tmp24_, 64);
		_tmp25_ = image;
		gtk_widget_set_opacity ((GtkWidget*) _tmp25_, 0.2);
		_tmp26_ = vbox;
		_tmp27_ = image;
		gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
		_tmp28_ = g_strconcat ("<b><span size=\"large\">", _ ("No scores yet"), NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "</span></b>", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = (GtkLabel*) gtk_label_new (_tmp31_);
		g_object_ref_sink (_tmp32_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		title_label = _tmp33_;
		_tmp34_ = title_label;
		gtk_label_set_use_markup (_tmp34_, TRUE);
		_tmp35_ = vbox;
		_tmp36_ = title_label;
		gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
		_tmp37_ = (GtkLabel*) gtk_label_new (_ ("Play some games and your scores will show up here."));
		g_object_ref_sink (_tmp37_);
		description_label = _tmp37_;
		_tmp38_ = vbox;
		_tmp39_ = description_label;
		gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
		_tmp40_ = vbox;
		gtk_widget_show_all ((GtkWidget*) _tmp40_);
		g_object_set ((GtkWidget*) self, "width-request", 450, NULL);
		g_object_set ((GtkWidget*) self, "height-request", 500, NULL);
		_g_object_unref0 (description_label);
		_g_object_unref0 (title_label);
		_g_object_unref0 (image);
		_g_object_unref0 (vbox);
		return self;
	}
	_tmp41_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp42_ = _g_object_ref0 (_tmp41_);
	vbox = _tmp42_;
	_tmp43_ = vbox;
	gtk_box_set_spacing (_tmp43_, 20);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 10);
	_tmp44_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp44_);
	catbar = _tmp44_;
	_tmp45_ = catbar;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp45_, 10);
	_tmp46_ = catbar;
	gtk_widget_set_halign ((GtkWidget*) _tmp46_, GTK_ALIGN_CENTER);
	_tmp47_ = games_scores_context_get_categories (context);
	categories = _tmp47_;
	_tmp48_ = categories;
	if (g_list_length (_tmp48_) > ((guint) 1)) {
		GtkBox* _tmp49_;
		GtkBox* _tmp50_;
		GtkSeparator* hdiv = NULL;
		GtkSeparator* _tmp51_;
		GtkBox* _tmp52_;
		GtkSeparator* _tmp53_;
		_tmp49_ = vbox;
		_tmp50_ = catbar;
		gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp50_, TRUE, FALSE, (guint) 0);
		_tmp51_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp51_);
		hdiv = _tmp51_;
		_tmp52_ = vbox;
		_tmp53_ = hdiv;
		gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (hdiv);
	}
	_tmp54_ = (GtkLabel*) gtk_label_new (category_type);
	g_object_ref_sink (_tmp54_);
	label = _tmp54_;
	_tmp55_ = label;
	gtk_label_set_use_markup (_tmp55_, TRUE);
	_tmp56_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp56_, GTK_ALIGN_CENTER);
	_tmp57_ = catbar;
	_tmp58_ = label;
	gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
	if (new_high_score != NULL) {
		GamesScoresCategory* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		GtkLabel* _tmp62_;
		GtkLabel* _tmp63_;
		GtkLabel* _tmp64_;
		GtkLabel* _tmp65_;
		GtkBox* _tmp66_;
		GtkLabel* _tmp67_;
		_tmp59_ = self->priv->scores_active_category;
		_tmp60_ = games_scores_category_get_name (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = (GtkLabel*) gtk_label_new (_tmp61_);
		g_object_ref_sink (_tmp62_);
		_g_object_unref0 (self->priv->category_label);
		self->priv->category_label = _tmp62_;
		_tmp63_ = self->priv->category_label;
		gtk_label_set_use_markup (_tmp63_, TRUE);
		_tmp64_ = self->priv->category_label;
		gtk_widget_set_halign ((GtkWidget*) _tmp64_, GTK_ALIGN_CENTER);
		_tmp65_ = self->priv->category_label;
		gtk_widget_set_valign ((GtkWidget*) _tmp65_, GTK_ALIGN_CENTER);
		_tmp66_ = catbar;
		_tmp67_ = self->priv->category_label;
		gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, FALSE, FALSE, (guint) 0);
	} else {
		GtkComboBoxText* _tmp68_;
		GtkComboBoxText* _tmp69_;
		GtkBox* _tmp70_;
		GtkComboBoxText* _tmp71_;
		GtkComboBoxText* _tmp72_;
		_tmp68_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
		g_object_ref_sink (_tmp68_);
		_g_object_unref0 (self->priv->combo);
		self->priv->combo = _tmp68_;
		_tmp69_ = self->priv->combo;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp69_, FALSE);
		_tmp70_ = catbar;
		_tmp71_ = self->priv->combo;
		gtk_box_pack_start (_tmp70_, (GtkWidget*) _tmp71_, TRUE, TRUE, (guint) 0);
		_tmp72_ = self->priv->combo;
		g_signal_connect_object ((GtkComboBox*) _tmp72_, "changed", (GCallback) _games_scores_dialog_load_scores_gtk_combo_box_changed, self, 0);
	}
	_tmp73_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp73_;
	_tmp74_ = vbox;
	_tmp75_ = self->priv->grid;
	gtk_box_pack_start (_tmp74_, (GtkWidget*) _tmp75_, FALSE, FALSE, (guint) 0);
	_tmp76_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp76_, TRUE);
	_tmp77_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp77_, 40);
	_tmp78_ = self->priv->grid;
	g_object_set ((GtkWidget*) _tmp78_, "margin", 20, NULL);
	_tmp79_ = self->priv->grid;
	gtk_widget_set_halign ((GtkWidget*) _tmp79_, GTK_ALIGN_CENTER);
	_tmp80_ = g_strdup (_ ("Rank"));
	string_rank = _tmp80_;
	_tmp81_ = string_rank;
	_tmp82_ = g_strconcat ("<span weight='bold'>", _tmp81_, NULL);
	_tmp83_ = _tmp82_;
	_tmp84_ = g_strconcat (_tmp83_, "</span>", NULL);
	_tmp85_ = _tmp84_;
	_tmp86_ = (GtkLabel*) gtk_label_new (_tmp85_);
	g_object_ref_sink (_tmp86_);
	_tmp87_ = _tmp86_;
	_g_free0 (_tmp85_);
	_g_free0 (_tmp83_);
	label_column_1 = _tmp87_;
	_tmp88_ = label_column_1;
	gtk_label_set_use_markup (_tmp88_, TRUE);
	_tmp89_ = self->priv->grid;
	_tmp90_ = label_column_1;
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 0, 0, 1, 1);
	_tmp91_ = g_strdup ("");
	score_or_time = _tmp91_;
	_tmp93_ = self->priv->scores_style;
	if (_tmp93_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp92_ = TRUE;
	} else {
		GamesScoresStyle _tmp94_;
		_tmp94_ = self->priv->scores_style;
		_tmp92_ = _tmp94_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp92_) {
		gchar* _tmp95_;
		_tmp95_ = g_strdup (_ ("Score"));
		_g_free0 (score_or_time);
		score_or_time = _tmp95_;
	} else {
		gchar* _tmp96_;
		_tmp96_ = g_strdup (_ ("Time"));
		_g_free0 (score_or_time);
		score_or_time = _tmp96_;
	}
	_tmp97_ = score_or_time;
	_tmp98_ = g_strconcat ("<span weight='bold'>", _tmp97_, NULL);
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (_tmp99_, "</span>", NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = (GtkLabel*) gtk_label_new (_tmp101_);
	g_object_ref_sink (_tmp102_);
	_tmp103_ = _tmp102_;
	_g_free0 (_tmp101_);
	_g_free0 (_tmp99_);
	label_column_2 = _tmp103_;
	_tmp104_ = label_column_2;
	gtk_label_set_use_markup (_tmp104_, TRUE);
	_tmp105_ = self->priv->grid;
	_tmp106_ = label_column_2;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 1, 0, 1, 1);
	_tmp107_ = g_strdup (_ ("Player"));
	string_player = _tmp107_;
	_tmp108_ = string_player;
	_tmp109_ = g_strconcat ("<span weight='bold'>", _tmp108_, NULL);
	_tmp110_ = _tmp109_;
	_tmp111_ = g_strconcat (_tmp110_, "</span>", NULL);
	_tmp112_ = _tmp111_;
	_tmp113_ = (GtkLabel*) gtk_label_new (_tmp112_);
	g_object_ref_sink (_tmp113_);
	_tmp114_ = _tmp113_;
	_g_free0 (_tmp112_);
	_g_free0 (_tmp110_);
	label_column_3 = _tmp114_;
	_tmp115_ = label_column_3;
	gtk_label_set_use_markup (_tmp115_, TRUE);
	_tmp116_ = self->priv->grid;
	_tmp117_ = label_column_3;
	gtk_grid_attach (_tmp116_, (GtkWidget*) _tmp117_, 2, 0, 1, 1);
	_tmp118_ = self->priv->grid;
	gtk_grid_set_baseline_row (_tmp118_, 0);
	games_scores_dialog_fill_grid_with_labels (self);
	if (new_high_score != NULL) {
		GtkWidget* _tmp119_;
		GtkStyleContext* _tmp120_;
		_tmp119_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("_Done"), (gint) GTK_RESPONSE_OK);
		_tmp120_ = gtk_widget_get_style_context (_tmp119_);
		gtk_style_context_add_class (_tmp120_, "suggested-action");
	}
	games_scores_dialog_load_categories (self);
	_tmp121_ = vbox;
	gtk_widget_show_all ((GtkWidget*) _tmp121_);
	_g_object_unref0 (label_column_3);
	_g_free0 (string_player);
	_g_object_unref0 (label_column_2);
	_g_free0 (score_or_time);
	_g_object_unref0 (label_column_1);
	_g_free0 (string_rank);
	_g_object_unref0 (label);
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
	_g_object_unref0 (catbar);
	_g_object_unref0 (vbox);
	return self;
}

GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         GtkWindow* window,
                         const gchar* app_name)
{
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, window, app_name);
}

static void
games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self)
{
	g_return_if_fail (self != NULL);
	{
		gint row = 0;
		row = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStack* stack = NULL;
				GtkStack* _tmp10_;
				GtkStack* _tmp11_;
				GtkStack* _tmp12_;
				GtkStack* _tmp13_;
				GtkStack* _tmp14_;
				GtkLabel* label = NULL;
				GtkLabel* _tmp15_;
				GtkLabel* _tmp16_;
				GtkLabel* _tmp17_;
				GtkLabel* _tmp18_;
				GtkStack* _tmp19_;
				GtkLabel* _tmp20_;
				GtkEntry* entry = NULL;
				GtkEntry* _tmp21_;
				GtkEntry* _tmp22_;
				GtkEntry* _tmp23_;
				GtkEntry* _tmp24_;
				GtkStack* _tmp25_;
				GtkEntry* _tmp26_;
				GtkStack* _tmp27_;
				GtkGrid* _tmp28_;
				GtkStack* _tmp29_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(row <= self->priv->rows_to_display)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GtkLabel* label = NULL;
							GtkLabel* _tmp4_;
							GtkLabel* _tmp5_;
							GtkLabel* _tmp6_;
							GtkLabel* _tmp7_;
							GtkGrid* _tmp8_;
							GtkLabel* _tmp9_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = column;
								column = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(column <= 1)) {
								break;
							}
							_tmp4_ = (GtkLabel*) gtk_label_new ("");
							g_object_ref_sink (_tmp4_);
							label = _tmp4_;
							_tmp5_ = label;
							gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
							_tmp6_ = label;
							gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
							_tmp7_ = label;
							gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
							_tmp8_ = self->priv->grid;
							_tmp9_ = label;
							gtk_grid_attach (_tmp8_, (GtkWidget*) _tmp9_, column, row, 1, 1);
							_g_object_unref0 (label);
						}
					}
				}
				_tmp10_ = (GtkStack*) gtk_stack_new ();
				g_object_ref_sink (_tmp10_);
				stack = _tmp10_;
				_tmp11_ = stack;
				gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
				_tmp12_ = stack;
				gtk_stack_set_homogeneous (_tmp12_, FALSE);
				_tmp13_ = stack;
				gtk_stack_set_vhomogeneous (_tmp13_, TRUE);
				_tmp14_ = stack;
				gtk_stack_set_transition_type (_tmp14_, GTK_STACK_TRANSITION_TYPE_NONE);
				_tmp15_ = (GtkLabel*) gtk_label_new ("");
				g_object_ref_sink (_tmp15_);
				label = _tmp15_;
				_tmp16_ = label;
				gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
				_tmp17_ = label;
				gtk_label_set_justify (_tmp17_, GTK_JUSTIFY_CENTER);
				_tmp18_ = label;
				gtk_widget_set_valign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
				_tmp19_ = stack;
				_tmp20_ = label;
				gtk_stack_add_named (_tmp19_, (GtkWidget*) _tmp20_, "label");
				_tmp21_ = (GtkEntry*) gtk_entry_new ();
				g_object_ref_sink (_tmp21_);
				entry = _tmp21_;
				_tmp22_ = entry;
				gtk_widget_set_visible ((GtkWidget*) _tmp22_, TRUE);
				_tmp23_ = entry;
				gtk_widget_set_size_request ((GtkWidget*) _tmp23_, 20, 20);
				_tmp24_ = entry;
				g_object_set ((GtkWidget*) _tmp24_, "expand", FALSE, NULL);
				_tmp25_ = stack;
				_tmp26_ = entry;
				gtk_stack_add_named (_tmp25_, (GtkWidget*) _tmp26_, "entry");
				_tmp27_ = stack;
				gtk_stack_set_visible_child_name (_tmp27_, "label");
				_tmp28_ = self->priv->grid;
				_tmp29_ = stack;
				gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 2, row, 1, 1);
				_g_object_unref0 (entry);
				_g_object_unref0 (label);
				_g_object_unref0 (stack);
			}
		}
	}
}

static void
__lambda10_ (GamesScoresDialog* self,
             GamesScoresCategory* x)
{
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = self->priv->combo;
	_tmp1_ = games_scores_category_get_key (x);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_scores_category_get_name (x);
	_tmp4_ = _tmp3_;
	gtk_combo_box_text_append (_tmp0_, _tmp2_, _tmp4_);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ ((GamesScoresDialog*) self, (GamesScoresCategory*) data);
}

static void
games_scores_dialog_load_categories (GamesScoresDialog* self)
{
	GamesScoresScore* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GList* categories = NULL;
	GamesScoresContext* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresCategory* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_high_score;
	if (_tmp0_ != NULL) {
		games_scores_dialog_load_scores (self);
	}
	_tmp1_ = self->priv->combo;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->context;
	_tmp3_ = games_scores_context_get_categories (_tmp2_);
	categories = _tmp3_;
	_tmp4_ = categories;
	g_list_foreach (_tmp4_, ___lambda10__gfunc, self);
	_tmp5_ = self->priv->scores_active_category;
	if (_tmp5_ == NULL) {
		GtkComboBoxText* _tmp6_;
		GList* _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->combo;
		_tmp7_ = categories;
		_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
		_tmp9_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp8_);
		_tmp10_ = _tmp9_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp6_, _tmp10_);
	} else {
		GtkComboBoxText* _tmp11_;
		GamesScoresCategory* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->combo;
		_tmp12_ = self->priv->scores_active_category;
		_tmp13_ = games_scores_category_get_key (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp11_, _tmp14_);
	}
	_tmp15_ = self->priv->active_category;
	if (_tmp15_ == NULL) {
		GList* _tmp16_;
		gconstpointer _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GList* _tmp20_;
		gconstpointer _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GamesScoresCategory* _tmp24_;
		_tmp16_ = categories;
		_tmp17_ = g_list_nth_data (_tmp16_, (guint) 0);
		_tmp18_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = categories;
		_tmp21_ = g_list_nth_data (_tmp20_, (guint) 0);
		_tmp22_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = games_scores_category_new (_tmp19_, _tmp23_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp24_;
	} else {
		GamesScoresCategory* _tmp25_;
		GList* _tmp26_;
		gconstpointer _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		GamesScoresCategory* _tmp30_;
		GList* _tmp31_;
		gconstpointer _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp25_ = self->priv->active_category;
		_tmp26_ = categories;
		_tmp27_ = g_list_nth_data (_tmp26_, (guint) 0);
		_tmp28_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp27_);
		_tmp29_ = _tmp28_;
		games_scores_category_set_key (_tmp25_, _tmp29_);
		_tmp30_ = self->priv->active_category;
		_tmp31_ = categories;
		_tmp32_ = g_list_nth_data (_tmp31_, (guint) 0);
		_tmp33_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp32_);
		_tmp34_ = _tmp33_;
		games_scores_category_set_name (_tmp30_, _tmp34_);
	}
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
}

static void
games_scores_dialog_load_scores (GamesScoresDialog* self)
{
	GamesScoresScore* _tmp0_;
	GeeList* best_n_scores = NULL;
	GamesScoresContext* _tmp14_;
	GamesScoresCategory* _tmp15_;
	GeeList* _tmp16_;
	gint row_count = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_high_score;
	if (_tmp0_ != NULL) {
		GamesScoresCategory* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GamesScoresCategory* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GamesScoresCategory* _tmp7_;
		_tmp1_ = self->priv->scores_active_category;
		_tmp2_ = games_scores_category_get_key (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->scores_active_category;
		_tmp5_ = games_scores_category_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = games_scores_category_new (_tmp3_, _tmp6_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp7_;
	} else {
		GtkComboBoxText* _tmp8_;
		const gchar* _tmp9_;
		GtkComboBoxText* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GamesScoresCategory* _tmp13_;
		_tmp8_ = self->priv->combo;
		_tmp9_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp8_);
		_tmp10_ = self->priv->combo;
		_tmp11_ = gtk_combo_box_text_get_active_text (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = games_scores_category_new (_tmp9_, _tmp12_);
		_g_object_unref0 (self->priv->active_category);
		self->priv->active_category = _tmp13_;
		_g_free0 (_tmp12_);
	}
	_tmp14_ = self->priv->context;
	_tmp15_ = self->priv->active_category;
	_tmp16_ = games_scores_context_get_high_scores (_tmp14_, _tmp15_, self->priv->rows_to_display);
	best_n_scores = _tmp16_;
	row_count = 1;
	{
		GeeList* _score_list = NULL;
		GeeList* _tmp17_;
		GeeList* _tmp18_;
		gint _score_size = 0;
		GeeList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _score_index = 0;
		_tmp17_ = best_n_scores;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_score_list = _tmp18_;
		_tmp19_ = _score_list;
		_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_score_size = _tmp21_;
		_score_index = -1;
		while (TRUE) {
			GamesScoresScore* score = NULL;
			GeeList* _tmp22_;
			gpointer _tmp23_;
			GamesScoresScore* _tmp24_;
			GeeList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_score_index = _score_index + 1;
			if (!(_score_index < _score_size)) {
				break;
			}
			_tmp22_ = _score_list;
			_tmp23_ = gee_list_get (_tmp22_, _score_index);
			score = (GamesScoresScore*) _tmp23_;
			_tmp24_ = score;
			_tmp25_ = best_n_scores;
			_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			games_scores_dialog_display_single_score (self, _tmp24_, row_count, (guint) _tmp27_);
			_tmp28_ = row_count;
			row_count = _tmp28_ + 1;
			_g_object_unref0 (score);
		}
		_g_object_unref0 (_score_list);
	}
	if (row_count < (self->priv->rows_to_display + 1)) {
		games_scores_dialog_make_remaining_labels_empty (self, row_count);
	}
	_g_object_unref0 (best_n_scores);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->score);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesScoresDialog* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->entry);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda9_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = self->priv->context;
	_tmp1_ = self->priv->active_category;
	_tmp2_ = _data5_->entry;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	games_scores_context_update_score_name (_tmp0_, _data4_->score, _tmp1_, _tmp3_);
	_tmp4_ = _data5_->entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	games_scores_score_set_user (_data4_->score, _tmp5_);
}

static void
____lambda9__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda9_ (self);
}

static void
games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                          GamesScoresScore* score,
                                          gint row_count,
                                          guint no_scores)
{
	Block4Data* _data4_;
	GamesScoresScore* _tmp0_;
	GtkLabel* rank_label = NULL;
	GtkGrid* _tmp1_;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* score_label = NULL;
	GtkGrid* _tmp7_;
	GtkWidget* _tmp8_;
	GtkLabel* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GamesScoresStyle _tmp11_;
	gboolean _tmp29_ = FALSE;
	GamesScoresScore* _tmp30_;
	GtkStack* name_stack = NULL;
	GtkGrid* _tmp46_;
	GtkWidget* _tmp47_;
	GtkStack* _tmp48_;
	GtkWidget* widget = NULL;
	GtkStack* _tmp49_;
	GtkWidget* _tmp50_;
	GtkWidget* _tmp51_;
	GtkStack* _tmp52_;
	const gchar* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (score != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (score);
	_g_object_unref0 (_data4_->score);
	_data4_->score = _tmp0_;
	_tmp1_ = self->priv->grid;
	_tmp2_ = gtk_grid_get_child_at (_tmp1_, 0, row_count);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_label_get_type (), GtkLabel));
	rank_label = _tmp3_;
	_tmp4_ = rank_label;
	_tmp5_ = g_strdup_printf ("%i", row_count);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->grid;
	_tmp8_ = gtk_grid_get_child_at (_tmp7_, 1, row_count);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_label_get_type (), GtkLabel));
	score_label = _tmp9_;
	_tmp11_ = self->priv->scores_style;
	if (_tmp11_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp10_ = TRUE;
	} else {
		GamesScoresStyle _tmp12_;
		_tmp12_ = self->priv->scores_style;
		_tmp10_ = _tmp12_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
	}
	if (_tmp10_) {
		GtkLabel* _tmp13_;
		glong _tmp14_;
		glong _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp13_ = score_label;
		_tmp14_ = games_scores_score_get_score (_data4_->score);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%li", _tmp15_);
		_tmp17_ = _tmp16_;
		gtk_label_set_text (_tmp13_, _tmp17_);
		_g_free0 (_tmp17_);
	} else {
		glong minutes = 0L;
		glong _tmp18_;
		glong _tmp19_;
		glong seconds = 0L;
		glong _tmp20_;
		glong _tmp21_;
		GtkLabel* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp18_ = games_scores_score_get_score (_data4_->score);
		_tmp19_ = _tmp18_;
		minutes = _tmp19_ / 60;
		_tmp20_ = games_scores_score_get_score (_data4_->score);
		_tmp21_ = _tmp20_;
		seconds = _tmp21_ % 60;
		_tmp22_ = score_label;
		_tmp23_ = g_strdup_printf (ngettext ("%ld minute", "%ld minutes", (gulong) minutes), minutes);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf (ngettext ("%ld second", "%ld seconds", (gulong) seconds), seconds);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup_printf ("%s %s", _tmp24_, _tmp26_);
		_tmp28_ = _tmp27_;
		gtk_label_set_text (_tmp22_, _tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
	}
	_tmp30_ = self->priv->new_high_score;
	if (_tmp30_ != NULL) {
		GamesScoresScore* _tmp31_;
		_tmp31_ = self->priv->new_high_score;
		_tmp29_ = games_scores_score_equals (_data4_->score, _tmp31_);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		Block5Data* _data5_;
		gboolean _tmp32_ = FALSE;
		GtkStack* temp_stack = NULL;
		GtkGrid* _tmp35_;
		GtkWidget* _tmp36_;
		GtkStack* _tmp37_;
		GtkStack* _tmp38_;
		GtkStack* _tmp39_;
		GtkWidget* _tmp40_;
		GtkEntry* _tmp41_;
		GtkEntry* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		GtkEntry* _tmp45_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		if (no_scores > ((guint) 1)) {
			_tmp32_ = row_count == 1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			GtkHeaderBar* _tmp33_;
			_tmp33_ = self->priv->headerbar;
			gtk_header_bar_set_subtitle (_tmp33_, _ ("Your score is the best!"));
		} else {
			GtkHeaderBar* _tmp34_;
			_tmp34_ = self->priv->headerbar;
			gtk_header_bar_set_subtitle (_tmp34_, _ ("Your score has made the top ten."));
		}
		_tmp35_ = self->priv->grid;
		_tmp36_ = gtk_grid_get_child_at (_tmp35_, 2, row_count);
		_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_stack_get_type (), GtkStack));
		temp_stack = _tmp37_;
		_tmp38_ = temp_stack;
		gtk_stack_set_visible_child_name (_tmp38_, "entry");
		_tmp39_ = temp_stack;
		_tmp40_ = gtk_stack_get_visible_child (_tmp39_);
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_entry_get_type (), GtkEntry));
		_data5_->entry = _tmp41_;
		_tmp42_ = _data5_->entry;
		_tmp43_ = games_scores_score_get_user (_data4_->score);
		_tmp44_ = _tmp43_;
		gtk_entry_set_text (_tmp42_, _tmp44_);
		_tmp45_ = _data5_->entry;
		g_signal_connect_data ((GObject*) _tmp45_, "notify::text", (GCallback) ____lambda9__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_g_object_unref0 (temp_stack);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_tmp46_ = self->priv->grid;
	_tmp47_ = gtk_grid_get_child_at (_tmp46_, 2, row_count);
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_stack_get_type (), GtkStack));
	name_stack = _tmp48_;
	_tmp49_ = name_stack;
	_tmp50_ = gtk_stack_get_visible_child (_tmp49_);
	_tmp51_ = _g_object_ref0 (_tmp50_);
	widget = _tmp51_;
	_tmp52_ = name_stack;
	_tmp53_ = gtk_stack_get_visible_child_name (_tmp52_);
	if (g_strcmp0 (_tmp53_, "label") == 0) {
		GtkLabel* user_label = NULL;
		GtkWidget* _tmp54_;
		GtkLabel* _tmp55_;
		GtkLabel* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp54_ = widget;
		_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_label_get_type (), GtkLabel));
		user_label = _tmp55_;
		_tmp56_ = user_label;
		_tmp57_ = games_scores_score_get_user (_data4_->score);
		_tmp58_ = _tmp57_;
		gtk_label_set_text (_tmp56_, _tmp58_);
		_g_object_unref0 (user_label);
	} else {
		GtkEntry* entry = NULL;
		GtkWidget* _tmp59_;
		GtkEntry* _tmp60_;
		GtkEntry* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		_tmp59_ = widget;
		_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_entry_get_type (), GtkEntry));
		entry = _tmp60_;
		_tmp61_ = entry;
		_tmp62_ = games_scores_score_get_user (_data4_->score);
		_tmp63_ = _tmp62_;
		gtk_entry_set_text (_tmp61_, _tmp63_);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (widget);
	_g_object_unref0 (name_stack);
	_g_object_unref0 (score_label);
	_g_object_unref0 (rank_label);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                 gint row_count)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = row_count;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStack* stack = NULL;
				GtkGrid* _tmp8_;
				GtkWidget* _tmp9_;
				GtkStack* _tmp10_;
				GtkLabel* label = NULL;
				GtkStack* _tmp11_;
				GtkWidget* _tmp12_;
				GtkLabel* _tmp13_;
				GtkLabel* _tmp14_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i <= self->priv->rows_to_display)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							GtkLabel* label = NULL;
							GtkGrid* _tmp4_;
							GtkWidget* _tmp5_;
							GtkLabel* _tmp6_;
							GtkLabel* _tmp7_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = j;
								j = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(j <= 1)) {
								break;
							}
							_tmp4_ = self->priv->grid;
							_tmp5_ = gtk_grid_get_child_at (_tmp4_, j, i);
							_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel));
							label = _tmp6_;
							_tmp7_ = label;
							gtk_label_set_text (_tmp7_, "");
							_g_object_unref0 (label);
						}
					}
				}
				_tmp8_ = self->priv->grid;
				_tmp9_ = gtk_grid_get_child_at (_tmp8_, 2, i);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_stack_get_type (), GtkStack));
				stack = _tmp10_;
				_tmp11_ = stack;
				_tmp12_ = gtk_stack_get_visible_child (_tmp11_);
				_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_label_get_type (), GtkLabel));
				label = _tmp13_;
				_tmp14_ = label;
				gtk_label_set_text (_tmp14_, "");
				_g_object_unref0 (label);
				_g_object_unref0 (stack);
			}
		}
	}
}

static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass,
                                gpointer klass_data)
{
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
}

static void
games_scores_dialog_instance_init (GamesScoresDialog * self,
                                   gpointer klass)
{
	self->priv = games_scores_dialog_get_instance_private (self);
	self->priv->active_category = NULL;
	self->priv->rows_to_display = 10;
	self->priv->combo = NULL;
	self->priv->category_label = NULL;
	self->priv->headerbar = NULL;
}

static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->active_category);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->category_label);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->new_high_score);
	_g_object_unref0 (self->priv->scores_active_category);
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
}

GType
games_scores_dialog_get_type (void)
{
	static volatile gsize games_scores_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
		GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
		g_once_init_leave (&games_scores_dialog_type_id__volatile, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__volatile;
}

