/*--------------------------------------------------------------------------+
$Id: SimulinkTestBase.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.testutils;

import java.io.FileNotFoundException;

import edu.tum.cs.commons.logging.SimpleLogger;
import edu.tum.cs.commons.test.CCSMTestCaseBase;
import edu.tum.cs.simulink.builder.SimulinkModelBuilder;
import edu.tum.cs.simulink.builder.SimulinkModelBuildingException;
import edu.tum.cs.simulink.model.SimulinkModel;
import edu.tum.cs.simulink.model.stateflow.IStateflowNodeContainer;
import edu.tum.cs.simulink.model.stateflow.StateflowNodeBase;

/**
 * Base class for Simulink tests.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 4554A70262645FD3C0B72DA2CE463A45
 */
public abstract class SimulinkTestBase extends CCSMTestCaseBase {

	/**
	 * Load Simulink model.
	 * 
	 * @param filename
	 *            bare filename
	 */
	protected SimulinkModel loadModel(String filename)
			throws FileNotFoundException, SimulinkModelBuildingException {
		SimulinkModelBuilder builder = new SimulinkModelBuilder(
				useTestFile(filename), new SimpleLogger());
		return builder.buildModel();
	}

	/**
	 * Get child node with specified id. This is O(# of children) running time.
	 */
	protected StateflowNodeBase getStateflowNode(String id,
			IStateflowNodeContainer<?> container) {
		for (StateflowNodeBase element : container.getNodes()) {
			if (element.getStateflowId().equals(id)) {
				return element;
			}
		}
		return null;
	}

}