      PROGRAM TEST
C
C     SAMPLE ADF TEST PROGRAM TO BUILD ADF FILES ILLUSTRATED
C     IN THE EXAMPLE DATABASE FIGURE
C
      PARAMETER (MAXCHR=32)
C
      CHARACTER*(MAXCHR) TSTLBL,DTYPE
      CHARACTER*(MAXCHR) FNAM,PATH
C
      REAL*8 RID,PID,CID,TMPID,RIDF2
      REAL A(4,3),B(4,3)
      INTEGER IC(6),ID(6)
      INTEGER IERR
      INTEGER IDIM(2),IDIMA(2),IDIMC,IDIMD
C
      DATA A /1.1,2.1,3.1,4.1,
     X        1.2,2.2,3.2,4.2,
     X        1.3,2.3,3.3,4.3/
      DATA IDIMA /4,3/
C
      DATA IC /1,2,3,4,5,6/
      DATA IDIMC /6/
C
C     SET ERROR FLAG TO ABORT ON ERROR
C
      CALL ADFSES(1,IERR)
C
C *** 1.) OPEN 1ST DATABASE (ADF_FILE_TWO.ADF)
C     2.) CREATE THREE NODES AT FIRST LEVEL
C     3.) PUT LABEL ON NODE F3
C     4.) PUT DATA IN F3
C     5.) CREATE TWO NODES BELOW F3
C     6.) CLOSE DATABASE
C
      CALL ADFDOPN('adf_file_two.adf','NEW',' ',RID,IERR)
      RIDF2 = RID
      CALL ADFCRE(RID,'F1',TMPID,IERR)
      CALL ADFCRE(RID,'F2',TMPID,IERR)
      CALL ADFCRE(RID,'F3',PID,IERR)
      CALL ADFSLB(PID,'LABEL ON NODE F3',IERR)
      CALL ADFPDIM(PID,'R4',2,IDIMA,IERR)
      CALL ADFWALL(PID,A,IERR)
C
      CALL ADFCRE(PID,'F4',CID,IERR)
C
      CALL ADFCRE(PID,'F5',CID,IERR)
C
      CALL ADFDCLO(RID,IERR)
C
C *** 1.) OPEN 2ND DATABASE
C     2.) CREATE NODES
C     3.) PUT DATA IN N13
C
      CALL ADFDOPN('adf_file_one.adf','NEW',' ',RID,IERR)
C
C     THREE NODES UNDER ROOT
C
      CALL ADFCRE(RID,'N1',TMPID,IERR)
      CALL ADFCRE(RID,'N2',TMPID,IERR)
      CALL ADFCRE(RID,'N3',TMPID,IERR)
C
C     THREE NODES UNDER N1 (TWO REGULAR AND ONE LINK)
C
      CALL ADFGNID(RID,'N1',PID,IERR)
      CALL ADFCRE(PID,'N4',TMPID,IERR)
      CALL ADFLINK(PID,'L3','adf_file_two.adf','/F3',TMPID,IERR)
      CALL ADFCRE(PID,'N5',TMPID,IERR)
C
C     TWO NODES UNDER N4
C
      CALL ADFGNID(PID,'N4',CID,IERR)
      CALL ADFCRE(CID,'N6',TMPID,IERR)
      CALL ADFCRE(CID,'N7',TMPID,IERR)
C
C     ONE NODE UNDER N6
C
      CALL ADFGNID(RID,'/N1/N4/N6',PID,IERR)
      CALL ADFCRE(PID,'N8',TMPID,IERR)
C
C     THREE NODES UNDER N3
C
      CALL ADFGNID(RID,'N3',PID,IERR)
      CALL ADFCRE(PID,'N9',TMPID,IERR)
      CALL ADFCRE(PID,'N10',TMPID,IERR)
      CALL ADFCRE(PID,'N11',TMPID,IERR)
C
C     TWO NODES UNDER N9
C
      CALL ADFGNID(PID,'N9',CID,IERR)
      CALL ADFCRE(CID,'N12',TMPID,IERR)
      CALL ADFCRE(CID,'N13',TMPID,IERR)
C
C     PUT LABEL AND DATA IN N13
C
      CALL ADFSLB(TMPID,'LABEL ON NODE N13',IERR)
      CALL ADFPDIM(TMPID,'I4',1,IDIMC,IERR)
      CALL ADFWALL(TMPID,IC,IERR)
C
C     TWO NODES UNDER N10
C
      CALL ADFGNID(RID,'/N3/N10',PID,IERR)
      CALL ADFLINK(PID,'L1',' ','/N3/N9/N13',TMPID,IERR)
      CALL ADFCRE(PID,'N14',TMPID,IERR)
C
C     TWO NODES UNDER N11
C
      CALL ADFGNID(RID,'/N3/N11',PID,IERR)
      CALL ADFLINK(PID,'L2',' ','/N3/N9/N13',TMPID,IERR)
      CALL ADFCRE(PID,'N15',TMPID,IERR)
C
C *** READ AND PRINT DATA FROM NODES
C     1.) NODE F5 THROUGH LINK L3
C
      CALL ADFGNID(RID,'/N1/L3',PID,IERR)
      CALL ADFGLB(PID,TSTLBL,IERR)
      CALL ADFGDT(PID,DTYPE,IERR)
      CALL ADFGND(PID,NUMDIM,IERR)
      CALL ADFGDV(PID,IDIM,IERR)
      CALL ADFRALL(PID,B,IERR)
      PRINT *,' NODE F3 THROUGH LINK L3:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA TYPE   = ',DTYPE
      PRINT *,'   NUM OF DIMS = ',NUMDIM
      PRINT *,'   DIM VALS    = ',IDIM
      PRINT *,'   DATA:'
      WRITE(*,100)((B(J,I),I=1,3),J=1,4)
  100 FORMAT(5X,3F10.2)
C
C     2.) N13
C
      CALL ADFGNID(RID,'N3/N9/N13',PID,IERR)
      CALL ADFGLB(PID,TSTLBL,IERR)
      CALL ADFGDT(PID,DTYPE,IERR)
      CALL ADFGND(PID,NUMDIM,IERR)
      CALL ADFGDV(PID,IDIMD,IERR)
      CALL ADFRALL(PID,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA TYPE   = ',DTYPE
      PRINT *,'   NUM OF DIMS = ',NUMDIM
      PRINT *,'   DIM VALS    = ',IDIMD
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
  200 FORMAT(5X,6I6)
C
C     3.) N13 THROUGH L1
C
      CALL ADFGNID(RID,'N3/N10/L1',TMPID,IERR)
      CALL ADFGLB(TMPID,TSTLBL,IERR)
      CALL ADFRALL(TMPID,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13 THROUGH LINK L1:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
C
C     4.) N13 THROUTH L2
C
      CALL ADFGNID(RID,'N3/N11/L2',CID,IERR)
      CALL ADFGLB(CID,TSTLBL,IERR)
      CALL ADFRALL(CID,ID,IERR)
      PRINT *,' '
      PRINT *,' NODE N13 THROUGH LINK L2:'
      PRINT *,'   LABEL       = ',TSTLBL
      PRINT *,'   DATA:'
      WRITE(*,200)(ID(I),I=1,6)
C
C     PRINT LIST OF CHILDREN UNDER ROOT NODE
C
      CALL PRTCLD(RID)
C
C     PRINT LIST OF CHILDREN UNDER N3
C
      CALL ADFGNID(RID,'N3',PID,IERR)
      CALL PRTCLD(PID)
C
C     REOPEN ADF_FILE_TWO AND GET NEW ROOT ID
C
      CALL ADFDOPN('adf_file_two.adf','OLD',' ',RID,IERR)
      PRINT *,' '
      PRINT *,' COMPARISON OF ROOT ID: '
      PRINT *,' ADF_FILE_TWO.ADF ORIGINAL ROOT ID = ',RIDF2
      PRINT *,' ADF_FILE_TWO.ADF NEW ROOT ID      = ',RID
C
      STOP
      END
C
C ************* SUBROUTINES ****************
C
      SUBROUTINE PRTCLD(PID)
C
C *** PRINT TABLE OF CHILDREN GIVEN A PARENT NODE-ID
C
      PARAMETER (MAXCLD=10)
      PARAMETER (MAXCHR=32)
      REAL*8 PID
      CHARACTER*(MAXCHR) NODNAM,NDNMS(MAXCLD)
      CALL ADFGNAM(PID,NODNAM,IERR)
      CALL ADFNCLD(PID,NUMC,IERR)
      WRITE(*,120)NODNAM,NUMC
  120 FORMAT(/,' PARENT NODE NAME = ',A,/,
     X       '     NUMBER OF CHILDREN = ',I2,/,
     X       '     CHILDREN NAMES:')
      NLEFT = NUMC
      ISTART = 1
C     --- TOP OF DO-WHILE LOOP
  130 CONTINUE
C        CALL ADFCNAM(PID,ISTART,MAXCLD,LEN(NDNMS),
C---------------- g77 doesn't like this ^
         CALL ADFCNAM(PID,ISTART,MAXCLD,MAXCHR,
     X                NUMRET,NDNMS,IERR)
         WRITE(*,140)(NDNMS(K),K=1,NUMRET)
  140    FORMAT(8X,A)
         NLEFT = NLEFT - MAXCLD
         ISTART = ISTART + MAXCLD
      IF (NLEFT .GT. 0) GO TO 130
      RETURN
      END

