/* appstream.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "As", gir_namespace = "Appstream", gir_version = "0.7", lower_case_cprefix = "as_")]
namespace Appstream {
	[CCode (cheader_filename = "appstream.h", type_id = "as_category_get_type ()")]
	public class Category : GLib.Object {
		[CCode (has_construct_function = false)]
		public Category ();
		public void add_subcategory (Appstream.Category cat);
		public void complete ();
		public static Appstream.Category @construct (GLib.Type object_type);
		public unowned string get_directory ();
		public unowned GLib.List<string> get_excluded ();
		public unowned string get_icon ();
		public unowned GLib.List<string> get_included ();
		public int get_level ();
		public unowned string get_name ();
		public unowned GLib.List<string> get_subcategories ();
		public unowned string get_summary ();
		public bool has_subcategory ();
		public void remove_subcategory (Appstream.Category cat);
		public void set_directory (string value);
		public void set_icon (string value);
		public void set_level (int value);
		public void set_name (string value);
		public string directory { get; set; }
		public void* excluded { get; }
		public string icon { get; set; }
		public void* included { get; }
		public int level { get; set; }
		public string name { get; set; }
		public void* subcategories { get; }
		public string summary { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_component_get_type ()")]
	public class Component : GLib.Object {
		[CCode (has_construct_function = false)]
		public Component ();
		public void add_extends (string cpt_id);
		public void add_language (string locale, int percentage);
		public void add_provided_item (Appstream.ProvidesKind kind, string value, string? data);
		public void add_release (Appstream.Release release);
		public void add_screenshot (Appstream.Screenshot sshot);
		public void add_url (Appstream.UrlKind url_kind, string url);
		public static Appstream.Component @construct (GLib.Type object_type);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_categories ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_compulsory_for_desktops ();
		public unowned string get_description ();
		public unowned string get_developer_name ();
		public unowned GLib.GenericArray<string> get_extends ();
		public unowned string get_icon ();
		public unowned string get_icon_url ();
		public unowned string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_keywords ();
		public Appstream.ComponentKind get_kind ();
		public int get_language (string locale);
		public GLib.List<weak string> get_languages ();
		public unowned string get_name ();
		public unowned string get_name_original ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_pkgnames ();
		public unowned string get_project_group ();
		public unowned string get_project_license ();
		public unowned GLib.GenericArray<string> get_provided_items ();
		public unowned GLib.GenericArray<Appstream.Release> get_releases ();
		public unowned GLib.GenericArray<Appstream.Screenshot> get_screenshots ();
		public unowned string get_summary ();
		public unowned string get_url (Appstream.UrlKind url_kind);
		public unowned GLib.HashTable<void*,void*> get_urls ();
		public bool has_category (string category);
		public bool is_compulsory_for_desktop (string desktop);
		public bool is_valid ();
		public bool provides_item (Appstream.ProvidesKind kind, string value);
		public void set_categories ([CCode (array_length = false, array_null_terminated = true)] string[] value);
		public void set_categories_from_str (string categories_str);
		public void set_compulsory_for_desktops (string value);
		public void set_description (string value);
		public void set_developer_name (string value);
		public void set_icon (string value);
		public void set_icon_url (string value);
		public void set_id (string value);
		public void set_keywords ([CCode (array_length = false, array_null_terminated = true)] string[] value);
		public void set_kind (Appstream.ComponentKind value);
		public void set_name (string value);
		public void set_name_original (string value);
		public void set_pkgnames ([CCode (array_length = false, array_null_terminated = true)] string[] value);
		public void set_project_group (string value);
		public void set_project_license (string value);
		public void set_summary (string value);
		public string to_string ();
		public string to_xml ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] categories { get; set; }
		public string description { get; set; }
		public string developer_name { get; set; }
		public string icon { get; set; }
		public string icon_url { get; set; }
		public string id { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] keywords { get; set; }
		public Appstream.ComponentKind kind { get; set; }
		public string name { get; set; }
		public string name_original { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] pkgnames { get; set; }
		public string project_group { get; set; }
		public string project_license { get; set; }
		public GLib.GenericArray<weak void*> screenshots { get; }
		public string summary { get; set; }
		public GLib.HashTable<weak void*,weak void*> urls { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_data_pool_get_type ()")]
	public class DataPool : GLib.Object {
		[CCode (has_construct_function = false)]
		public DataPool ();
		public GLib.List<weak Appstream.Component> get_components ();
		public unowned string get_locale ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_watched_locations ();
		public void initialize ();
		public void set_data_source_directories ([CCode (array_length = false, array_null_terminated = true)] string[] dirs);
		public void set_locale (string locale);
		public bool update ();
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_database_get_type ()")]
	public class Database : GLib.Object {
		[CCode (has_construct_function = false)]
		public Database ();
		public static Appstream.Database @construct (GLib.Type object_type);
		public bool db_exists ();
		public GLib.GenericArray<Appstream.Component> find_components (Appstream.SearchQuery query);
		public GLib.GenericArray<Appstream.Component> find_components_by_term (string search_term, string? categories_str);
		public GLib.GenericArray<Appstream.Component> get_all_components ();
		public Appstream.Component get_component_by_id (string idname);
		public GLib.GenericArray<Appstream.Component> get_components_by_kind (Appstream.ComponentKind kinds);
		public GLib.GenericArray<Appstream.Component> get_components_by_provides (Appstream.ProvidesKind kind, string value, string data);
		public unowned string get_database_path ();
		public virtual bool open ();
		public void set_database_path (string value);
		public string database_path { get; set; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_distro_details_get_type ()")]
	public class DistroDetails : GLib.Object {
		[CCode (has_construct_function = false)]
		public DistroDetails ();
		public bool config_distro_get_bool (string key);
		public string config_distro_get_str (string key);
		public static Appstream.DistroDetails @construct (GLib.Type object_type);
		public unowned string get_distro_id ();
		public unowned string get_distro_name ();
		public unowned string get_distro_version ();
		[CCode (array_length = false, array_null_terminated = true)]
		public static string[] get_icon_repository_paths ();
		public string distro_id { get; }
		public string distro_name { get; }
		public string distro_version { get; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_image_get_type ()")]
	public class Image : GLib.Object {
		[CCode (has_construct_function = false)]
		public Image ();
		public uint get_height ();
		public Appstream.ImageKind get_kind ();
		public unowned string get_url ();
		public uint get_width ();
		public static Appstream.ImageKind kind_from_string (string kind);
		public static unowned string kind_to_string (Appstream.ImageKind kind);
		public void set_height (uint height);
		public void set_kind (Appstream.ImageKind kind);
		public void set_url (string url);
		public void set_width (uint width);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_menu_parser_get_type ()")]
	public class MenuParser : GLib.Object {
		[CCode (has_construct_function = false)]
		public MenuParser ();
		public static Appstream.MenuParser @construct (GLib.Type object_type);
		public static Appstream.MenuParser construct_from_file (GLib.Type object_type, string menu_file);
		[CCode (has_construct_function = false)]
		public MenuParser.from_file (string menu_file);
		public bool get_update_category_data ();
		public GLib.List<Appstream.Category> parse ();
		public void set_update_category_data (bool value);
		public bool update_category_data { get; set; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_metadata_get_type ()")]
	public class Metadata : GLib.Object {
		[CCode (has_construct_function = false)]
		public Metadata ();
		public static GLib.Quark error_quark ();
		public unowned string get_locale ();
		public Appstream.Component parse_data (string data) throws GLib.Error;
		public Appstream.Component parse_file (GLib.File infile) throws GLib.Error;
		public void set_locale (string locale);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_release_get_type ()")]
	public class Release : GLib.Object {
		[CCode (has_construct_function = false)]
		public Release ();
		public unowned string get_description ();
		public uint64 get_timestamp ();
		public unowned string get_version ();
		public void set_description (string description);
		public void set_timestamp (uint64 timestamp);
		public void set_version (string version);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_screenshot_get_type ()")]
	public class Screenshot : GLib.Object {
		[CCode (has_construct_function = false)]
		public Screenshot ();
		public void add_image (Appstream.Image image);
		public unowned string get_caption ();
		public unowned GLib.GenericArray<Appstream.Image> get_images ();
		public Appstream.ScreenshotKind get_kind ();
		public bool is_valid ();
		public static Appstream.ScreenshotKind kind_from_string (string kind);
		public static unowned string kind_to_string (Appstream.ScreenshotKind kind);
		public void set_caption (string caption);
		public void set_kind (Appstream.ScreenshotKind kind);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_search_query_get_type ()")]
	public class SearchQuery : GLib.Object {
		[CCode (has_construct_function = false)]
		public SearchQuery (string term);
		public static Appstream.SearchQuery @construct (GLib.Type object_type, string term);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_categories ();
		public bool get_search_all_categories ();
		public unowned string get_search_term ();
		public void sanitize_search_term ();
		public void set_categories (string value);
		public void set_categories_from_string (string categories_str);
		public void set_search_all_categories ();
		public void set_search_term (string value);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] categories { owned get; set; }
		public string search_term { get; set; }
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_validator_get_type ()")]
	public class Validator : GLib.Object {
		[CCode (has_construct_function = false)]
		public Validator ();
		public void clear_issues ();
		public GLib.List<weak Appstream.ValidatorIssue> get_issues ();
		public bool validate_data (string metadata);
		public bool validate_file (GLib.File metadata_file);
	}
	[CCode (cheader_filename = "appstream.h", type_id = "as_validator_issue_get_type ()")]
	public class ValidatorIssue : GLib.Object {
		[CCode (has_construct_function = false)]
		public ValidatorIssue ();
		public Appstream.IssueImportance get_importance ();
		public Appstream.IssueKind get_kind ();
		public unowned string get_message ();
		public void set_importance (Appstream.IssueImportance importance);
		public void set_kind (Appstream.IssueKind kind);
		public void set_message (string message);
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_COMPONENT_KIND_", type_id = "as_component_kind_get_type ()")]
	public enum ComponentKind {
		UNKNOWN,
		GENERIC,
		[CCode (cname = "AS_COMPONENT_KIND_DESKTOP_APP")]
		DESKTOP,
		FONT,
		CODEC,
		INPUTMETHOD,
		LAST;
		public static Appstream.ComponentKind from_string (string kind_str);
		public static unowned string to_string (Appstream.ComponentKind kind);
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_IMAGE_KIND_", has_type_id = false)]
	public enum ImageKind {
		UNKNOWN,
		SOURCE,
		THUMBNAIL,
		LAST
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ISSUE_IMPORTANCE_", has_type_id = false)]
	public enum IssueImportance {
		UNKNOWN,
		ERROR,
		WARNING,
		INFO,
		PEDANTIC
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_ISSUE_KIND_", has_type_id = false)]
	public enum IssueKind {
		UNKNOWN,
		MARKUP_INVALID,
		LEGACY,
		TAG_DUPLICATED,
		TAG_MISSING,
		TAG_UNKNOWN,
		TAG_NOT_ALLOWED,
		PROPERTY_MISSING,
		PROPERTY_INVALID,
		VALUE_WRONG,
		VALUE_ISSUE
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_METADATA_ERROR_", has_type_id = false)]
	public enum MetadataError {
		FAILED,
		LAST
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_PROVIDES_KIND_", has_type_id = false)]
	public enum ProvidesKind {
		UNKNOWN,
		LIBRARY,
		BINARY,
		FONT,
		MODALIAS,
		FIRMWARE,
		PYTHON2,
		PYTHON3,
		MIMETYPE,
		DBUS;
		public static Appstream.ProvidesKind from_string (string kind_str);
		public static unowned string to_string (Appstream.ProvidesKind kind);
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_SCREENSHOT_KIND_", has_type_id = false)]
	public enum ScreenshotKind {
		UNKNOWN,
		NORMAL,
		DEFAULT
	}
	[CCode (cheader_filename = "appstream.h", cprefix = "AS_URL_KIND_", has_type_id = false)]
	public enum UrlKind {
		UNKNOWN,
		HOMEPAGE,
		BUGTRACKER,
		FAQ,
		HELP,
		DONATION,
		LAST;
		public static Appstream.UrlKind from_string (string url_kind);
		public static unowned string to_string (Appstream.UrlKind url_kind);
	}
	[CCode (cheader_filename = "appstream.h")]
	public static string description_markup_convert_simple (string markup);
	[CCode (cheader_filename = "appstream.h")]
	public static GLib.List<Appstream.Category> get_system_categories ();
	[CCode (cheader_filename = "appstream.h")]
	public static string provides_item_create (Appstream.ProvidesKind kind, string value, string data);
	[CCode (cheader_filename = "appstream.h")]
	public static Appstream.ProvidesKind provides_item_get_kind (string item);
	[CCode (cheader_filename = "appstream.h")]
	public static string provides_item_get_value (string item);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "appstream.h")]
	public static string[] ptr_array_to_strv (GLib.GenericArray<string> array);
	[CCode (cheader_filename = "appstream.h")]
	public static bool str_empty (string str);
}
