/**
 * SECTION:ipk-control
 * @short_description: Generic IPK package control data
 */
/**
 * LISTALLER_IPK_TYPE_CONTROL:
 * 
 * The type for <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link>.
 */
/**
 * listaller_ipk_control_load_appstream_data:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @data: &nbsp;
 */
/**
 * listaller_ipk_control_open_packsetting:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @pksFName: &nbsp;
 */
/**
 * listaller_ipk_control_get_ipk_version:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 */
/**
 * listaller_ipk_control_set_ipk_version:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @ipkV: &nbsp;
 */
/**
 * listaller_ipk_control_get_architectures:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * 
 * Get architectures supported by this package
 */
/**
 * listaller_ipk_control_set_architectures:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @archs: &nbsp;
 * 
 * Set architectures supported by this package
 */
/**
 * listaller_ipk_control_get_replaces:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * 
 * Get replaced native components for the package.
 * 
 * <para>DEPRECATED</para>
 */
/**
 * listaller_ipk_control_set_replaces:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @repList: &nbsp;
 * 
 * DEPRECATED
 */
/**
 * listaller_ipk_control_set_install_modes:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @modes: &nbsp;
 */
/**
 * listaller_ipk_control_get_install_modes:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 */
/**
 * listaller_ipk_control_get_application:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @error: (error-domains ListallerIPKControlDataError): location to store the error occuring, or %NULL to ignore
 */
/**
 * listaller_ipk_control_set_dependencies:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @dependencies_list: &nbsp;
 * @arch: &nbsp;
 */
/**
 * listaller_ipk_control_get_dependencies:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @arch: &nbsp;
 * @arch_only: &nbsp;
 */
/**
 * listaller_ipk_control_set_license_text_from_file:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @fname: &nbsp;
 */
/**
 * listaller_ipk_control_set_license_text:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance
 * @txt: &nbsp;
 */
/**
 * ListallerIPKControl:user-accept-license:
 * 
 * TRUE if user should manually accept the supplied license/eula. FALSE if there is no need to do this.
 */
/**
 * listaller_ipk_control_get_user_accept_license:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerIPKControl--user-accept-license"><type>"user-accept-license"</type></link> property.
 * 
 * TRUE if user should manually accept the supplied license/eula. FALSE if there is no need to do this.
 * 
 * Returns: the value of the <link linkend="ListallerIPKControl--user-accept-license"><type>"user-accept-license"</type></link> property
 */
/**
 * listaller_ipk_control_set_user_accept_license:
 * @self: the <link linkend="ListallerIPKControl"><type>ListallerIPKControl</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerIPKControl--user-accept-license"><type>"user-accept-license"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerIPKControl--user-accept-license"><type>"user-accept-license"</type></link> property to @value.
 * 
 * TRUE if user should manually accept the supplied license/eula. FALSE if there is no need to do this.
 */
/**
 * ListallerIPKControl:
 * 
 * Generic IPK package control data
 */
/**
 * ListallerIPKControlClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-IPK-TYPE-CONTROL:CAPS"><literal>LISTALLER_IPK_TYPE_CONTROL</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * LISTALLER_IPK_TYPE_PACK_CONTROL:
 * 
 * The type for <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link>.
 */
/**
 * listaller_ipk_pack_control_open_control:
 * @self: the <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link> instance
 * @fPackSetting: &nbsp;
 * @fAppStream: &nbsp;
 */
/**
 * listaller_ipk_pack_control_create_new:
 * @self: the <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link> instance
 * @newAppStreamData: &nbsp;
 * @ipkV: &nbsp;
 */
/**
 * listaller_ipk_pack_control_is_delta_pkg:
 * @self: the <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link> instance
 */
/**
 * listaller_ipk_pack_control_save_to_dir:
 * @self: the <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link> instance
 * @dirPath: &nbsp;
 */
/**
 * listaller_ipk_pack_control_get_files:
 * @self: the <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link> instance
 * 
 * Returns: (array length=result_length1): 
 */
/**
 * listaller_ipk_pack_control_update_installmode_data:
 * @self: the <link linkend="ListallerIPKPackControl"><type>ListallerIPKPackControl</type></link> instance
 */
/**
 * listaller_ipk_pack_control_new:
 */
/**
 * ListallerIPKPackControl:
 * 
 * Control metadata of an IPK package
 */
/**
 * ListallerIPKPackControlClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-IPK-TYPE-PACK-CONTROL:CAPS"><literal>LISTALLER_IPK_TYPE_PACK_CONTROL</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * LISTALLER_IPK_TYPE_CONTROL_DIR:
 * 
 * The type for <link linkend="ListallerIPKControlDir"><type>ListallerIPKControlDir</type></link>.
 */
/**
 * listaller_ipk_control_dir_open_dir:
 * @self: the <link linkend="ListallerIPKControlDir"><type>ListallerIPKControlDir</type></link> instance
 * @dir: &nbsp;
 * @error: (error-domains ListallerIPKControlDataError): location to store the error occuring, or %NULL to ignore
 */
/**
 * listaller_ipk_control_dir_get_files_rootdir:
 * @self: the <link linkend="ListallerIPKControlDir"><type>ListallerIPKControlDir</type></link> instance
 */
/**
 * listaller_ipk_control_dir_auto_dependency_search:
 * @self: the <link linkend="ListallerIPKControlDir"><type>ListallerIPKControlDir</type></link> instance
 */
/**
 * listaller_ipk_control_dir_get_appstream_data:
 * @self: the <link linkend="ListallerIPKControlDir"><type>ListallerIPKControlDir</type></link> instance
 */
/**
 * listaller_ipk_control_dir_save_control:
 * @self: the <link linkend="ListallerIPKControlDir"><type>ListallerIPKControlDir</type></link> instance
 */
/**
 * listaller_ipk_control_dir_new:
 */
/**
 * ListallerIPKControlDir:
 * 
 * Data stored in an IPK-source control directory.
 * 
 * <para>This class is used by tools like lipkgen to extract data about a to-be-created IPK package from an IPK control directory.</para>
 */
/**
 * ListallerIPKControlDirClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-IPK-TYPE-CONTROL-DIR:CAPS"><literal>LISTALLER_IPK_TYPE_CONTROL_DIR</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * ListallerIPKControlDataError:
 */
