#!/usr/bin/perl

if($#ARGV != 1) {
    print "usage: line6_find_device.pl <mode> <name>\n";
    exit(1);
}

$mode = @ARGV[0];
$name = @ARGV[1];

if($mode eq "card") {
    open(cards, "/proc/asound/cards");

    while(<cards>) {
	if(/^\s*(\d+)\s*\[Line6USB/) {
	    $card = $1;
	    $_ = <cards>;

	    if(/$name/) {
		print "$card\n";
		exit;
	    }
	}
    }
}
elsif($mode eq "sysdir") {
    $SYSROOT="/sys/bus/usb/devices";
    open(dev, "ls $SYSROOT |");

    while(<dev>) {
	chop;
	next if /:/;
	$sysdir = "$SYSROOT/$_";
	open(sys, "$sysdir/idVendor");
	$idVendor = <sys>;
	close(sys);
	chop($idVendor);
	next if $idVendor ne "0e41";

	open(sys, "$sysdir/product");
	$product = <sys>;
	close(sys);
	chop($product);

	if($product =~ /$name/) {
	    print $sysdir.":1.0\n";
	    exit;
	}
    }
}
else {
    print "unknown mode \"$mode\"\n";
    exit(1);
}
