.\" @(#)$RCSfile: Cns_closedir.man,v $ $Revision$ $Date$ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2010 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_CLOSEDIR 3 "$Date$" CASTOR "Cns Library Functions"
.SH NAME
Cns_closedir \- close CASTOR directory opened by
.B Cns_opendir
in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "int Cns_closedir (Cns_DIR *" dirp )
.SH DESCRIPTION
.B Cns_closedir
closes the CASTOR directory opened by
.B Cns_opendir
in the name server and frees the
.B Cns_DIR
structure pointed by
.IR dirp .
.TP
.I dirp
specifies the pointer value returned by
.BR Cns_opendir .
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
File descriptor in DIR structure is invalid.
.TP 
.B EFAULT
.I dirp
is a NULL pointer.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Cns_opendir(3) ,
.BR Cns_readdir(3) ,
.BR Cns_rewinddir(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
