/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#include "mainwindow.h"
#include "dlgconnhidwifi.h"
#include <QTranslator>
#include <QLocale>
#include <QApplication>
#include <QDebug>

#include "ksimplenm.h"
#include "kylin-network-interface.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QIcon::setThemeName("ukui-icon-theme");

    // 国际化
    QString locale = QLocale::system().name();
    QTranslator trans_global;
    if(locale == "zh_CN"){
        trans_global.load(":/res/kylin-nm_zh_CN.qm");
        a.installTranslator(&trans_global);
    }

    MainWindow w;
    return a.exec();
}
