/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "addressbook_filtermodel.h"
#include "connection.h"

#include "addressbook_listingmodel.h"

void AddressBookListingModel::doQuery( const QString &userFilter )
{
  QString filter = QString( "(&(objectClass=inetOrgPerson)%1(!(uid=*))(sn=*))" ).arg( userFilter );

  mData = Connection::self()->search( "", QLdap::Sub, filter, QStringList(), QLatin1String( "givenName" ) );

  emit layoutChanged();
}

int AddressBookListingModel::columnCount( const QModelIndex &parent ) const
{
  if ( parent.isValid() )
    return 0;

  return 1;
}

int AddressBookListingModel::rowCount( const QModelIndex &parent ) const
{
  if ( parent.isValid() )
    return 0;

  return mData.entries().count();
}

QVariant AddressBookListingModel::data( const QModelIndex &index, int role ) const
{
  if ( !index.isValid() )
    return QVariant();

  const QLdapEntry entry = mData.entries()[ index.row() ];

  if ( role == Qt::DisplayRole ) {
    switch ( index.column() ) {
      case 0:
        return QString( "%1 %2" ).arg( entry.value( "givenName" ), entry.value( "sn" ) );
        break;
      default:
        return QVariant();
    }
  } else if ( role == HasModifyActionRole ) {
    return true;
  } else if ( role == HasDeleteActionRole ) {
    return true;
  } else if ( role == ModifyActionLabelRole ) {
    return tr( "Modify" );
  } else if ( role == DeleteActionLabelRole ) {
    return tr( "Delete" );
  } else if ( role == ModifyActionIdRole ) {
    return mData.entries()[ index.row() ].dn();
  } else if ( role == DeleteActionIdRole ) {
    return mData.entries()[ index.row() ].dn();
  }

  return QVariant();
}

QVariant AddressBookListingModel::headerData( int section, Qt::Orientation, int role ) const
{
  if ( role != Qt::DisplayRole )
    return QVariant();

  switch ( section ) {
    case 0:
      return tr( "Name" );
      break;
    default:
      return QVariant();
  }
}

FilterModel* AddressBookListingModel::filterModel()
{
  return new AddressBookFilterModel( this );
}
