/*
 *  Copyright (c) 2002-2003, The Joust Project
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  - Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  - Neither the name of the Joust Project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *
 *  File created by keith @ Feb 17, 2003
 *
 */

package net.kano.joscar.snac;

import net.kano.joscar.DefensiveTools;

/**
 * An event fired when a SNAC packet is received in response to an outgoing SNAC
 * request.
 */
public class SnacResponseEvent extends SnacPacketEvent {
    /**
     * The request to which this event is a response.
     */
    private final SnacRequest request;

    /**
     * Creates a new <code>SnacResponseEvent</code> with the given properties,
     * a copy of the given event plus the given request.
     *
     * @param other a <code>SnacPacketEvent</code> to copy
     * @param request the request to which the given
     *        <code>SnacPacketEvent</code> is a response
     */
    protected SnacResponseEvent(SnacPacketEvent other, SnacRequest request) {
        super(other);

        DefensiveTools.checkNull(request, "request");

        this.request = request;
    }

    /**
     * The SNAC request to which the associated packet is in response.
     *
     * @return the SNAC request to which the associated packet responds
     */
    public final SnacRequest getRequest() { return request; }

    public String toString() {
        return "SnacResponseEvent: "
                + "request=" + request + " - " + super.toString();
    }
}