# Translating It's All Text!

Hello and thanks for considering adding a translation to *It's All Text!*

Below are several ways to go about updating or creating a new translation.  Use the one you're the most comfortable with.

You can view all of the available locales in [`src/chrome/locale`](https://github.com/docwhat/itsalltext/tree/master/src/chrome/locale).

Because I am only fluent in English, the `en-US` is the "authorative" locale.  I keep it up-to-date with the code.

## Updating a translation

If a locale has English in it still, then you can contribute to *It's All Text!* by forking and submitting pull requests.

Github has excellent instructions for this:

* [Forking a repository](https://help.github.com/articles/fork-a-repo)
* [Submitting a Pull Request](https://help.github.com/articles/using-pull-requests)

### Github's editor

Once you've forked `itsalltext` then you can go in the `src/chrome/locale` directory.  Find the directory matching the language
you're willing to update.  Once there, you can edit files by clicking on them and then clicking "Edit".

Github has some help for this:

* [Creating and editing files in your repository](https://help.github.com/articles/creating-and-editing-files-in-your-repository)

Once you're done, submit a Pull Request.  I'll double check everything and then the next version of *It's All Text!* will your
translations!

### Git

If you're comfortable with `git`, then you should know how this goes.  If you're new to `git` but still want to use it, then I suggest reading
github's guides at [help.github.com](https://help.github.com/).

## Testing a translation

There are several ways to do this.

### Use rake

If you have `ruby` installed and you're comfortable with it you can just do:

1. `bundle install`
2. `rake build`

If you have a Mac, you can just use `rake install` to install the `.xpi`.

If you are not on a Mac, you can just install the `.xpi` by hand.

### Tell firefox to use your checked out version.

Find your Firefox profile directory (e.g. `~/.mozilla/firefox/Profiles/`) and inside the profile you're currently using there should be an extensions folder.

In the extensions folder, create a file named `itsalltext@docwhat.gerf.org`.  The contents should be the path to `src` directory.

For example, on my system the contens of this file is:

    /Users/docwhat/Projects/itsalltext/src

You have to restart firefox to have the changes take effect.

### Replace the unpacked copy of itsalltext@docwhat.gerf.org with your translations.

As above, find your profile directory.  If you have *It's All Text!* already
installed there should be a directory called `itsalltext@docwhat.gerf.org`.
The contents of this folder are laid out just like the `src` directory.

Just copy your translations in there and restart Firefox.

## A Completely new translation

If you're a `git` user, just copy the `en-US` locale and use it for your
starting point.  Remind me it is a new locale so I remember to add it to the
`install.rdf` (or you can add it yourself and save me from making a mistake).

If you aren't comfortable with `git` then I can mail you a copy of the `en-US`
locale and you can email me the resulting translation!

To contact me, just use [my mail form](https://docwhat.org/email/).

## File format information

### DTD files

The `.dtd` files are [Document Type Definition](https://developer.mozilla.org/en-US/docs/XUL/Tutorial/Localization#DTD_Files) files.

They should be UTF-8 files.  Each line looks like so:

    <!ENTITY magic.key.word "The translated text">

The way it works in that in the parts of display that are
[XUL](https://developer.mozilla.org/en-US/docs/XUL) (the preferences, dialogs,
etc.) I can use the `magic.key.word` to pull in the translated text.

For the string in the double quotes use UTF-8 unescaped characters.

The only HTML/XML escaping that can be used are:

    &quote; &amp; &apos; &lt; &gt;

### Properties files

The `.properties` files are [XUL Properties](https://developer.mozilla.org/en-US/docs/XUL/Tutorial/Property_Files) files.

These translations are used from JavaScript and contain placeholders (e.g.
`%1$S`) that will be replaced with strings later.

The format is pretty simple:

    keyword=The translation string that will be used.

The translation string should be straight UTF-8.  There are some old
translations that still contain XML-style escapes (such as `&oacute;`) -- They
were translations done for pre-2.0 Firefox and should be replaced with UTF-8.

## Additional Notes

Don't worry about translating the GPL license.  For legal reasons it cannot be
translated.  See [GNU's page on translations](http://www.gnu.org/licenses/translations.html).
