/*=========================================================================
 *
 *  Copyright Insight Software Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/
#if defined( _MSC_VER )
#pragma warning ( disable : 4786 )
#endif

#include "itkVideoIOBase.h"

namespace itk
{

VideoIOBase::VideoIOBase() :
  m_ReadType(ReadFromFile),
  m_FramesPerSecond(0.0),
  m_FrameTotal(NumericTraits<SizeValueType>::Zero),
  m_CurrentFrame(NumericTraits<SizeValueType>::Zero),
  m_IFrameInterval(NumericTraits<SizeValueType>::Zero),
  m_LastIFrame(NumericTraits<SizeValueType>::Zero),
  m_Ratio(0.0),
  m_PositionInMSec(0.0),
  m_WriterOpen(false),
  m_ReaderOpen(false)
{
}

VideoIOBase::~VideoIOBase()
{
}

void VideoIOBase::PrintSelf(std::ostream & os, Indent indent) const
{
  Superclass::PrintSelf(os,indent);
}

} //namespace itk end
