/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iviewobjectfamily.h"


#include "idata.h"
#include "iviewobject.h"


#include "iarraytemplate.h"
#include "iviewfamilytemplate.h"


//
//  Helper intermediate class
//
iViewObjectParent::iViewObjectParent(iViewModule *vm, const iObjectType &ot, const iDataType &dt) : mViewModule(vm), mDataType(dt), mObjectType(ot)
{
	IERROR_ASSERT(vm);
}


//
//  Main class
//
iViewObjectFamily* iViewObjectFamily::New(iViewModule *vm, const iObjectType &ot, bool singleInstance)
{
	return new iViewObjectFamily(new iViewObjectParent(vm,ot,iDataType::Null()),singleInstance);
}


iViewObjectFamily* iViewObjectFamily::New(iViewModule *vm, const iObjectType &ot, bool singleInstance, const iDataType &dt)
{
	return new iViewObjectFamily(new iViewObjectParent(vm,ot,dt),singleInstance);
}


iViewObjectFamily::iViewObjectFamily(iViewObjectParent *parent, bool singleInstance) : iViewFamily<iViewObject,iViewObjectParent>(parent), mIsSingleInstance(singleInstance)
{
}


iViewObjectFamily::~iViewObjectFamily()
{
}


iViewObjectParent* iViewObjectFamily::GetParent() const
{
	return mParent;
}


int iViewObjectFamily::CreateMember()
{
	if(mIsSingleInstance) return -1; else return this->iViewFamily<iViewObject,iViewObjectParent>::CreateMember();
}


bool iViewObjectFamily::DeleteMember(int i)
{
	if(mIsSingleInstance) return false; else return this->iViewFamily<iViewObject,iViewObjectParent>::DeleteMember(i);
}

