---
title: Hugo Features
linktitle: Hugo Features
description: Hugo boasts blistering speed, robust content management, and a powerful templating language making it a great fit for all kinds of static websites.
date: 2017-02-01
publishdate: 2017-02-01
lastmod: 2017-02-01
menu:
  docs:
    parent: "about"
    weight: 20
weight: 20
sections_weight: 20
draft: false
toc: true
---

## General

* [Extremely fast][] build times (&lt; 1 ms per page)
* Completely cross platform, with [easy installation][install] on macOS, Linux, Windows, and more
* Renders changes on the fly with [LiveReload][] as you develop
* [Powerful theming][]
* [Host your site anywhere][hostanywhere]

## Organization

* Straightforward [organization for your projects][], including website sections
* Customizable [URLs][]
* Support for configurable [taxonomies][], including categories and tags
* [Sort content][] as you desire through powerful template [functions][]
* Automatic [table of contents][] generation
* [Dynamic menu][] creation
* [Pretty URLs][] support
* [Permalink][] pattern support
* Redirects via [aliases][]

## Content

* Native Markdown and Emacs Org-Mode support, as well as other languages via *external helpers* (see [supported formats][])
* TOML, YAML, and JSON metadata support in [front matter][]
* Customizable [homepage][]
* Multiple [content types][]
* Automatic and user defined [content summaries][]
* [Shortcodes][] to enable rich content inside of Markdown
* ["Minutes to Read"][pagevars] functionality
* ["Wordcount"][pagevars] functionality

## Additional Features

* Integrated [Disqus][] comment support
* Integrated [Google Analytics][] support
* Automatic [RSS][] creation
* Support for [Go][], [Amber], and [Ace][] HTML templates
* [Syntax highlighting][] powered by [Chroma][] (partly compatible with Pygments)


[Ace]: /templates/alternatives/
[aliases]: /content-management/urls/#aliases
[Amber]: https://github.com/eknkc/amber
[Chroma]: https://github.com/alecthomas/chroma
[content summaries]: /content-management/summaries/
[content types]: /content-management/types/
[Disqus]: https://disqus.com/
[Dynamic menu]: /templates/menus/
[Extremely fast]: https://github.com/bep/hugo-benchmark
[front matter]: /content-management/front-matter/
[functions]: /functions/
[Go]: https://golang.org/pkg/html/template/
[Google Analytics]: https://google-analytics.com/
[homepage]: /templates/homepage/
[hostanywhere]: /hosting-and-deployment/
[install]: /getting-started/installing/
[LiveReload]: /getting-started/usage/
[organization for your projects]: /getting-started/directory-structure/
[pagevars]: /variables/page/
[Permalink]: /content-management/urls/#permalinks
[Powerful theming]: /themes/
[Pretty URLs]: /content-management/urls/
[RSS]: /templates/rss/
[Shortcodes]: /content-management/shortcodes/
[sort content]: /templates/
[supported formats]: /content-management/formats/
[Syntax highlighting]: /tools/syntax-highlighting/
[table of contents]: /content-management/toc/
[taxonomies]: /content-management/taxonomies/
[URLs]: /content-management/urls/
