#include "pvVector.h"
#include "osl/state/numEffectState.h"
#include "osl/eval/pieceEval.h"
#include <boost/foreach.hpp>
#include <iostream>

int gpsshogi::PVVector::pieceValue() const
{
  static const osl::NumEffectState dummy;
  int sum = 0;
  BOOST_FOREACH(osl::Move move, *this)
    if (move.isNormal())
      sum += osl::PieceEval::diffWithMove(dummy, move);
  return sum;
}

int gpsshogi::PVVector::pieceValueOfTurn() const
{
  if (empty())
    return 0;
  return pieceValue() * playerToMul(front().player());
}

std::ostream& gpsshogi::operator<<(std::ostream& os, const PVVector& moves)
{
  os<< "PVVector" << std::endl;
  BOOST_FOREACH(osl::Move m, moves) {
    os << m << std::endl;
  }
  return os<<std::endl;
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
