%{
/*
 * Copyright (c) 2010 Mark Liversedge (liversedge@gmail.com)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "DataFilter.h"

// need to get rid of this and use a string...
#include <stdio.h>

// tokens
#include "DataFilter_yacc.h"/* generated by the scanner */

%}
%option noyywrap
%option nounput
%option noinput
%option 8bit
%%

"="                                         DataFilterlval.op = EQ; return EQ;
"<>"                                        DataFilterlval.op = NEQ; return NEQ;
"<"                                         DataFilterlval.op = LT; return LT;
"<="                                        DataFilterlval.op = LTE; return LTE;
">"                                         DataFilterlval.op = GT; return GT;
">="                                        DataFilterlval.op = GTE; return GTE;

[Mm][Aa][Tt][Cc][Hh][Ee][Ss]                DataFilterlval.op = MATCHES; return MATCHES;
[Bb][Ee][Gg][Ii][Nn][Ss][Ww][Ii][Tt][Hh]    DataFilterlval.op = BEGINSWITH; return BEGINSWITH;
[Ee][Nn][Dd][Ss][Ww][Ii][Tt][Hh]            DataFilterlval.op = ENDSWITH; return ENDSWITH;
[Cc][Oo][Nn][Tt][Aa][Ii][Nn][Ss]            DataFilterlval.op = CONTAINS; return CONTAINS;

[Bb][Ee][Ss][Tt]                           strcpy(DataFilterlval.function, "best"); return BEST;
[Tt][Ii][Zz]                               strcpy(DataFilterlval.function, "tiz"); return TIZ;
[Ll][Tt][Ss]                               strcpy(DataFilterlval.function, "lts"); return LTS;
[Ss][Tt][Ss]                               strcpy(DataFilterlval.function, "sts"); return STS;
[Ss][Bb]                                   strcpy(DataFilterlval.function, "sb"); return SB;
[Rr][Rr]                                   strcpy(DataFilterlval.function, "rr"); return RR;

"&&"                                        DataFilterlval.op = AND; return AND;
[Aa][nN][Dd]                                DataFilterlval.op = AND; return AND;
"||"                                        DataFilterlval.op = OR; return OR;
[Oo][Rr]                                    DataFilterlval.op = OR; return OR;


[-+]?[0-9]+                                 return DF_INTEGER;
[-+]?[0-9]+e-[0-9]+                         return DF_FLOAT;
[-+]?[0-9]+\.[-e0-9]*                       return DF_FLOAT;
\"([^\"]|\\\")*\"                           return DF_STRING;  /* contains non-quotes or escaped-quotes */


"TRIMP(100)_Points"                         return SYMBOL; /* special case */
"Left/Right_Balance"                        return SYMBOL; /* special case */
"Minimum_W'bal"                             return SYMBOL; /* special case */
"Maximum_W'bal_Match"                       return SYMBOL; /* special case */
"Max_W'_Expended"                           return SYMBOL; /* special case */
"W'_Work"                                   return SYMBOL; /* special case */
"W'bal_TAU"                                 return SYMBOL; /* special case */
[a-zA-Z0-9][a-zA-Z0-9_%™]+                  return SYMBOL; /* symbols can start with 0-9 */


"+"                                         DataFilterlval.op = ADD; return ADD;
"-"                                         DataFilterlval.op = SUBTRACT; return SUBTRACT;
"*"                                         DataFilterlval.op = MULTIPLY; return MULTIPLY;
"/"                                         DataFilterlval.op = DIVIDE; return DIVIDE;
"^"                                         DataFilterlval.op = POW; return POW;

[ \n\t\r]                                   ;               /* we just ignore whitespace */


.                   return DataFiltertext[0]; /* any other character, typically :, { or } */
%%

// Older versions of flex (prior to 2.5.9) do not have the destroy function
// Or We're not using GNU flex then we also won't have a destroy function
#if !defined(FLEX_SCANNER) || (YY_FLEX_SUBMINOR_VERSION < 9)
int DataFilterlex_destroy(void) { return 0; }
#endif

void DataFilter_setString(QString p)
{
    BEGIN(0);
    DataFilter_scan_string(p.toLatin1().data());
}

void DataFilter_clearString()
{
    DataFilterlex_destroy();
}

