// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/appengine/v1/deploy.proto
// DO NOT EDIT!

package google_appengine_v1 // import "google.golang.org/genproto/googleapis/appengine/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Code and application artifacts used to deploy a version to App Engine.
type Deployment struct {
	// Manifest of the files stored in Google Cloud Storage that are included
	// as part of this version. All files must be readable using the
	// credentials supplied with this call.
	Files map[string]*FileInfo `protobuf:"bytes,1,rep,name=files" json:"files,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// A Docker image that App Engine uses to run the version.
	// Only applicable for instances in App Engine flexible environment.
	Container *ContainerInfo `protobuf:"bytes,2,opt,name=container" json:"container,omitempty"`
	// The zip file for this deployment, if this is a zip deployment.
	Zip *ZipInfo `protobuf:"bytes,3,opt,name=zip" json:"zip,omitempty"`
}

func (m *Deployment) Reset()                    { *m = Deployment{} }
func (m *Deployment) String() string            { return proto.CompactTextString(m) }
func (*Deployment) ProtoMessage()               {}
func (*Deployment) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *Deployment) GetFiles() map[string]*FileInfo {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *Deployment) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *Deployment) GetZip() *ZipInfo {
	if m != nil {
		return m.Zip
	}
	return nil
}

// Single source file that is part of the version to be deployed. Each source
// file that is deployed must be specified separately.
type FileInfo struct {
	// URL source to use to fetch this file. Must be a URL to a resource in
	// Google Cloud Storage in the form
	// 'http(s)://storage.googleapis.com/\<bucket\>/\<object\>'.
	SourceUrl string `protobuf:"bytes,1,opt,name=source_url,json=sourceUrl" json:"source_url,omitempty"`
	// The SHA1 hash of the file, in hex.
	Sha1Sum string `protobuf:"bytes,2,opt,name=sha1_sum,json=sha1Sum" json:"sha1_sum,omitempty"`
	// The MIME type of the file.
	//
	// Defaults to the value from Google Cloud Storage.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType" json:"mime_type,omitempty"`
}

func (m *FileInfo) Reset()                    { *m = FileInfo{} }
func (m *FileInfo) String() string            { return proto.CompactTextString(m) }
func (*FileInfo) ProtoMessage()               {}
func (*FileInfo) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

// Docker image that is used to start a VM container for the version you
// deploy.
type ContainerInfo struct {
	// URI to the hosted container image in a Docker repository. The URI must be
	// fully qualified and include a tag or digest.
	// Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
	Image string `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
}

func (m *ContainerInfo) Reset()                    { *m = ContainerInfo{} }
func (m *ContainerInfo) String() string            { return proto.CompactTextString(m) }
func (*ContainerInfo) ProtoMessage()               {}
func (*ContainerInfo) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

type ZipInfo struct {
	// URL of the zip file to deploy from. Must be a URL to a resource in
	// Google Cloud Storage in the form
	// 'http(s)://storage.googleapis.com/\<bucket\>/\<object\>'.
	SourceUrl string `protobuf:"bytes,3,opt,name=source_url,json=sourceUrl" json:"source_url,omitempty"`
	// An estimate of the number of files in a zip for a zip deployment.
	// If set, must be greater than or equal to the actual number of files.
	// Used for optimizing performance; if not provided, deployment may be slow.
	FilesCount int32 `protobuf:"varint,4,opt,name=files_count,json=filesCount" json:"files_count,omitempty"`
}

func (m *ZipInfo) Reset()                    { *m = ZipInfo{} }
func (m *ZipInfo) String() string            { return proto.CompactTextString(m) }
func (*ZipInfo) ProtoMessage()               {}
func (*ZipInfo) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func init() {
	proto.RegisterType((*Deployment)(nil), "google.appengine.v1.Deployment")
	proto.RegisterType((*FileInfo)(nil), "google.appengine.v1.FileInfo")
	proto.RegisterType((*ContainerInfo)(nil), "google.appengine.v1.ContainerInfo")
	proto.RegisterType((*ZipInfo)(nil), "google.appengine.v1.ZipInfo")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/appengine/v1/deploy.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 396 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x92, 0x4f, 0x8b, 0xd5, 0x30,
	0x14, 0xc5, 0xe9, 0xab, 0x75, 0x5e, 0x6f, 0x11, 0x24, 0x0a, 0xd6, 0xd1, 0xc1, 0x52, 0x10, 0x8a,
	0x8b, 0x94, 0x37, 0xb3, 0x11, 0x37, 0x0e, 0x33, 0x2a, 0xbc, 0xdd, 0x50, 0x15, 0xc1, 0x4d, 0x89,
	0xf5, 0xbe, 0x18, 0x6c, 0x93, 0x90, 0xa6, 0x85, 0xfa, 0x4d, 0xfc, 0xb6, 0x92, 0xb4, 0xe3, 0xc3,
	0xa1, 0x0b, 0x77, 0xcd, 0xe9, 0x39, 0xbf, 0x7b, 0xf2, 0x07, 0xde, 0x72, 0xa5, 0x78, 0x8b, 0x94,
	0xab, 0x96, 0x49, 0x4e, 0x95, 0xe1, 0x25, 0x47, 0xa9, 0x8d, 0xb2, 0xaa, 0x9c, 0x7f, 0x31, 0x2d,
	0xfa, 0x92, 0x69, 0x8d, 0x92, 0x0b, 0x89, 0xe5, 0xb8, 0x2b, 0xbf, 0xa3, 0x6e, 0xd5, 0x44, 0xbd,
	0x89, 0x3c, 0x5a, 0x00, 0x7f, 0x1d, 0x74, 0xdc, 0x9d, 0xee, 0xff, 0x97, 0x2a, 0xca, 0x1e, 0xcd,
	0x28, 0x1a, 0x6c, 0x94, 0x3c, 0x08, 0x5e, 0x32, 0x29, 0x95, 0x65, 0x56, 0x28, 0xd9, 0xcf, 0xfc,
	0xfc, 0xf7, 0x06, 0xe0, 0x9d, 0x1f, 0xd8, 0xa1, 0xb4, 0xe4, 0x12, 0xa2, 0x83, 0x68, 0xb1, 0x4f,
	0x83, 0x2c, 0x2c, 0x92, 0xf3, 0x57, 0x74, 0x65, 0x3c, 0x3d, 0xfa, 0xe9, 0x07, 0x67, 0x7e, 0x2f,
	0xad, 0x99, 0xaa, 0x39, 0x48, 0x2e, 0x21, 0x6e, 0x94, 0xb4, 0x4c, 0x48, 0x34, 0xe9, 0x26, 0x0b,
	0x8a, 0xe4, 0x3c, 0x5f, 0xa5, 0x5c, 0xdf, 0xba, 0xf6, 0xf2, 0xa0, 0xaa, 0x63, 0x88, 0x50, 0x08,
	0x7f, 0x09, 0x9d, 0x86, 0x3e, 0xfb, 0x7c, 0x35, 0xfb, 0x55, 0x68, 0x9f, 0x72, 0xc6, 0xd3, 0x2f,
	0x00, 0xc7, 0x1a, 0xe4, 0x21, 0x84, 0x3f, 0x71, 0x4a, 0x83, 0x2c, 0x28, 0xe2, 0xca, 0x7d, 0x92,
	0x0b, 0x88, 0x46, 0xd6, 0x0e, 0xb8, 0xb4, 0x39, 0x5b, 0x25, 0x3a, 0x82, 0x47, 0xce, 0xde, 0x37,
	0x9b, 0xd7, 0x41, 0xce, 0x60, 0x7b, 0x2b, 0x93, 0x33, 0x80, 0x5e, 0x0d, 0xa6, 0xc1, 0x7a, 0x30,
	0xed, 0x42, 0x8f, 0x67, 0xe5, 0xb3, 0x69, 0xc9, 0x53, 0xd8, 0xf6, 0x3f, 0xd8, 0xae, 0xee, 0x87,
	0xce, 0x8f, 0x89, 0xab, 0x13, 0xb7, 0xfe, 0x38, 0x74, 0xe4, 0x19, 0xc4, 0x9d, 0xe8, 0xb0, 0xb6,
	0x93, 0x46, 0xbf, 0xa9, 0xb8, 0xda, 0x3a, 0xe1, 0xd3, 0xa4, 0x31, 0x7f, 0x09, 0x0f, 0xfe, 0x39,
	0x07, 0xf2, 0x18, 0x22, 0xd1, 0x31, 0x8e, 0xcb, 0x88, 0x79, 0x91, 0xef, 0xe1, 0x64, 0xd9, 0xf2,
	0x9d, 0x22, 0xe1, 0xdd, 0x22, 0x2f, 0x20, 0xf1, 0xf7, 0x50, 0x37, 0x6a, 0x90, 0x36, 0xbd, 0x97,
	0x05, 0x45, 0x54, 0x81, 0x97, 0xae, 0x9d, 0x72, 0x55, 0xc0, 0x93, 0x46, 0x75, 0x6b, 0x67, 0x70,
	0x95, 0xcc, 0x17, 0x7b, 0xe3, 0x1e, 0xc6, 0x4d, 0xf0, 0xed, 0xbe, 0x7f, 0x21, 0x17, 0x7f, 0x02,
	0x00, 0x00, 0xff, 0xff, 0x71, 0x4b, 0x8e, 0x87, 0xc4, 0x02, 0x00, 0x00,
}
