/*******************************************************************************
*                         Goggles Music Manager                                *
********************************************************************************
*           Copyright (C) 2007-2011 by Sander Jansen. All Rights Reserved      *
*                               ---                                            *
* This program is free software: you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation, either version 3 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
*                                                                              *
* You should have received a copy of the GNU General Public License            *
* along with this program.  If not, see http://www.gnu.org/licenses.           *
********************************************************************************/
#ifndef GMPLAYLISTSOURCE_H
#define GMPLAYLISTSOURCE_H

class GMPlayListSource : public GMDatabaseSource {
FXDECLARE(GMPlayListSource)
protected:
  FXint playlist;
  FXint current_queue;
protected:
  GMPlayListSource();
private:
  GMPlayListSource(const GMPlayListSource&);
  GMPlayListSource& operator=(const GMPlayListSource&);
protected:
  virtual FXint getPlayList() const { return playlist; }
  void getSelectedTrackQueues(FXIntList & q);
  void getTrackQueues(FXIntList & q);
public:
  enum {
    ID_EDIT_NAME = GMDatabaseSource::ID_LAST,
    ID_REMOVE,
    ID_IMPORT,
    ID_LAST
    };
public:
  long onCmdEditName(FXObject*,FXSelector,void*);
  long onCmdRemove(FXObject*,FXSelector,void*);
  long onCmdRemoveInPlaylist(FXObject*,FXSelector,void*);
  long onCmdPaste(FXObject*,FXSelector,void*);
  long onCmdDrop(FXObject*,FXSelector,void*);
  long onCmdImport(FXObject*,FXSelector,void*);
public:
  GMPlayListSource(GMTrackDatabase * db,FXint playlist);

  virtual void orderChanged(GMTrackList*) const;

  virtual FXbool hasCurrentTrack(GMSource * ) const;

  virtual FXbool findCurrent(GMTrackList * tracklist,GMSource * src);

  virtual void resetCurrent() { current_track=-1; current_queue=-1; }

  virtual void markCurrent(GMTrackList * tracklist,FXint item);

  virtual FXbool moveTrack(GMTrackList *,FXint from,FXint to);

  virtual FXString getName() const;

  virtual FXint getType() const { return SOURCE_DATABASE_PLAYLIST; }

  virtual FXint getSortColumn(FXbool browse) const { if (browse) return HEADER_BROWSE; else return HEADER_QUEUE; }

  virtual FXbool getQueueColumn(FXbool browse) const { if (browse) return false; else return true; }

  virtual FXbool defaultBrowse() const { return false; }

#if FOXVERSION >= FXVERSION(1,7,12)
  virtual FXString settingKey() const { return "database_playlist_" + FXString::value(playlist); }
#else
  virtual FXString settingKey() const { return "database_playlist_" + FXStringVal(playlist); }
#endif


  virtual FXbool source_context_menu(FXMenuPane * pane);

  virtual FXbool genre_context_menu(FXMenuPane * pane);

  virtual FXbool artist_context_menu(FXMenuPane * pane);

  virtual FXbool album_context_menu(FXMenuPane * pane);

  virtual FXbool track_context_menu(FXMenuPane * pane);

  virtual FXbool dnd_source_accepts(FXDragType*,FXuint);

  virtual ~GMPlayListSource();
  };

#endif
