/* serializer.c generated by valac 0.26.1, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>


#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
typedef struct _SerializerPrivate SerializerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

struct _Serializer {
	GObject parent_instance;
	SerializerPrivate * priv;
};

struct _SerializerClass {
	GObjectClass parent_class;
};

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
};


static gpointer serializer_parent_class = NULL;

GType display_format_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERIALIZER, SerializerPrivate))
enum  {
	SERIALIZER_DUMMY_PROPERTY
};
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self, Number* x);
static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits);
gint serializer_get_base (Serializer* self);
static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits);
Number* serializer_from_string (Serializer* self, const gchar* str);
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_radix (Serializer* self, gunichar radix);
gunichar serializer_get_radix (Serializer* self);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
gunichar serializer_get_thousands_separator (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
void serializer_set_thousands_separator_count (Serializer* self, gint count);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean serializer_get_show_thousands_separators (Serializer* self);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
gint serializer_get_leading_digits (Serializer* self);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
gint serializer_get_trailing_digits (Serializer* self);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
DisplayFormat serializer_get_number_format (Serializer* self);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
Number* number_real_component (Number* self);
static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string);
gboolean number_is_complex (Number* self);
Number* number_imaginary_component (Number* self);
gboolean number_is_negative (Number* self);
Number* number_abs (Number* self);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_add (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_is_zero (Number* self);
Number* number_subtract (Number* self, Number* y);
gint64 number_to_integer (Number* self);
Number* number_fractional_component (Number* self);
static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits);
Number* number_divide (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
static void serializer_append_exponent (Serializer* self, GString* string, gint exponent);
static void serializer_finalize (GObject* obj);


GType display_format_get_type (void) {
	static volatile gsize display_format_type_id__volatile = 0;
	if (g_once_init_enter (&display_format_type_id__volatile)) {
		static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
		GType display_format_type_id;
		display_format_type_id = g_enum_register_static ("DisplayFormat", values);
		g_once_init_leave (&display_format_type_id__volatile, display_format_type_id);
	}
	return display_format_type_id__volatile;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits) {
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* tsep_string = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	DisplayFormat _tmp21_ = 0;
	self = (Serializer*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	_tmp1_ = g_strdup (_tmp0_);
	radix_string = _tmp1_;
	_tmp3_ = radix_string;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = radix_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		_tmp5_ = radix_string;
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) (-1), NULL, NULL, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
		self->priv->radix = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		self->priv->radix = (gunichar) '.';
	}
	_tmp9_ = nl_langinfo (THOUSEP);
	_tmp10_ = g_strdup (_tmp9_);
	tsep_string = _tmp10_;
	_tmp12_ = tsep_string;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = tsep_string;
		_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		_tmp14_ = tsep_string;
		_tmp15_ = g_locale_to_utf8 (_tmp14_, (gssize) (-1), NULL, NULL, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		self->priv->tsep = _tmp17_;
		_g_free0 (_tmp16_);
	} else {
		self->priv->tsep = (gunichar) ' ';
	}
	self->priv->tsep_count = 3;
	_tmp18_ = number_base;
	self->priv->number_base = _tmp18_;
	_tmp19_ = number_base;
	self->priv->representation_base = (guint) _tmp19_;
	self->priv->leading_digits = 12;
	_tmp20_ = trailing_digits;
	self->priv->trailing_digits = _tmp20_;
	self->priv->show_zeroes = FALSE;
	self->priv->show_tsep = FALSE;
	_tmp21_ = format;
	self->priv->format = _tmp21_;
	_g_free0 (tsep_string);
	_g_free0 (radix_string);
	return self;
}


Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits) {
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
}


gchar* serializer_to_string (Serializer* self, Number* x) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	DisplayFormat _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->representation_base;
	_tmp1_ = self->priv->number_base;
	if (_tmp0_ != ((guint) _tmp1_)) {
		gint n_digits = 0;
		Number* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		n_digits = 0;
		_tmp2_ = x;
		_tmp3_ = serializer_cast_to_string (self, _tmp2_, &n_digits);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->format;
	switch (_tmp4_) {
		default:
		case DISPLAY_FORMAT_AUTOMATIC:
		{
			gint n_digits = 0;
			gchar* s0 = NULL;
			Number* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			n_digits = 0;
			_tmp5_ = x;
			_tmp6_ = serializer_cast_to_string (self, _tmp5_, &n_digits);
			s0 = _tmp6_;
			_tmp7_ = serializer_get_base (self);
			switch (_tmp7_) {
				case 2:
				{
					gint _tmp8_ = 0;
					_tmp8_ = n_digits;
					if (_tmp8_ <= 64) {
						result = s0;
						return result;
					} else {
						Number* _tmp9_ = NULL;
						gchar* _tmp10_ = NULL;
						_tmp9_ = x;
						_tmp10_ = serializer_cast_to_exponential_string (self, _tmp9_, FALSE, &n_digits);
						result = _tmp10_;
						_g_free0 (s0);
						return result;
					}
				}
				case 8:
				{
					gint _tmp11_ = 0;
					_tmp11_ = n_digits;
					if (_tmp11_ <= 22) {
						result = s0;
						return result;
					} else {
						Number* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
						_tmp12_ = x;
						_tmp13_ = serializer_cast_to_exponential_string (self, _tmp12_, FALSE, &n_digits);
						result = _tmp13_;
						_g_free0 (s0);
						return result;
					}
				}
				case 16:
				{
					gint _tmp14_ = 0;
					_tmp14_ = n_digits;
					if (_tmp14_ <= 16) {
						result = s0;
						return result;
					} else {
						Number* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						_tmp15_ = x;
						_tmp16_ = serializer_cast_to_exponential_string (self, _tmp15_, FALSE, &n_digits);
						result = _tmp16_;
						_g_free0 (s0);
						return result;
					}
				}
				default:
				case 10:
				{
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					_tmp17_ = n_digits;
					_tmp18_ = self->priv->leading_digits;
					if (_tmp17_ <= _tmp18_) {
						result = s0;
						return result;
					} else {
						Number* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						_tmp19_ = x;
						_tmp20_ = serializer_cast_to_exponential_string (self, _tmp19_, FALSE, &n_digits);
						result = _tmp20_;
						_g_free0 (s0);
						return result;
					}
				}
			}
			_g_free0 (s0);
		}
		case DISPLAY_FORMAT_FIXED:
		{
			gint n_digits = 0;
			Number* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			n_digits = 0;
			_tmp21_ = x;
			_tmp22_ = serializer_cast_to_string (self, _tmp21_, &n_digits);
			result = _tmp22_;
			return result;
		}
		case DISPLAY_FORMAT_SCIENTIFIC:
		{
			guint _tmp23_ = 0U;
			_tmp23_ = self->priv->representation_base;
			if (_tmp23_ == ((guint) 10)) {
				gint n_digits = 0;
				Number* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				n_digits = 0;
				_tmp24_ = x;
				_tmp25_ = serializer_cast_to_exponential_string (self, _tmp24_, FALSE, &n_digits);
				result = _tmp25_;
				return result;
			} else {
				gint n_digits = 0;
				Number* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				n_digits = 0;
				_tmp26_ = x;
				_tmp27_ = serializer_cast_to_string (self, _tmp26_, &n_digits);
				result = _tmp27_;
				return result;
			}
		}
		case DISPLAY_FORMAT_ENGINEERING:
		{
			guint _tmp28_ = 0U;
			_tmp28_ = self->priv->representation_base;
			if (_tmp28_ == ((guint) 10)) {
				gint n_digits = 0;
				Number* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				n_digits = 0;
				_tmp29_ = x;
				_tmp30_ = serializer_cast_to_exponential_string (self, _tmp29_, TRUE, &n_digits);
				result = _tmp30_;
				return result;
			} else {
				gint n_digits = 0;
				Number* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				n_digits = 0;
				_tmp31_ = x;
				_tmp32_ = serializer_cast_to_string (self, _tmp31_, &n_digits);
				result = _tmp32_;
				return result;
			}
		}
	}
}


Number* serializer_from_string (Serializer* self, const gchar* str) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = self->priv->number_base;
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


void serializer_set_base (Serializer* self, gint number_base) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = number_base;
	self->priv->number_base = _tmp0_;
}


gint serializer_get_base (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->number_base;
	result = _tmp0_;
	return result;
}


void serializer_set_representation_base (Serializer* self, guint representation_base) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = representation_base;
	self->priv->representation_base = _tmp0_;
}


guint serializer_get_representation_base (Serializer* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->representation_base;
	result = _tmp0_;
	return result;
}


void serializer_set_radix (Serializer* self, gunichar radix) {
	gunichar _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = radix;
	self->priv->radix = _tmp0_;
}


gunichar serializer_get_radix (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->radix;
	result = _tmp0_;
	return result;
}


void serializer_set_thousands_separator (Serializer* self, gunichar separator) {
	gunichar _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = separator;
	self->priv->tsep = _tmp0_;
}


gunichar serializer_get_thousands_separator (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->tsep;
	result = _tmp0_;
	return result;
}


gint serializer_get_thousands_separator_count (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tsep_count;
	result = _tmp0_;
	return result;
}


void serializer_set_thousands_separator_count (Serializer* self, gint count) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = count;
	self->priv->tsep_count = _tmp0_;
}


void serializer_set_show_thousands_separators (Serializer* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = visible;
	self->priv->show_tsep = _tmp0_;
}


gboolean serializer_get_show_thousands_separators (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_tsep;
	result = _tmp0_;
	return result;
}


void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = visible;
	self->priv->show_zeroes = _tmp0_;
}


gboolean serializer_get_show_trailing_zeroes (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->show_zeroes;
	result = _tmp0_;
	return result;
}


gint serializer_get_leading_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->leading_digits;
	result = _tmp0_;
	return result;
}


void serializer_set_leading_digits (Serializer* self, gint leading_digits) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = leading_digits;
	self->priv->leading_digits = _tmp0_;
}


gint serializer_get_trailing_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->trailing_digits;
	result = _tmp0_;
	return result;
}


void serializer_set_trailing_digits (Serializer* self, gint trailing_digits) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = trailing_digits;
	self->priv->trailing_digits = _tmp0_;
}


DisplayFormat serializer_get_number_format (Serializer* self) {
	DisplayFormat result = 0;
	DisplayFormat _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->format;
	result = _tmp0_;
	return result;
}


void serializer_set_number_format (Serializer* self, DisplayFormat format) {
	DisplayFormat _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = format;
	self->priv->format = _tmp0_;
}


static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_ = NULL;
	Number* x_real = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GString* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GString* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = x;
	_tmp2_ = number_real_component (_tmp1_);
	x_real = _tmp2_;
	_tmp3_ = x_real;
	_tmp4_ = self->priv->representation_base;
	_tmp5_ = string;
	serializer_cast_to_string_real (self, _tmp3_, (gint) _tmp4_, FALSE, n_digits, _tmp5_);
	_tmp6_ = x;
	_tmp7_ = number_is_complex (_tmp6_);
	if (_tmp7_) {
		Number* x_im = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gboolean force_sign = FALSE;
		GString* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GString* s = NULL;
		GString* _tmp13_ = NULL;
		gint n_complex_digits = 0;
		Number* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		gboolean _tmp16_ = FALSE;
		GString* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		GString* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp8_ = x;
		_tmp9_ = number_imaginary_component (_tmp8_);
		x_im = _tmp9_;
		force_sign = TRUE;
		_tmp10_ = string;
		_tmp11_ = _tmp10_->str;
		if (g_strcmp0 (_tmp11_, "0") == 0) {
			GString* _tmp12_ = NULL;
			_tmp12_ = string;
			g_string_assign (_tmp12_, "");
			force_sign = FALSE;
		}
		_tmp13_ = g_string_sized_new ((gsize) 1024);
		s = _tmp13_;
		n_complex_digits = 0;
		_tmp14_ = x_im;
		_tmp15_ = self->priv->representation_base;
		_tmp16_ = force_sign;
		_tmp17_ = s;
		serializer_cast_to_string_real (self, _tmp14_, (gint) _tmp15_, _tmp16_, &n_complex_digits, _tmp17_);
		_tmp18_ = n_complex_digits;
		_tmp19_ = *n_digits;
		if (_tmp18_ > _tmp19_) {
			gint _tmp20_ = 0;
			_tmp20_ = n_complex_digits;
			*n_digits = _tmp20_;
		}
		_tmp23_ = s;
		_tmp24_ = _tmp23_->str;
		if (g_strcmp0 (_tmp24_, "0") == 0) {
			_tmp22_ = TRUE;
		} else {
			GString* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			_tmp25_ = s;
			_tmp26_ = _tmp25_->str;
			_tmp22_ = g_strcmp0 (_tmp26_, "+0") == 0;
		}
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			_tmp27_ = s;
			_tmp28_ = _tmp27_->str;
			_tmp21_ = g_strcmp0 (_tmp28_, "−0") == 0;
		}
		if (_tmp21_) {
		} else {
			GString* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			_tmp29_ = s;
			_tmp30_ = _tmp29_->str;
			if (g_strcmp0 (_tmp30_, "1") == 0) {
				GString* _tmp31_ = NULL;
				_tmp31_ = string;
				g_string_append (_tmp31_, "i");
			} else {
				GString* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				_tmp32_ = s;
				_tmp33_ = _tmp32_->str;
				if (g_strcmp0 (_tmp33_, "+1") == 0) {
					GString* _tmp34_ = NULL;
					_tmp34_ = string;
					g_string_append (_tmp34_, "+i");
				} else {
					GString* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					_tmp35_ = s;
					_tmp36_ = _tmp35_->str;
					if (g_strcmp0 (_tmp36_, "−1") == 0) {
						GString* _tmp37_ = NULL;
						_tmp37_ = string;
						g_string_append (_tmp37_, "−i");
					} else {
						GString* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						GString* _tmp46_ = NULL;
						_tmp38_ = s;
						_tmp39_ = _tmp38_->str;
						if (g_strcmp0 (_tmp39_, "+0") == 0) {
							GString* _tmp40_ = NULL;
							_tmp40_ = string;
							g_string_append (_tmp40_, "+");
						} else {
							GString* _tmp41_ = NULL;
							const gchar* _tmp42_ = NULL;
							_tmp41_ = s;
							_tmp42_ = _tmp41_->str;
							if (g_strcmp0 (_tmp42_, "0") != 0) {
								GString* _tmp43_ = NULL;
								GString* _tmp44_ = NULL;
								const gchar* _tmp45_ = NULL;
								_tmp43_ = string;
								_tmp44_ = s;
								_tmp45_ = _tmp44_->str;
								g_string_append (_tmp43_, _tmp45_);
							}
						}
						_tmp46_ = string;
						g_string_append (_tmp46_, "i");
					}
				}
			}
		}
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp47_ = string;
	_tmp48_ = _tmp47_->str;
	_tmp49_ = g_strdup (_tmp48_);
	result = _tmp49_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string) {
	static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	Number* number = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Number* temp = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* rounded_number = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	gint i = 0;
	gssize last_non_zero = 0L;
	GString* _tmp54_ = NULL;
	gssize _tmp55_ = 0L;
	GString* _tmp56_ = NULL;
	gunichar _tmp57_ = 0U;
	Number* _tmp58_ = NULL;
	Number* _tmp59_ = NULL;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp87_ = FALSE;
	GString* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = x;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	number = _tmp1_;
	_tmp2_ = number;
	_tmp3_ = number_is_negative (_tmp2_);
	if (_tmp3_) {
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		_tmp4_ = number;
		_tmp5_ = number_abs (_tmp4_);
		_g_object_unref0 (number);
		number = _tmp5_;
	}
	_tmp6_ = number_base;
	_tmp7_ = number_new_integer ((gint64) _tmp6_);
	temp = _tmp7_;
	_tmp8_ = temp;
	_tmp9_ = self->priv->trailing_digits;
	_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) (-(_tmp9_ + 1)));
	_g_object_unref0 (temp);
	temp = _tmp10_;
	_tmp11_ = temp;
	_tmp12_ = number_base;
	_tmp13_ = number_multiply_integer (_tmp11_, (gint64) _tmp12_);
	_g_object_unref0 (temp);
	temp = _tmp13_;
	_tmp14_ = temp;
	_tmp15_ = number_divide_integer (_tmp14_, (gint64) 2);
	_g_object_unref0 (temp);
	temp = _tmp15_;
	_tmp16_ = number;
	_tmp17_ = temp;
	_tmp18_ = number_add (_tmp16_, _tmp17_);
	rounded_number = _tmp18_;
	_tmp19_ = rounded_number;
	_tmp20_ = number_floor (_tmp19_);
	_g_object_unref0 (temp);
	temp = _tmp20_;
	i = 0;
	{
		gboolean _tmp21_ = FALSE;
		_tmp21_ = TRUE;
		while (TRUE) {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gint _tmp26_ = 0;
			gint _tmp32_ = 0;
			Number* t = NULL;
			Number* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
			Number* _tmp37_ = NULL;
			Number* t2 = NULL;
			Number* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			Number* _tmp40_ = NULL;
			Number* t3 = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
			Number* _tmp43_ = NULL;
			gint64 d = 0LL;
			Number* _tmp44_ = NULL;
			gint64 _tmp45_ = 0LL;
			gchar _tmp46_ = '\0';
			gint64 _tmp47_ = 0LL;
			GString* _tmp50_ = NULL;
			gint _tmp51_ = 0;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
			if (!_tmp21_) {
				Number* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				_tmp22_ = temp;
				_tmp23_ = number_is_zero (_tmp22_);
				if (!(!_tmp23_)) {
					break;
				}
			}
			_tmp21_ = FALSE;
			_tmp26_ = number_base;
			if (_tmp26_ == 10) {
				gboolean _tmp27_ = FALSE;
				_tmp27_ = self->priv->show_tsep;
				_tmp25_ = _tmp27_;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				_tmp28_ = i;
				_tmp29_ = self->priv->tsep_count;
				_tmp24_ = _tmp28_ == _tmp29_;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GString* _tmp30_ = NULL;
				gunichar _tmp31_ = 0U;
				_tmp30_ = string;
				_tmp31_ = self->priv->tsep;
				g_string_prepend_unichar (_tmp30_, _tmp31_);
				i = 0;
			}
			_tmp32_ = i;
			i = _tmp32_ + 1;
			_tmp33_ = temp;
			_tmp34_ = number_base;
			_tmp35_ = number_divide_integer (_tmp33_, (gint64) _tmp34_);
			t = _tmp35_;
			_tmp36_ = t;
			_tmp37_ = number_floor (_tmp36_);
			_g_object_unref0 (t);
			t = _tmp37_;
			_tmp38_ = t;
			_tmp39_ = number_base;
			_tmp40_ = number_multiply_integer (_tmp38_, (gint64) _tmp39_);
			t2 = _tmp40_;
			_tmp41_ = temp;
			_tmp42_ = t2;
			_tmp43_ = number_subtract (_tmp41_, _tmp42_);
			t3 = _tmp43_;
			_tmp44_ = t3;
			_tmp45_ = number_to_integer (_tmp44_);
			d = _tmp45_;
			_tmp47_ = d;
			if (_tmp47_ < ((gint64) 16)) {
				gint64 _tmp48_ = 0LL;
				gchar _tmp49_ = '\0';
				_tmp48_ = d;
				_tmp49_ = digits[_tmp48_];
				_tmp46_ = _tmp49_;
			} else {
				_tmp46_ = '?';
			}
			_tmp50_ = string;
			g_string_prepend_c (_tmp50_, _tmp46_);
			_tmp51_ = *n_digits;
			*n_digits = _tmp51_ + 1;
			_tmp52_ = t;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			_g_object_unref0 (temp);
			temp = _tmp53_;
			_g_object_unref0 (t3);
			_g_object_unref0 (t2);
			_g_object_unref0 (t);
		}
	}
	_tmp54_ = string;
	_tmp55_ = _tmp54_->len;
	last_non_zero = _tmp55_;
	_tmp56_ = string;
	_tmp57_ = self->priv->radix;
	g_string_append_unichar (_tmp56_, _tmp57_);
	_tmp58_ = rounded_number;
	_tmp59_ = number_fractional_component (_tmp58_);
	_g_object_unref0 (temp);
	temp = _tmp59_;
	{
		gboolean _tmp60_ = FALSE;
		i = 0;
		_tmp60_ = TRUE;
		while (TRUE) {
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			Number* _tmp64_ = NULL;
			gboolean _tmp65_ = FALSE;
			Number* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			Number* _tmp68_ = NULL;
			Number* digit = NULL;
			Number* _tmp69_ = NULL;
			Number* _tmp70_ = NULL;
			gint64 d = 0LL;
			Number* _tmp71_ = NULL;
			gint64 _tmp72_ = 0LL;
			GString* _tmp73_ = NULL;
			gint64 _tmp74_ = 0LL;
			gchar _tmp75_ = '\0';
			gint64 _tmp76_ = 0LL;
			Number* _tmp79_ = NULL;
			Number* _tmp80_ = NULL;
			Number* _tmp81_ = NULL;
			if (!_tmp60_) {
				gint _tmp61_ = 0;
				_tmp61_ = i;
				i = _tmp61_ + 1;
			}
			_tmp60_ = FALSE;
			_tmp62_ = i;
			_tmp63_ = self->priv->trailing_digits;
			if (!(_tmp62_ < _tmp63_)) {
				break;
			}
			_tmp64_ = temp;
			_tmp65_ = number_is_zero (_tmp64_);
			if (_tmp65_) {
				break;
			}
			_tmp66_ = temp;
			_tmp67_ = number_base;
			_tmp68_ = number_multiply_integer (_tmp66_, (gint64) _tmp67_);
			_g_object_unref0 (temp);
			temp = _tmp68_;
			_tmp69_ = temp;
			_tmp70_ = number_floor (_tmp69_);
			digit = _tmp70_;
			_tmp71_ = digit;
			_tmp72_ = number_to_integer (_tmp71_);
			d = _tmp72_;
			_tmp73_ = string;
			_tmp74_ = d;
			_tmp75_ = digits[_tmp74_];
			g_string_append_c (_tmp73_, _tmp75_);
			_tmp76_ = d;
			if (_tmp76_ != ((gint64) 0)) {
				GString* _tmp77_ = NULL;
				gssize _tmp78_ = 0L;
				_tmp77_ = string;
				_tmp78_ = _tmp77_->len;
				last_non_zero = _tmp78_;
			}
			_tmp79_ = temp;
			_tmp80_ = digit;
			_tmp81_ = number_subtract (_tmp79_, _tmp80_);
			_g_object_unref0 (temp);
			temp = _tmp81_;
			_g_object_unref0 (digit);
		}
	}
	_tmp83_ = self->priv->show_zeroes;
	if (!_tmp83_) {
		_tmp82_ = TRUE;
	} else {
		gint _tmp84_ = 0;
		_tmp84_ = self->priv->trailing_digits;
		_tmp82_ = _tmp84_ == 0;
	}
	if (_tmp82_) {
		GString* _tmp85_ = NULL;
		gssize _tmp86_ = 0L;
		_tmp85_ = string;
		_tmp86_ = last_non_zero;
		g_string_truncate (_tmp85_, (gsize) _tmp86_);
	}
	_tmp88_ = string;
	_tmp89_ = _tmp88_->str;
	if (g_strcmp0 (_tmp89_, "0") != 0) {
		_tmp87_ = TRUE;
	} else {
		gboolean _tmp90_ = FALSE;
		_tmp90_ = force_sign;
		_tmp87_ = _tmp90_;
	}
	if (_tmp87_) {
		Number* _tmp91_ = NULL;
		gboolean _tmp92_ = FALSE;
		_tmp91_ = x;
		_tmp92_ = number_is_negative (_tmp91_);
		if (_tmp92_) {
			GString* _tmp93_ = NULL;
			_tmp93_ = string;
			g_string_prepend (_tmp93_, "−");
		} else {
			gboolean _tmp94_ = FALSE;
			_tmp94_ = force_sign;
			if (_tmp94_) {
				GString* _tmp95_ = NULL;
				_tmp95_ = string;
				g_string_prepend (_tmp95_, "+");
			}
		}
	}
	_tmp96_ = number_base;
	_tmp97_ = self->priv->number_base;
	if (_tmp96_ != _tmp97_) {
		static const gchar* sub_digits[] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
		gint multiplier = 0;
		gint b = 0;
		gint _tmp98_ = 0;
		multiplier = 1;
		_tmp98_ = number_base;
		b = _tmp98_;
		while (TRUE) {
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
			_tmp99_ = number_base;
			_tmp100_ = multiplier;
			if (!((_tmp99_ / _tmp100_) != 0)) {
				break;
			}
			_tmp101_ = multiplier;
			multiplier = _tmp101_ * 10;
		}
		while (TRUE) {
			gint _tmp102_ = 0;
			gint d = 0;
			gint _tmp103_ = 0;
			gint _tmp104_ = 0;
			gint _tmp105_ = 0;
			GString* _tmp106_ = NULL;
			gint _tmp107_ = 0;
			const gchar* _tmp108_ = NULL;
			gint _tmp109_ = 0;
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			_tmp102_ = multiplier;
			if (!(_tmp102_ != 1)) {
				break;
			}
			_tmp103_ = multiplier;
			multiplier = _tmp103_ / 10;
			_tmp104_ = b;
			_tmp105_ = multiplier;
			d = _tmp104_ / _tmp105_;
			_tmp106_ = string;
			_tmp107_ = d;
			_tmp108_ = sub_digits[_tmp107_];
			g_string_append (_tmp106_, _tmp108_);
			_tmp109_ = b;
			_tmp110_ = d;
			_tmp111_ = multiplier;
			b = _tmp109_ - (_tmp110_ * _tmp111_);
		}
	}
	_g_object_unref0 (rounded_number);
	_g_object_unref0 (temp);
	_g_object_unref0 (number);
}


static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits) {
	gint result = 0;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Number* mantissa = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* base_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* base3 = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* base10 = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* t = NULL;
	Number* _tmp11_ = NULL;
	Number* base10inv = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	gint exponent = 0;
	Number* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GString* _tmp64_ = NULL;
	Number* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (string != NULL, 0);
	_tmp0_ = x;
	_tmp1_ = number_is_negative (_tmp0_);
	if (_tmp1_) {
		GString* _tmp2_ = NULL;
		_tmp2_ = string;
		g_string_append (_tmp2_, "−");
	}
	_tmp3_ = x;
	_tmp4_ = number_abs (_tmp3_);
	mantissa = _tmp4_;
	_tmp5_ = self->priv->number_base;
	_tmp6_ = number_new_integer ((gint64) _tmp5_);
	base_ = _tmp6_;
	_tmp7_ = base_;
	_tmp8_ = number_xpowy_integer (_tmp7_, (gint64) 3);
	base3 = _tmp8_;
	_tmp9_ = base_;
	_tmp10_ = number_xpowy_integer (_tmp9_, (gint64) 10);
	base10 = _tmp10_;
	_tmp11_ = number_new_integer ((gint64) 1);
	t = _tmp11_;
	_tmp12_ = t;
	_tmp13_ = base10;
	_tmp14_ = number_divide (_tmp12_, _tmp13_);
	base10inv = _tmp14_;
	exponent = 0;
	_tmp15_ = mantissa;
	_tmp16_ = number_is_zero (_tmp15_);
	if (!_tmp16_) {
		Number* _tmp52_ = NULL;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gint _tmp22_ = 0;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			Number* _tmp25_ = NULL;
			_tmp18_ = eng_format;
			if (!_tmp18_) {
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				_tmp19_ = mantissa;
				_tmp20_ = base10;
				_tmp21_ = number_compare (_tmp19_, _tmp20_);
				_tmp17_ = _tmp21_ >= 0;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = exponent;
			exponent = _tmp22_ + 10;
			_tmp23_ = mantissa;
			_tmp24_ = base10inv;
			_tmp25_ = number_multiply (_tmp23_, _tmp24_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp25_;
		}
		while (TRUE) {
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gint _tmp39_ = 0;
			Number* _tmp40_ = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
			_tmp28_ = eng_format;
			if (!_tmp28_) {
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				_tmp29_ = mantissa;
				_tmp30_ = base_;
				_tmp31_ = number_compare (_tmp29_, _tmp30_);
				_tmp27_ = _tmp31_ >= 0;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
				_tmp33_ = eng_format;
				if (_tmp33_) {
					gboolean _tmp34_ = FALSE;
					Number* _tmp35_ = NULL;
					Number* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					_tmp35_ = mantissa;
					_tmp36_ = base3;
					_tmp37_ = number_compare (_tmp35_, _tmp36_);
					if (_tmp37_ >= 0) {
						_tmp34_ = TRUE;
					} else {
						gint _tmp38_ = 0;
						_tmp38_ = exponent;
						_tmp34_ = (_tmp38_ % 3) != 0;
					}
					_tmp32_ = _tmp34_;
				} else {
					_tmp32_ = FALSE;
				}
				_tmp26_ = _tmp32_;
			}
			if (!_tmp26_) {
				break;
			}
			_tmp39_ = exponent;
			exponent = _tmp39_ + 1;
			_tmp40_ = mantissa;
			_tmp41_ = base_;
			_tmp42_ = number_divide (_tmp40_, _tmp41_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp42_;
		}
		while (TRUE) {
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			gint _tmp48_ = 0;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
			_tmp44_ = eng_format;
			if (!_tmp44_) {
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
				gint _tmp47_ = 0;
				_tmp45_ = mantissa;
				_tmp46_ = base10inv;
				_tmp47_ = number_compare (_tmp45_, _tmp46_);
				_tmp43_ = _tmp47_ < 0;
			} else {
				_tmp43_ = FALSE;
			}
			if (!_tmp43_) {
				break;
			}
			_tmp48_ = exponent;
			exponent = _tmp48_ - 10;
			_tmp49_ = mantissa;
			_tmp50_ = base10;
			_tmp51_ = number_multiply (_tmp49_, _tmp50_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp51_;
		}
		_tmp52_ = number_new_integer ((gint64) 1);
		_g_object_unref0 (t);
		t = _tmp52_;
		while (TRUE) {
			gboolean _tmp53_ = FALSE;
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			gint _tmp56_ = 0;
			gint _tmp60_ = 0;
			Number* _tmp61_ = NULL;
			Number* _tmp62_ = NULL;
			Number* _tmp63_ = NULL;
			_tmp54_ = mantissa;
			_tmp55_ = t;
			_tmp56_ = number_compare (_tmp54_, _tmp55_);
			if (_tmp56_ < 0) {
				_tmp53_ = TRUE;
			} else {
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
				_tmp58_ = eng_format;
				if (_tmp58_) {
					gint _tmp59_ = 0;
					_tmp59_ = exponent;
					_tmp57_ = (_tmp59_ % 3) != 0;
				} else {
					_tmp57_ = FALSE;
				}
				_tmp53_ = _tmp57_;
			}
			if (!_tmp53_) {
				break;
			}
			_tmp60_ = exponent;
			exponent = _tmp60_ - 1;
			_tmp61_ = mantissa;
			_tmp62_ = base_;
			_tmp63_ = number_multiply (_tmp61_, _tmp62_);
			_g_object_unref0 (mantissa);
			mantissa = _tmp63_;
		}
	}
	_tmp64_ = string;
	_tmp65_ = mantissa;
	_tmp66_ = serializer_cast_to_string (self, _tmp65_, n_digits);
	_tmp67_ = _tmp66_;
	g_string_append (_tmp64_, _tmp67_);
	_g_free0 (_tmp67_);
	result = exponent;
	_g_object_unref0 (base10inv);
	_g_object_unref0 (t);
	_g_object_unref0 (base10);
	_g_object_unref0 (base3);
	_g_object_unref0 (base_);
	_g_object_unref0 (mantissa);
	return result;
}


static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_ = NULL;
	Number* x_real = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint exponent = 0;
	Number* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	GString* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Number* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GString* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = x;
	_tmp2_ = number_real_component (_tmp1_);
	x_real = _tmp2_;
	_tmp3_ = x_real;
	_tmp4_ = string;
	_tmp5_ = eng_format;
	_tmp6_ = serializer_cast_to_exponential_string_real (self, _tmp3_, _tmp4_, _tmp5_, n_digits);
	exponent = _tmp6_;
	_tmp7_ = string;
	_tmp8_ = exponent;
	serializer_append_exponent (self, _tmp7_, _tmp8_);
	_tmp9_ = x;
	_tmp10_ = number_is_complex (_tmp9_);
	if (_tmp10_) {
		Number* x_im = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		GString* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GString* s = NULL;
		GString* _tmp16_ = NULL;
		gint n_complex_digits = 0;
		Number* _tmp17_ = NULL;
		GString* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		GString* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GString* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		_tmp11_ = x;
		_tmp12_ = number_imaginary_component (_tmp11_);
		x_im = _tmp12_;
		_tmp13_ = string;
		_tmp14_ = _tmp13_->str;
		if (g_strcmp0 (_tmp14_, "0") == 0) {
			GString* _tmp15_ = NULL;
			_tmp15_ = string;
			g_string_assign (_tmp15_, "");
		}
		_tmp16_ = g_string_sized_new ((gsize) 1024);
		s = _tmp16_;
		n_complex_digits = 0;
		_tmp17_ = x_im;
		_tmp18_ = s;
		_tmp19_ = eng_format;
		_tmp20_ = serializer_cast_to_exponential_string_real (self, _tmp17_, _tmp18_, _tmp19_, &n_complex_digits);
		exponent = _tmp20_;
		_tmp21_ = n_complex_digits;
		_tmp22_ = *n_digits;
		if (_tmp21_ > _tmp22_) {
			gint _tmp23_ = 0;
			_tmp23_ = n_complex_digits;
			*n_digits = _tmp23_;
		}
		_tmp26_ = s;
		_tmp27_ = _tmp26_->str;
		if (g_strcmp0 (_tmp27_, "0") == 0) {
			_tmp25_ = TRUE;
		} else {
			GString* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			_tmp28_ = s;
			_tmp29_ = _tmp28_->str;
			_tmp25_ = g_strcmp0 (_tmp29_, "+0") == 0;
		}
		if (_tmp25_) {
			_tmp24_ = TRUE;
		} else {
			GString* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			_tmp30_ = s;
			_tmp31_ = _tmp30_->str;
			_tmp24_ = g_strcmp0 (_tmp31_, "−0") == 0;
		}
		if (_tmp24_) {
		} else {
			GString* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			_tmp32_ = s;
			_tmp33_ = _tmp32_->str;
			if (g_strcmp0 (_tmp33_, "1") == 0) {
				GString* _tmp34_ = NULL;
				_tmp34_ = string;
				g_string_append (_tmp34_, "i");
			} else {
				GString* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				_tmp35_ = s;
				_tmp36_ = _tmp35_->str;
				if (g_strcmp0 (_tmp36_, "+1") == 0) {
					GString* _tmp37_ = NULL;
					_tmp37_ = string;
					g_string_append (_tmp37_, "+i");
				} else {
					GString* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					_tmp38_ = s;
					_tmp39_ = _tmp38_->str;
					if (g_strcmp0 (_tmp39_, "−1") == 0) {
						GString* _tmp40_ = NULL;
						_tmp40_ = string;
						g_string_append (_tmp40_, "−i");
					} else {
						GString* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						GString* _tmp49_ = NULL;
						_tmp41_ = s;
						_tmp42_ = _tmp41_->str;
						if (g_strcmp0 (_tmp42_, "+0") == 0) {
							GString* _tmp43_ = NULL;
							_tmp43_ = string;
							g_string_append (_tmp43_, "+");
						} else {
							GString* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
							_tmp44_ = s;
							_tmp45_ = _tmp44_->str;
							if (g_strcmp0 (_tmp45_, "0") != 0) {
								GString* _tmp46_ = NULL;
								GString* _tmp47_ = NULL;
								const gchar* _tmp48_ = NULL;
								_tmp46_ = string;
								_tmp47_ = s;
								_tmp48_ = _tmp47_->str;
								g_string_append (_tmp46_, _tmp48_);
							}
						}
						_tmp49_ = string;
						g_string_append (_tmp49_, "i");
					}
				}
			}
		}
		_tmp50_ = string;
		_tmp51_ = exponent;
		serializer_append_exponent (self, _tmp50_, _tmp51_);
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp52_ = string;
	_tmp53_ = _tmp52_->str;
	_tmp54_ = g_strdup (_tmp53_);
	result = _tmp54_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void serializer_append_exponent (Serializer* self, GString* string, gint exponent) {
	static const gunichar super_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gint _tmp0_ = 0;
	GString* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* super_value = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (string != NULL);
	_tmp0_ = exponent;
	if (_tmp0_ == 0) {
		return;
	}
	_tmp1_ = string;
	g_string_append (_tmp1_, "×10");
	_tmp2_ = exponent;
	if (_tmp2_ < 0) {
		gint _tmp3_ = 0;
		GString* _tmp4_ = NULL;
		_tmp3_ = exponent;
		exponent = -_tmp3_;
		_tmp4_ = string;
		g_string_append_unichar (_tmp4_, 8315U);
	}
	_tmp5_ = exponent;
	_tmp6_ = g_strdup_printf ("%d", _tmp5_);
	super_value = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				GString* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gchar _tmp16_ = '\0';
				gunichar _tmp17_ = 0U;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = super_value;
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(_tmp9_ < _tmp12_)) {
					break;
				}
				_tmp13_ = string;
				_tmp14_ = super_value;
				_tmp15_ = i;
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
				_tmp17_ = super_digits[_tmp16_ - '0'];
				g_string_append_unichar (_tmp13_, _tmp17_);
			}
		}
	}
	_g_free0 (super_value);
}


static void serializer_class_init (SerializerClass * klass) {
	serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SerializerPrivate));
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
}


static void serializer_instance_init (Serializer * self) {
	self->priv = SERIALIZER_GET_PRIVATE (self);
}


static void serializer_finalize (GObject* obj) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
}


GType serializer_get_type (void) {
	static volatile gsize serializer_type_id__volatile = 0;
	if (g_once_init_enter (&serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
		GType serializer_type_id;
		serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
		g_once_init_leave (&serializer_type_id__volatile, serializer_type_id);
	}
	return serializer_type_id__volatile;
}



