#ifdef GHMM_OBSOLETE

#ifndef GHMM_OBSOLETE_H
#define GHMM_OBSOLETE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "scanner.h"
#include "model.h"


/*================== matrix.h ===============================================*/
/**
  Reads in a double matrix.

  \obsolete
  @return 0 for succes; -1 for error
  @param s:          scanner
  @param matrix:     matrix to read
  @param max_row:    number of rows
  @param max_column: number of columns
  */
  int ighmm_cmatrix_read (scanner_t * s, double **matrix, int max_row,
                     int max_column);

/**
  Writes a double matrix (without parenthesis).

  \obsolete
  @param file:       output file
  @param matrix:     matrix to write
  @param rows:       number of rows
  @param columns:    number of columns
  @param tab:        format: leading tabs
  @param separator:  format: separator for columns
  @param ending:     format: end of a row  
  */
  void ighmm_cmatrix_print (FILE * file, double **matrix, int rows, int columns,
                       char *tab, char *separator, char *ending);

/**
  Determines the number of entries != 0 in a row of a matrix.

  \obsolete
  @return         number of entries
  @param matrix:   double matrix
  @param row:      row to scan
  @param max_col:  number of columns 
  */
  int ighmm_cmatrix_notzero_columns (double **matrix, int row, int max_col);

/**
  Determines the number of entries != 0 in a column of a matrix. 

  \obsolete
  @return         number of entries
  @param matrix:   double matrix
  @param col:      column to scan
  @param max_row:  number of rows
  */
  int ighmm_cmatrix_notzero_rows (double **matrix, int col, int max_row);

/** 
  Scales the rowvectors of a matrix, so that they have sum 1.

  \obsolete
  @return 0 for success; -1 for error
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  */
  int ighmm_cmatrix_normalize (double **matrix, int rows, int cols);

/** 
  Gives the elements in a matrix uniformly distributed values between min and
  max.

  \obsolete 
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  @param min:      minimum for the random values
  @param max:      maximum for the random values
  */
  void ighmm_cmatrix_random_values (double **matrix, int rows, int cols,
                               double min, double max);

/** 
  Gives the elements in a matrix uniformly distributed values between min and
  max.

  \obsolete Gives all elements in the last row a constant value.
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  @param min:      minimum for the random values
  @param max:      maximum for the random values
  @param c:        value for the last row
  */
  void ighmm_cmatrix_random_const_values (double **matrix, int rows, int cols,
                                     double min, double max, double c);

/** 
  Gives all elements in a matrix a constant value.

  \obsolete
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  @param c:        value for the elements
  */
  void ighmm_cmatrix_const_values (double **matrix, int rows, int cols, double c);

/** 
  Gives all elements on the 1. upper secondary diagonal in a matrix the
  value 1.

  \obsolete
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  */
  void ighmm_cmatrix_left_right_strict (double **matrix, int rows, int cols);

/** 
  Gives the elements in a matrix with band width 3 random values.

  \obsolete
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  */
  void ighmm_cmatrix_random_left_right (double **matrix, int rows, int cols);


/** 
  Gives all elements != 0 in a matrix a constant value.

  \obsolete
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  @param c:        value for the elements
  */
  void ighmm_cmatrix_const_preserve_struct (double **matrix, int rows, int cols,
                                       double c);

/** 
  Gives all elements != 0 in a matrix uniformly distributed random values 
  between 0 and 1.

  \obsolete
  @param matrix   double matrix
  @param rows     number of rows
  @param cols     number of columns
  */
  void ighmm_cmatrix_random_preserve_struct (double **matrix, int rows, int cols);

/** 
  Gives each row in a matrix values according to a certain Gauss density.

  \obsolete Mean values are randomly generated if mue == NULL.
  u (\f$\sigma^2\f$) must be given.
  @return 0 for success; -1 for failure
  @param matrix:   double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  @param mue:      pointer to the vector containing the mean values for each row
  @param u:        standard deviation, for all rows equal
 */
  int ighmm_cmatrix_gaussrows_values (double **matrix, int rows, int cols,
                                 double **mue, double u);

/** 
  Transposes a matrix.

  \obsolete
  @param A:        double matrix
  @param rows:     number of rows
  @param cols:     number of columns
  @param A_T:      transposed double matrix (the returned value)
 */
  void ighmm_cmatrix_transpose (double **A, int rows, int cols, double **A_T);

/**
  Solves a linear equation system, Ax = b, for a symmetric, positiv definit
  matrix.

  \obsolete
  @return 0 for success; -1 for failure
  @param a:    double matrix 
  @param b:    double vector
  @param dim:  dimension of a
  @param x:    double vector, a solution of the system.
  */
  int ighmm_cmatrix_cholesky (double **a, double *b, int dim, double *x);

/**
  Finds the determinant of a symmetric, positiv definit matrix.

  \obsolete
  @return 0 for success; -1 for failure
  @param a:    double matrix
  @param dim:  dimension of a
  @param det:  determinant of a, the returning value
  */
  int ighmm_cmatrix_det_symposdef (double **a, int dim, double *det);

/** 
  Copies a matrix.

  \obsolete \note Allocation needs to be done outside!
  @param src:    double matrix to copy
  @param target: copy of src, the returning value 
  @param rows:   number of rows
  @param cols:   number of columns
*/
  void ighmm_cmatrix_copy (double **src, double **target, int rows, int cols);

/**
  Checks whether a quadratic double matrix is stochastic.

  \obsolete
  @return 0/1 flag for true/false
  @param  double NxN matrix to be checked
  @param  matrix dimension N (matrix must be quadaratic)
  */
  int ighmm_cmatrix_check_stochasticity (double **matrix, int N);


/*================== model.h ================================================*/
/** full matrix HMM.

  \obsolete Keeps the model parameters in a matrix form. 
*/
  struct model_direct {
  /** Number of states */
    int N;
  /** Number of outputs */
    int M;
  /** Prior for the a priori probability for the model.
      Gets the value -1 if no prior defined. */
    double prior;
  /** Transition matrix  */
    double **A;
  /** Output matrix */
    double **B;
  /** Initial matrix */
    double *Pi;
  /** A vector to know the states where the output should not be trained.
      Default value is 0 for all states. */
    int *fix_state;

    /* XXX additional struct members not addedd here; model_direct is 
       depreciated anyways. Not used by C++ interface */

  };
  typedef struct model_direct model_direct;


/** Checks the consistence of the model

  \obsolete
  */
  struct hmm_check_t {
  /** Number of rows in the A matrix */
    int r_a;
  /** Number of columns in the A matrix */
    int c_a;
  /** Number of rows in the B matrix */
    int r_b;
  /** Number of columns in the B matrix */
    int c_b;
  /** Length of the phi vector */
    int len_pi;
  /** Length of the fix vector */
    int len_fix;
  };
  typedef struct hmm_check_t hmm_check_t;

/**
   Reads in ASCII data to initialize an array of models.

   \obsolete Memory allocation for
   the models is done here.
   @return array of pointers to the models
   @param filename:   the ASCII input file
   @param mo_number:  filled with number of models read */
  ghmm_dmodel **ghmm_dmodel_read (char *filename, int *mo_number);

/**
   Reads in a model, where the model parameters are explicit given in
   matrix form.

   \obsolete Memory allocation for the model is also done here.
   @return pointer to the ghmm_dmodel
   @param s:       scanner
   @param multip:  multiplicity; gives how many copies should 
   be made of the model */
  ghmm_dmodel *ghmm_dmodel_direct_read (scanner_t * s, int *multip);

/**
   Writes a HMM in matrix format.

   \obsolete The input model must be of type
   model_direct, that is, have the parameters saved as matrices.
   @param file:   output file
   @param mo_d:   model of type model_direct
   @param multip: number of copies to write
*/
  void ghmm_dmodel_direct_print (FILE * file, model_direct * mo_d, int multip);

/** 
    Frees all memory from a model.

    \obsolete Also sets the pointers to NULL and 
    variables to zero.
    @param mo_d  HMM structure (\Ref{struct model_direct})
    @param check Check structure (\Ref{struct hmm_check_t})
*/
  void ghmm_dmodel_direct_clean (model_direct * mo_d, hmm_check_t * check);

/** 
    Tests compatibility of the model components.

    \obsolete
    @return 0 for success; -1 for failure 
    @param mo_d  HMM structure  (\Ref{struct model_direct})
    @param check Check structure  (\Ref{struct hmm_check_t})
*/
  int ghmm_dmodel_direct_check_data (model_direct * mo_d, hmm_check_t * check);

/**
   Produces simple left-right models given sequences. 

   \obsolete
   The function "ghmm_dmodel_generate_from_sequence" is called for each 
   model that should be made. The sequences are read in from the
   ASCII file and thrown away again when leaving the function.
   @return vector of models
   @param s:          scanner
   @param new_models: number of models to produce */
  ghmm_dmodel **ghmm_dmodel_from_sequence_ascii (scanner_t * s, long *mo_number);



/*============== vector.h ===================================================*/
/**
  Gives all elements in a vector a constant value.

  \obsolete
  @param v    vector
  @param len  length of the vector
  @param c    given value for the elements
*/
  void ighmm_cvector_const_values (double *v, int len, double c);

/**
  Gives all elements, not equal zero, in a vector a constant value.

  \obsolete
  @param v    vector
  @param len  length of the vector
  @param c    given value for the elements
*/
  void ighmm_cvector_const_preserve_struct (double *v, int len, double c);

/**
  Gives all elements in a vector random values between 0 and 1.

  \obsolete
  @param v    vector
  @param len  length of the vector       
*/
  void ighmm_cvector_random_values (double *v, int len);

/**
  Gives all elements, not equal zero, in a vector random values
  between 0 and 1.

  \obsolete
  @param v    vector
  @param len  length of the vector   
*/
  void ighmm_cvector_random_preserve_struct (double *v, int len);

/**
  Calculates Ax, where A is a double matrix and x a double vector.

  \obsolete
  @param A       n x m matrix
  @param x       vector to calculate
  @param n       number of rows
  @param m       number of columns
  @param v       calculated vector (return value)
  */
  int ighmm_cvector_mat_times_vec (double **A, double *x, int n, int m, double *v);



/*============= smodel.h ====================================================*/
/** Reads an ascii file with specifications for one or more smodels.

    \obsolete
    All parameters in matrix or vector form.
    This is necessary whenever an initial model is needed (e.g. 
    training) or sequences have to be generated from trained models.
    For each ghmm_cmodel block smodel\_read\_block() is called.
   @return vector of read smodels
   @param filename   input ascii file
   @param smo_number  number of smodels to read*/
  ghmm_cmodel **ghmm_cmodel_read (const char *filename, int *smo_number);

/** Reads one ghmm_cmodel block. It is possible to generate multiple
    identical copies of the model read. Memory allocation is here.
   @return pointer of smode read
   @param s        scanner for reading
   @param multip   number ob identical copies
*/
  ghmm_cmodel *ghmm_cmodel_read_block (scanner_t * s, int *multip);


/*============ sequence.h ===================================================*/
/**
   Reads one or several arrays of integer sequences.

   \obsolete
   Calls sequence\_read\_alloc, where reading
   and memory allocation is done. 
   @return pointer to sequence array
   @param filename    input filename
   @param seq\_arrays number of sequence arrays read
*/
  ghmm_dseq **ghmm_dseq_read (const char *filename, int *seq_arrays);

/**
   Reading of one integer sequence field.

   \obsolete Memory alloc here.
   @param s scanner
   @return array of sequences
*/
  ghmm_dseq *ghmm_dseq_read_alloc (scanner_t * s);

/**
   Reads one or several arrays of double sequences. 

   \obsolete Calls ghmm_dseq_read_alloc(), where reading
   and memory allocation is done. 
   @return pointer to sequence array
   @param filename    input filename
*/
  ghmm_cseq **ghmm_cseq_read (const char *filename, int *sqd_number);

/**
   Reading of one double sequence field.

   \obsolete Memory alloc here.
   @param s scanner
   @return array of sequences
*/
  ghmm_cseq *ghmm_cseq_read_alloc (scanner_t * s);


#ifdef __cplusplus
}
#endif

#endif /* GHMM_OBSOLETE_H */

#endif /* GHMM_OBSOLETE */
