/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  selection.cc - AtkSelection C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "selection.hh"
#include "private/marshal.hh"
#include "object.hh"

using namespace GFC;

/*  Atk::Selection
 */

Atk::Selection::Selection()
{
}
	
Atk::Selection::~Selection()
{
}
	
Atk::Object*
Atk::Selection::ref_selection(int i)
{
	AtkObject *object = atk_selection_ref_selection(atk_selection(), i);
	return object ? G::Object::wrap<Atk::Object>(object) : 0;
}

/*  Atk::Selection signals
 */

const Atk::Selection::SelectionChangedSignalType Atk::Selection::selection_changed_signal("selection_changed", (GCallback)&G::Marshal::void_callback);

