/**
 * D header file for POSIX.
 *
 * Copyright: Copyright Sean Kelly 2005 - 2009.
 * License:   <a href="http://www.boost.org/LICENSE_1_0.txt">Boost License 1.0</a>.
 * Authors:   Sean Kelly
 * Standards: The Open Group Base Specifications Issue 6, IEEE Std 1003.1, 2004 Edition
 */

/*          Copyright Sean Kelly 2005 - 2009.
 * Distributed under the Boost Software License, Version 1.0.
 *    (See accompanying file LICENSE_1_0.txt or copy at
 *          http://www.boost.org/LICENSE_1_0.txt)
 */
module core.sys.posix.config;

public import core.stdc.config;

extern (C):

version( linux )
{
    enum bool  __USE_LARGEFILE64    = true;
    enum bool  __USE_FILE_OFFSET64  = __USE_LARGEFILE64;
    enum bool  __REDIRECT           = false;
}

/// %% FIXME: Probably not consistent for all architectures.
static if( size_t.sizeof == 8 )
{
    enum uint __WORDSIZE            = 64;
}
else
{
    enum uint __WORDSIZE            = 32;
}
