/* ***** BEGIN LICENSE BLOCK *****
 * FW4SPL - Copyright (C) IRCAD, 2009-2012.
 * Distributed under the terms of the GNU Lesser General Public License (LGPL) as
 * published by the Free Software Foundation.
 * ****** END LICENSE BLOCK ****** */

#include <vtkPolyData.h>
#include <vtkSphereSource.h>
#include <vtkSmartPointer.h>

#include <fwData/TriangularMesh.hpp>

#include <fwVtkIO/vtk.hpp>

#include "TrianTest.hpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ::fwVtkIO::ut::TrianTest );

namespace fwVtkIO
{
namespace ut
{

//------------------------------------------------------------------------------

void TrianTest::setUp()
{
    // Set up context before running a test.
}

//------------------------------------------------------------------------------

void TrianTest::tearDown()
{
    // Clean up after the test run.
}

//------------------------------------------------------------------------------

void TrianTest::testTrianToVtk()
{
    ::fwData::TriangularMesh::sptr trian1 = ::fwData::TriangularMesh::New();
    CPPUNIT_ASSERT( trian1 );

    vtkSmartPointer< vtkSphereSource > source = vtkSmartPointer< vtkSphereSource >::New();
    source->SetThetaResolution(50);
    source->SetPhiResolution(50);
    source->SetRadius(2);
    source->Update();
    vtkSmartPointer< vtkPolyData > poly_source = source->GetOutput();

    CPPUNIT_ASSERT( trian1->cells().empty() );
    CPPUNIT_ASSERT( trian1->points().empty() );

    ::fwVtkIO::fromVTKMesh(poly_source, trian1);

    CPPUNIT_ASSERT( !trian1->cells().empty() );
    CPPUNIT_ASSERT( !trian1->points().empty() );

    vtkPolyData *mesh = ::fwVtkIO::toVTKMesh( trian1 );
    CPPUNIT_ASSERT( mesh );

    CPPUNIT_ASSERT_EQUAL(poly_source->GetNumberOfVerts(), mesh->GetNumberOfVerts());
    CPPUNIT_ASSERT_EQUAL(poly_source->GetNumberOfLines(), mesh->GetNumberOfLines());
    CPPUNIT_ASSERT_EQUAL(poly_source->GetNumberOfPolys(), mesh->GetNumberOfPolys());
    CPPUNIT_ASSERT_EQUAL(poly_source->GetNumberOfStrips(), mesh->GetNumberOfStrips());


    ::fwData::TriangularMesh::sptr trian2 = ::fwData::TriangularMesh::New();
    CPPUNIT_ASSERT( trian2 );
    ::fwVtkIO::fromVTKMesh(mesh, trian2);

    CPPUNIT_ASSERT_EQUAL(trian1->getNumCells(),  trian2->getNumCells());
    CPPUNIT_ASSERT_EQUAL(trian1->getNumPoints(), trian2->getNumPoints());
    CPPUNIT_ASSERT(trian1->points() == trian2->points());
    CPPUNIT_ASSERT(trian1->cells() ==  trian2->cells());

    mesh->Delete();
}

//------------------------------------------------------------------------------

} // namespace ut
} // namespace fwVtkIO
