/* ***** BEGIN LICENSE BLOCK *****
 * FW4SPL - Copyright (C) IRCAD, 2009-2012.
 * Distributed under the terms of the GNU Lesser General Public License (LGPL) as
 * published by the Free Software Foundation.
 * ****** END LICENSE BLOCK ****** */

#ifndef FWSERVICESNAMESPACE_HPP_
#define FWSERVICESNAMESPACE_HPP_

/**
 * @brief Namespace fwServices is dedicated to (mimic) the dynamic affectation of methods to (pure data) objects (::fwTools::Object), and component orientation transparently. This is assimilable to the
 * notion of role (corresponding to the IService class).
 * \li IService : API to normalize manipulation, using a limited set of well defined methods
 * \li IService : contract for service implementation
 * \li macros.hpp : declaration of service to object bindings
 * \li A set of high level methods to facilitate the use of implemented concepts (Add.hpp, New.hpp, Info.hpp, Erase.hpp, Get.hpp and Run.hpp)
 * \li ObjectMsg and IEditionService : communication management (implementation of an adaptation of the observer design pattern), high-level methods being available in Com.hpp
 * @namespace   fwServices
 * 
 * @date        2009-2010.
 *
 */
namespace fwServices
{
}
#endif /* FWSERVICESNAMESPACE_HPP_ */
