/* ***** BEGIN LICENSE BLOCK *****
 * FW4SPL - Copyright (C) IRCAD, 2009-2014.
 * Distributed under the terms of the GNU Lesser General Public License (LGPL) as
 * published by the Free Software Foundation.
 * ****** END LICENSE BLOCK ****** */

#ifndef _FWGUIQT_MESSAGEBOX_HPP_
#define _FWGUIQT_MESSAGEBOX_HPP_

#include <string>
#include <fwCore/base.hpp>

#include <fwGui/dialog/IMessageDialog.hpp>

#include "fwGuiQt/config.hpp"

namespace fwGuiQt
{
namespace dialog
{
/**
 * @brief   Defines the generic message box for IHM.
 * @class   MessageDialog
 *
 * @date    2009-2010.
 *
 */
class FWGUIQT_CLASS_API MessageDialog : public ::fwGui::dialog::IMessageDialog
{

public:

    fwCoreClassDefinitionsWithFactoryMacro( (MessageDialog)(::fwGui::dialog::IMessageDialog),
                                            (()),
                                            ::fwGui::factory::New< MessageDialog > );

    FWGUIQT_API MessageDialog(::fwGui::GuiBaseObject::Key key);

    FWGUIQT_API virtual ~MessageDialog();

    /// Set the title of the message box
    FWGUIQT_API virtual void setTitle( const std::string &title );

    /// Set the message
    FWGUIQT_API virtual void setMessage( const std::string &msg );

    /// Set the icon (CRITICAL, WARNING, INFO or QUESTION)
    FWGUIQT_API virtual void setIcon( IMessageDialog::Icons icon);

    /// Add a button (OK, YES_NO, CANCEL)
    FWGUIQT_API virtual void addButton( IMessageDialog::Buttons button );

    /// Set the default buttons
    FWGUIQT_API virtual void setDefaultButton( IMessageDialog::Buttons button );

    /// Show the message box and return the clicked button.
    FWGUIQT_API virtual Buttons show();

protected:
    /// Dialog title
    std::string m_title;
    /// Dialog box message
    std::string m_message;
    /// List of the button
    ::fwGui::dialog::IMessageDialog::Buttons m_buttons;
    /// default buttons
    ::fwGui::dialog::IMessageDialog::Buttons m_defaultButton;
    /// Icon
    ::fwGui::dialog::IMessageDialog::Icons m_icon;
};
} // namespace dialog
} // namespace fwGuiQt

#endif /*_FWGUIQT_MESSAGEBOX_HPP_*/


